/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.elements;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.phpunit.model.elements.PHPUnitTest;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;

public class PHPUnitTestGroup
extends PHPUnitTest {
    private Set<PHPUnitTest> children = null;
    private int runCount = 0;
    private final StatusCount statusCount = new StatusCount();
    private int totalCount;

    public PHPUnitTestGroup(Map<?, ?> test, PHPUnitTestGroup parent, RemoteDebugger remoteDebugger) {
        super(test, parent, remoteDebugger);
        this.totalCount = test == null ? 0 : Integer.parseInt((String)test.get("tests"));
    }

    public void addChild(PHPUnitTest test, boolean finished) {
        if (this.children == null) {
            this.children = new LinkedHashSet<PHPUnitTest>();
        }
        this.children.add(test);
        if (test instanceof PHPUnitTestCase && finished) {
            this.addRunCount(1);
        }
        this.setStatus(test.getStatus());
    }

    private void addRunCount(int count) {
        this.runCount += count;
        if (this.parent != null) {
            ((PHPUnitTestGroup)this.parent).addRunCount(count);
        }
    }

    public Set<PHPUnitTest> getChildren() {
        return this.children;
    }

    @Override
    public int getRunCount() {
        return this.runCount;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public int getStatusCount(int status) {
        return this.statusCount.counts[status];
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setParent(PHPUnitTestGroup group) {
        this.parent = group;
    }

    @Override
    public void setStatus(int status) {
        int n = status;
        this.statusCount.counts[n] = this.statusCount.counts[n] + 1;
        this.status = Math.max(this.status, status);
        if (this.parent != null) {
            ((PHPUnitTestGroup)this.parent).setStatus(status);
        }
    }

    private class StatusCount {
        public int[] counts = new int[6];

        private StatusCount() {
        }
    }
}

