/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.wizards;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.core.engine.ProfilerDataSerializationUtil;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.wizards.ImportSessionWizardFirstPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportSessionWizard
extends Wizard
implements IImportWizard {
    private ImportSessionWizardFirstPage page1;

    public boolean performFinish() {
        Job importJob = new Job(PHPProfileUIMessages.getString("ImportSessionWizard.0")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ProfilerDB[] profilerDBs = ProfilerDataSerializationUtil.deserialize((InputStream)new FileInputStream(ImportSessionWizard.this.page1.getSourceFile()));
                    if (profilerDBs != null && profilerDBs.length > 0) {
                        int i = 0;
                        while (i < profilerDBs.length) {
                            ProfileSessionsManager.addSession((ProfilerDB)profilerDBs[i]);
                            ++i;
                        }
                    } else {
                        final Display display = Display.getDefault();
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPProfileUIMessages.getString("ImportSessionWizard.1"), (String)NLS.bind((String)PHPProfileUIMessages.getString("ImportSessionWizard.2"), (Object)ImportSessionWizard.this.page1.getSourceFile()));
                            }
                        });
                    }
                }
                catch (IOException e) {
                    final Display display = Display.getDefault();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPProfileUIMessages.getString("ImportSessionWizard.3"), (String)(String.valueOf(PHPProfileUIMessages.getString("ImportSessionWizard.4")) + e.getMessage()));
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        importJob.setUser(true);
        importJob.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(PHPProfileUIMessages.getString("ImportSessionWizard.5"));
    }

    public void addPages() {
        this.page1 = new ImportSessionWizardFirstPage();
        this.addPage((IWizardPage)this.page1);
    }

    public Image getDefaultPageImage() {
        return ProfilerUIImages.get("IMG_WIZBAN_IMPORT_PROFILE_SESSIONS");
    }
}

