/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.test;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.refactoring.core.utils.ASTUtils;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.junit.Assert;

public abstract class AbstractRefactoringTest {
    protected static final char OFFSET_CHAR = '|';

    protected Program createProgram(IFile file) throws Exception {
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
        Program program = null;
        program = ASTUtils.createProgramFromSource((ISourceModule)sourceModule);
        return program;
    }

    protected void performChange(RefactoringProcessor processor) {
        try {
            Change change = processor.createChange((IProgressMonitor)new NullProgressMonitor());
            if (change != null) {
                change.perform((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        TestUtils.waitForIndexer();
    }

    protected void checkInitCondition(RefactoringProcessor processor) {
        try {
            RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((long)0L, (long)status.getSeverity());
        }
        catch (OperationCanceledException e1) {
            Assert.fail((String)e1.getMessage());
        }
        catch (CoreException e1) {
            Assert.fail((String)e1.getMessage());
        }
    }

    protected void checkFinalCondition(RefactoringProcessor processor) {
        try {
            RefactoringStatus status = processor.checkFinalConditions((IProgressMonitor)new NullProgressMonitor(), null);
            Assert.assertNotSame((Object)4, (Object)status.getSeverity());
        }
        catch (OperationCanceledException e1) {
            Assert.fail((String)e1.getMessage());
        }
        catch (CoreException e1) {
            Assert.fail((String)e1.getMessage());
        }
    }

    protected void performChange(Refactoring processor) {
        try {
            Change change = processor.createChange((IProgressMonitor)new NullProgressMonitor());
            change.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected void checkInitCondition(Refactoring processor) {
        try {
            RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((long)0L, (long)status.getSeverity());
        }
        catch (OperationCanceledException e1) {
            Assert.fail((String)e1.getMessage());
        }
        catch (CoreException e1) {
            Assert.fail((String)e1.getMessage());
        }
    }

    protected ASTNode locateNode(Program program, int start, int end) {
        ASTNode locateNode = NodeFinder.perform((ASTNode)program, (int)start, (int)end);
        return locateNode;
    }

    protected IStructuredModel createUnManagedStructuredModelFor(IFile file) throws IOException, CoreException {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(file);
        }
        catch (Exception e) {
            try {
                Thread.sleep(3000L);
                model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(file);
            }
            catch (InterruptedException e1) {
                Assert.fail((String)e1.getMessage());
            }
        }
        return model;
    }
}

