/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.util.HashSet;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.TypeFilter;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.core.typeinference.FakeMethod;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.text.correction.NameMatcher;
import org.eclipse.php.internal.ui.text.correction.SimilarElement;

public class SimilarElementsRequestor
extends CompletionRequestor {
    public static final int CLASSES = 2;
    public static final int INTERFACES = 4;
    public static final int FUNCTIONS = 8;
    public static final int CONSTANTS = 16;
    public static final int REF_TYPES = 6;
    public static final int ALL_TYPES = 6;
    public static final String ENCLOSING_TYPE_SEPARATOR = new String(new char[]{'\\'});
    private int fKind;
    private String fName;
    private static final TypeFilter filter = new TypeFilter(DLTKUILanguageManager.getLanguageToolkit((String)"org.eclipse.php.core.PHPNature"));
    private HashSet<SimilarElement> fResult;

    public static SimilarElement[] findSimilarElement(ISourceModule cu, Identifier name, int kind) throws ModelException {
        String identifier = PHPModelUtils.extractElementName((String)name.getName());
        int pos = name.getStart() + 1;
        SimilarElementsRequestor requestor = new SimilarElementsRequestor(identifier, kind);
        requestor.setIgnored(2, true);
        requestor.setIgnored(3, true);
        requestor.setIgnored(11, true);
        requestor.setIgnored(8, true);
        requestor.setIgnored(5, true);
        requestor.setIgnored(1, true);
        requestor.setIgnored(4, true);
        requestor.setIgnored(8, true);
        requestor.setIgnored(8, true);
        requestor.setIgnored(9, true);
        requestor.setIgnored(10, true);
        return requestor.process(cu, pos);
    }

    private SimilarElementsRequestor(String name, int kind) {
        this.fName = name;
        this.fKind = kind;
        this.fResult = new HashSet();
    }

    private void addResult(SimilarElement elem) {
        this.fResult.add(elem);
    }

    private SimilarElement[] process(ISourceModule cu, int pos) throws ModelException {
        try {
            cu.codeComplete(pos, (CompletionRequestor)this, 5000L);
            SimilarElement[] similarElementArray = this.fResult.toArray(new SimilarElement[this.fResult.size()]);
            return similarElementArray;
        }
        finally {
            this.fResult.clear();
        }
    }

    private boolean isKind(int kind) {
        return (this.fKind & kind) != 0;
    }

    private static final int getKind(int flags, char[] typeNameSig) {
        if (Flags.isInterface((int)flags)) {
            return 4;
        }
        return 2;
    }

    private void addType(char[] typeNameSig, int flags, int relevance) {
        int kind = SimilarElementsRequestor.getKind(flags, typeNameSig);
        if (!this.isKind(kind)) {
            return;
        }
        String fullName = new String(typeNameSig);
        if (filter.isFiltered(fullName)) {
            return;
        }
        if (NameMatcher.isSimilarName(this.fName, PHPModelUtils.extractElementName((String)fullName))) {
            this.addResult(new SimilarElement(kind, fullName, relevance));
        }
    }

    public void accept(CompletionProposal proposal) {
        if (proposal.getKind() == 7 || proposal.getKind() == 6) {
            String name = null;
            IModelElement element = proposal.getModelElement();
            if (element instanceof IType || element instanceof FakeConstructor) {
                IMember type = (IMember)element;
                try {
                    if (!PHPFlags.isNamespace((int)type.getFlags())) {
                        if (element instanceof FakeConstructor) {
                            element = ((FakeConstructor)element).getParent();
                        }
                        name = ((IType)element).getTypeQualifiedName(ENCLOSING_TYPE_SEPARATOR);
                    }
                }
                catch (ModelException modelException) {}
            } else if (element instanceof FakeMethod) {
                try {
                    name = ((IMethod)element).getTypeQualifiedName(ENCLOSING_TYPE_SEPARATOR, false);
                }
                catch (ModelException e) {
                    PHPUiPlugin.log(e);
                }
            }
            if (name != null) {
                this.addType(name.toCharArray(), proposal.getFlags(), proposal.getRelevance());
            }
        }
    }
}

