/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.astview.views;

import org.eclipse.php.astview.views.ASTAttribute;
import org.eclipse.php.astview.views.Binding;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.swt.graphics.Image;

public class BindingProperty
extends ASTAttribute {
    private final String fName;
    private final Binding fParent;
    private final Binding[] fValues;
    private final boolean fIsRelevant;

    public BindingProperty(Binding parent, String name, String value, boolean isRelevant) {
        this.fParent = parent;
        this.fName = value == null ? String.valueOf(name) + ": null" : (value.length() > 0 ? String.valueOf(name) + ": '" + value + "'" : String.valueOf(name) + ": (empty string)");
        this.fValues = null;
        this.fIsRelevant = isRelevant;
    }

    public BindingProperty(Binding parent, String name, boolean value, boolean isRelevant) {
        this.fParent = parent;
        this.fName = String.valueOf(name) + ": " + String.valueOf(value);
        this.fValues = null;
        this.fIsRelevant = isRelevant;
    }

    public BindingProperty(Binding parent, String name, int value, boolean isRelevant) {
        this.fParent = parent;
        this.fName = String.valueOf(name) + ": " + String.valueOf(value);
        this.fValues = null;
        this.fIsRelevant = isRelevant;
    }

    public BindingProperty(Binding parent, String name, IBinding[] bindings, boolean isRelevant) {
        this.fParent = parent;
        if (bindings == null || bindings.length == 0) {
            this.fName = String.valueOf(name) + " (0)";
            this.fValues = null;
        } else {
            this.fValues = this.createBindings(bindings, isRelevant);
            this.fName = String.valueOf(name) + " (" + String.valueOf(this.fValues.length) + ')';
        }
        this.fIsRelevant = isRelevant;
    }

    public BindingProperty(Binding parent, StringBuffer label, boolean isRelevant) {
        this.fParent = parent;
        this.fName = label.toString();
        this.fValues = null;
        this.fIsRelevant = isRelevant;
    }

    private Binding[] createBindings(IBinding[] bindings, boolean isRelevant) {
        Binding[] res = new Binding[bindings.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new Binding(this, String.valueOf(i), bindings[i], isRelevant);
            ++i;
        }
        return res;
    }

    @Override
    public Object getParent() {
        return this.fParent;
    }

    @Override
    public Object[] getChildren() {
        if (this.fValues != null) {
            return this.fValues;
        }
        return EMPTY;
    }

    @Override
    public String getLabel() {
        return this.fName;
    }

    @Override
    public Image getImage() {
        return null;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean isRelevant() {
        return this.fIsRelevant;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        BindingProperty other = (BindingProperty)obj;
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals(other.fParent)) {
            return false;
        }
        return !(this.fName == null ? other.fName != null : !this.fName.equals(other.fName));
    }

    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fName != null ? this.fName.hashCode() : 0);
    }
}

