/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.php.internal.core.Logger;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class PerformanceMonitor {
    private static final int AVG_SAMPLES = 5;
    private static final int HISTORY_SIZE = 50;
    private static final FieldType STORED_SORTED_LONG_FIELD_TYPE = new FieldType();
    private static final FieldType STORED_LONG_FIELD_TYPE;
    private Analyzer analyzer = null;
    private IndexWriter executionsWriter = null;
    private IndexWriter resultsWriter = null;
    private IndexReader executionsReader = null;
    private IndexReader resultsReader = null;
    private IndexSearcher executionsSearcher = null;
    private IndexSearcher resultsSearcher = null;
    private long executionId;

    static {
        STORED_SORTED_LONG_FIELD_TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        STORED_SORTED_LONG_FIELD_TYPE.setStored(true);
        STORED_SORTED_LONG_FIELD_TYPE.freeze();
        STORED_LONG_FIELD_TYPE = new FieldType();
        STORED_LONG_FIELD_TYPE.setDocValuesType(DocValuesType.NUMERIC);
        STORED_LONG_FIELD_TYPE.setStored(true);
        STORED_LONG_FIELD_TYPE.freeze();
    }

    public PerformanceMonitor(Bundle bundle) throws Exception {
        String baseDir = String.valueOf(System.getProperty("user.home")) + File.separator + ".perf_results_lucene" + File.separator + bundle.getSymbolicName() + bundle.getVersion();
        File executionsDir = new File(String.valueOf(baseDir) + File.separator + "executions");
        File resultsDir = new File(String.valueOf(baseDir) + File.separator + "results");
        if (!executionsDir.exists()) {
            executionsDir.mkdirs();
        }
        if (!resultsDir.exists()) {
            resultsDir.mkdirs();
        }
        this.analyzer = new SimpleAnalyzer();
        this.executionsWriter = new IndexWriter((Directory)FSDirectory.open((Path)executionsDir.toPath()), new IndexWriterConfig(this.analyzer));
        this.resultsWriter = new IndexWriter((Directory)FSDirectory.open((Path)resultsDir.toPath()), new IndexWriterConfig(this.analyzer));
        this.executionsReader = DirectoryReader.open((IndexWriter)this.executionsWriter);
        this.resultsReader = DirectoryReader.open((IndexWriter)this.resultsWriter);
        this.executionsSearcher = new IndexSearcher(this.executionsReader);
        this.resultsSearcher = new IndexSearcher(this.resultsReader);
        this.executionId = System.currentTimeMillis();
        while (this.executionsSearcher.search((Query)LongPoint.newExactQuery((String)"executionId", (long)this.executionId), (int)1).scoreDocs.length != 0) {
            this.executionId = Math.max(this.executionId + 1L, System.currentTimeMillis());
        }
        this.executionsWriter.addDocument((Iterable)new ExecutionDocument(this.executionId));
        this.executionsWriter.flush();
        this.compact();
    }

    public void dispose() {
        block28: {
            block26: {
                block24: {
                    block22: {
                        this.resultsSearcher = null;
                        if (this.resultsReader != null) {
                            try {
                                try {
                                    this.resultsReader.close();
                                }
                                catch (IOException e) {
                                    Logger.logException((Throwable)e);
                                    this.resultsReader = null;
                                    break block22;
                                }
                            }
                            catch (Throwable throwable) {
                                this.resultsReader = null;
                                throw throwable;
                            }
                            this.resultsReader = null;
                        }
                    }
                    if (this.executionsReader != null) {
                        try {
                            try {
                                this.executionsReader.close();
                            }
                            catch (IOException e) {
                                Logger.logException((Throwable)e);
                                this.executionsReader = null;
                                break block24;
                            }
                        }
                        catch (Throwable throwable) {
                            this.executionsReader = null;
                            throw throwable;
                        }
                        this.executionsReader = null;
                    }
                }
                if (this.resultsWriter != null) {
                    try {
                        try {
                            this.resultsWriter.close();
                        }
                        catch (IOException e) {
                            Logger.logException((Throwable)e);
                            this.resultsWriter = null;
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        this.resultsWriter = null;
                        throw throwable;
                    }
                    this.resultsWriter = null;
                }
            }
            if (this.executionsWriter != null) {
                try {
                    try {
                        this.executionsWriter.close();
                    }
                    catch (IOException e) {
                        Logger.logException((Throwable)e);
                        this.executionsWriter = null;
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    this.executionsWriter = null;
                    throw throwable;
                }
                this.executionsWriter = null;
            }
        }
        if (this.analyzer != null) {
            this.analyzer.close();
            this.analyzer = null;
        }
    }

    private void compact() throws IOException {
        Sort sort = new Sort((SortField)new SortedNumericSortField("executionId", SortField.Type.LONG, true));
        TopFieldDocs executions = this.executionsSearcher.search((Query)new MatchAllDocsQuery(), 51, sort, false, false);
        if (executions.scoreDocs.length > 50) {
            Document firstExecutionToDelete = this.executionsReader.document(executions.scoreDocs[50].doc);
            long deleteFromExecutionID = firstExecutionToDelete.getField("executionId").numericValue().longValue();
            Query deleteQuery = LongPoint.newRangeQuery((String)"executionId", (long)Long.MIN_VALUE, (long)deleteFromExecutionID);
            this.resultsWriter.deleteDocuments(new Query[]{deleteQuery});
            this.executionsWriter.deleteDocuments(new Query[]{deleteQuery});
            this.resultsWriter.flush();
            this.executionsWriter.flush();
        }
    }

    public void execute(String id, Operation operation, int times, int threshold) throws Exception {
        long diff;
        long testTimeSum = 0L;
        int i = 0;
        while (i < times) {
            long testStart = System.currentTimeMillis();
            operation.run();
            testTimeSum += System.currentTimeMillis() - testStart;
            ++i;
        }
        long testAverage = testTimeSum / (long)times;
        long savedAverage = this.getAverage(id, 5);
        if (savedAverage != 0L && savedAverage != -1L && testAverage > savedAverage && (diff = testAverage - savedAverage) * 100L / savedAverage > (long)threshold) {
            Assert.fail((String)("Average execution time (" + testAverage + "ms) is greater by more than " + threshold + "% than the saved average (" + savedAverage + "ms)"));
        }
        this.writeResult(id, testAverage);
    }

    private void writeResult(String testId, long time) throws IOException {
        ResultDocument newDoc = new ResultDocument(this.executionId, testId, time);
        this.resultsWriter.addDocument((Iterable)newDoc);
        this.resultsWriter.flush();
    }

    private long getAverage(String testId, int samples) throws IOException {
        TermQuery query = new TermQuery(new Term("testName", testId));
        Sort sort = new Sort((SortField)new SortedNumericSortField("executionId", SortField.Type.LONG, true));
        TopFieldDocs topDocs = this.resultsSearcher.search((Query)query, samples, sort, false, false);
        if (topDocs.scoreDocs.length != samples) {
            return -1L;
        }
        long totalTime = 0L;
        ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
        int n = topDocs.scoreDocs.length;
        int n2 = 0;
        while (n2 < n) {
            ScoreDoc scoreDoc = scoreDocArray[n2];
            long thisValue = this.resultsReader.document(scoreDoc.doc).getField("time").numericValue().longValue();
            totalTime += thisValue;
            ++n2;
        }
        return totalTime / (long)samples;
    }

    private class CustomDocument
    implements Iterable<IndexableField> {
        protected final List<IndexableField> fields = new ArrayList<IndexableField>();

        private CustomDocument() {
        }

        @Override
        public Iterator<IndexableField> iterator() {
            return this.fields.iterator();
        }

        protected class StoredLongField
        extends Field {
            public StoredLongField(String name, long value) {
                super(name, (IndexableFieldType)STORED_LONG_FIELD_TYPE);
                this.fieldsData = value;
            }
        }

        protected class StoredSortedLongField
        extends Field {
            public StoredSortedLongField(String name, long value) {
                super(name, (IndexableFieldType)STORED_SORTED_LONG_FIELD_TYPE);
                this.fieldsData = value;
            }
        }
    }

    private class ExecutionDocument
    extends CustomDocument {
        public ExecutionDocument(long executionId) {
            this.fields.add(new CustomDocument.StoredSortedLongField("executionId", executionId));
        }
    }

    public static interface Operation {
        public void run() throws Exception;
    }

    private class ResultDocument
    extends CustomDocument {
        public ResultDocument(long executionId, String testName, long time) {
            this.fields.add(new CustomDocument.StoredSortedLongField("executionId", executionId));
            this.fields.add(new StringField("testName", testName, Field.Store.YES));
            this.fields.add(new CustomDocument.StoredLongField("time", time));
        }
    }
}

