/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance.codeassist;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.performance.AbstractPDTTTest;
import org.eclipse.php.core.tests.performance.PHPCorePerformanceTests;
import org.eclipse.php.core.tests.performance.PerformanceMonitor;
import org.eclipse.php.core.tests.performance.codeassist.CodeAssistPdttFile;

public class CodeAssistTestsWrapper
extends AbstractPDTTTest {
    protected static final char OFFSET_CHAR = '|';
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    protected IFile testFile;
    private PerformanceMonitor perfMonitor;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/project/codeassist/php5/exclusive", "/workspace/project/codeassist/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/project/codeassist/php53"});
    }

    public static void tearDownSuite() throws Exception {
    }

    public CodeAssistTestsWrapper() {
        super("");
    }

    public Test suite(Map<?, ?> map) {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(map.get("project").toString());
        this.perfMonitor = PHPCorePerformanceTests.getPerformanceMonitor();
        TestSuite suite = new TestSuite("Auto Code Assist Tests");
        PHPVersion phpVersion = (PHPVersion)map.get("phpVersion");
        String[] stringArray = TESTS.get(phpVersion);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String testsDirectory = stringArray[n2];
            testsDirectory = testsDirectory.replaceAll("project", map.get("project").toString());
            String[] stringArray2 = CodeAssistTestsWrapper.getPDTTFiles(testsDirectory, PHPCorePerformanceTests.getDefault().getBundle());
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                final String fileName = stringArray2[n4];
                try {
                    final CodeAssistPdttFile pdttFile = new CodeAssistPdttFile(PHPCorePerformanceTests.getDefault().getBundle(), fileName);
                    CodeAssistTests test = new CodeAssistTests(this, fileName){

                        protected void setUp() throws Exception {
                        }

                        protected void tearDown() throws Exception {
                            if (testFile != null) {
                                testFile.delete(true, null);
                                testFile = null;
                            }
                        }

                        protected void runTest() throws Throwable {
                            perfMonitor.execute("PerformanceTests.testCodeAssist_" + fileName, new PerformanceMonitor.Operation(){

                                @Override
                                public void run() throws Exception {
                                    CompletionProposal[] proposals = this.getProposals(pdttFile.getFile());
                                }
                            }, 1, 10);
                        }
                    };
                    suite.addTest((Test)test);
                }
                catch (Exception e) {
                    suite.addTest((Test)new TestCase(fileName){

                        protected void runTest() throws Throwable {
                            throw e;
                        }
                    });
                }
                ++n4;
            }
            ++n2;
        }
        return suite;
    }

    protected int createFile(String data) throws Exception {
        int offset = data.lastIndexOf(124);
        if (offset == -1) {
            throw new IllegalArgumentException("Offset character is not set");
        }
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        this.testFile = this.project.getFile("pdttest/test.php");
        this.testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        this.project.refreshLocal(1, null);
        this.project.build(10, null);
        TestUtils.waitForIndexer();
        return offset;
    }

    protected ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)this.testFile);
    }

    public CompletionProposal[] getProposals(String data) throws Exception {
        int offset = this.createFile(data);
        return this.getProposals(offset);
    }

    public CompletionProposal[] getProposals(int offset) throws ModelException {
        return CodeAssistTestsWrapper.getProposals(this.getSourceModule(), offset);
    }

    public static CompletionProposal[] getProposals(ISourceModule sourceModule, int offset) throws ModelException {
        final LinkedList proposals = new LinkedList();
        sourceModule.codeComplete(offset, new CompletionRequestor(){

            public void accept(CompletionProposal proposal) {
                proposals.add(proposal);
            }
        });
        return proposals.toArray(new CompletionProposal[proposals.size()]);
    }

    public class CodeAssistTests
    extends AbstractPDTTTest {
        public CodeAssistTests(String description) {
            super(description);
        }
    }
}

