/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance.typeinference;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.performance.AbstractPDTTTest;
import org.eclipse.php.core.tests.performance.PHPCorePerformanceTests;
import org.eclipse.php.core.tests.performance.PerformanceMonitor;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.context.ContextFinder;

public class TypeInferenceTestsWrapper
extends AbstractPDTTTest {
    protected static final int ENGINE_TIMEOUT = 100000;
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private IProject project;
    private PerformanceMonitor perfMonitor;
    private static PHPTypeInferencer typeInferenceEngine;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/project/typeinference/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/project/typeinference/php53"});
    }

    public TypeInferenceTestsWrapper() {
        super("");
    }

    public static void setUpSuite() throws Exception {
        typeInferenceEngine = new PHPTypeInferencer();
    }

    public static void tearDownSuite() throws Exception {
        typeInferenceEngine = null;
    }

    public Test suite(Map<?, ?> map) {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(map.get("project").toString());
        this.perfMonitor = PHPCorePerformanceTests.getPerformanceMonitor();
        TestSuite suite = new TestSuite("Type Inference Tests");
        final PHPVersion phpVersion = (PHPVersion)map.get("phpVersion");
        String[] stringArray = TESTS.get(phpVersion);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String testsDirectory = stringArray[n2];
            testsDirectory = testsDirectory.replaceAll("project", map.get("project").toString());
            String[] stringArray2 = TypeInferenceTestsWrapper.getPDTTFiles(testsDirectory, PHPCorePerformanceTests.getDefault().getBundle());
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                final String fileName = stringArray2[n4];
                try {
                    final PdttFile pdttFile = new PdttFile(PHPCorePerformanceTests.getDefault().getBundle(), fileName);
                    final String pruner = TypeInferenceTestsWrapper.getPrunerType(pdttFile);
                    suite.addTest((Test)new TypeInferenceTests(this, String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                        protected void setUp() throws Exception {
                            TestUtils.setProjectPHPVersion((IProject)project, (PHPVersion)phpVersion);
                        }

                        protected void tearDown() throws Exception {
                        }

                        protected void runTest() throws Throwable {
                            String criteriaFunction = new File(fileName).getName().replaceAll("\\.pdtt", "");
                            String code = pdttFile.getFile();
                            this.findEvaluatedType(fileName, code, criteriaFunction, pruner);
                        }
                    });
                }
                catch (Exception e) {
                    suite.addTest((Test)new TestCase(fileName){

                        protected void runTest() throws Throwable {
                            throw e;
                        }
                    });
                }
                ++n4;
            }
            ++n2;
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                TypeInferenceTestsWrapper.setUpSuite();
            }

            protected void tearDown() throws Exception {
                TypeInferenceTestsWrapper.tearDownSuite();
            }
        };
        return setup;
    }

    private static String getPrunerType(PdttFile pdttFile) {
        Map config = pdttFile.getConfig();
        return (String)config.get("prune");
    }

    protected void findEvaluatedType(String fileName, String code, String criteriaFunction, final String pruner) throws Exception {
        IFile file = this.project.getFile("pdttest/test.php");
        if (file.exists()) {
            file.setContents((InputStream)new ByteArrayInputStream(code.getBytes()), true, false, null);
        } else {
            file.create((InputStream)new ByteArrayInputStream(code.getBytes()), true, null);
        }
        try {
            this.project.build(10, null);
            TestUtils.waitForIndexer();
            ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
            ModuleDeclaration moduleDecl = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            ASTNodeSearcher searcher = new ASTNodeSearcher(sourceModule, criteriaFunction);
            moduleDecl.traverse((ASTVisitor)searcher);
            Assert.assertNotNull((String)("Method call " + criteriaFunction + "() in code: " + code), (Object)searcher.getResult());
            Assert.assertNotNull((String)("Can't find context for " + criteriaFunction + "() in code: " + code), (Object)searcher.getContext());
            final ExpressionTypeGoal goal = new ExpressionTypeGoal(searcher.getContext(), searcher.getResult());
            this.perfMonitor.execute("PerformanceTests.testCodeAssist_" + fileName, new PerformanceMonitor.Operation(){

                @Override
                public void run() throws Exception {
                    if ("phpdocGoals".equals(pruner)) {
                        typeInferenceEngine.evaluateTypeHeavy((AbstractTypeGoal)goal, 100000);
                    } else if ("heavyGoals".equals(pruner)) {
                        typeInferenceEngine.evaluateTypePHPDoc((AbstractTypeGoal)goal, 100000);
                    } else {
                        typeInferenceEngine.evaluateType((AbstractTypeGoal)goal, 100000);
                    }
                }
            }, 1, 10);
        }
        finally {
            try {
                file.delete(true, null);
            }
            catch (Exception exception) {}
        }
    }

    class ASTNodeSearcher
    extends ContextFinder {
        private IContext context;
        private ASTNode result;
        private String criteriaFunction;

        public ASTNodeSearcher(ISourceModule sourceModule, String criteriaFunction) {
            super(sourceModule);
            this.criteriaFunction = criteriaFunction;
        }

        public boolean visit(Expression node) throws Exception {
            CallExpression callExpression;
            if (node instanceof CallExpression && this.criteriaFunction.equals((callExpression = (CallExpression)node).getName())) {
                this.result = (ASTNode)callExpression.getArgs().getChilds().get(0);
                this.context = (IContext)this.contextStack.peek();
                return false;
            }
            return true;
        }

        public ASTNode getResult() {
            return this.result;
        }

        public IContext getContext() {
            return this.context;
        }
    }

    public class TypeInferenceTests
    extends AbstractPDTTTest {
        public TypeInferenceTests(String description) {
            super(description);
        }
    }
}

