/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.compiler_ast.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractPHPSourceParser;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPSourceParserFactory;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class GetUseStatementsByTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private AbstractPHPSourceParser parser;

    static {
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/astutils/get_use_statements/php53"});
    }

    public GetUseStatementsByTests(PHPVersion phpVersion, String[] fileName) {
        this.parser = PHPSourceParserFactory.createParser((PHPVersion)phpVersion);
    }

    @Test
    public void getUse(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(fileName);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdttFile.getFile().trim().getBytes());
        ModuleDeclaration moduleDeclaration = (ModuleDeclaration)this.parser.parse((Reader)new InputStreamReader(inputStream), null, ProjectOptions.useShortTags(null));
        int offset = Integer.parseInt(pdttFile.getConfig().get("offset"));
        UseStatement[] useStatements = ASTUtils.getUseStatements((ModuleDeclaration)moduleDeclaration, (int)offset);
        StringBuilder builder = new StringBuilder();
        UseStatement[] useStatementArray = useStatements;
        int n = useStatements.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatement s = useStatementArray[n2];
            builder.append(s);
            ++n2;
        }
        String actual = builder.toString();
        PDTTUtils.assertContents(pdttFile.getExpected(), actual);
    }
}

