/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.ArrayCreation;
import org.eclipse.php.core.ast.nodes.Assignment;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.BreakStatement;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.ContinueStatement;
import org.eclipse.php.core.ast.nodes.EchoStatement;
import org.eclipse.php.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.core.ast.nodes.ForStatement;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.IfStatement;
import org.eclipse.php.core.ast.nodes.ListVariable;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.ReturnStatement;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.SwitchStatement;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.dom_ast.rewrite.ICodeManipulator;
import org.eclipse.text.edits.TextEdit;
import org.junit.Assert;
import org.junit.Test;

public class NodeDeletionTests {
    @Test
    public void variable() throws Exception {
        String str = "<?php $a; $A; ?>";
        String expected = "<?php ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                List<ExpressionStatement> allOfType = NodeDeletionTests.this.getAllOfType(program, ExpressionStatement.class);
                for (ASTNode aSTNode : allOfType) {
                    aSTNode.delete();
                }
            }
        });
    }

    @Test
    public void functionInvocationWithParamsFirst() throws Exception {
        String str = "<?php $foo($a, 's<>&', 12, true, __CLASS__); ?>";
        String expected = "<?php $foo('s<>&', 12, true, __CLASS__); ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
                FunctionInvocation functionInvocation = (FunctionInvocation)statement.getExpression();
                functionInvocation.parameters().remove(0);
            }
        });
    }

    @Test
    public void functionInvocationWithParamsLast() throws Exception {
        String str = "<?php $foo($a, 's<>&', 12, true, __CLASS__); ?>";
        String expected = "<?php $foo($a, 's<>&', 12, true); ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
                FunctionInvocation functionInvocation = (FunctionInvocation)statement.getExpression();
                functionInvocation.parameters().remove(4);
            }
        });
    }

    @Test
    public void functionInvocationWithParamsMiddle() throws Exception {
        String str = "<?php $foo($a, 's<>&', 12, true, __CLASS__); ?>";
        String expected = "<?php $foo($a, 's<>&', true, __CLASS__); ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
                FunctionInvocation functionInvocation = (FunctionInvocation)statement.getExpression();
                functionInvocation.parameters().remove(2);
            }
        });
    }

    @Test
    public void classRemove() throws Exception {
        String str = "<?php $a = 5; class A { } ?>";
        String expected = "<?php $a = 5; ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                Statement statement = (Statement)program.statements().get(1);
                statement.delete();
            }
        });
    }

    @Test
    public void statementBeforeClass() throws Exception {
        String str = "<?php $a = 5; class A { } ?>";
        String expected = "<?php class A { } ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                Statement statement = (Statement)program.statements().get(0);
                statement.delete();
            }
        });
    }

    @Test
    public void arrayFirst() throws Exception {
        String str = "<?php array (0, 1, 2, 3) ?>";
        String expected = "<?php array (1, 2, 3) ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
                ArrayCreation expression = (ArrayCreation)statement.getExpression();
                expression.elements().remove(0);
            }
        });
    }

    @Test
    public void arrayLast() throws Exception {
        String str = "<?php array (0, 1, 2, 3) ?>";
        String expected = "<?php array (0, 1, 2) ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
                ArrayCreation expression = (ArrayCreation)statement.getExpression();
                expression.elements().remove(3);
            }
        });
    }

    @Test
    public void arrayMiddle() throws Exception {
        String str = "<?php array (0, 1, 2, 3) ?>";
        String expected = "<?php array (0, 1, 3) ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
                ArrayCreation expression = (ArrayCreation)statement.getExpression();
                expression.elements().remove(2);
            }
        });
    }

    @Test
    public void deleteArrayKeyValue() throws Exception {
        String str = "<?php array('Dodo'=>'Golo','Dafna'=>'Dodidu');?>";
        String expected = "<?php array('Dafna'=>'Dodidu');?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
                ArrayCreation expression = (ArrayCreation)statement.getExpression();
                expression.elements().remove(0);
            }
        });
    }

    @Test
    public void listFirst() throws Exception {
        String str = "<?php list($a, $b, $c, $d) = array () ?>";
        String expected = "<?php list($b, $c, $d) = array () ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
                Assignment expression = (Assignment)statement.getExpression();
                ListVariable list = (ListVariable)expression.getLeftHandSide();
                list.variables().remove(0);
            }
        });
    }

    @Test
    public void listMiddle() throws Exception {
        String str = "<?php list($a, $b, $c, $d)  = array ()  ?>";
        String expected = "<?php list($a, $b, $d)  = array ()  ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
                Assignment expression = (Assignment)statement.getExpression();
                ListVariable list = (ListVariable)expression.getLeftHandSide();
                list.variables().remove(2);
            }
        });
    }

    @Test
    public void listLast() throws Exception {
        String str = "<?php list ($a, $b, $c, $d)  = array ()  ?>";
        String expected = "<?php list ($a, $b, $c)  = array ()  ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ExpressionStatement statement = (ExpressionStatement)program.statements().get(0);
                Assignment expression = (Assignment)statement.getExpression();
                ListVariable list = (ListVariable)expression.getLeftHandSide();
                list.variables().remove(3);
            }
        });
    }

    @Test
    public void deleteBreak() throws Exception {
        String str = "<?php break $a;?>";
        String expected = "<?php break;?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                BreakStatement statement = (BreakStatement)program.statements().get(0);
                statement.getExpression().delete();
            }
        });
    }

    @Test
    public void deleteContinue() throws Exception {
        String str = "<?php continue $a;?>";
        String expected = "<?php continue;?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ContinueStatement statement = (ContinueStatement)program.statements().get(0);
                statement.getExpression().delete();
            }
        });
    }

    @Test
    public void deleteReturn() throws Exception {
        String str = "<?php return $a;?>";
        String expected = "<?php return;?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ReturnStatement statement = (ReturnStatement)program.statements().get(0);
                statement.getExpression().delete();
            }
        });
    }

    @Test
    public void deleteEchoFirst() throws Exception {
        String str = "<?php echo $a, $b , $c; ?>";
        String expected = "<?php echo $b , $c; ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                EchoStatement statement = (EchoStatement)program.statements().get(0);
                statement.expressions().remove(0);
            }
        });
    }

    @Test
    public void deleteEchoLast() throws Exception {
        String str = "<?php echo $a, $b , $c; ?>";
        String expected = "<?php echo $a, $b; ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                EchoStatement statement = (EchoStatement)program.statements().get(0);
                statement.expressions().remove(2);
            }
        });
    }

    @Test
    public void deleteEchoMiddle() throws Exception {
        String str = "<?php echo $a, $b , $c; ?>";
        String expected = "<?php echo $a, $c; ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                EchoStatement statement = (EchoStatement)program.statements().get(0);
                statement.expressions().remove(1);
            }
        });
    }

    @Test
    public void deleteSwitch() throws Exception {
        String str = "<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>";
        String expected = "<?php switch ($i) { case 0:    echo 'i equals 0';    break; default:    echo 'i not equals 0,1';  }  ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                SwitchStatement statement = (SwitchStatement)program.statements().get(0);
                statement.getBody().statements().remove(1);
            }
        });
    }

    @Test
    public void deleteBlockFirst() throws Exception {
        String str = "<?php if ($a) { $a = 5; $b = 4; $c = 4; }  ?>";
        String expected = "<?php if ($a) { $b = 4; $c = 4; }  ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                IfStatement statement = (IfStatement)program.statements().get(0);
                Block block = (Block)statement.getTrueStatement();
                block.statements().remove(0);
            }
        });
    }

    @Test
    public void deleteBlockMiddle() throws Exception {
        String str = "<?php if ($a) { $a = 5; $b = 4; }  ?>";
        String expected = "<?php if ($a) { $a = 5; }  ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                IfStatement statement = (IfStatement)program.statements().get(0);
                Block block = (Block)statement.getTrueStatement();
                block.statements().remove(1);
            }
        });
    }

    @Test
    public void deleteBlockLast() throws Exception {
        String str = "<?php if ($a) { $a = 5; $b = 4; $c = 4;}  ?>";
        String expected = "<?php if ($a) { $a = 5; $b = 4;}  ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                IfStatement statement = (IfStatement)program.statements().get(0);
                Block block = (Block)statement.getTrueStatement();
                block.statements().remove(2);
            }
        });
    }

    @Test
    public void deleteForComponent1() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        String expected = "<?php for (;;) {  echo $i; } ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ForStatement statement = (ForStatement)program.statements().get(0);
                statement.initializers().remove(0);
                statement.conditions().remove(0);
                statement.updaters().remove(0);
            }
        });
    }

    @Test
    public void deleteFunctionFormalFirst() throws Exception {
        String str = "<?php function foo($a, $b, $c = 5) { $a= 5; $b = 6; $c = 7; } ?>";
        String expected = "<?php function foo($b, $c = 5) { $a= 5; $b = 6; $c = 7; } ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                FunctionDeclaration statement = (FunctionDeclaration)program.statements().get(0);
                statement.formalParameters().remove(0);
            }
        });
    }

    @Test
    public void deleteFunctionFormalLast() throws Exception {
        String str = "<?php function foo($a, $b, $c = 5) { $a= 5; $b = 6; $c = 7; } ?>";
        String expected = "<?php function foo($a, $b) { $a= 5; $b = 6; $c = 7; } ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                FunctionDeclaration statement = (FunctionDeclaration)program.statements().get(0);
                statement.formalParameters().remove(2);
            }
        });
    }

    @Test
    public void deleteFunctionFormalMiddle() throws Exception {
        String str = "<?php function foo($a, $b, $c = 5) { $a= 5; $b = 6; $c = 7; } ?>";
        String expected = "<?php function foo($a, $c = 5) { $a= 5; $b = 6; $c = 7; } ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                FunctionDeclaration statement = (FunctionDeclaration)program.statements().get(0);
                statement.formalParameters().remove(1);
            }
        });
    }

    @Test
    public void deleteFunctionBodyFirst() throws Exception {
        String str = "<?php function foo() { $a= 5; $b = 6; $c = 7; } ?>";
        String expected = "<?php function foo() { $b = 6; $c = 7; } ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                FunctionDeclaration statement = (FunctionDeclaration)program.statements().get(0);
                statement.getBody().statements().remove(0);
            }
        });
    }

    @Test
    public void deleteFunctionBodyLast() throws Exception {
        String str = "<?php function foo() { $a= 5; $b = 6; $c = 7; } ?>";
        String expected = "<?php function foo() { $a= 5; $b = 6; } ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                FunctionDeclaration statement = (FunctionDeclaration)program.statements().get(0);
                statement.getBody().statements().remove(2);
            }
        });
    }

    @Test
    public void deleteFunctionBodyMiddle() throws Exception {
        String str = "<?php function foo() { $a= 5; $b = 6; $c = 7; } ?>";
        String expected = "<?php function foo() { $a= 5; $c = 7; } ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                FunctionDeclaration statement = (FunctionDeclaration)program.statements().get(0);
                statement.getBody().statements().remove(1);
            }
        });
    }

    @Test
    public void deleteClassElements() throws Exception {
        String str = "<?php final class MyClass extends SuperClass implements Interface1, Interface2 { const MY_CONSTANT = 3; public static final $myVar = 5, $yourVar; var $anotherOne; private function myFunction(MyClass $a, $b = 6) { }  } ?>";
        String expected = "<?php final class MyClass extends SuperClass {  } ?>";
        this.parseAndCompare(str, expected, new ICodeManipulator(){

            @Override
            public void manipulate(Program program) {
                ClassDeclaration statement = (ClassDeclaration)program.statements().get(0);
                statement.interfaces().remove(1);
                statement.interfaces().remove(0);
                statement.getBody().statements().remove(3);
                statement.getBody().statements().remove(2);
                statement.getBody().statements().remove(1);
                statement.getBody().statements().remove(0);
            }
        });
    }

    public void parseAndCompare(String string, String expected, ICodeManipulator manipulator) throws Exception {
        Document document = new Document(string);
        Program program = this.initialize((IDocument)document);
        manipulator.manipulate(program);
        this.rewrite(program, (IDocument)document);
        String actual = document.get();
        String diff = TestUtils.compareContentsIgnoreWhitespace(expected, actual);
        if (diff != null) {
            Assert.fail((String)diff);
        }
    }

    private Program initialize(IDocument document) throws Exception {
        ASTParser parser = ASTParser.newParser((PHPVersion)this.getPHPVersion(), (boolean)ProjectOptions.useShortTags(null));
        parser.setSource(document.get().toCharArray());
        Program program = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        program.recordModifications();
        return program;
    }

    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP5;
    }

    private void rewrite(Program program, IDocument document) throws Exception {
        TextEdit edits = program.rewrite(document, null);
        edits.apply(document);
    }

    public <T extends ASTNode> List<T> getAllOfType(Program program, final Class<T> nodeClass) {
        final ArrayList list = new ArrayList();
        program.accept((Visitor)new ApplyAll(){

            protected boolean apply(ASTNode node) {
                if (node.getClass() == nodeClass) {
                    list.add(node);
                }
                return true;
            }
        });
        return list;
    }
}

