/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.dltk.compiler.problem.DefaultProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemSeverityTranslator;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class ProblemFactory
extends DefaultProblemFactory {
    public IProblemSeverityTranslator createSeverityTranslator(IScriptProject project) {
        return new SeverityTranslator(project);
    }

    private class SeverityTranslator
    implements IProblemSeverityTranslator {
        private final Map<IProblemIdentifier, ProblemSeverity> cache = new HashMap<IProblemIdentifier, ProblemSeverity>();
        private final IScopeContext[] contexts;

        public SeverityTranslator(IScriptProject project) {
            this.contexts = PHPCorePlugin.getDefault().getProblemPreferences().getScopeContexts(project.getProject());
        }

        public ProblemSeverity getSeverity(IProblemIdentifier problemId, ProblemSeverity defaultServerity) {
            if (problemId == null) {
                return IProblemSeverityTranslator.IDENTITY.getSeverity(problemId, defaultServerity);
            }
            if (this.cache.containsKey(problemId)) {
                return this.cache.get(problemId);
            }
            ProblemSeverity severity = PHPCorePlugin.getDefault().getProblemPreferences().getSeverity(problemId, this.contexts);
            if (severity == ProblemSeverity.DEFAULT) {
                severity = IProblemSeverityTranslator.IDENTITY.getSeverity(problemId, defaultServerity);
            }
            this.cache.put(problemId, severity);
            return severity;
        }
    }
}

