/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.rename.RenameFolderProcessor;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameFolderTestCase30346
extends AbstractRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"project1");
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        folder = TestUtils.createFolder((IProject)this.project1, (String)"src/src1");
        this.file = TestUtils.createFile((IFolder)folder, (String)"RenameFolderTest1.php", (String)"<?php class TestRenameClass{}?>");
        this.file = TestUtils.createFile((IProject)this.project1, (String)"src/src1/RenameFolderTest2.php", (String)"<?php include '../RenameFolderTest1.php'; ?>");
        TestUtils.waitForIndexer();
    }

    @Test
    public void testRename() {
        RenameFolderProcessor processor = new RenameFolderProcessor((IContainer)this.project1.getFolder("src"));
        processor.setNewElementName("src11");
        processor.setUpdateRefernces(true);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        IFolder folder = this.project1.getFolder("src11");
        Assert.assertTrue((boolean)folder.exists());
        try {
            this.file = folder.getFile("src1/RenameFolderTest2.php");
            Assert.assertTrue((boolean)this.file.exists());
            String content = FileUtils.getContents(this.file);
            Assert.assertEquals((Object)"<?php include '../RenameFolderTest1.php'; ?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

