/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.ElementsStrategy;
import org.eclipse.php.internal.core.language.keywords.PHPKeywords;

public abstract class KeywordsStrategy
extends ElementsStrategy {
    public KeywordsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public KeywordsStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext concreteContext = (AbstractCompletionContext)context;
        ISourceModule sourceModule = concreteContext.getSourceModule();
        String prefix = concreteContext.getPrefix();
        ISourceRange replaceRange = this.getReplacementRange(concreteContext);
        Collection<PHPKeywords.KeywordData> keywordsList = PHPKeywords.getInstance(sourceModule.getScriptProject().getProject()).findByPrefix(prefix);
        for (PHPKeywords.KeywordData keyword : keywordsList) {
            if (this.filterKeyword(keyword)) continue;
            String suffix = this.getSuffix(keyword, replaceRange);
            reporter.reportKeyword(keyword.name, suffix, replaceRange);
        }
    }

    private String getSuffix(PHPKeywords.KeywordData keyword, ISourceRange replaceRange) {
        String suffix = keyword.suffix;
        if (StringUtils.isEmpty((CharSequence)suffix)) {
            return suffix;
        }
        AbstractCompletionContext context = (AbstractCompletionContext)this.getContext();
        int offset = this.isInsertMode() ? context.getOffset() : replaceRange.getOffset() + replaceRange.getLength();
        try {
            String realSuffix = context.getDocument().get(offset, suffix.length());
            if (suffix.equals(realSuffix)) {
                return "";
            }
        }
        catch (BadLocationException badLocationException) {
            return suffix;
        }
        return suffix;
    }

    @Override
    public ISourceRange getReplacementRange(ICompletionContext context) throws BadLocationException {
        if (!this.isInsertMode()) {
            return this.getReplacementRangeWithSpaceAtPrefixEnd(context);
        }
        return super.getReplacementRange(context);
    }

    protected abstract boolean filterKeyword(PHPKeywords.KeywordData var1);
}

