/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.Debugger;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class PHPResponseHandler {
    PHPDebugTarget fDebugTarget;

    public PHPResponseHandler(PHPDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    public class AddFilesResponseHandler
    implements Debugger.AddFilesResponseHandler {
        @Override
        public void addFiles(boolean success) {
            if (!success) {
                Logger.log(4, "PHPResponseHandler: AddFilesResponseHandler failed");
            }
        }
    }

    public class BreakpointAddedResponseHandler
    implements Debugger.BreakpointAddedResponseHandler {
        @Override
        public void breakpointAdded(String fileName, int lineNumber, int id, boolean success) {
            String info = "Filename: " + fileName + " lineNumber " + lineNumber + " id: " + id;
            if (success) {
                IBreakpoint breakpoint = PHPResponseHandler.this.fDebugTarget.findBreakpoint(fileName, lineNumber);
                if (breakpoint != null) {
                    if (PHPResponseHandler.this.fDebugTarget.isFirstBreakpointAdded(breakpoint)) {
                        PHPResponseHandler.this.fDebugTarget.addBreakpointFiles(PHPResponseHandler.this.fDebugTarget.getProject());
                    }
                    PHPLineBreakpoint lineBreakpoint = (PHPLineBreakpoint)breakpoint;
                    Breakpoint rbp = lineBreakpoint.getRuntimeBreakpoint();
                    rbp.setID(id);
                } else {
                    Logger.trace("debug", "PHPResponseHandler:: BreakpointAddedResponseHandler unable to find breakpoint " + info);
                }
            } else {
                Logger.log(4, "PHPResponseHandler: BreakpointAddedResponseHandler failed " + info);
            }
        }
    }

    public class BreakpointRemovedResponseHandler
    implements Debugger.BreakpointRemovedResponseHandler {
        @Override
        public void breakpointRemoved(int id, boolean success) {
        }
    }

    public class GoResponseHandler
    implements Debugger.GoResponseHandler {
        @Override
        public void go(boolean success) {
            if (!success) {
                Logger.log(4, "PHPResponseHandler: GoResponseHandler failed");
            }
        }
    }

    public class PauseResponseHandler
    implements Debugger.PauseResponseHandler {
        @Override
        public void pause(boolean success) {
            if (!success) {
                Logger.log(4, "PHPResponseHandler: PauseResponseHandler failed");
            }
        }
    }

    public class StartResponseHandler
    implements Debugger.StartResponseHandler {
        @Override
        public void started(boolean success) {
            if (!success) {
                Logger.log(4, "PHPResponseHandler: StartResponseHandler failed");
            }
        }
    }

    public class StepIntoResponseHandler
    implements Debugger.StepIntoResponseHandler {
        @Override
        public void stepInto(boolean success) {
            if (!success) {
                Logger.log(4, "PHPResponseHandler: StepIntoResponseHandler failed");
            }
        }
    }

    public class StepOutResponseHandler
    implements Debugger.StepOutResponseHandler {
        @Override
        public void stepOut(boolean success) {
            if (!success) {
                Logger.log(4, "PHPResponseHandler: StepOutResponseHandler failed");
            }
        }
    }

    public class StepOverResponseHandler
    implements Debugger.StepOverResponseHandler {
        @Override
        public void stepOver(boolean success) {
            if (!success) {
                Logger.log(4, "PHPResponseHandler: StepOverResponseHandler failed");
            }
        }
    }
}

