/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.test;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.model.ModelAccess;
import org.eclipse.php.composer.test.ComposerCoreTestPlugin;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class ReverseNamespaceResolverTest {
    private IProject project;
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();

    @Test
    public void testNamespaceResolver() throws CoreException, IOException {
        this.project = TestUtils.createProject((String)"testproject2");
        Assert.assertNotNull((Object)this.project);
        ComposerCoreTestPlugin.copyProjectFiles(this.project);
        this.project.refreshLocal(2, null);
        TestUtils.setProjectPHPVersion((IProject)this.project, (PHPVersion)PHPVersion.PHP5_3);
        PHPFacets.setFacetedVersion((IProject)this.project, (PHPVersion)PHPVersion.PHP5_3);
        FacetManager.installFacets((IProject)this.project, (PHPVersion)PHPVersion.PHP5_3, (IProgressMonitor)new NullProgressMonitor());
        this.project.build(6, null);
        TestUtils.waitForIndexer();
        TestUtils.waitForAutoBuild();
        IFile file = this.project.getFile("composer.json");
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)this.project.hasNature("org.eclipse.php.core.PHPNature"));
        Assert.assertTrue((boolean)FacetManager.hasComposerFacet((IProject)this.project));
        String namespace = "Foobar\\Sub";
        IPath resolvedPath = ModelAccess.getInstance().reverseResolve(this.project, namespace);
        Assert.assertNotNull((Object)resolvedPath);
        Assert.assertTrue((boolean)this.project.getFolder(resolvedPath).exists());
    }

    @After
    public void cleanup() throws CoreException {
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }
}

