/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.engine.cachegrind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CacheGrindParser {
    private InputStream fFile;
    private static final List<State> mainStates = new ArrayList<State>();

    static {
        mainStates.add(new FunctionState());
        mainStates.add(new FileState("fl="));
        mainStates.add(new FileState("fi="));
        mainStates.add(new FileState("fe="));
        mainStates.add(new NextFunctionState());
        mainStates.add(new NextFileState("cfl="));
        mainStates.add(new NextFileState("cfi="));
        mainStates.add(new CostState());
        mainStates.add(new CallsState());
        mainStates.add(new CreatorState());
        mainStates.add(new VersionState());
        mainStates.add(new CMDState());
        mainStates.add(new PIDState());
        mainStates.add(new PartState());
        mainStates.add(new PositionsState());
        mainStates.add(new EventsState());
        mainStates.add(new SummaryState());
        mainStates.add(new TotalsState());
        mainStates.add(new CommentState());
    }

    public CacheGrindParser(InputStream file) {
        this.fFile = file;
    }

    public void parse(CacheGrindParserListener listener) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.fFile));
            int letter = ((Reader)reader).read();
            StringBuilder buff = new StringBuilder();
            List<State> states = mainStates;
            while (letter != -1) {
                if (letter == 10 || letter == 13) {
                    if (states.size() != 1) {
                        if (buff.length() > 0) {
                            listener.unknown(buff.toString());
                        }
                    } else if (states.size() == 1) {
                        states.get(0).consume(listener);
                    }
                    if (states.size() > 0) {
                        states.forEach(s -> s.reset());
                    }
                    buff.setLength(0);
                    states = mainStates;
                } else if (states.size() > 0) {
                    char tmp = (char)letter;
                    states = states.stream().filter(s -> {
                        if (s.valid(tmp)) {
                            return true;
                        }
                        s.reset();
                        return false;
                    }).collect(Collectors.toList());
                    buff.append(tmp);
                } else {
                    buff.append((char)letter);
                }
                letter = ((Reader)reader).read();
            }
        }
        finally {
            mainStates.forEach(s -> s.reset());
        }
    }

    private static abstract class BlockState
    implements State {
        private final char[] name;
        private int pointer = 0;

        public BlockState(char[] name) {
            this.name = name;
        }

        @Override
        public boolean valid(char letter) {
            if (this.pointer >= this.name.length) {
                return this.next().valid(letter);
            }
            if (this.name.length > this.pointer && this.name[this.pointer] == letter) {
                ++this.pointer;
                return true;
            }
            return false;
        }

        public abstract State next();

        @Override
        public void reset() {
            this.pointer = 0;
            this.next().reset();
        }
    }

    private static class CMDState
    extends TagState {
        private StringState next = new StringState();

        public CMDState() {
            super("cmd".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.cmd(this.next.result());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    public static interface CacheGrindParserListener {
        default public void events(String[] events) {
        }

        default public void version(String version) {
        }

        default public void creator(String creator) {
        }

        default public void unknown(String line) {
        }

        default public void positions(String[] type) {
        }

        default public void part(int part) {
        }

        default public void cmd(String cmd) {
        }

        default public void calls(int count, int[] values) {
        }

        default public void pid(int pid) {
        }

        default public void summary(int[] sum) {
        }

        default public void totals(int[] sum) {
        }

        default public void file(int id, String name) {
        }

        default public void function(int id, String name) {
        }

        default public void nextFile(int id, String name) {
        }

        default public void nextFunction(int id, String name) {
        }

        default public void cost(int pos, int[] events) {
        }
    }

    private static class CallsState
    extends BlockState {
        private NumbersState next = new NumbersState();

        public CallsState() {
            super("calls=".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            int[] nums = this.next.result();
            if (nums.length > 1) {
                listener.calls(nums[0], Arrays.stream(nums).skip(1L).toArray());
            } else {
                listener.unknown("calls=");
            }
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class CommentState
    implements State {
        private boolean test = true;

        private CommentState() {
        }

        @Override
        public boolean valid(char letter) {
            if (this.test && letter != '#') {
                return false;
            }
            this.test = false;
            return true;
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
        }

        @Override
        public void reset() {
            this.test = true;
        }
    }

    private static class CostState
    extends BlockState {
        private NumbersState next = new NumbersState();

        public CostState() {
            super("".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            int[] nums = this.next.result();
            listener.cost(nums[0], Arrays.stream(nums).skip(1L).toArray());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class CreatorState
    extends TagState {
        private StringState next = new StringState();

        public CreatorState() {
            super("creator".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.creator(this.next.result());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class EventsState
    extends TagState {
        private StringsState next = new StringsState();

        public EventsState() {
            super("events".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.events(this.next.result());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class FileState
    extends BlockState {
        private NameState next = new NameState();

        public FileState(String name) {
            super(name.toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.file(this.next.index(), this.next.name());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class FunctionState
    extends BlockState {
        private NameState next = new NameState();

        public FunctionState() {
            super("fn=".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.function(this.next.index(), this.next.name());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class NameState
    implements State {
        private static final int WAIT_INDEX = -1;
        private static final int WAIT_INDEX_NUM = -2;
        private static final int WAIT_SPACE = -4;
        private static final int WAIT_NAME = -8;
        private int index = -1;
        private NumberState num = new NumberState();
        private StringState name = new StringState();

        private NameState() {
        }

        @Override
        public boolean valid(char letter) {
            if (this.index == -1) {
                if (letter == '(') {
                    this.index = -2;
                    return true;
                }
                this.index = -8;
            } else {
                if (this.index == -2) {
                    if (letter == ')') {
                        this.index = -4;
                        return true;
                    }
                    return this.num.valid(letter);
                }
                if (this.index == -4) {
                    if (letter == ' ' || letter == '\t') {
                        this.index = this.num.result();
                        return true;
                    }
                    return false;
                }
            }
            return this.name.valid(letter);
        }

        @Override
        public void reset() {
            this.num.reset();
            this.name.reset();
            this.index = -1;
        }

        public String name() {
            if (this.index == -8 || this.index > 0) {
                String val = this.name.result();
                if (val.length() == 0) {
                    return null;
                }
                return val;
            }
            return null;
        }

        public int index() {
            if (this.index == -4) {
                this.index = this.num.result();
            }
            if (this.index >= 0) {
                return this.index;
            }
            return -1;
        }
    }

    private static class NextFileState
    extends BlockState {
        private NameState next = new NameState();

        public NextFileState(String name) {
            super(name.toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.nextFile(this.next.index(), this.next.name());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class NextFunctionState
    extends BlockState {
        private NameState next = new NameState();

        public NextFunctionState() {
            super("cfn=".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.nextFunction(this.next.index(), this.next.name());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class NumberState
    implements State {
        private StringBuilder sb = new StringBuilder();

        private NumberState() {
        }

        @Override
        public boolean valid(char letter) {
            if (Character.isDigit(letter) || this.sb.length() == 0 && (letter == '+' || letter == '-')) {
                this.sb.append(letter);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.sb.setLength(0);
        }

        public int result() {
            if (this.sb.length() == 0) {
                return 0;
            }
            return Integer.valueOf(this.sb.toString());
        }
    }

    private static class NumbersState
    implements State {
        private StringBuilder sb = new StringBuilder();
        private List<Integer> numbers = new ArrayList<Integer>();

        private NumbersState() {
        }

        @Override
        public boolean valid(char letter) {
            if (letter == ' ' || letter == '\t') {
                this.collect();
                return true;
            }
            if (Character.isDigit(letter) || this.sb.length() == 0 && (letter == '+' || letter == '-')) {
                this.sb.append(letter);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.sb.setLength(0);
            this.numbers.clear();
        }

        private void collect() {
            if (this.sb.length() > 0) {
                this.numbers.add(Integer.valueOf(this.sb.toString()));
                this.sb.setLength(0);
            }
        }

        public int[] result() {
            this.collect();
            return this.numbers.stream().mapToInt(Integer::intValue).toArray();
        }
    }

    private static class PIDState
    extends TagState {
        private NumberState next = new NumberState();

        public PIDState() {
            super("pid".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.pid(this.next.result());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class PartState
    extends TagState {
        private NumberState next = new NumberState();

        public PartState() {
            super("part".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.part(this.next.result());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class PositionsState
    extends TagState {
        private StringsState next = new StringsState();

        public PositionsState() {
            super("positions".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.positions(this.next.result());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static interface State {
        public boolean valid(char var1);

        default public void consume(CacheGrindParserListener listener) {
        }

        public void reset();
    }

    private static class StringState
    implements State {
        private StringBuilder sb = new StringBuilder();

        private StringState() {
        }

        @Override
        public boolean valid(char letter) {
            this.sb.append(letter);
            return true;
        }

        @Override
        public void reset() {
            this.sb.setLength(0);
        }

        public String result() {
            return this.sb.toString();
        }
    }

    private static class StringsState
    implements State {
        private StringBuilder sb = new StringBuilder();
        private List<String> strings = new ArrayList<String>();

        private StringsState() {
        }

        @Override
        public boolean valid(char letter) {
            if (letter == ' ' || letter == '\t') {
                this.collect();
            } else {
                this.sb.append(letter);
            }
            return true;
        }

        @Override
        public void reset() {
            this.sb.setLength(0);
            this.strings.clear();
        }

        private void collect() {
            if (this.sb.length() > 0) {
                this.strings.add(this.sb.toString());
                this.sb.setLength(0);
            }
        }

        public String[] result() {
            this.collect();
            return this.strings.toArray(new String[0]);
        }
    }

    private static class SummaryState
    extends TagState {
        private NumbersState next = new NumbersState();

        public SummaryState() {
            super("summary".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.summary(this.next.result());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static abstract class TagState
    implements State {
        private final char[] name;
        private int pointer = 0;

        public TagState(char[] name) {
            this.name = name;
        }

        @Override
        public boolean valid(char letter) {
            if (this.pointer > this.name.length) {
                if (this.pointer == this.name.length + 1) {
                    ++this.pointer;
                    return letter == ' ' || letter == '\t';
                }
                return this.next().valid(letter);
            }
            if (this.pointer == this.name.length && letter == ':') {
                ++this.pointer;
                return true;
            }
            if (this.name[this.pointer] == letter) {
                ++this.pointer;
                return true;
            }
            return false;
        }

        public abstract State next();

        @Override
        public void reset() {
            this.pointer = 0;
            this.next().reset();
        }
    }

    private static class TotalsState
    extends TagState {
        private NumbersState next = new NumbersState();

        public TotalsState() {
            super("totals".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.totals(this.next.result());
        }

        @Override
        public State next() {
            return this.next;
        }
    }

    private static class VersionState
    extends TagState {
        private StringState next = new StringState();

        public VersionState() {
            super("version".toCharArray());
        }

        @Override
        public void consume(CacheGrindParserListener listener) {
            listener.version(this.next.result());
        }

        @Override
        public State next() {
            return this.next;
        }
    }
}

