/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006, 2017 Zend Corporation and IBM Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.ast.scanner.php5;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;

import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.util.collections.StateStack;

import java_cup.sym;
import java_cup.runtime.Symbol;

@SuppressWarnings({"unused", "nls"})


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>ast_scanner.flex</tt>
 */
public class PHPAstLexer implements org.eclipse.php.internal.core.ast.scanner.AstLexer {

	/** This character denotes the end of file */
	public static final int YYEOF = -1;

	/** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

	/** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_IN_SCRIPTING = 2;
  public static final int ST_DOUBLE_QUOTES = 4;
  public static final int ST_SINGLE_QUOTE = 6;
  public static final int ST_BACKQUOTE = 8;
  public static final int ST_HEREDOC = 10;
  public static final int ST_START_HEREDOC = 12;
  public static final int ST_END_HEREDOC = 14;
  public static final int ST_LOOKING_FOR_PROPERTY = 16;
  public static final int ST_LOOKING_FOR_VARNAME = 18;
  public static final int ST_VAR_OFFSET = 20;
  public static final int ST_COMMENT = 22;
  public static final int ST_DOCBLOCK = 24;
  public static final int ST_ONE_LINE_COMMENT = 26;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\11\2\0\1\13\22\0\1\12\1\57\1\15\1\77"+
    "\1\14\1\63\1\64\1\76\1\50\1\52\1\61\1\4\1\67\1\44"+
    "\1\2\1\62\1\5\11\1\1\46\1\21\1\60\1\56\1\45\1\73"+
    "\1\74\1\35\1\7\1\30\1\24\1\3\1\25\1\51\1\36\1\22"+
    "\1\53\1\41\1\40\1\43\1\27\1\31\1\42\1\55\1\33\1\32"+
    "\1\23\1\26\1\47\1\37\1\6\1\34\1\10\1\70\1\16\1\71"+
    "\1\66\1\54\1\17\1\35\1\7\1\30\1\24\1\3\1\25\1\51"+
    "\1\36\1\22\1\53\1\41\1\40\1\43\1\27\1\31\1\42\1\55"+
    "\1\33\1\32\1\23\1\26\1\47\1\37\1\6\1\34\1\10\1\20"+
    "\1\65\1\75\1\72\1\0\260\10\2\22\115\10\1\32\u1faa\10\1\41"+
    "\uded5\10\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\20\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\10\0\2\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\4\3\6\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\16\6\1\16\1\17\1\20\1\6\1\21\1\6"+
    "\1\22\1\6\1\23\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\1\43\1\44\1\1\1\3\1\45\2\3"+
    "\1\46\1\3\1\47\1\1\2\3\1\50\1\3\2\1"+
    "\3\3\2\51\1\3\1\52\1\53\1\52\1\54\1\55"+
    "\1\56\1\5\1\7\1\56\1\57\1\60\1\61\1\62"+
    "\1\16\1\17\1\20\1\21\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\63\1\40\1\64"+
    "\1\10\1\65\3\10\3\66\2\65\1\0\1\67\1\70"+
    "\1\71\1\0\1\72\6\6\1\73\1\74\1\0\2\6"+
    "\2\0\1\75\2\0\1\76\2\0\1\77\7\6\1\100"+
    "\11\6\1\101\5\6\1\102\5\6\1\103\1\104\1\105"+
    "\1\106\1\107\1\110\1\6\12\0\2\6\1\111\1\112"+
    "\2\113\1\114\1\115\1\0\1\116\1\117\1\120\1\121"+
    "\1\122\1\123\1\124\1\125\1\126\1\127\1\130\4\0"+
    "\1\75\2\131\1\132\1\133\1\131\1\0\1\134\3\0"+
    "\2\131\3\0\1\1\2\131\1\0\1\135\2\0\1\136"+
    "\1\0\1\137\1\0\1\140\1\141\1\142\1\143\1\0"+
    "\1\71\1\0\7\6\1\71\1\144\1\6\1\0\5\6"+
    "\1\145\3\6\1\146\2\6\1\147\1\6\1\150\1\151"+
    "\12\6\1\152\6\6\1\153\1\154\12\0\6\6\1\155"+
    "\1\156\1\157\3\0\1\160\2\0\1\161\1\162\1\1"+
    "\1\56\1\0\6\6\1\163\1\164\1\6\1\165\21\6"+
    "\1\166\11\6\1\167\4\6\12\0\7\6\2\0\1\170"+
    "\3\0\1\6\1\171\5\6\1\172\1\173\3\6\1\174"+
    "\1\6\1\175\3\6\1\176\2\6\1\177\1\6\1\200"+
    "\1\201\1\202\1\203\5\6\1\204\1\205\1\6\1\206"+
    "\2\6\4\0\1\207\7\0\7\6\2\210\2\0\1\211"+
    "\2\212\2\6\1\213\2\6\1\214\4\6\1\215\5\6"+
    "\1\216\1\217\1\220\2\6\1\221\2\6\3\0\1\222"+
    "\5\0\1\223\1\0\1\224\6\6\2\0\1\225\5\6"+
    "\1\226\2\6\1\227\1\230\1\6\1\231\1\6\1\232"+
    "\1\6\1\233\1\6\3\0\1\234\1\0\1\235\6\6"+
    "\2\0\3\6\1\236\4\6\1\237\1\240\1\6\1\241"+
    "\1\6\1\242\1\243\1\244\3\6\1\245\1\6\4\0"+
    "\2\6\1\246\1\247\4\6\1\250\1\6\1\251\2\6"+
    "\2\0\1\252\1\253\1\6\1\254\1\255\3\6\1\256"+
    "\2\0\4\6\3\0\1\257\1\260\1\261\1\6\2\0"+
    "\1\6\1\262\1\6\1\263";

  private static int [] zzUnpackAction() {
    int [] result = new int[610];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\100\0\200\0\300\0\u0100\0\u0140\0\u0180\0\u01c0"+
    "\0\u0200\0\u0240\0\u0280\0\u02c0\0\u0300\0\u0340\0\u0380\0\u03c0"+
    "\0\u0400\0\u0440\0\u0480\0\u04c0\0\u0500\0\u0540\0\u0580\0\u05c0"+
    "\0\u0600\0\u0640\0\u0680\0\u06c0\0\u0400\0\u0400\0\u0400\0\u0700"+
    "\0\u0740\0\u0780\0\u07c0\0\u0800\0\u0840\0\u0880\0\u08c0\0\u0900"+
    "\0\u0940\0\u0980\0\u09c0\0\u0a00\0\u0a40\0\u0a80\0\u0ac0\0\u0b00"+
    "\0\u0b40\0\u0b80\0\u0bc0\0\u0400\0\u0c00\0\u0c40\0\u0c80\0\u0cc0"+
    "\0\u0d00\0\u0d40\0\u0d80\0\u0dc0\0\u0e00\0\u0e40\0\u0400\0\u0400"+
    "\0\u0400\0\u0400\0\u0e80\0\u0400\0\u0400\0\u0ec0\0\u0400\0\u0f00"+
    "\0\u0f40\0\u0400\0\u0f80\0\u0fc0\0\u1000\0\u1040\0\u0400\0\u1080"+
    "\0\u10c0\0\u1100\0\u0400\0\u1140\0\u1180\0\u11c0\0\u1200\0\u1240"+
    "\0\u1280\0\u0400\0\u12c0\0\u1300\0\u0400\0\u1340\0\u1380\0\u0400"+
    "\0\u13c0\0\u1400\0\u0400\0\u0400\0\u1440\0\u0400\0\u0400\0\u0400"+
    "\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400"+
    "\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400"+
    "\0\u0400\0\u1480\0\u14c0\0\u0400\0\u1500\0\u1540\0\u1580\0\u0400"+
    "\0\u15c0\0\u0400\0\u1600\0\u1640\0\u1680\0\u16c0\0\u1700\0\u1740"+
    "\0\u0400\0\u1780\0\u17c0\0\u1800\0\u1840\0\u1880\0\u18c0\0\u0400"+
    "\0\u0400\0\u1900\0\u1940\0\u1980\0\u19c0\0\u0ec0\0\u1a00\0\u06c0"+
    "\0\u1a40\0\u0400\0\u1a80\0\u1ac0\0\u0600\0\u1b00\0\u1b40\0\u1b80"+
    "\0\u1bc0\0\u1c00\0\u1c40\0\u1c80\0\u0600\0\u1cc0\0\u1d00\0\u1d40"+
    "\0\u1d80\0\u1dc0\0\u1e00\0\u1e40\0\u1e80\0\u1ec0\0\u0600\0\u1f00"+
    "\0\u1f40\0\u1f80\0\u1fc0\0\u2000\0\u0600\0\u2040\0\u2080\0\u20c0"+
    "\0\u2100\0\u2140\0\u0400\0\u0400\0\u0400\0\u2180\0\u0400\0\u0400"+
    "\0\u21c0\0\u2200\0\u0b80\0\u2240\0\u2280\0\u22c0\0\u2300\0\u2340"+
    "\0\u2380\0\u23c0\0\u2400\0\u2440\0\u2480\0\u0400\0\u24c0\0\u2500"+
    "\0\u0400\0\u0400\0\u2540\0\u2580\0\u0400\0\u0400\0\u25c0\0\u0400"+
    "\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400\0\u0400\0\u2600"+
    "\0\u2640\0\u0f80\0\u2680\0\u26c0\0\u2640\0\u0400\0\u0400\0\u0400"+
    "\0\u2680\0\u2700\0\u0400\0\u2740\0\u1100\0\u2780\0\u2740\0\u2780"+
    "\0\u27c0\0\u1240\0\u2800\0\u2840\0\u27c0\0\u2800\0\u12c0\0\u0400"+
    "\0\u2880\0\u1300\0\u0400\0\u28c0\0\u0400\0\u2900\0\u0400\0\u0400"+
    "\0\u0400\0\u0400\0\u2940\0\u2980\0\u2980\0\u29c0\0\u2a00\0\u2a40"+
    "\0\u2a80\0\u2ac0\0\u2b00\0\u2b40\0\u1900\0\u0600\0\u2b80\0\u2bc0"+
    "\0\u2c00\0\u2c40\0\u2c80\0\u2cc0\0\u2d00\0\u0600\0\u2d40\0\u2d80"+
    "\0\u2dc0\0\u0600\0\u2e00\0\u2e40\0\u2e80\0\u2ec0\0\u0600\0\u0600"+
    "\0\u2f00\0\u2f40\0\u2f80\0\u2fc0\0\u3000\0\u3040\0\u3080\0\u30c0"+
    "\0\u3100\0\u3140\0\u0600\0\u3180\0\u31c0\0\u3200\0\u3240\0\u3280"+
    "\0\u32c0\0\u0400\0\u0600\0\u3300\0\u3340\0\u3380\0\u33c0\0\u3400"+
    "\0\u3440\0\u3480\0\u34c0\0\u3500\0\u3540\0\u3580\0\u35c0\0\u3600"+
    "\0\u3640\0\u3680\0\u36c0\0\u0400\0\u0400\0\u0400\0\u3700\0\u3740"+
    "\0\u3780\0\u37c0\0\u3800\0\u3840\0\u0400\0\u0400\0\u3880\0\u2900"+
    "\0\u38c0\0\u3900\0\u3940\0\u3980\0\u39c0\0\u3a00\0\u3a40\0\u0600"+
    "\0\u3a80\0\u3ac0\0\u0600\0\u3b00\0\u3b40\0\u3b80\0\u3bc0\0\u3c00"+
    "\0\u3c40\0\u3c80\0\u3cc0\0\u3d00\0\u3d40\0\u3d80\0\u3dc0\0\u3e00"+
    "\0\u3e40\0\u3e80\0\u3ec0\0\u3f00\0\u0600\0\u3f40\0\u3f80\0\u3fc0"+
    "\0\u4000\0\u4040\0\u4080\0\u40c0\0\u4100\0\u4140\0\u0600\0\u4180"+
    "\0\u41c0\0\u4200\0\u4240\0\u4280\0\u42c0\0\u4300\0\u4340\0\u4380"+
    "\0\u43c0\0\u4400\0\u4440\0\u4480\0\u44c0\0\u4500\0\u4540\0\u4580"+
    "\0\u45c0\0\u4600\0\u4640\0\u4680\0\u46c0\0\u4700\0\u0400\0\u4740"+
    "\0\u4780\0\u47c0\0\u4800\0\u0600\0\u4840\0\u4880\0\u48c0\0\u4900"+
    "\0\u4940\0\u0600\0\u0600\0\u4980\0\u49c0\0\u4a00\0\u0600\0\u4a40"+
    "\0\u0600\0\u4a80\0\u4ac0\0\u4b00\0\u0600\0\u4b40\0\u4b80\0\u0600"+
    "\0\u4bc0\0\u0600\0\u0600\0\u0600\0\u0600\0\u4c00\0\u4c40\0\u4c80"+
    "\0\u4cc0\0\u4d00\0\u0600\0\u0600\0\u4d40\0\u0600\0\u4d80\0\u4dc0"+
    "\0\u4e00\0\u4e40\0\u4e80\0\u4ec0\0\u0400\0\u4f00\0\u4f40\0\u4f80"+
    "\0\u4fc0\0\u5000\0\u5040\0\u5080\0\u50c0\0\u5100\0\u5140\0\u5180"+
    "\0\u51c0\0\u5200\0\u5240\0\u0400\0\u5280\0\u52c0\0\u5300\0\u0400"+
    "\0\u0400\0\u5340\0\u5380\0\u53c0\0\u5400\0\u5440\0\u5480\0\u0600"+
    "\0\u54c0\0\u5500\0\u5540\0\u5580\0\u0600\0\u55c0\0\u5600\0\u5640"+
    "\0\u5680\0\u56c0\0\u0600\0\u0600\0\u0600\0\u5700\0\u5740\0\u0600"+
    "\0\u5780\0\u57c0\0\u5800\0\u5840\0\u5880\0\u0400\0\u58c0\0\u5900"+
    "\0\u5940\0\u5980\0\u59c0\0\u0400\0\u5a00\0\u0600\0\u5a40\0\u5a80"+
    "\0\u5ac0\0\u5b00\0\u5b40\0\u5b80\0\u5bc0\0\u5c00\0\u0600\0\u5c40"+
    "\0\u5c80\0\u5cc0\0\u5d00\0\u5d40\0\u5d80\0\u5dc0\0\u5e00\0\u0600"+
    "\0\u0600\0\u5e40\0\u0600\0\u5e80\0\u5ec0\0\u5f00\0\u0600\0\u5f40"+
    "\0\u5f80\0\u5fc0\0\u6000\0\u0400\0\u6040\0\u0400\0\u6080\0\u60c0"+
    "\0\u6100\0\u6140\0\u6180\0\u61c0\0\u6200\0\u6240\0\u6280\0\u62c0"+
    "\0\u6300\0\u0600\0\u6340\0\u6380\0\u63c0\0\u6400\0\u0600\0\u0600"+
    "\0\u6440\0\u0600\0\u6480\0\u0400\0\u0400\0\u0600\0\u64c0\0\u6500"+
    "\0\u6540\0\u0600\0\u6580\0\u65c0\0\u6600\0\u6640\0\u6680\0\u66c0"+
    "\0\u6700\0\u0600\0\u0600\0\u6740\0\u6780\0\u67c0\0\u6800\0\u0600"+
    "\0\u6840\0\u0600\0\u6880\0\u68c0\0\u6900\0\u6940\0\u0600\0\u0600"+
    "\0\u6980\0\u0600\0\u0600\0\u69c0\0\u6a00\0\u6a40\0\u0600\0\u6a80"+
    "\0\u6ac0\0\u6b00\0\u6b40\0\u6b80\0\u6bc0\0\u6c00\0\u6c40\0\u6c80"+
    "\0\u0600\0\u0600\0\u0600\0\u6cc0\0\u6d00\0\u6d40\0\u6d80\0\u0400"+
    "\0\u6dc0\0\u0600";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[610];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\60\17\1\20\17\17\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\3\32\1\33\1\34\1\21"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\31\1\52\1\31"+
    "\1\53\1\54\1\31\1\55\1\31\1\56\1\57\1\60"+
    "\1\61\1\62\1\63\1\64\1\31\1\65\1\31\1\66"+
    "\1\67\1\70\1\71\1\72\1\73\1\74\1\75\1\76"+
    "\1\77\1\100\1\101\1\102\1\103\1\104\1\105\1\106"+
    "\1\107\14\110\1\111\1\112\1\113\1\110\1\114\57\110"+
    "\16\115\1\116\57\115\1\117\1\115\14\120\1\121\1\120"+
    "\1\122\1\123\1\124\57\120\11\125\1\126\1\125\1\126"+
    "\1\127\1\125\1\130\1\125\1\131\57\125\3\132\1\133"+
    "\2\132\3\133\11\132\22\133\3\132\1\133\1\132\1\133"+
    "\1\132\3\133\22\132\3\21\1\134\2\21\3\134\11\21"+
    "\22\134\3\21\1\134\1\21\1\134\1\21\3\134\22\21"+
    "\3\135\1\136\2\135\3\136\11\135\22\136\1\137\2\135"+
    "\1\136\1\135\1\136\1\135\3\136\22\135\3\140\1\141"+
    "\2\140\3\141\11\140\22\141\3\140\1\141\1\140\1\141"+
    "\1\140\3\141\22\140\1\21\1\142\1\143\1\31\1\144"+
    "\1\145\3\31\3\146\1\33\1\147\1\146\1\150\1\151"+
    "\1\37\22\31\1\152\1\153\1\154\1\31\1\155\1\31"+
    "\1\64\3\31\1\156\1\157\1\160\1\161\1\162\1\163"+
    "\1\164\1\165\1\166\1\77\1\100\1\167\1\102\1\170"+
    "\1\104\1\171\2\146\61\172\1\173\16\172\13\174\1\175"+
    "\45\174\1\176\16\174\11\177\1\200\1\177\1\201\31\177"+
    "\1\202\15\177\1\203\7\177\1\203\4\177\60\17\1\204"+
    "\77\17\1\0\2\17\1\205\7\17\1\206\4\17\101\0"+
    "\1\22\1\207\1\210\1\0\1\22\73\0\1\207\3\0"+
    "\1\207\50\0\1\211\22\0\1\31\1\0\1\31\1\0"+
    "\1\31\1\212\2\31\11\0\5\31\1\213\1\214\7\31"+
    "\1\215\2\31\1\216\3\0\1\217\1\0\1\31\1\0"+
    "\3\31\26\0\1\220\51\0\1\221\22\0\1\22\1\207"+
    "\1\210\1\0\1\22\1\222\72\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\7\31\1\223\12\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\4\0\1\34\4\0\11\31\1\224\10\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\2\0\1\225"+
    "\15\0\1\226\2\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\33\0\3\32\67\0\1\227\2\0\3\227\11\0\22\227"+
    "\3\0\1\227\1\0\1\227\1\0\3\227\22\0\14\230"+
    "\1\231\1\232\1\233\1\230\1\234\57\230\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\3\31\1\235\1\31"+
    "\1\236\2\31\1\237\10\31\1\240\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\11\31\1\241\2\31\1\242\5\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\243\1\0\4\31\11\0\1\244\6\31\1\245\12\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\246\3\31\1\247"+
    "\2\31\1\250\12\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\5\31\1\251\2\31\1\252\11\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\253\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\7\31\1\254\3\31\1\255\2\31\1\256\3\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\11\31\1\257\10\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\31\1\260\13\31\1\261"+
    "\4\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\262\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\2\31\1\263\1\31\11\0\5\31\1\264"+
    "\2\31\1\265\1\266\10\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\14\31\1\267\5\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\1\270\21\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\4\31\1\271\4\31\1\272\10\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\66\0\1\273\1\274\10\0\1\275"+
    "\66\0\1\276\10\0\1\277\67\0\1\300\32\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\13\31\1\301\6\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\31\0\1\302"+
    "\2\0\1\303\7\0\1\304\1\0\1\305\1\306\1\307"+
    "\2\0\1\310\1\311\1\312\1\0\1\313\43\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\16\31\1\314\3\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\1\31\1\315\1\31\67\0\1\316"+
    "\10\0\1\317\77\0\1\320\66\0\1\321\10\0\1\322"+
    "\1\0\1\323\1\0\1\324\73\0\1\325\77\0\1\326"+
    "\2\0\1\327\1\107\62\0\1\330\10\0\1\331\77\0"+
    "\1\332\5\0\1\333\71\0\1\334\6\0\1\335\70\0"+
    "\1\336\66\0\1\337\32\0\16\226\1\340\57\226\1\232"+
    "\1\226\14\110\1\341\1\0\1\342\1\110\1\343\62\110"+
    "\1\344\2\110\3\344\3\110\1\345\1\346\1\342\1\110"+
    "\1\347\1\110\22\344\3\110\1\344\1\110\1\344\1\110"+
    "\3\344\136\110\1\350\1\346\1\342\1\110\1\351\57\110"+
    "\16\115\1\352\57\115\1\0\17\115\1\353\57\115\1\353"+
    "\1\115\14\120\1\354\1\120\1\355\1\0\1\356\62\120"+
    "\1\344\2\120\3\344\3\120\1\357\1\120\1\355\1\346"+
    "\1\347\1\120\22\344\3\120\1\344\1\120\1\344\1\120"+
    "\3\344\136\120\1\350\1\120\1\355\1\346\1\360\57\120"+
    "\11\125\1\126\1\125\1\126\1\361\1\125\1\362\1\125"+
    "\1\363\62\125\1\364\2\125\3\364\1\126\1\125\1\126"+
    "\1\361\1\125\1\362\1\125\1\363\1\125\22\364\3\125"+
    "\1\364\1\125\1\364\1\125\3\364\25\125\1\344\2\125"+
    "\3\344\1\126\1\125\1\126\1\365\1\125\1\362\1\125"+
    "\1\347\1\125\22\344\3\125\1\344\1\125\1\344\1\125"+
    "\3\344\33\125\1\126\1\125\1\126\75\125\1\126\1\125"+
    "\1\126\1\350\1\125\1\362\1\125\1\366\57\125\1\0"+
    "\1\367\1\0\1\367\1\0\4\367\1\370\1\0\1\370"+
    "\5\0\1\371\22\367\3\0\1\367\1\0\1\367\1\0"+
    "\3\367\23\0\1\372\1\0\1\372\1\0\4\372\1\373"+
    "\1\0\1\373\5\0\1\374\22\372\3\0\1\372\1\0"+
    "\1\372\1\0\3\372\23\0\1\136\1\0\1\136\1\0"+
    "\4\136\11\0\22\136\3\0\1\136\1\0\1\136\1\0"+
    "\3\136\67\0\1\375\33\0\1\141\1\0\1\141\1\0"+
    "\4\141\11\0\22\141\3\0\1\141\1\0\1\141\1\0"+
    "\3\141\23\0\1\142\3\0\1\142\73\0\1\142\3\0"+
    "\1\142\1\376\71\0\61\172\1\0\16\172\62\0\1\377"+
    "\26\0\1\174\150\0\1\u0100\15\0\11\177\1\200\1\177"+
    "\1\201\31\177\1\200\15\177\1\200\7\177\1\200\4\177"+
    "\11\0\1\200\133\0\1\u0101\32\0\60\17\1\0\2\17"+
    "\1\0\7\17\1\0\4\17\56\0\1\u0102\63\0\1\u0103"+
    "\13\0\1\u0102\22\0\1\207\1\0\1\210\1\0\1\207"+
    "\73\0\1\u0104\2\0\1\u0105\1\u0104\36\0\1\u0105\34\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\1\u0106\1\u0107"+
    "\20\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\2\31\1\u0108"+
    "\17\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\14\31\1\u0109"+
    "\5\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\10\31\1\u010a"+
    "\11\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\20\31\1\u010b"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\13\31\1\u010c"+
    "\6\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\u010d\1\0\1\u010d\1\0\1\u010d\1\0\1\u010d\14\0"+
    "\2\u010d\2\0\1\u010d\4\0\1\u010d\43\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\11\31\1\u010e\10\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\u010f\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\102\0\1\u0110\20\0\1\227\1\0"+
    "\1\227\1\0\4\227\11\0\22\227\3\0\1\227\1\0"+
    "\1\227\1\0\3\227\22\0\3\230\1\0\2\230\3\0"+
    "\3\230\1\231\1\232\1\233\1\230\1\0\1\230\22\0"+
    "\3\230\1\0\1\230\1\0\1\230\3\0\136\230\1\0"+
    "\1\232\1\233\1\230\1\234\57\230\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\31\1\u0111\4\31\1\u0112"+
    "\1\31\1\u0113\11\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\10\31\1\u0114\11\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\20\31\1\u0115\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\12\31\1\u0116\7\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\11\31\1\u0117\10\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\3\31\1\u0118\2\31\1\u0119\13\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\u011a\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\5\31\1\u011b\14\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\5\31\1\u011c\14\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\11\31\1\u011d\10\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\10\31\1\u011e\11\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\u011f\1\0\4\31\11\0"+
    "\22\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\15\31\1\u0120"+
    "\4\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\5\31\1\u0121"+
    "\14\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\1\31\1\u0122"+
    "\6\31\1\u0123\11\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\7\31\1\u0124\3\31\1\u0125\6\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\13\31\1\u0126\6\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\u0127\21\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\1\31\1\u0128\20\31\3\0\1\31\1\0\1\31"+
    "\1\0\2\31\1\u0129\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\10\31\1\u012a\11\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\2\31\1\u012b\17\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\11\31\1\u012c\10\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\u012d\21\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\10\31\1\u012e\11\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\2\31"+
    "\1\u012f\1\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\1\u0130\6\31\1\u0131\12\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\100\0\1\u0132\22\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\11\31\1\u0133\10\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\44\0\1\u0134\6\0"+
    "\1\u0135\75\0\1\u0136\101\0\1\u0137\106\0\1\u0138\66\0"+
    "\1\u0139\57\0\1\u013a\113\0\1\u013b\57\0\1\u013c\127\0"+
    "\1\u013d\45\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\7\31\1\u013e\12\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\3\31\1\u013f\2\31\1\u0140\5\31\1\u0141\1\31\1\u0142"+
    "\2\31\1\u0143\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\100\0\1\u0144\77\0\1\u0145\77\0\1\u0146\1\0\1\u0147"+
    "\51\0\1\u0148\56\0\3\u0149\45\0\1\u014a\12\0\1\u014b"+
    "\3\0\100\226\3\110\1\0\2\110\3\0\3\110\1\345"+
    "\1\346\1\342\1\110\1\0\1\110\22\0\3\110\1\0"+
    "\1\110\1\0\1\110\3\0\36\110\1\0\1\346\1\342"+
    "\1\110\1\351\57\110\1\0\1\344\1\0\1\344\1\0"+
    "\4\344\11\0\22\344\1\u014c\2\0\1\344\1\0\1\344"+
    "\1\0\3\344\12\0\1\u014d\7\0\16\115\1\0\57\115"+
    "\1\0\1\115\3\120\1\0\2\120\3\0\3\120\1\357"+
    "\1\120\1\355\1\346\1\0\1\120\22\0\3\120\1\0"+
    "\1\120\1\0\1\120\3\0\36\120\1\0\1\120\1\355"+
    "\1\346\1\360\57\120\3\125\1\0\2\125\3\0\1\126"+
    "\1\125\1\126\1\365\1\125\1\362\1\125\1\0\1\125"+
    "\22\0\3\125\1\0\1\125\1\0\1\125\3\0\33\125"+
    "\1\126\1\125\1\126\1\0\1\125\1\362\1\125\1\366"+
    "\60\125\1\364\1\125\1\364\1\125\4\364\1\u014e\1\125"+
    "\1\u014e\1\361\1\125\1\362\1\125\1\363\1\u014f\22\364"+
    "\3\125\1\364\1\125\1\364\1\125\3\364\22\125\11\0"+
    "\1\370\1\0\1\370\75\0\1\373\1\0\1\373\65\0"+
    "\1\u0150\1\0\1\u0150\1\0\1\u0150\1\0\1\u0150\14\0"+
    "\2\u0150\2\0\1\u0150\4\0\1\u0150\100\0\1\u0151\42\0"+
    "\1\u0104\3\0\1\u0104\73\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\31\1\u011a\20\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\u0152\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\u0153\1\31\1\u0154\1\u0155\4\31\1\u0156\4\31\1\u0157"+
    "\4\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\7\31\1\u0158"+
    "\12\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\u0159\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\31\1\u015a\20\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\16\31\1\u015b\3\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\13\31\1\u015c\6\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\102\0\1\u0147\20\0"+
    "\1\31\1\0\1\u015d\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\16\31\1\u015e\3\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\31\1\u015f\20\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\u0160\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\16\31\1\u0161\3\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\7\31\1\u0162\12\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\u0163\12\31\1\u0164\6\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\16\31\1\u0165\3\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\13\31\1\u0166\6\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\6\31\1\u0167\13\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\u0168"+
    "\1\0\4\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\u0169\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\1\31"+
    "\1\u016a\6\31\1\u016b\11\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\6\31\1\u016c\13\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\u016d\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\5\31"+
    "\1\u016e\14\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\10\31"+
    "\1\u016f\11\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\1\31"+
    "\1\u0170\20\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\1\31"+
    "\1\u0171\20\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\4\31"+
    "\1\u0172\15\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\4\31"+
    "\1\u0173\15\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\1\31"+
    "\1\u0174\20\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\13\31"+
    "\1\u0175\6\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\16\31"+
    "\1\u0176\3\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\1\31"+
    "\1\u0177\20\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\16\31"+
    "\1\u0178\3\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\5\31"+
    "\1\u0179\14\31\3\0\1\u017a\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\1\31"+
    "\1\u017b\20\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\51\0\1\u017c\101\0\1\u017d\71\0\1\u017e\102\0\1\u017f"+
    "\102\0\1\u0180\100\0\1\u0181\120\0\1\u0182\57\0\1\u0183"+
    "\101\0\1\u0184\75\0\1\u0185\45\0\1\31\1\0\1\31"+
    "\1\0\2\31\1\u0186\1\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\u0187\3\31\1\u0188\15\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\16\31\1\u0189\3\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\13\31\1\u018a\6\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\u018b\21\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\u018c"+
    "\1\0\4\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\25\0\1\u018d\2\0\3\u018d\1\0\1\u0147"+
    "\7\0\22\u018d\3\0\1\u018d\1\0\1\u018d\1\0\3\u018d"+
    "\52\0\1\u018e\60\0\3\u0149\60\0\1\u014b\65\0\1\u018f"+
    "\64\0\1\u0190\75\0\1\u0191\32\0\11\125\1\u014e\1\125"+
    "\1\u014e\1\361\1\125\1\362\1\125\1\363\57\125\42\0"+
    "\1\u0192\36\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\5\31\1\u0193\14\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\3\31\1\u0194\16\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\u0195\1\0\4\31\11\0"+
    "\22\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\7\31\1\u0196"+
    "\12\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\15\31\1\u0197"+
    "\4\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\14\31\1\u0198"+
    "\5\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\1\u0199\21\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\12\31\1\u019a\7\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\17\31\1\u019b\2\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\11\31\1\u019c\10\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\4\31\1\u019d\15\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\13\31\1\u019e\6\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\31\1\u019f\20\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\u01a0\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\15\31\1\u01a1\4\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\5\31\1\u01a2\14\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\4\31\1\u01a3\15\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\13\31\1\u01a4\6\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\16\31\1\u01a5\3\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\31\1\u01a6\20\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\13\31\1\u01a7\6\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\31\1\u01a8\20\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\u01a9\21\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\31\1\u01aa\20\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\14\31\1\u01ab\5\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\u01ac\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\10\31\1\u01ad\11\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\u01ae\21\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\6\31"+
    "\1\u01af\13\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\11\31"+
    "\1\u01b0\10\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\1\u01b1"+
    "\21\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\11\31\1\u01b2"+
    "\10\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\12\31\1\u01b3"+
    "\7\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\u01b4\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\u01b5\21\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\31\1\u01b6\20\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\13\31\1\u01b7\6\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\u01b8"+
    "\1\0\4\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\57\0\1\u01b9\102\0\1\u01ba\42\0\1\u01bb"+
    "\6\0\1\u01bc\37\0\1\u01bd\34\0\1\u01be\125\0\1\u01bf"+
    "\45\0\1\u01c0\77\0\1\u01c1\116\0\1\u01c2\115\0\1\u01c3"+
    "\74\0\1\u01c4\43\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\13\31\1\u01c5\6\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\16\31\1\u01c6\3\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\5\31\1\u01c7\14\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\13\31\1\u01c8\6\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\16\31\1\u01c9\3\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\5\31\1\u01ca\14\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\1\31\1\u01cb\20\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\u018d\1\0\1\u018d\1\0\4\u018d"+
    "\1\u01cc\1\0\1\u01cd\6\0\22\u018d\3\0\1\u018d\1\0"+
    "\1\u018d\1\0\3\u018d\55\0\1\u01ce\101\0\1\u01cf\45\0"+
    "\1\u01d0\2\0\3\u01d0\11\0\22\u01d0\3\0\1\u01d0\1\0"+
    "\1\u01d0\1\0\3\u01d0\33\0\2\u01d1\1\u01d2\65\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\2\31\1\u01d3\17\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\6\31\1\u01d4\13\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\11\31\1\u01d5\10\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\u01d6\21\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\1\u01d7\21\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\3\31\1\u01d8\16\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\3\31\1\u01d9\16\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\2\31\1\u01da\17\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\5\31\1\u01db\14\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\21\31\1\u01dc\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\u01dd\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\16\31\1\u01de\3\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\11\31\1\u01df\10\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\1\u01e0\21\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\6\31"+
    "\1\u01e1\13\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\5\31"+
    "\1\u01e2\14\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\6\31"+
    "\1\u01e3\13\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\14\31"+
    "\1\u01e4\5\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\5\31"+
    "\1\u01e5\14\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\11\31"+
    "\1\u01e6\10\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\13\31"+
    "\1\u01e7\6\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\6\31"+
    "\1\u01e8\13\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\1\31"+
    "\1\u01e9\20\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\6\31"+
    "\1\u01ea\13\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\55\0\1\u01eb\47\0\1\u01ec\6\0\1\u01ed\37\0\1\u01ee"+
    "\76\0\1\u01ef\40\0\1\u01bc\37\0\1\u01bd\65\0\1\u01f0"+
    "\62\0\1\u01c3\77\0\1\u01f1\104\0\1\u01f2\76\0\1\u01f3"+
    "\62\0\1\u01c3\37\0\1\u01f4\61\0\1\u01f5\44\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\16\31\1\u01f6\3\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\u01f7\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\6\31\1\u01f8\13\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\10\31\1\u01f9\11\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\31\1\u01fa\20\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\u01fb"+
    "\1\0\4\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\14\31\1\u01fc\5\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\33\0\1\u01cc\110\0\1\u01fd\110\0\1\u01fe"+
    "\55\0\1\u01d1\67\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\10\31\1\u01ff\11\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\16\31\1\u0200\3\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\u0201\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\1\31"+
    "\1\u0202\20\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\16\31"+
    "\1\u0203\3\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\13\31"+
    "\1\u0204\6\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\u0205\1\0\4\31\11\0\22\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\6\31\1\u0206\13\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\u0207\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\31\1\u0208\20\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\u0209"+
    "\1\0\4\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\7\31\1\u020a\12\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\14\31\1\u020b\5\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\4\31\1\u020c\15\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\u020d\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\6\31"+
    "\1\u020e\13\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\u020f\1\0\4\31\11\0\22\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\31\1\u0210\20\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\56\0\1\u0211"+
    "\100\0\1\u0212\54\0\1\u01ed\37\0\1\u01ee\30\0\1\u0213"+
    "\77\0\1\u01c3\106\0\1\u01f1\37\0\1\u0214\50\0\1\u0215"+
    "\125\0\1\u0211\40\0\1\u01f5\37\0\1\u0216\26\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\1\31\1\u0217\1\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\31\1\u0218\20\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\10\31\1\u0219\11\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\1\31\1\u021a\1\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\1\31\1\u021b\1\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\7\31\1\u021c\12\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\64\0\1\u021d"+
    "\46\0\3\u021e\65\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\13\31\1\u021f\6\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\13\31\1\u0220\6\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\6\31\1\u0221\13\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\u0222\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\6\31"+
    "\1\u0223\13\31\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\22\31"+
    "\3\0\1\31\1\0\1\31\1\0\1\31\1\u0224\1\31"+
    "\23\0\1\31\1\0\1\u0225\1\0\4\31\11\0\22\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\5\31\1\u0226\14\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\5\31\1\u0227\14\31"+
    "\3\0\1\31\1\0\1\31\1\0\3\31\23\0\1\31"+
    "\1\0\1\u0228\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\1\31\1\u0229\1\31\23\0\1\31\1\0\1\31"+
    "\1\0\4\31\11\0\1\31\1\u022a\20\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\23\0\1\31\1\0\1\u022b"+
    "\1\0\4\31\11\0\22\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\34\0\1\u0211\37\0\1\u022c\54\0\1\u01ed"+
    "\103\0\1\u01bc\56\0\1\u0215\37\0\1\u022d\26\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\22\31\3\0\1\31"+
    "\1\0\1\31\1\0\1\31\1\u022e\1\31\23\0\1\31"+
    "\1\0\1\31\1\0\4\31\11\0\1\u022f\21\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\1\31\1\u0230\1\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\6\31\1\u0231\13\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\1\31\1\u0232\1\31\23\0\1\31\1\0"+
    "\1\31\1\0\4\31\11\0\2\31\1\u0233\17\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\45\0\1\u0234\57\0"+
    "\1\u0235\2\0\3\u0235\3\u021e\1\u0236\5\0\22\u0235\3\0"+
    "\1\u0235\1\0\1\u0235\1\0\3\u0235\7\0\1\u0237\2\0"+
    "\2\u0237\7\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\11\31\1\u0238\10\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\6\31\1\u0239\13\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\14\31\1\u023a\5\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\u023b\1\0\4\31\11\0"+
    "\22\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\7\31\1\u023c"+
    "\12\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\7\31\1\u023d"+
    "\12\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\1\31\1\u023e"+
    "\20\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\7\31\1\u023f"+
    "\12\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\2\31\1\u0240"+
    "\17\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\7\31\1\u0241"+
    "\12\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\1\31\1\u0242\1\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\7\31\1\u0243"+
    "\12\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\1\31\1\u0244\1\31\33\0"+
    "\3\u0234\31\0\1\337\33\0\1\u0235\1\0\1\u0235\1\0"+
    "\4\u0235\3\u0245\6\0\22\u0235\3\0\1\u0235\1\0\1\u0235"+
    "\1\0\3\u0235\7\0\1\u0237\2\0\2\u0237\11\0\1\u0246"+
    "\2\0\3\u0246\11\0\22\u0246\3\0\1\u0246\1\0\1\u0246"+
    "\1\0\3\u0246\25\0\1\u0235\2\0\3\u0235\3\u0245\6\0"+
    "\22\u0235\3\0\1\u0235\1\0\1\u0235\1\0\3\u0235\7\0"+
    "\1\u0237\2\0\2\u0237\7\0\1\31\1\0\1\u0247\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\14\31\1\u0248\5\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\5\31\1\u0249\14\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\3\31\1\u024a\16\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\10\31\1\u024b\11\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\5\31\1\u024c\14\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\5\31\1\u024d\14\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\23\0\1\31\1\0\1\31\1\0\4\31\11\0"+
    "\21\31\1\u024e\3\0\1\31\1\0\1\31\1\0\3\31"+
    "\23\0\1\31\1\0\1\31\1\0\4\31\11\0\22\31"+
    "\3\0\1\31\1\0\1\31\1\0\1\31\1\u024f\1\31"+
    "\33\0\3\u0245\1\u0250\64\0\1\u0246\1\0\1\u0246\1\0"+
    "\4\u0246\3\u0251\6\0\22\u0246\3\0\1\u0246\1\0\1\u0246"+
    "\1\0\3\u0246\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\6\31\1\u0252\13\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\6\31\1\u0253\13\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\22\31\3\0\1\31\1\0\1\31\1\0\1\31"+
    "\1\u0254\1\31\23\0\1\31\1\0\1\31\1\0\4\31"+
    "\11\0\20\31\1\u0255\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\25\0\1\u0256\2\0\3\u0256\11\0\22\u0256"+
    "\3\0\1\u0256\1\0\1\u0256\1\0\3\u0256\25\0\1\u0257"+
    "\2\0\3\u0257\3\u0251\6\0\22\u0257\3\0\1\u0257\1\0"+
    "\1\u0257\1\0\3\u0257\7\0\1\u0258\2\0\2\u0258\7\0"+
    "\1\31\1\0\1\u0259\1\0\4\31\11\0\22\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\23\0\1\31\1\0"+
    "\1\u025a\1\0\4\31\11\0\22\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\22\31\3\0\1\31\1\0\1\31\1\0"+
    "\1\31\1\u025b\1\31\23\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\1\u025c\21\31\3\0\1\31\1\0\1\31"+
    "\1\0\3\31\23\0\1\u0256\1\0\1\u0256\1\0\4\u0256"+
    "\3\u025d\6\0\22\u0256\3\0\1\u0256\1\0\1\u0256\1\0"+
    "\3\u0256\3\0\1\u025e\17\0\1\u0257\1\0\1\u0257\1\0"+
    "\4\u0257\3\u025d\6\0\22\u0257\3\0\1\u0257\1\0\1\u0257"+
    "\1\0\3\u0257\3\0\1\u025e\3\0\1\u0258\2\0\2\u0258"+
    "\11\0\1\u0257\2\0\3\u0257\3\u025d\6\0\22\u0257\3\0"+
    "\1\u0257\1\0\1\u0257\1\0\3\u0257\3\0\1\u025e\3\0"+
    "\1\u0258\2\0\2\u0258\7\0\1\31\1\0\1\31\1\0"+
    "\4\31\11\0\16\31\1\u025f\3\31\3\0\1\31\1\0"+
    "\1\31\1\0\3\31\33\0\3\u025d\45\0\1\u025e\100\0"+
    "\1\u0260\16\0\1\31\1\0\1\u0261\1\0\4\31\11\0"+
    "\22\31\3\0\1\31\1\0\1\31\1\0\3\31\23\0"+
    "\1\31\1\0\1\31\1\0\4\31\11\0\11\31\1\u0262"+
    "\10\31\3\0\1\31\1\0\1\31\1\0\3\31\22\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[28160];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


	/* error codes */
	private static final int ZZ_UNKNOWN_ERROR = 0;
	private static final int ZZ_NO_MATCH = 1;
	private static final int ZZ_PUSHBACK_2BIG = 2;

	/* error messages for the codes above */
	private static final String ZZ_ERROR_MSG[] = {
		"Unknown internal scanner error",		//$NON-NLS-1$
		"Error: could not match input",			//$NON-NLS-1$
		"Error: pushback value was too large"	//$NON-NLS-1$
	};

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\1\1\10\0\2\1\1\11\13\1\3\11\24\1"+
    "\1\11\12\1\4\11\1\1\2\11\1\1\1\11\2\1"+
    "\1\11\4\1\1\11\3\1\1\11\6\1\1\11\2\1"+
    "\1\11\2\1\1\11\2\1\2\11\1\1\24\11\2\1"+
    "\1\11\3\1\1\11\1\1\1\11\1\1\1\0\3\1"+
    "\1\0\1\11\6\1\2\11\1\0\2\1\2\0\1\1"+
    "\2\0\1\11\2\0\36\1\3\11\1\1\2\11\1\1"+
    "\12\0\2\1\1\11\2\1\2\11\1\1\1\0\2\11"+
    "\1\1\10\11\4\0\2\1\3\11\1\1\1\0\1\11"+
    "\3\0\2\1\3\0\3\1\1\0\1\11\2\0\1\11"+
    "\1\0\1\11\1\0\4\11\1\0\1\1\1\0\12\1"+
    "\1\0\41\1\1\11\1\1\12\0\6\1\3\11\3\0"+
    "\1\1\2\0\2\11\2\1\1\0\52\1\12\0\7\1"+
    "\2\0\1\11\3\0\46\1\4\0\1\11\7\0\7\1"+
    "\1\11\1\1\2\0\2\11\31\1\3\0\1\11\5\0"+
    "\1\11\1\0\7\1\2\0\22\1\3\0\1\11\1\0"+
    "\1\11\6\1\2\0\15\1\2\11\6\1\4\0\15\1"+
    "\2\0\11\1\2\0\4\1\3\0\4\1\2\0\1\1"+
    "\1\11\2\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[610];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

	/** the input device */
	private java.io.Reader zzReader;

	/** the current state of the DFA */
	private int zzState;

	/** the current lexical state */
	private int zzLexicalState = YYINITIAL;

	/** this buffer contains the current text to be matched and is
		the source of the yytext() string */
	private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

	/** the textposition at the last accepting state */
	private int zzMarkedPos;

	/** the current text position in the buffer */
	private int zzCurrentPos;

	/** startRead marks the beginning of the yytext() string in the buffer */
	private int zzStartRead;

	/** endRead marks the last character in the buffer, that has been read
		from input */
	private int zzEndRead;

	/** number of newlines encountered up to the start of the matched text */
	private int yyline;

	/** the number of characters up to the start of the matched text */
	private int yychar;

	/**
	 * the number of characters from the last newline up to the start of the
	 * matched text
	 */
	private int yycolumn;

	/**
	 * zzAtBOL == true <=> the scanner is currently at the beginning of a line
	 */
	private boolean zzAtBOL = true;

	/** zzAtEOF == true <=> the scanner is at the EOF */
	private boolean zzAtEOF;

	/** denotes if the user-EOF-code has already been executed */
	private boolean zzEOFDone;

	/**
	 * The number of occupied positions in zzBuffer beyond zzEndRead.
	 * When a lead/high surrogate has been read from the input stream
	 * into the final zzBuffer position, this will have a value of 1;
	 * otherwise, it will have a value of 0.
	 */
	private int zzFinalHighSurrogate = 0;

  /* user code: */
	private final LinkedList<Object> commentList = new LinkedList<>();
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=514632
	// stores nested HEREDOC ids
	private final Stack<String> heredocIds = new Stack<>();
	private boolean asp_tags = false;
	private boolean short_tags_allowed = true;
	// XXX: "heredocIds" and "stack" are never reset
	private final StateStack stack = new StateStack();
	protected int commentStartPosition;

	private AST ast;

	public void setAST(AST ast) {
		this.ast = ast;
	}

	@Override
	public PHPVersion getPHPVersion() {
		return PHPVersion.PHP5;
	}

	@Override
	public void setInScriptingState() {
		yybegin(ST_IN_SCRIPTING);
	}

	@Override
	public void resetCommentList() {
		commentList.clear();
	}

	/**
	 * Will only be filled when ast != null
	 */
	@Override
	public LinkedList<Object> getCommentList() {
		return commentList;
	}

	/**
	 * Will only be added when ast != null
	 */
	protected void addComment(int type) {
		if (ast != null) {
			int leftPosition = getTokenStartPosition();
			Comment comment = new Comment(commentStartPosition, leftPosition + getTokenLength(), ast, type);
			commentList.add(comment);
		}
	}

	@Override
	public void setUseAspTagsAsPHP(boolean useAspTagsAsPhp) {
		asp_tags = useAspTagsAsPhp;
	}

	@Override
	public void setUseShortTags(boolean useShortTags) {
		short_tags_allowed = useShortTags;
	}

	private void pushState(int state) {
		stack.pushStack(zzLexicalState);
		yybegin(state);
	}

	private void popState() {
		yybegin(stack.popStack());
	}

	@Override
	public int getCurrentLine() {
		return yyline;
	}

	protected int getTokenStartPosition() {
		return zzStartRead - _zzPushbackPos;
	}

	protected int getTokenLength() {
		return zzMarkedPos - zzStartRead;
	}

	@Override
	public int getLength() {
		return zzEndRead - _zzPushbackPos;
	}

	private void handleCommentStart() {
		commentStartPosition = getTokenStartPosition();
	}

	private void handleLineCommentEnd() {
		addComment(Comment.TYPE_SINGLE_LINE);
	}

	private void handleMultilineCommentEnd() {
		addComment(Comment.TYPE_MULTILINE);
	}

	private void handlePHPDocEnd() {
		addComment(Comment.TYPE_PHPDOC);
	}

	protected void handleVarComment() {
		addComment(Comment.TYPE_MULTILINE);
	}

	private Symbol createFullSymbol(int symbolNumber) {
		Symbol symbol = createSymbol(symbolNumber);
		symbol.value = yytext();
		return symbol;
	}

	protected Symbol createSymbol(int symbolNumber) {
		int leftPosition = getTokenStartPosition();
		return new Symbol(symbolNumber, leftPosition, leftPosition + getTokenLength());
	}

	public int[] getParameters() {
		return new int[] { zzMarkedPos, _zzPushbackPos, zzCurrentPos,
				zzStartRead, zzEndRead, yyline, zzAtBOL ? 1 : 0,
				zzAtEOF ? 1 : 0, zzEOFDone ? 1 : 0, zzFinalHighSurrogate };
	}

	/**
	 * Parses a PHPDoc block comment. Underlying reader (zzReader) can be closed
	 * in the process (when EOF is reached).
	 *
	 * @return true when PHPDoc was parsed, false otherwise (false also implies
	 *         that underlying lexer was unavailable)
	 */
	protected boolean parsePHPDoc() {
		final IDocumentorLexer documentorLexer = getDocumentorLexer(zzReader);
		if (documentorLexer == null) {
			return false;
		}
		yypushback(zzMarkedPos - zzStartRead);
		int[] parameters = getParameters();
		documentorLexer.reset(zzReader, zzBuffer, parameters);
		Object phpDocBlock = documentorLexer.parse();
		commentList.add(phpDocBlock);
		reset(zzReader, documentorLexer.getBuffer(), documentorLexer.getParameters());
		return true;
	}

	protected IDocumentorLexer getDocumentorLexer(java.io.Reader reader) {
		return null;
	}

	/**
	 * Resets the {@code PhpAstLexer} properties to previous values, but leaves
	 * the lexical state unchanged. Be careful, method {@link #next_token()}
	 * also caches those properties using internal variables (zzCurrentPosL,
	 * zzMarkedPosL, zzBufferL, zzEndReadL) that should be accordingly resetted
	 * by the lexical rules calling
	 * {@link #reset(java.io.Reader, char[], int[])}. Also be careful that those
	 * internal variables could change from one version of JFlex to another.
	 *
	 * @param reader
	 * @param buffer
	 * @param parameters
	 */
	public void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		this.yychar = this.zzStartRead - this._zzPushbackPos;
		// XXX: never used
		this.yycolumn = 0;
		this.zzAtEOF = parameters[7] != 0;
		this.zzEOFDone = parameters[8] != 0;
		this.zzFinalHighSurrogate = parameters[9];
		// XXX: check if there's no side-effect to reset zzAtBOL
		// when zzAtEOF is false and zzMarkedPos is equal to zzStartRead.
		// One possible case would be that IDocumentorLexer#parse() matches
		// no text at all without being at EOF (i.e. the document lexer returns
		// a zero-length token), which of course would be totally broken...
		this.zzAtBOL = this.zzAtEOF ? false : (parameters[6] != 0);
	}


	/** the textposition at the last state to be included in yytext */
	private int _zzPushbackPos;

	/* The following fields are added in order to support the change in zzRefill */
	private String oldString = null;
	private boolean useOldString = false;
	private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PHPAstLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 236) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>false</code>, iff there was new input.
	 *
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
	private boolean zzRefill() throws java.io.IOException {

		if (useOldString) {
			String saveOldString = oldString;
			oldString = new String(zzBuffer, startPos, zzMarkedPos - startPos);
			if (saveOldString != null) {
				oldString = saveOldString + oldString;
			}
		}

		/* first: make room (if you can) */
		if (zzStartRead > 0) {
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
			System.arraycopy(zzBuffer, zzStartRead,
							zzBuffer, 0,
							zzEndRead-zzStartRead);

			/* translate stored positions */
			zzEndRead-= zzStartRead;
			zzCurrentPos-= zzStartRead;
			zzMarkedPos-= zzStartRead;
			_zzPushbackPos-= zzStartRead;
			startPos = 0;
			zzStartRead = 0;
		}

		/* is the buffer big enough? */
		if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
			/* if not: blow it up */
			char newBuffer[] = new char[zzBuffer.length*2];
			System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
			zzBuffer = newBuffer;
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
		}

		/* fill the buffer with new input */
		int requested = zzBuffer.length - zzEndRead;
		int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

		/* not supposed to occur according to specification of java.io.Reader */
		if (numRead == 0) {
			throw new java.io.IOException("Reader returned 0 characters.");
		}
		if (numRead > 0) {
			zzEndRead += numRead;
			/* If numRead == requested, we might have requested to few chars to
			   encode a full Unicode character. We assume that a Reader would
			   otherwise never return half characters. */
			if (numRead == requested) {
				if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
					--zzEndRead;
					zzFinalHighSurrogate = 1;
				}
			}
			/* potentially more input available */
			return false;
		}

		/* numRead < 0 ==> end of stream */
		return true;
	}


	/**
	 * Gets the next input character.
	 *
	 * @return      the next character of the input stream, EOF if the
	 *              end of the stream is reached.
	 * @exception   IOException  if any I/O-Error occurs
	 */
	private int yy_advance() throws java.io.IOException {

		/* standard case */
		if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

		/* if the eof is reached, we don't need to work hard */
		if (zzAtEOF) return YYEOF;

		/* otherwise: need to refill the buffer */

		String saveOldString = oldString;
		oldString = null;

		/* first: make room (if you can) */
		if (zzRefill()) {
			oldString = saveOldString;
			return YYEOF;
		}

		oldString = saveOldString;

		return zzBuffer[zzCurrentPos++];
	}


	/**
	 * Closes the input stream.
	 */
	public final void yyclose() throws java.io.IOException {
		zzAtEOF = true;            /* indicate end of file */
		zzEndRead = zzStartRead;  /* invalidate buffer    */

		if (zzReader != null)
			zzReader.close();
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>ZZ_INITIAL</tt>.
	 *
	 * Internal scan buffer is resized down to its initial length, if it has grown.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		zzReader = reader;
		zzAtBOL  = true;
		zzAtEOF  = false;
		zzEOFDone = false;
		zzEndRead = zzStartRead = 0;
		zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
		zzFinalHighSurrogate = 0;
		oldString = null;
		yyline = yychar = yycolumn = 0;
		zzLexicalState = YYINITIAL;
		if (zzBuffer.length > ZZ_BUFFERSIZE)
			zzBuffer = new char[ZZ_BUFFERSIZE];
	}


	/**
	 * Returns the current lexical state.
	 */
	public final int yystate() {
		return zzLexicalState;
	}


	/**
	 * Enters a new lexical state
	 *
	 * @param newState the new lexical state
	 */
	public final void yybegin(int newState) {
		zzLexicalState = newState;
	}


	/**
	 * Returns the text matched by the current regular expression.
	 */
	public final String yytext() {
		return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
	}


	/**
	 * Returns the character at position <tt>pos</tt> from the
	 * matched text.
	 *
	 * It is equivalent to yytext().charAt(pos), but faster
	 *
	 * @param pos the position of the character to fetch.
	 *            A value from 0 to yylength()-1.
	 *
	 * @return the character at position pos
	 */
	public final char yycharat(int pos) {
		return zzBuffer[zzStartRead+pos];
	}


	/**
	 * Returns the length of the matched text region.
	 */
	public final int yylength() {
		return zzMarkedPos-zzStartRead;
	}


	/**
	 * Reports an error that occured while scanning.
	 *
	 * In a wellformed scanner (no or only correct usage of
	 * yypushback(int) and a match-all fallback rule) this method
	 * will only be called with things that "Can't Possibly Happen".
	 * If this method is called, something is seriously wrong
	 * (e.g. a JFlex bug producing a faulty scanner etc.).
	 *
	 * Usual syntax/scanner level error handling should be done
	 * in error fallback rules.
	 *
	 * @param   errorCode  the code of the errormessage to display
	 */
  private void zzScanError(int errorCode) {
		String message;
		try {
			message = ZZ_ERROR_MSG[errorCode];
		}
		catch (ArrayIndexOutOfBoundsException e) {
			message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
		}

    throw new Error(message);
	}


	/**
	 * Pushes the specified amount of characters back into the input stream.
	 *
	 * They will be read again by then next call of the scanning method
	 *
	 * @param number  the number of characters to be read again.
	 *                This number must not be greater than yylength()!
	 */
  public void yypushback(int number)  {
		if ( number > yylength() )
			zzScanError(ZZ_PUSHBACK_2BIG);

		zzMarkedPos -= number;
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		updateStartPos(zzMarkedPos);
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos(int position) {
		startPos = position;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


	/**
	 * Resumes scanning until the next regular expression is matched,
	 * the end of input is encountered or an I/O-Error occurs.
	 *
	 * @return      the next token
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
	int zzInput;
	int zzAction;

	// cached fields:
	int zzCurrentPosL;
	int zzMarkedPosL;
	int zzEndReadL = zzEndRead;
	char [] zzBufferL = zzBuffer;
	char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

	while (true) {
		zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
		zzAction = -1;

		zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


		zzForAction: {
			while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
				zzAction = zzState;
				zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
				}

			}
		}

			// store back cached position
			zzMarkedPos = zzMarkedPosL;

			if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
				zzAtEOF = true;
            zzDoEOF();
          { 	return createSymbol(sym.EOF);
 }
			}
			else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 180: break;
          case 2: 
            { return createSymbol(ParserConstants.T_INLINE_HTML);
            }
          case 181: break;
          case 3: 
            { // do nothing
            }
          case 182: break;
          case 4: 
            { return createFullSymbol(ParserConstants.T_LNUMBER);
            }
          case 183: break;
          case 5: 
            { return createSymbol(ParserConstants.T_NEKUDA);
            }
          case 184: break;
          case 6: 
            { return createFullSymbol(ParserConstants.T_STRING);
            }
          case 185: break;
          case 7: 
            { return createSymbol(ParserConstants.T_PLUS);
            }
          case 186: break;
          case 8: 
            { 
            }
          case 187: break;
          case 9: 
            { return createSymbol(ParserConstants.T_DOLLAR);
            }
          case 188: break;
          case 10: 
            { yybegin(ST_DOUBLE_QUOTES);
	return createSymbol(ParserConstants.T_QUATE);
            }
          case 189: break;
          case 11: 
            { yybegin(ST_BACKQUOTE);
	return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 190: break;
          case 12: 
            { pushState(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          case 191: break;
          case 13: 
            { return createSymbol(ParserConstants.T_SEMICOLON);
            }
          case 192: break;
          case 14: 
            { return createSymbol(ParserConstants.T_MINUS);
            }
          case 193: break;
          case 15: 
            { return createSymbol(ParserConstants.T_LGREATER);
            }
          case 194: break;
          case 16: 
            { return createSymbol(ParserConstants.T_NEKUDOTAIM);
            }
          case 195: break;
          case 17: 
            { return createSymbol(ParserConstants.T_OPEN_PARENTHESE);
            }
          case 196: break;
          case 18: 
            { return createSymbol(ParserConstants.T_CLOSE_PARENTHESE);
            }
          case 197: break;
          case 19: 
            { return createSymbol(ParserConstants.T_EQUAL);
            }
          case 198: break;
          case 20: 
            { return createSymbol(ParserConstants.T_NOT);
            }
          case 199: break;
          case 21: 
            { return createSymbol(ParserConstants.T_RGREATER);
            }
          case 200: break;
          case 22: 
            { return createSymbol(ParserConstants.T_TIMES);
            }
          case 201: break;
          case 23: 
            { return createSymbol(ParserConstants.T_DIV);
            }
          case 202: break;
          case 24: 
            { return createSymbol(ParserConstants.T_PRECENT);
            }
          case 203: break;
          case 25: 
            { return createSymbol(ParserConstants.T_REFERENCE);
            }
          case 204: break;
          case 26: 
            { return createSymbol(ParserConstants.T_OR);
            }
          case 205: break;
          case 27: 
            { return createSymbol(ParserConstants.T_KOVA);
            }
          case 206: break;
          case 28: 
            { return createSymbol(ParserConstants.T_COMMA);
            }
          case 207: break;
          case 29: 
            { return createSymbol(ParserConstants.T_OPEN_RECT);
            }
          case 208: break;
          case 30: 
            { return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          case 209: break;
          case 31: 
            { return createSymbol(ParserConstants.T_TILDA);
            }
          case 210: break;
          case 32: 
            { return createSymbol(ParserConstants.T_QUESTION_MARK);
            }
          case 211: break;
          case 33: 
            { return createSymbol(ParserConstants.T_AT);
            }
          case 212: break;
          case 34: 
            { if (!stack.isEmpty()) {
		popState();
	}
	return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          case 213: break;
          case 35: 
            { yybegin(ST_SINGLE_QUOTE);
	return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          case 214: break;
          case 36: 
            { handleCommentStart();
	yybegin(ST_ONE_LINE_COMMENT);
	// yymore();
            }
          case 215: break;
          case 37: 
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_QUATE);
            }
          case 216: break;
          case 38: 
            { return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 217: break;
          case 39: 
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          case 218: break;
          case 40: 
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 219: break;
          case 41: 
            { yypushback(1);
	yybegin(ST_HEREDOC);
            }
          case 220: break;
          case 42: 
            { yypushback(1);
	popState();
            }
          case 221: break;
          case 43: 
            { popState();
	return createFullSymbol(ParserConstants.T_STRING);
            }
          case 222: break;
          case 44: 
            { yypushback(1);
	yybegin(ST_IN_SCRIPTING);
            }
          case 223: break;
          case 45: 
            { yybegin(ST_IN_SCRIPTING);
	return createFullSymbol(ParserConstants.T_STRING_VARNAME);
            }
          case 224: break;
          case 46: 
            { /* treat numbers (almost) as strings inside encapsulated strings */
	return createFullSymbol(ParserConstants.T_NUM_STRING);
            }
          case 225: break;
          case 47: 
            { yypushback(1);
	popState();
	return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 226: break;
          case 48: 
            { return createSymbol(ParserConstants.T_QUATE);
            }
          case 227: break;
          case 49: 
            { return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 228: break;
          case 50: 
            { return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          case 229: break;
          case 51: 
            { popState();
	return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          case 230: break;
          case 52: 
            { return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          case 231: break;
          case 53: 
            { // yymore();
            }
          case 232: break;
          case 54: 
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			handleLineCommentEnd();
			yybegin(ST_IN_SCRIPTING);
	}
	// yymore();
            }
          case 233: break;
          case 55: 
            { if (asp_tags) {
		yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          case 234: break;
          case 56: 
            { if (short_tags_allowed) {
		yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          case 235: break;
          case 57: 
            { return createFullSymbol(ParserConstants.T_DNUMBER);
            }
          case 236: break;
          case 58: 
            { return createSymbol(ParserConstants.T_CONCAT_EQUAL);
            }
          case 237: break;
          case 59: 
            { return createSymbol(ParserConstants.T_INC);
            }
          case 238: break;
          case 60: 
            { return createSymbol(ParserConstants.T_PLUS_EQUAL);
            }
          case 239: break;
          case 61: 
            { return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 240: break;
          case 62: 
            { return createFullSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
            }
          case 241: break;
          case 63: 
            { return createSymbol(ParserConstants.T_IF);
            }
          case 242: break;
          case 64: 
            { return createSymbol(ParserConstants.T_DO);
            }
          case 243: break;
          case 65: 
            { return createSymbol(ParserConstants.T_LOGICAL_OR);
            }
          case 244: break;
          case 66: 
            { return createSymbol(ParserConstants.T_AS);
            }
          case 245: break;
          case 67: 
            { return createSymbol(ParserConstants.T_DEC);
            }
          case 246: break;
          case 68: 
            { pushState(ST_LOOKING_FOR_PROPERTY);
	return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          case 247: break;
          case 69: 
            { return createSymbol(ParserConstants.T_MINUS_EQUAL);
            }
          case 248: break;
          case 70: 
            { return createSymbol(ParserConstants.T_SR);
            }
          case 249: break;
          case 71: 
            { return createSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);
            }
          case 250: break;
          case 72: 
            { return createSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);
            }
          case 251: break;
          case 73: 
            { return createSymbol(ParserConstants.T_DOUBLE_ARROW);
            }
          case 252: break;
          case 74: 
            { return createSymbol(ParserConstants.T_IS_EQUAL);
            }
          case 253: break;
          case 75: 
            { return createSymbol(ParserConstants.T_IS_NOT_EQUAL);
            }
          case 254: break;
          case 76: 
            { return createSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);
            }
          case 255: break;
          case 77: 
            { return createSymbol(ParserConstants.T_SL);
            }
          case 256: break;
          case 78: 
            { return createSymbol(ParserConstants.T_MUL_EQUAL);
            }
          case 257: break;
          case 79: 
            { return createSymbol(ParserConstants.T_DIV_EQUAL);
            }
          case 258: break;
          case 80: 
            { handleCommentStart();
	yybegin(ST_COMMENT);
            }
          case 259: break;
          case 81: 
            { if (asp_tags) {
		yybegin(YYINITIAL);
		return createSymbol(ParserConstants.T_SEMICOLON); /* implicit ';' at php-end tag */
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          case 260: break;
          case 82: 
            { return createSymbol(ParserConstants.T_MOD_EQUAL);
            }
          case 261: break;
          case 83: 
            { return createSymbol(ParserConstants.T_AND_EQUAL);
            }
          case 262: break;
          case 84: 
            { return createSymbol(ParserConstants.T_BOOLEAN_AND);
            }
          case 263: break;
          case 85: 
            { return createSymbol(ParserConstants.T_OR_EQUAL);
            }
          case 264: break;
          case 86: 
            { return createSymbol(ParserConstants.T_BOOLEAN_OR);
            }
          case 265: break;
          case 87: 
            { return createSymbol(ParserConstants.T_XOR_EQUAL);
            }
          case 266: break;
          case 88: 
            { yybegin(YYINITIAL);
	return createSymbol(ParserConstants.T_SEMICOLON); /* implicit ';' at php-end tag */
            }
          case 267: break;
          case 89: 
            { yypushback(1);
	return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 268: break;
          case 90: 
            { pushState(ST_LOOKING_FOR_VARNAME);
	return createSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
            }
          case 269: break;
          case 91: 
            { pushState(ST_IN_SCRIPTING);
	yypushback(yylength() - 1);
	return createSymbol(ParserConstants.T_CURLY_OPEN_WITH_DOLAR);
            }
          case 270: break;
          case 92: 
            { return createSymbol(ParserConstants.T_CHARACTER);
            }
          case 271: break;
          case 93: 
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	String heredoc = heredocIds.peek();
	if (yytext.equals(heredoc)) {
		yypushback(nb_pushback);
		heredocIds.pop();
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_END_HEREDOC);
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
		yybegin(ST_HEREDOC);
	}
            }
          case 272: break;
          case 94: 
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		nb_pushback = 2;
	} else {
		nb_pushback = 1;
	}
	yypushback(nb_pushback);
	heredocIds.pop();
	yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_END_HEREDOC);
            }
          case 273: break;
          case 95: 
            { return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          case 274: break;
          case 96: 
            { handleMultilineCommentEnd();
	yybegin(ST_IN_SCRIPTING);
            }
          case 275: break;
          case 97: 
            { handlePHPDocEnd();
	yybegin(ST_IN_SCRIPTING);
            }
          case 276: break;
          case 98: 
            { if (asp_tags || yytext().charAt(0) != '%') { /* asp comment? */
		handleLineCommentEnd();
		yypushback(yylength());
		yybegin(ST_IN_SCRIPTING);
	}
            }
          case 277: break;
          case 99: 
            { String yytext = yytext();
	if ((yytext.charAt(1) == '%' && asp_tags)
		|| (yytext.charAt(1) == '?' && short_tags_allowed)) {
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_OPEN_TAG_WITH_ECHO);
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          case 278: break;
          case 100: 
            { return createSymbol(ParserConstants.T_LOGICAL_XOR);
            }
          case 279: break;
          case 101: 
            { return createSymbol(ParserConstants.T_TRY);
            }
          case 280: break;
          case 102: 
            { return createFullSymbol(ParserConstants.T_EXIT);
            }
          case 281: break;
          case 103: 
            { return createSymbol(ParserConstants.T_FOR);
            }
          case 282: break;
          case 104: 
            { return createSymbol(ParserConstants.T_USE);
            }
          case 283: break;
          case 105: 
            { return createSymbol(ParserConstants.T_NEW);
            }
          case 284: break;
          case 106: 
            { return createSymbol(ParserConstants.T_LOGICAL_AND);
            }
          case 285: break;
          case 107: 
            { return createSymbol(ParserConstants.T_SR_EQUAL);
            }
          case 286: break;
          case 108: 
            { return createSymbol(ParserConstants.T_VAR);
            }
          case 287: break;
          case 109: 
            { return createSymbol(ParserConstants.T_IS_IDENTICAL);
            }
          case 288: break;
          case 110: 
            { return createSymbol(ParserConstants.T_IS_NOT_IDENTICAL);
            }
          case 289: break;
          case 111: 
            { return createSymbol(ParserConstants.T_SL_EQUAL);
            }
          case 290: break;
          case 112: 
            { if (parsePHPDoc()) {
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=316077
	// Reset the internal variables caching the values
	// previously resetted by parsePHPDoc().
	// Actually it would be enough to only reset zzEndReadL,
	// but do it cleanly...
	// Also be careful that those internal variables could
	// change from one version of JFlex to another.
	zzCurrentPosL = zzCurrentPos;
	zzMarkedPosL = zzMarkedPos;
	zzBufferL = zzBuffer;
	zzEndReadL = zzEndRead;
} else {
	handleCommentStart();
	yybegin(ST_DOCBLOCK);
}
            }
          case 291: break;
          case 113: 
            { yypushback(1);
	pushState(ST_VAR_OFFSET);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 292: break;
          case 114: 
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	int textLength = yytext.length();
	String heredoc = heredocIds.peek();
	int heredocLength = heredoc.length();
	if (textLength > heredocLength && yytext.substring(textLength - heredocLength, textLength).equals(heredoc)) {
		char c = yytext.charAt(textLength - heredocLength - 1);
		if (c == '\n' || c == '\r') {
			nb_pushback += heredocLength;
			// we need to remove the closing label from the symbol value
			yypushback(nb_pushback);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		}
	}
	// we must (at least) push the newline character back
	yypushback(1);
            }
          case 293: break;
          case 115: 
            { return createSymbol(ParserConstants.T_ECHO);
            }
          case 294: break;
          case 116: 
            { return createSymbol(ParserConstants.T_ELSE);
            }
          case 295: break;
          case 117: 
            { return createSymbol(ParserConstants.T_EVAL);
            }
          case 296: break;
          case 118: 
            { return createSymbol(ParserConstants.T_CASE);
            }
          case 297: break;
          case 119: 
            { return createSymbol(ParserConstants.T_LIST);
            }
          case 298: break;
          case 120: 
            { handleCommentStart();
	handleMultilineCommentEnd();
            }
          case 299: break;
          case 121: 
            { return createSymbol(ParserConstants.T_ENDIF);
            }
          case 300: break;
          case 122: 
            { return createSymbol(ParserConstants.T_EMPTY);
            }
          case 301: break;
          case 123: 
            { return createSymbol(ParserConstants.T_BREAK);
            }
          case 302: break;
          case 124: 
            { return createSymbol(ParserConstants.T_ISSET);
            }
          case 303: break;
          case 125: 
            { return createSymbol(ParserConstants.T_THROW);
            }
          case 304: break;
          case 126: 
            { return createSymbol(ParserConstants.T_FINAL);
            }
          case 305: break;
          case 127: 
            { return createSymbol(ParserConstants.T_UNSET);
            }
          case 306: break;
          case 128: 
            { return createSymbol(ParserConstants.T_CONST);
            }
          case 307: break;
          case 129: 
            { return createSymbol(ParserConstants.T_CATCH);
            }
          case 308: break;
          case 130: 
            { return createSymbol(ParserConstants.T_CLONE);
            }
          case 309: break;
          case 131: 
            { return createSymbol(ParserConstants.T_CLASS);
            }
          case 310: break;
          case 132: 
            { return createSymbol(ParserConstants.T_ARRAY);
            }
          case 311: break;
          case 133: 
            { return createSymbol(ParserConstants.T_WHILE);
            }
          case 312: break;
          case 134: 
            { return createSymbol(ParserConstants.T_PRINT);
            }
          case 313: break;
          case 135: 
            { return createSymbol(ParserConstants.T_INT_CAST);
            }
          case 314: break;
          case 136: 
            { String yytext = yytext();
	int removeChars = (yytext.charAt(0) == 'b') ? 4 : 3;
	yytext = yytext.substring(removeChars).trim();    // for 'b<<<' or '<<<'
	heredocIds.push(yytext);
	yybegin(ST_START_HEREDOC);
	Symbol sym = createFullSymbol(ParserConstants.T_START_HEREDOC);
	sym.value = yytext;
	return sym;
            }
          case 315: break;
          case 137: 
            { yypushback(3);
	pushState(ST_LOOKING_FOR_PROPERTY);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 316: break;
          case 138: 
            { yybegin(ST_IN_SCRIPTING);
	//return T_OPEN_TAG;
            }
          case 317: break;
          case 139: 
            { return createSymbol(ParserConstants.T_ENDFOR);
            }
          case 318: break;
          case 140: 
            { return createSymbol(ParserConstants.T_ELSEIF);
            }
          case 319: break;
          case 141: 
            { /* not a keyword, used to recognize constants.*/
	return createFullSymbol(ParserConstants.T_DEFINE);
            }
          case 320: break;
          case 142: 
            { return createSymbol(ParserConstants.T_STATIC);
            }
          case 321: break;
          case 143: 
            { return createSymbol(ParserConstants.T_SWITCH);
            }
          case 322: break;
          case 144: 
            { return createSymbol(ParserConstants.T_RETURN);
            }
          case 323: break;
          case 145: 
            { return createSymbol(ParserConstants.T_PUBLIC);
            }
          case 324: break;
          case 146: 
            { return createSymbol(ParserConstants.T_BOOL_CAST);
            }
          case 325: break;
          case 147: 
            { return createSymbol(ParserConstants.T_DOUBLE_CAST);
            }
          case 326: break;
          case 148: 
            { return createSymbol(ParserConstants.T_GLOBAL);
            }
          case 327: break;
          case 149: 
            { return createSymbol(ParserConstants.T_EXTENDS);
            }
          case 328: break;
          case 150: 
            { return createSymbol(ParserConstants.T_INCLUDE);
            }
          case 329: break;
          case 151: 
            { return createSymbol(ParserConstants.T_DEFAULT);
            }
          case 330: break;
          case 152: 
            { return createSymbol(ParserConstants.T_DECLARE);
            }
          case 331: break;
          case 153: 
            { return createSymbol(ParserConstants.T_FOREACH);
            }
          case 332: break;
          case 154: 
            { return createSymbol(ParserConstants.T_REQUIRE);
            }
          case 333: break;
          case 155: 
            { return createSymbol(ParserConstants.T_PRIVATE);
            }
          case 334: break;
          case 156: 
            { return createSymbol(ParserConstants.T_UNSET_CAST);
            }
          case 335: break;
          case 157: 
            { return createSymbol(ParserConstants.T_ARRAY_CAST);
            }
          case 336: break;
          case 158: 
            { return createSymbol(ParserConstants.T_ENDWHILE);
            }
          case 337: break;
          case 159: 
            { return createSymbol(ParserConstants.T_FUNCTION);
            }
          case 338: break;
          case 160: 
            { return createSymbol(ParserConstants.T_CONTINUE);
            }
          case 339: break;
          case 161: 
            { return createSymbol(ParserConstants.T_ABSTRACT);
            }
          case 340: break;
          case 162: 
            { return createSymbol(ParserConstants.T_STRING_CAST);
            }
          case 341: break;
          case 163: 
            { return createSymbol(ParserConstants.T_OBJECT_CAST);
            }
          case 342: break;
          case 164: 
            { return createSymbol(ParserConstants.T_FILE);
            }
          case 343: break;
          case 165: 
            { return createSymbol(ParserConstants.T_LINE);
            }
          case 344: break;
          case 166: 
            { return createSymbol(ParserConstants.T_ENDSWITCH);
            }
          case 345: break;
          case 167: 
            { return createSymbol(ParserConstants.T_INTERFACE);
            }
          case 346: break;
          case 168: 
            { return createSymbol(ParserConstants.T_PROTECTED);
            }
          case 347: break;
          case 169: 
            { return createSymbol(ParserConstants.T_CLASS_C);
            }
          case 348: break;
          case 170: 
            { return createSymbol(ParserConstants.T_ENDDECLARE);
            }
          case 349: break;
          case 171: 
            { return createSymbol(ParserConstants.T_ENDFOREACH);
            }
          case 350: break;
          case 172: 
            { return createSymbol(ParserConstants.T_INSTANCEOF);
            }
          case 351: break;
          case 173: 
            { return createSymbol(ParserConstants.T_IMPLEMENTS);
            }
          case 352: break;
          case 174: 
            { return createSymbol(ParserConstants.T_METHOD_C);
            }
          case 353: break;
          case 175: 
            { return createSymbol(ParserConstants.T_INCLUDE_ONCE);
            }
          case 354: break;
          case 176: 
            { return createSymbol(ParserConstants.T_REQUIRE_ONCE);
            }
          case 355: break;
          case 177: 
            { return createSymbol(ParserConstants.T_FUNC_C);
            }
          case 356: break;
          case 178: 
            { handleCommentStart();
	handleVarComment();
	//return createFullSymbol(ParserConstants.T_VAR_COMMENT);
            }
          case 357: break;
          case 179: 
            { return createSymbol(ParserConstants.T_HALT_COMPILER);
            }
          case 358: break;
		default:
            zzScanError(ZZ_NO_MATCH);
				}
			}
		}
	}

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java PHPAstLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          java.nio.charset.Charset.forName(encodingName); // Side-effect: is encodingName valid? 
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        PHPAstLexer scanner = null;
        try {
          java.io.FileInputStream stream = new java.io.FileInputStream(argv[i]);
          java.io.Reader reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new PHPAstLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
