/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006, 2017 Zend Corporation and IBM Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.ast.scanner.php53;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;

import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.util.collections.StateStack;

import java_cup.sym;
import java_cup.runtime.Symbol;

@SuppressWarnings({"unused", "nls"})


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>ast_scanner.flex</tt>
 */
public class PHPAstLexer implements org.eclipse.php.internal.core.ast.scanner.AstLexer {

	/** This character denotes the end of file */
	public static final int YYEOF = -1;

	/** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

	/** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_IN_SCRIPTING = 2;
  public static final int ST_DOUBLE_QUOTES = 4;
  public static final int ST_SINGLE_QUOTE = 6;
  public static final int ST_BACKQUOTE = 8;
  public static final int ST_HEREDOC = 10;
  public static final int ST_NOWDOC = 12;
  public static final int ST_START_HEREDOC = 14;
  public static final int ST_START_NOWDOC = 16;
  public static final int ST_END_HEREDOC = 18;
  public static final int ST_LOOKING_FOR_PROPERTY = 20;
  public static final int ST_LOOKING_FOR_VARNAME = 22;
  public static final int ST_VAR_OFFSET = 24;
  public static final int ST_COMMENT = 26;
  public static final int ST_DOCBLOCK = 28;
  public static final int ST_ONE_LINE_COMMENT = 30;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\11\2\0\1\13\22\0\1\12\1\57\1\15\1\77"+
    "\1\14\1\63\1\64\1\76\1\51\1\52\1\61\1\4\1\67\1\45"+
    "\1\2\1\62\1\5\11\1\1\47\1\21\1\60\1\56\1\46\1\73"+
    "\1\74\1\35\1\7\1\30\1\24\1\3\1\25\1\42\1\36\1\22"+
    "\1\53\1\41\1\40\1\44\1\27\1\31\1\43\1\55\1\33\1\32"+
    "\1\23\1\26\1\50\1\37\1\6\1\34\1\10\1\70\1\16\1\71"+
    "\1\66\1\54\1\17\1\35\1\7\1\30\1\24\1\3\1\25\1\42"+
    "\1\36\1\22\1\53\1\41\1\40\1\44\1\27\1\31\1\43\1\55"+
    "\1\33\1\32\1\23\1\26\1\50\1\37\1\6\1\34\1\10\1\20"+
    "\1\65\1\75\1\72\1\0\260\10\2\22\115\10\1\32\u1faa\10\1\41"+
    "\uded5\10\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\20\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\2\1\11\0\2\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\4\3\6\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\17\6\1\17\1\20\1\21\1\6\1\22"+
    "\1\23\1\6\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\1\43\1\44\1\45\1\1\1\3\1\46\2\3"+
    "\1\47\1\3\1\50\1\1\2\3\1\51\1\3\2\1"+
    "\3\3\1\1\2\52\2\53\1\3\1\54\1\55\1\54"+
    "\1\56\1\57\1\60\1\5\1\7\1\60\1\61\1\62"+
    "\1\63\1\64\1\17\1\20\1\21\1\22\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\65"+
    "\1\41\1\66\1\10\1\67\3\10\3\70\2\67\1\0"+
    "\1\71\1\72\1\73\1\0\1\74\6\6\1\75\1\76"+
    "\1\0\2\6\2\0\1\77\2\0\1\100\2\0\1\101"+
    "\7\6\1\102\12\6\1\103\5\6\1\104\7\6\1\105"+
    "\1\106\1\107\1\110\1\111\1\112\1\6\12\0\1\6"+
    "\1\113\1\114\2\115\1\116\1\117\1\0\1\120\1\121"+
    "\1\122\1\123\1\124\1\125\1\126\1\127\1\130\1\131"+
    "\1\132\4\0\1\77\2\133\1\134\1\135\1\133\1\0"+
    "\1\136\3\0\2\133\3\0\1\1\2\133\1\1\1\0"+
    "\1\137\2\0\1\140\2\0\1\141\1\0\1\142\1\0"+
    "\1\143\1\144\1\145\1\146\1\0\1\73\1\0\7\6"+
    "\1\73\1\147\1\6\1\0\5\6\1\150\3\6\1\151"+
    "\2\6\1\152\1\6\1\153\1\154\13\6\1\155\10\6"+
    "\1\156\1\157\12\0\7\6\1\160\1\161\1\162\3\0"+
    "\1\163\2\0\1\164\1\165\1\1\1\166\1\1\1\60"+
    "\1\0\6\6\1\167\1\170\1\6\1\171\22\6\1\172"+
    "\11\6\1\173\1\174\5\6\12\0\10\6\4\0\1\175"+
    "\3\0\1\6\1\176\5\6\1\177\1\200\3\6\1\201"+
    "\1\6\1\202\3\6\1\203\2\6\1\204\2\6\1\205"+
    "\1\206\1\207\1\210\5\6\1\211\1\212\2\6\1\213"+
    "\2\6\4\0\1\214\7\0\10\6\2\215\4\0\1\216"+
    "\2\217\2\6\1\220\2\6\1\221\4\6\1\222\6\6"+
    "\1\223\1\224\1\225\2\6\1\226\1\227\2\6\3\0"+
    "\1\230\5\0\1\231\1\0\10\6\3\0\1\232\5\6"+
    "\1\233\2\6\1\234\1\235\1\6\1\236\2\6\1\237"+
    "\1\6\1\240\1\6\3\0\1\241\1\0\1\242\1\243"+
    "\7\6\2\0\3\6\1\244\4\6\1\245\1\6\1\246"+
    "\1\6\1\247\1\6\1\250\1\251\1\252\4\6\1\253"+
    "\1\6\4\0\2\6\1\254\1\255\3\6\1\256\1\6"+
    "\1\257\2\6\1\260\2\6\2\0\1\261\1\262\1\6"+
    "\1\263\1\264\4\6\1\265\2\0\5\6\3\0\1\266"+
    "\1\267\1\270\2\6\2\0\1\271\1\6\1\272\1\6"+
    "\1\273";

  private static int [] zzUnpackAction() {
    int [] result = new int[654];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\100\0\200\0\300\0\u0100\0\u0140\0\u0180\0\u01c0"+
    "\0\u0200\0\u0240\0\u0280\0\u02c0\0\u0300\0\u0340\0\u0380\0\u03c0"+
    "\0\u0400\0\u0440\0\u0480\0\u04c0\0\u0500\0\u0540\0\u0580\0\u05c0"+
    "\0\u0600\0\u0640\0\u0680\0\u06c0\0\u0700\0\u0740\0\u0480\0\u0480"+
    "\0\u0480\0\u0480\0\u0780\0\u07c0\0\u0800\0\u0840\0\u0880\0\u08c0"+
    "\0\u0900\0\u0940\0\u0980\0\u09c0\0\u0a00\0\u0a40\0\u0a80\0\u0ac0"+
    "\0\u0b00\0\u0b40\0\u0b80\0\u0bc0\0\u0c00\0\u0c40\0\u0480\0\u0c80"+
    "\0\u0cc0\0\u0d00\0\u0d40\0\u0d80\0\u0dc0\0\u0e00\0\u0e40\0\u0e80"+
    "\0\u0ec0\0\u0480\0\u0480\0\u0480\0\u0480\0\u0f00\0\u0480\0\u0480"+
    "\0\u0f40\0\u0480\0\u0f80\0\u0fc0\0\u0480\0\u1000\0\u1040\0\u1080"+
    "\0\u10c0\0\u0480\0\u1100\0\u1140\0\u1180\0\u0480\0\u11c0\0\u1200"+
    "\0\u1240\0\u1280\0\u12c0\0\u1300\0\u1340\0\u0480\0\u1380\0\u0480"+
    "\0\u13c0\0\u1400\0\u0480\0\u1440\0\u1480\0\u0480\0\u14c0\0\u1500"+
    "\0\u0480\0\u0480\0\u1540\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480"+
    "\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480"+
    "\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480\0\u1580"+
    "\0\u15c0\0\u0480\0\u1600\0\u1640\0\u1680\0\u0480\0\u16c0\0\u0480"+
    "\0\u1700\0\u1740\0\u1780\0\u17c0\0\u1800\0\u1840\0\u0480\0\u1880"+
    "\0\u18c0\0\u1900\0\u1940\0\u1980\0\u19c0\0\u0480\0\u0480\0\u1a00"+
    "\0\u1a40\0\u1a80\0\u1ac0\0\u0f40\0\u1b00\0\u0740\0\u1b40\0\u0480"+
    "\0\u1b80\0\u1bc0\0\u0680\0\u1c00\0\u1c40\0\u1c80\0\u1cc0\0\u1d00"+
    "\0\u1d40\0\u1d80\0\u0680\0\u1dc0\0\u1e00\0\u1e40\0\u1e80\0\u1ec0"+
    "\0\u1f00\0\u1f40\0\u1f80\0\u1fc0\0\u2000\0\u0680\0\u2040\0\u2080"+
    "\0\u20c0\0\u2100\0\u2140\0\u0680\0\u2180\0\u21c0\0\u2200\0\u2240"+
    "\0\u2280\0\u22c0\0\u2300\0\u0480\0\u0480\0\u0480\0\u2340\0\u0480"+
    "\0\u0480\0\u2380\0\u23c0\0\u0c40\0\u2400\0\u2440\0\u2480\0\u24c0"+
    "\0\u2500\0\u2540\0\u2580\0\u25c0\0\u2600\0\u0480\0\u2640\0\u2680"+
    "\0\u0480\0\u0480\0\u26c0\0\u2700\0\u0480\0\u0480\0\u2740\0\u0480"+
    "\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480\0\u0480\0\u2780"+
    "\0\u27c0\0\u1000\0\u2800\0\u2840\0\u27c0\0\u0480\0\u0480\0\u0480"+
    "\0\u2800\0\u2880\0\u0480\0\u28c0\0\u1180\0\u2900\0\u28c0\0\u2900"+
    "\0\u2940\0\u12c0\0\u2980\0\u29c0\0\u2940\0\u2980\0\u2a00\0\u1380"+
    "\0\u0480\0\u2a40\0\u13c0\0\u0480\0\u2a80\0\u1400\0\u0480\0\u2ac0"+
    "\0\u0480\0\u2b00\0\u0480\0\u0480\0\u0480\0\u0480\0\u2b40\0\u2b80"+
    "\0\u2b80\0\u2bc0\0\u2c00\0\u2c40\0\u2c80\0\u2cc0\0\u2d00\0\u2d40"+
    "\0\u1a00\0\u0680\0\u2d80\0\u2dc0\0\u2e00\0\u2e40\0\u2e80\0\u2ec0"+
    "\0\u2f00\0\u0680\0\u2f40\0\u2f80\0\u2fc0\0\u0680\0\u3000\0\u3040"+
    "\0\u3080\0\u30c0\0\u0680\0\u0680\0\u3100\0\u3140\0\u3180\0\u31c0"+
    "\0\u3200\0\u3240\0\u3280\0\u32c0\0\u3300\0\u3340\0\u3380\0\u0680"+
    "\0\u33c0\0\u3400\0\u3440\0\u3480\0\u34c0\0\u3500\0\u3540\0\u3580"+
    "\0\u0480\0\u0680\0\u35c0\0\u3600\0\u3640\0\u3680\0\u36c0\0\u3700"+
    "\0\u3740\0\u3780\0\u37c0\0\u3800\0\u3840\0\u3880\0\u38c0\0\u3900"+
    "\0\u3940\0\u3980\0\u39c0\0\u0480\0\u0480\0\u0480\0\u3a00\0\u3a40"+
    "\0\u3a80\0\u3ac0\0\u3b00\0\u3b40\0\u0480\0\u0480\0\u3b80\0\u0480"+
    "\0\u3bc0\0\u2b00\0\u3c00\0\u3c40\0\u3c80\0\u3cc0\0\u3d00\0\u3d40"+
    "\0\u3d80\0\u0680\0\u3dc0\0\u3e00\0\u0680\0\u3e40\0\u3e80\0\u3ec0"+
    "\0\u3f00\0\u3f40\0\u3f80\0\u3fc0\0\u4000\0\u4040\0\u4080\0\u40c0"+
    "\0\u4100\0\u4140\0\u4180\0\u41c0\0\u4200\0\u4240\0\u4280\0\u0680"+
    "\0\u42c0\0\u4300\0\u4340\0\u4380\0\u43c0\0\u4400\0\u4440\0\u4480"+
    "\0\u44c0\0\u0680\0\u0680\0\u4500\0\u4540\0\u4580\0\u45c0\0\u4600"+
    "\0\u4640\0\u4680\0\u46c0\0\u4700\0\u4740\0\u4780\0\u47c0\0\u4800"+
    "\0\u4840\0\u4880\0\u48c0\0\u4900\0\u4940\0\u4980\0\u49c0\0\u4a00"+
    "\0\u4a40\0\u4a80\0\u4ac0\0\u4b00\0\u4b40\0\u4b80\0\u0480\0\u4bc0"+
    "\0\u4c00\0\u4c40\0\u4c80\0\u0680\0\u4cc0\0\u4d00\0\u4d40\0\u4d80"+
    "\0\u4dc0\0\u0680\0\u0680\0\u4e00\0\u4e40\0\u4e80\0\u0680\0\u4ec0"+
    "\0\u0680\0\u4f00\0\u4f40\0\u4f80\0\u0680\0\u4fc0\0\u5000\0\u0680"+
    "\0\u5040\0\u5080\0\u0680\0\u0680\0\u0680\0\u0680\0\u50c0\0\u5100"+
    "\0\u5140\0\u5180\0\u51c0\0\u0680\0\u0680\0\u5200\0\u5240\0\u0680"+
    "\0\u5280\0\u52c0\0\u5300\0\u5340\0\u5380\0\u53c0\0\u0480\0\u5400"+
    "\0\u5440\0\u5480\0\u54c0\0\u5500\0\u5540\0\u5580\0\u55c0\0\u5600"+
    "\0\u5640\0\u5680\0\u56c0\0\u5700\0\u5740\0\u5780\0\u0480\0\u57c0"+
    "\0\u5800\0\u5840\0\u5880\0\u58c0\0\u0480\0\u0480\0\u5900\0\u5940"+
    "\0\u5980\0\u59c0\0\u5a00\0\u5a40\0\u0680\0\u5a80\0\u5ac0\0\u5b00"+
    "\0\u5b40\0\u0680\0\u5b80\0\u5bc0\0\u5c00\0\u5c40\0\u5c80\0\u5cc0"+
    "\0\u0680\0\u0680\0\u0680\0\u5d00\0\u5d40\0\u0680\0\u0680\0\u5d80"+
    "\0\u5dc0\0\u5e00\0\u5e40\0\u5e80\0\u0480\0\u5ec0\0\u5f00\0\u5f40"+
    "\0\u5f80\0\u5fc0\0\u0480\0\u6000\0\u6040\0\u6080\0\u60c0\0\u6100"+
    "\0\u6140\0\u6180\0\u61c0\0\u6200\0\u6240\0\u6280\0\u62c0\0\u0680"+
    "\0\u6300\0\u6340\0\u6380\0\u63c0\0\u6400\0\u6440\0\u6480\0\u64c0"+
    "\0\u0680\0\u0680\0\u6500\0\u0680\0\u6540\0\u6580\0\u65c0\0\u6600"+
    "\0\u0680\0\u6640\0\u6680\0\u66c0\0\u6700\0\u0480\0\u6740\0\u0480"+
    "\0\u0680\0\u6780\0\u67c0\0\u6800\0\u6840\0\u6880\0\u68c0\0\u6900"+
    "\0\u6940\0\u6980\0\u69c0\0\u6a00\0\u6a40\0\u0680\0\u6a80\0\u6ac0"+
    "\0\u6b00\0\u6b40\0\u0680\0\u6b80\0\u0680\0\u6bc0\0\u0680\0\u6c00"+
    "\0\u0480\0\u0480\0\u0680\0\u6c40\0\u6c80\0\u6cc0\0\u6d00\0\u0680"+
    "\0\u6d40\0\u6d80\0\u6dc0\0\u6e00\0\u6e40\0\u6e80\0\u6ec0\0\u0680"+
    "\0\u0680\0\u6f00\0\u6f40\0\u6f80\0\u0680\0\u6fc0\0\u0680\0\u7000"+
    "\0\u7040\0\u0680\0\u7080\0\u70c0\0\u7100\0\u7140\0\u0680\0\u0680"+
    "\0\u7180\0\u0680\0\u0680\0\u71c0\0\u7200\0\u7240\0\u7280\0\u0680"+
    "\0\u72c0\0\u7300\0\u7340\0\u7380\0\u73c0\0\u7400\0\u7440\0\u7480"+
    "\0\u74c0\0\u7500\0\u0680\0\u0680\0\u0680\0\u7540\0\u7580\0\u75c0"+
    "\0\u7600\0\u0680\0\u7640\0\u0480\0\u7680\0\u0680";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[654];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\60\21\1\22\17\21\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\1\31\1\32\1\33\3\34\1\35\1\36\1\37"+
    "\1\40\1\41\1\42\1\43\1\44\1\45\1\46\1\47"+
    "\1\50\1\51\1\52\1\53\1\54\1\33\1\55\1\33"+
    "\1\56\1\57\1\33\1\60\1\61\1\33\1\62\1\63"+
    "\1\64\1\65\1\66\1\67\1\33\1\70\1\33\1\71"+
    "\1\72\1\73\1\74\1\75\1\76\1\77\1\100\1\101"+
    "\1\102\1\103\1\104\1\105\1\106\1\107\1\110\1\111"+
    "\1\112\14\113\1\114\1\115\1\116\1\113\1\117\57\113"+
    "\16\120\1\121\57\120\1\122\1\120\14\123\1\124\1\123"+
    "\1\125\1\126\1\127\57\123\11\130\1\131\1\130\1\131"+
    "\1\132\1\130\1\133\1\130\1\134\57\130\11\7\1\135"+
    "\1\7\1\135\64\7\3\136\1\137\2\136\3\137\11\136"+
    "\23\137\3\136\1\137\2\136\3\137\22\136\3\140\1\141"+
    "\2\140\3\141\11\140\23\141\3\140\1\141\2\140\3\141"+
    "\22\140\3\23\1\142\2\23\3\142\11\23\23\142\3\23"+
    "\1\142\2\23\3\142\22\23\3\143\1\144\2\143\3\144"+
    "\3\34\6\143\23\144\1\145\2\143\1\144\2\143\3\144"+
    "\22\143\3\146\1\147\2\146\3\147\11\146\23\147\3\146"+
    "\1\147\2\146\3\147\22\146\1\23\1\150\1\151\1\33"+
    "\1\152\1\153\3\33\3\154\1\35\1\155\1\154\1\156"+
    "\1\157\1\42\23\33\1\160\1\161\1\162\1\33\1\163"+
    "\1\67\3\33\1\164\1\165\1\166\1\167\1\170\1\171"+
    "\1\172\1\173\1\174\1\102\1\103\1\175\1\105\1\176"+
    "\1\107\1\177\2\154\61\200\1\201\16\200\13\202\1\203"+
    "\45\202\1\204\16\202\11\205\1\206\1\205\1\207\32\205"+
    "\1\210\14\205\1\211\7\205\1\211\4\205\60\21\1\212"+
    "\77\21\1\0\2\21\1\213\7\21\1\214\4\21\101\0"+
    "\1\24\1\215\1\216\1\0\1\24\73\0\1\215\3\0"+
    "\1\215\50\0\1\217\22\0\1\33\1\0\1\33\1\0"+
    "\1\33\1\220\2\33\11\0\5\33\1\221\1\222\7\33"+
    "\1\223\3\33\1\224\3\0\1\225\2\0\3\33\26\0"+
    "\1\226\51\0\1\227\22\0\1\24\1\215\1\216\1\0"+
    "\1\24\1\230\72\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\7\33\1\231\13\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\4\0\1\36"+
    "\4\0\11\33\1\232\11\33\3\0\1\33\2\0\3\33"+
    "\2\0\1\233\15\0\1\234\2\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\23\33\3\0\1\33\2\0\3\33"+
    "\33\0\3\34\67\0\1\235\2\0\3\235\11\0\23\235"+
    "\3\0\1\235\2\0\3\235\22\0\14\236\1\237\1\240"+
    "\1\241\1\236\1\242\57\236\1\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\3\33\1\243\1\33\1\244\2\33"+
    "\1\245\11\33\1\246\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\11\33\1\247"+
    "\2\33\1\250\6\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\251\1\0\4\33\11\0\1\252\6\33"+
    "\1\253\13\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\1\254\3\33\1\255"+
    "\2\33\1\256\13\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\5\33\1\257"+
    "\2\33\1\260\12\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\261\1\0\4\33\11\0\13\33\1\262"+
    "\7\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\7\33\1\263\3\33\1\264"+
    "\2\33\1\265\4\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\11\33\1\266"+
    "\11\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\1\33\1\267\13\33\1\270"+
    "\5\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\271\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\2\33\1\272"+
    "\1\33\11\0\5\33\1\273\2\33\1\274\1\275\11\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\14\33\1\276\6\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\1\277\22\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\7\33\1\300"+
    "\6\33\1\301\4\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\4\33\1\302"+
    "\4\33\1\303\11\33\3\0\1\33\2\0\3\33\67\0"+
    "\1\304\1\305\7\0\1\306\67\0\1\307\7\0\1\310"+
    "\70\0\1\311\31\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\13\33\1\312\7\33\3\0\1\33\2\0\3\33"+
    "\31\0\1\313\2\0\1\314\7\0\1\315\1\0\1\316"+
    "\1\317\1\320\2\0\1\321\1\322\1\323\1\0\1\324"+
    "\43\0\1\33\1\0\1\33\1\0\4\33\11\0\23\33"+
    "\3\0\1\33\2\0\1\33\1\325\1\33\70\0\1\326"+
    "\7\0\1\327\77\0\1\330\67\0\1\331\7\0\1\332"+
    "\1\0\1\333\1\0\1\334\73\0\1\335\77\0\1\336"+
    "\2\0\1\337\1\112\63\0\1\340\7\0\1\341\77\0"+
    "\1\342\5\0\1\343\71\0\1\344\6\0\1\345\70\0"+
    "\1\346\67\0\1\347\31\0\16\234\1\350\57\234\1\240"+
    "\1\234\14\113\1\351\1\0\1\352\1\113\1\353\62\113"+
    "\1\354\2\113\3\354\3\113\1\355\1\356\1\352\1\113"+
    "\1\357\1\113\23\354\3\113\1\354\2\113\3\354\136\113"+
    "\1\360\1\356\1\352\1\113\1\361\57\113\16\120\1\362"+
    "\57\120\1\0\17\120\1\363\57\120\1\363\1\120\14\123"+
    "\1\364\1\123\1\365\1\0\1\366\62\123\1\354\2\123"+
    "\3\354\3\123\1\367\1\123\1\365\1\356\1\357\1\123"+
    "\23\354\3\123\1\354\2\123\3\354\136\123\1\360\1\123"+
    "\1\365\1\356\1\370\57\123\11\130\1\131\1\130\1\131"+
    "\1\371\1\130\1\372\1\130\1\373\62\130\1\374\2\130"+
    "\3\374\1\131\1\130\1\131\1\371\1\130\1\372\1\130"+
    "\1\373\1\130\23\374\3\130\1\374\2\130\3\374\25\130"+
    "\1\354\2\130\3\354\1\131\1\130\1\131\1\375\1\130"+
    "\1\372\1\130\1\357\1\130\23\354\3\130\1\354\2\130"+
    "\3\354\33\130\1\131\1\130\1\131\75\130\1\131\1\130"+
    "\1\131\1\360\1\130\1\372\1\130\1\376\57\130\3\7"+
    "\1\377\2\7\3\377\1\135\1\7\1\135\6\7\23\377"+
    "\3\7\1\377\2\7\3\377\22\7\1\0\1\u0100\1\0"+
    "\1\u0100\1\0\4\u0100\1\u0101\1\0\1\u0101\5\0\1\u0102"+
    "\23\u0100\3\0\1\u0100\2\0\3\u0100\23\0\1\u0103\1\0"+
    "\1\u0103\1\0\4\u0103\1\u0104\1\0\1\u0104\5\0\1\u0105"+
    "\23\u0103\3\0\1\u0103\2\0\3\u0103\23\0\1\u0106\1\0"+
    "\1\u0106\1\0\4\u0106\1\u0107\1\0\1\u0107\5\0\1\u0108"+
    "\23\u0106\3\0\1\u0106\2\0\3\u0106\23\0\1\144\1\0"+
    "\1\144\1\0\4\144\11\0\23\144\3\0\1\144\2\0"+
    "\3\144\70\0\1\u0109\32\0\1\147\1\0\1\147\1\0"+
    "\4\147\11\0\23\147\3\0\1\147\2\0\3\147\23\0"+
    "\1\150\3\0\1\150\73\0\1\150\3\0\1\150\1\u010a"+
    "\71\0\61\200\1\0\16\200\62\0\1\u010b\26\0\1\202"+
    "\150\0\1\u010c\15\0\11\205\1\206\1\205\1\207\32\205"+
    "\1\206\14\205\1\206\7\205\1\206\4\205\11\0\1\206"+
    "\134\0\1\u010d\31\0\60\21\1\0\2\21\1\0\7\21"+
    "\1\0\4\21\56\0\1\u010e\64\0\1\u010f\12\0\1\u010e"+
    "\22\0\1\215\1\0\1\216\1\0\1\215\73\0\1\u0110"+
    "\2\0\1\u0111\1\u0110\37\0\1\u0111\33\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\1\u0112\1\u0113\21\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\2\33\1\u0114\20\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\14\33\1\u0115\6\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\10\33\1\u0116"+
    "\12\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\21\33\1\u0117\1\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\13\33\1\u0118\7\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\u0119\1\0\1\u0119\1\0\1\u0119\1\0"+
    "\1\u0119\14\0\2\u0119\2\0\1\u0119\4\0\1\u0119\43\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\11\33\1\u011a"+
    "\11\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\u011b\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\3\33\102\0\1\u011c\20\0\1\235\1\0\1\235\1\0"+
    "\4\235\11\0\23\235\3\0\1\235\2\0\3\235\22\0"+
    "\3\236\1\0\2\236\3\0\3\236\1\237\1\240\1\241"+
    "\1\236\1\0\1\236\23\0\3\236\1\0\2\236\3\0"+
    "\136\236\1\0\1\240\1\241\1\236\1\242\57\236\1\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\1\33\1\u011d"+
    "\4\33\1\u011e\1\33\1\u011f\12\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\10\33\1\u0120\12\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\21\33\1\u0121"+
    "\1\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\12\33\1\u0122\10\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\11\33\1\u0123\11\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\3\33\1\u0124\2\33\1\u0125\14\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\u0126\1\0\4\33\11\0"+
    "\23\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\5\33\1\u0127\15\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\5\33\1\u0128\15\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\11\33\1\u0129\11\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\10\33\1\u012a"+
    "\12\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\u012b\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\15\33\1\u012c\5\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\22\33\1\u012d"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\5\33\1\u012e\15\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\1\33\1\u012f\6\33\1\u0130\12\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\7\33\1\u0131\3\33\1\u0132\7\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\13\33\1\u0133\7\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\1\u0134"+
    "\22\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\1\33\1\u0135\21\33\3\0"+
    "\1\33\2\0\2\33\1\u0136\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\10\33\1\u0137\12\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\2\33\1\u0138\20\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\11\33"+
    "\1\u0139\11\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\1\u013a\22\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\10\33\1\u013b\12\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\1\33\1\u013c\21\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\7\33\1\u013d"+
    "\13\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\2\33\1\u013e\1\33\11\0\23\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\1\u013f\6\33\1\u0140\13\33\3\0\1\33"+
    "\2\0\3\33\100\0\1\u0141\22\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\11\33\1\u0142\11\33\3\0\1\33"+
    "\2\0\3\33\44\0\1\u0143\6\0\1\u0144\75\0\1\u0145"+
    "\101\0\1\u0146\106\0\1\u0147\66\0\1\u0148\57\0\1\u0149"+
    "\113\0\1\u014a\57\0\1\u014b\127\0\1\u014c\45\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\2\33\1\u014d\1\u014e"+
    "\1\33\1\u014f\1\u0150\5\33\1\u0151\1\33\1\u0152\3\33"+
    "\1\u0153\3\0\1\33\2\0\3\33\100\0\1\u0154\77\0"+
    "\1\u0155\77\0\1\u0156\1\0\1\u0157\51\0\1\u0158\56\0"+
    "\3\u0159\45\0\1\u015a\12\0\1\u015b\3\0\100\234\3\113"+
    "\1\0\2\113\3\0\3\113\1\355\1\356\1\352\1\113"+
    "\1\0\1\113\23\0\3\113\1\0\2\113\3\0\36\113"+
    "\1\0\1\356\1\352\1\113\1\361\57\113\1\0\1\354"+
    "\1\0\1\354\1\0\4\354\11\0\23\354\1\u015c\2\0"+
    "\1\354\2\0\3\354\12\0\1\u015d\7\0\16\120\1\0"+
    "\57\120\1\0\1\120\3\123\1\0\2\123\3\0\3\123"+
    "\1\367\1\123\1\365\1\356\1\0\1\123\23\0\3\123"+
    "\1\0\2\123\3\0\36\123\1\0\1\123\1\365\1\356"+
    "\1\370\57\123\3\130\1\0\2\130\3\0\1\131\1\130"+
    "\1\131\1\375\1\130\1\372\1\130\1\0\1\130\23\0"+
    "\3\130\1\0\2\130\3\0\33\130\1\131\1\130\1\131"+
    "\1\0\1\130\1\372\1\130\1\376\60\130\1\374\1\130"+
    "\1\374\1\130\4\374\1\u015e\1\130\1\u015e\1\371\1\130"+
    "\1\372\1\130\1\373\1\u015f\23\374\3\130\1\374\2\130"+
    "\3\374\22\130\1\7\1\377\1\7\1\377\1\7\4\377"+
    "\1\u0160\1\7\1\u0160\5\7\1\u0161\23\377\3\7\1\377"+
    "\2\7\3\377\22\7\11\0\1\u0101\1\0\1\u0101\75\0"+
    "\1\u0104\1\0\1\u0104\75\0\1\u0107\1\0\1\u0107\65\0"+
    "\1\u0162\1\0\1\u0162\1\0\1\u0162\1\0\1\u0162\14\0"+
    "\2\u0162\2\0\1\u0162\4\0\1\u0162\100\0\1\u0163\42\0"+
    "\1\u0110\3\0\1\u0110\73\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\1\33\1\u0126\21\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\u0164\1\0\4\33\11\0"+
    "\23\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\1\u0165\1\33\1\u0166\1\u0167"+
    "\4\33\1\u0168\4\33\1\u0169\5\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\7\33\1\u016a\13\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\u016b\1\0\4\33\11\0\23\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\1\33\1\u016c\21\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\16\33\1\u016d\4\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\13\33\1\u016e"+
    "\7\33\3\0\1\33\2\0\3\33\102\0\1\u0157\20\0"+
    "\1\33\1\0\1\u016f\1\0\4\33\11\0\23\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\16\33\1\u0170\4\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\1\33\1\u0171\21\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\u0172\1\0\4\33\11\0\23\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\16\33\1\u0173\4\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\7\33\1\u0174\13\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\1\u0175\12\33"+
    "\1\u0176\7\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\16\33\1\u0177\4\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\13\33\1\u0178\7\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\6\33\1\u0179\14\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\u017a\1\0\4\33\11\0\23\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\u017b"+
    "\1\0\4\33\11\0\23\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\u017c\1\0\4\33\11\0\23\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\1\33\1\u017d\6\33\1\u017e\12\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\6\33\1\u017f\14\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\u0180\1\0\4\33"+
    "\11\0\23\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\5\33\1\u0181\15\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\10\33\1\u0182\12\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\1\33\1\u0183\21\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\1\33"+
    "\1\u0184\21\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\4\33\1\u0185\16\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\4\33\1\u0186\16\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\1\33\1\u0187\21\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\13\33"+
    "\1\u0188\7\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\16\33\1\u0189\4\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\1\33\1\u018a\21\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\7\33\1\u018b\13\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\2\33\1\u018c\1\33"+
    "\11\0\23\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\16\33\1\u018d\4\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\5\33\1\u018e\15\33\3\0\1\u018f"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\1\33\1\u0190\21\33\3\0\1\33\2\0\3\33"+
    "\51\0\1\u0191\101\0\1\u0192\71\0\1\u0193\102\0\1\u0194"+
    "\102\0\1\u0195\100\0\1\u0196\120\0\1\u0197\57\0\1\u0198"+
    "\101\0\1\u0199\75\0\1\u019a\45\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\1\u019b\22\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\1\u019c\3\33\1\u019d\16\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\13\33"+
    "\1\u019e\7\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\16\33\1\u019f\4\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\13\33\1\u01a0\7\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\1\u01a1\22\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\u01a2\1\0\4\33\11\0\23\33\3\0"+
    "\1\33\2\0\3\33\25\0\1\u01a3\2\0\3\u01a3\1\0"+
    "\1\u0157\2\0\1\u01a4\4\0\23\u01a3\3\0\1\u01a3\2\0"+
    "\3\u01a3\20\0\1\u01a5\31\0\1\u01a6\60\0\3\u0159\60\0"+
    "\1\u015b\65\0\1\u01a7\65\0\1\u01a8\75\0\1\u01a9\31\0"+
    "\11\130\1\u015e\1\130\1\u015e\1\371\1\130\1\372\1\130"+
    "\1\373\57\130\11\7\1\u0160\1\7\1\u0160\64\7\43\0"+
    "\1\u01aa\35\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\5\33\1\u01ab\15\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\3\33\1\u01ac"+
    "\17\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\u01ad\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\7\33\1\u01ae\13\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\15\33\1\u01af"+
    "\5\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\14\33\1\u01b0\6\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\1\u01b1\22\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\12\33"+
    "\1\u01b2\10\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\17\33\1\u01b3\3\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\11\33\1\u01b4\11\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\4\33\1\u01b5\16\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\13\33"+
    "\1\u01b6\7\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\1\33\1\u01b7\21\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\u01b8"+
    "\1\0\4\33\11\0\23\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\15\33"+
    "\1\u01b9\5\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\5\33\1\u01ba\15\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\4\33\1\u01bb\16\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\13\33\1\u01bc\7\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\16\33"+
    "\1\u01bd\4\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\1\33\1\u01be\21\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\13\33\1\u01bf\7\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\1\33\1\u01c0\21\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\10\33"+
    "\1\u01c1\12\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\1\u01c2\22\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\1\33\1\u01c3\21\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\14\33\1\u01c4\6\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\u01c5\1\0\4\33\11\0\23\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\10\33\1\u01c6\12\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\1\u01c7\22\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\6\33\1\u01c8\14\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\11\33\1\u01c9\11\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\1\u01ca\22\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\11\33\1\u01cb"+
    "\11\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\12\33\1\u01cc\10\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\u01cd\1\0"+
    "\4\33\11\0\23\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\13\33\1\u01ce"+
    "\7\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\1\u01cf\22\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\1\33\1\u01d0\21\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\13\33"+
    "\1\u01d1\7\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\u01d2\1\0\4\33\11\0\23\33\3\0\1\33"+
    "\2\0\3\33\57\0\1\u01d3\102\0\1\u01d4\42\0\1\u01d5"+
    "\6\0\1\u01d6\37\0\1\u01d7\34\0\1\u01d8\125\0\1\u01d9"+
    "\45\0\1\u01da\77\0\1\u01db\116\0\1\u01dc\115\0\1\u01dd"+
    "\74\0\1\u01de\43\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\11\33\1\u01df\11\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\16\33"+
    "\1\u01e0\4\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\5\33\1\u01e1\15\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\22\33\1\u01e2\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\13\33\1\u01e3\7\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\16\33\1\u01e4"+
    "\4\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\5\33\1\u01e5\15\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\1\33\1\u01e6\21\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\u01a3\1\0\1\u01a3\1\0\4\u01a3\1\u01e7"+
    "\1\0\1\u01e8\6\0\23\u01a3\3\0\1\u01a3\2\0\3\u01a3"+
    "\25\0\1\u01e9\2\0\3\u01e9\11\0\23\u01e9\3\0\1\u01e9"+
    "\2\0\3\u01e9\25\0\1\u01ea\2\0\3\u01ea\11\0\23\u01ea"+
    "\3\0\1\u01ea\2\0\3\u01ea\55\0\1\u01eb\101\0\1\u01ec"+
    "\45\0\1\u01ed\2\0\3\u01ed\11\0\23\u01ed\3\0\1\u01ed"+
    "\2\0\3\u01ed\33\0\2\u01ee\1\u01ef\65\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\2\33\1\u01f0\20\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\6\33\1\u01f1\14\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\11\33\1\u01f2\11\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\1\u01f3\22\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\1\u01f4\22\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\3\33\1\u01f5\17\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\3\33\1\u01f6"+
    "\17\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\2\33\1\u01f7\20\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\5\33\1\u01f8\15\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\22\33\1\u01f9\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\u01fa\1\0\4\33\11\0\23\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\16\33\1\u01fb\4\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\11\33"+
    "\1\u01fc\11\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\1\u01fd\22\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\6\33\1\u01fe\14\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\21\33\1\u01ff\1\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\5\33\1\u0200"+
    "\15\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\6\33\1\u0201\14\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\14\33\1\u0202\6\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\5\33\1\u0203\15\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\11\33\1\u0204"+
    "\11\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\13\33\1\u0205\7\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\16\33\1\u0206\4\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\6\33\1\u0207\14\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\1\33\1\u0208"+
    "\21\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\6\33\1\u0209\14\33\3\0"+
    "\1\33\2\0\3\33\55\0\1\u020a\47\0\1\u020b\6\0"+
    "\1\u020c\37\0\1\u020d\67\0\1\u020e\47\0\1\u01d6\37\0"+
    "\1\u01d7\65\0\1\u020f\62\0\1\u01dd\77\0\1\u0210\104\0"+
    "\1\u0211\76\0\1\u0212\62\0\1\u01dd\37\0\1\u0213\61\0"+
    "\1\u0214\44\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\23\33\3\0\1\33\2\0\1\33\1\u0215\1\33\23\0"+
    "\1\33\1\0\1\u0216\1\0\4\33\11\0\23\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\6\33\1\u0217\14\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\u0218\1\0\4\33\11\0"+
    "\23\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\10\33\1\u0219\12\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\1\33\1\u021a\21\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\u021b\1\0\4\33\11\0"+
    "\23\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\14\33\1\u021c\6\33\3\0"+
    "\1\33\2\0\3\33\33\0\1\u01e7\67\0\1\u01e9\1\0"+
    "\1\u01e9\1\0\4\u01e9\4\0\1\u021d\4\0\23\u01e9\3\0"+
    "\1\u01e9\2\0\3\u01e9\23\0\1\u01ea\1\0\1\u01ea\1\0"+
    "\4\u01ea\11\0\23\u01ea\3\0\1\u01ea\2\0\3\u01ea\20\0"+
    "\1\u021d\23\0\1\u021e\110\0\1\u021f\55\0\1\u01ee\67\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\10\33\1\u0220"+
    "\12\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\16\33\1\u0221\4\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\u0222\1\0"+
    "\4\33\11\0\23\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\1\33\1\u0223"+
    "\21\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\16\33\1\u0224\4\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\13\33\1\u0225\7\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\u0226\1\0\4\33\11\0"+
    "\23\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\6\33\1\u0227\14\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\u0228\1\0"+
    "\4\33\11\0\23\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\1\33\1\u0229"+
    "\21\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\u022a\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\7\33\1\u022b\13\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\14\33\1\u022c"+
    "\6\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\13\33\1\u022d\7\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\4\33\1\u022e\16\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\u022f\1\0\4\33\11\0"+
    "\23\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\6\33\1\u0230\14\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\u0231\1\0"+
    "\4\33\11\0\23\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\1\33\1\u0232"+
    "\21\33\3\0\1\33\2\0\3\33\56\0\1\u0233\100\0"+
    "\1\u0234\54\0\1\u020c\37\0\1\u020d\30\0\1\u0235\77\0"+
    "\1\u01dd\106\0\1\u0210\37\0\1\u0236\50\0\1\u0237\116\0"+
    "\1\u0233\47\0\1\u0214\37\0\1\u0238\26\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\1\33\1\u0239\1\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\23\33\3\0\1\33\2\0\1\33\1\u023a"+
    "\1\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\1\33\1\u023b\21\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\10\33\1\u023c"+
    "\12\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\10\33\1\u023d\12\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\23\33\3\0\1\33\2\0\1\33\1\u023e"+
    "\1\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\23\33\3\0\1\33\2\0\1\33\1\u023f\1\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\7\33\1\u0240"+
    "\13\33\3\0\1\33\2\0\3\33\33\0\1\u01e7\1\0"+
    "\1\u01e8\127\0\1\u0241\45\0\3\u0242\65\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\13\33\1\u0243\7\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\13\33\1\u0244\7\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\6\33\1\u0245\14\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\u0246\1\0\4\33\11\0\23\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\6\33\1\u0247\14\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\23\33\3\0\1\33\2\0\1\33\1\u0248\1\33\23\0"+
    "\1\33\1\0\1\u0249\1\0\4\33\11\0\23\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\5\33\1\u024a\15\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\5\33\1\u024b\15\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\6\33\1\u024c"+
    "\14\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\u024d\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\23\33\3\0\1\33\2\0\1\33\1\u024e\1\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\1\33\1\u024f"+
    "\21\33\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\u0250\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\3\33\34\0\1\u0233\37\0\1\u0251\54\0\1\u020c\103\0"+
    "\1\u01d6\56\0\1\u0237\37\0\1\u0252\26\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\1\33\1\u0253\1\33\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\1\u0254\22\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\21\33"+
    "\1\u0255\1\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\23\33\3\0\1\33"+
    "\2\0\1\33\1\u0256\1\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\6\33\1\u0257\14\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\23\33\3\0\1\33\2\0\1\33\1\u0258\1\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\2\33"+
    "\1\u0259\20\33\3\0\1\33\2\0\3\33\45\0\1\u025a"+
    "\57\0\1\u025b\2\0\3\u025b\3\u0242\1\u025c\1\0\1\u025d"+
    "\3\0\23\u025b\3\0\1\u025b\2\0\3\u025b\7\0\1\u025d"+
    "\2\0\2\u025d\7\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\11\33\1\u025e\11\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\6\33"+
    "\1\u025f\14\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\14\33\1\u0260\6\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\u0261"+
    "\1\0\4\33\11\0\23\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\7\33"+
    "\1\u0262\13\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\7\33\1\u0263\13\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\1\33\1\u0264\21\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\u0265\1\0\4\33"+
    "\11\0\23\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\7\33\1\u0266\13\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\2\33\1\u0267\20\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\7\33\1\u0268\13\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\13\33"+
    "\1\u0269\7\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\23\33\3\0\1\33"+
    "\2\0\1\33\1\u026a\1\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\7\33\1\u026b\13\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\23\33\3\0\1\33\2\0\1\33\1\u026c\1\33"+
    "\33\0\3\u025a\32\0\1\347\32\0\1\u025b\1\0\1\u025b"+
    "\1\0\4\u025b\3\u026d\2\0\1\u025d\3\0\23\u025b\3\0"+
    "\1\u025b\2\0\3\u025b\7\0\1\u025d\2\0\2\u025d\11\0"+
    "\1\u026e\2\0\3\u026e\11\0\23\u026e\3\0\1\u026e\2\0"+
    "\3\u026e\25\0\1\u025b\2\0\3\u025b\3\u026d\2\0\1\u025d"+
    "\3\0\23\u025b\3\0\1\u025b\2\0\3\u025b\7\0\1\u025d"+
    "\2\0\2\u025d\7\0\1\33\1\0\1\u026f\1\0\4\33"+
    "\11\0\23\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\14\33\1\u0270\6\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\5\33\1\u0271\15\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\3\33\1\u0272\17\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\10\33"+
    "\1\u0273\12\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\5\33\1\u0274\15\33"+
    "\3\0\1\33\2\0\3\33\23\0\1\33\1\0\1\33"+
    "\1\0\4\33\11\0\5\33\1\u0275\15\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\6\33\1\u0276\14\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\22\33"+
    "\1\u0277\3\0\1\33\2\0\3\33\23\0\1\33\1\0"+
    "\1\33\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\1\33\1\u0278\1\33\33\0\3\u026d\1\u0279\64\0\1\u026e"+
    "\1\0\1\u026e\1\0\4\u026e\3\u027a\6\0\23\u026e\3\0"+
    "\1\u026e\2\0\3\u026e\23\0\1\33\1\0\1\33\1\0"+
    "\4\33\11\0\6\33\1\u027b\14\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\6\33\1\u027c\14\33\3\0\1\33\2\0\3\33\23\0"+
    "\1\33\1\0\1\33\1\0\4\33\11\0\23\33\3\0"+
    "\1\33\2\0\1\33\1\u027d\1\33\23\0\1\33\1\0"+
    "\1\u027e\1\0\4\33\11\0\23\33\3\0\1\33\2\0"+
    "\3\33\23\0\1\33\1\0\1\33\1\0\4\33\11\0"+
    "\21\33\1\u027f\1\33\3\0\1\33\2\0\3\33\25\0"+
    "\1\u0280\2\0\3\u0280\11\0\23\u0280\3\0\1\u0280\2\0"+
    "\3\u0280\25\0\1\u0281\2\0\3\u0281\3\u027a\2\0\1\u0282"+
    "\3\0\23\u0281\3\0\1\u0281\2\0\3\u0281\7\0\1\u0282"+
    "\2\0\2\u0282\7\0\1\33\1\0\1\u0283\1\0\4\33"+
    "\11\0\23\33\3\0\1\33\2\0\3\33\23\0\1\33"+
    "\1\0\1\u0284\1\0\4\33\11\0\23\33\3\0\1\33"+
    "\2\0\3\33\23\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\23\33\3\0\1\33\2\0\1\33\1\u0285\1\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\23\33"+
    "\3\0\1\33\2\0\1\33\1\u0286\1\33\23\0\1\33"+
    "\1\0\1\33\1\0\4\33\11\0\1\u0287\22\33\3\0"+
    "\1\33\2\0\3\33\23\0\1\u0280\1\0\1\u0280\1\0"+
    "\4\u0280\3\u0288\6\0\23\u0280\3\0\1\u0280\2\0\3\u0280"+
    "\3\0\1\u0289\17\0\1\u0281\1\0\1\u0281\1\0\4\u0281"+
    "\3\u0288\2\0\1\u0282\3\0\23\u0281\3\0\1\u0281\2\0"+
    "\3\u0281\3\0\1\u0289\3\0\1\u0282\2\0\2\u0282\11\0"+
    "\1\u0281\2\0\3\u0281\3\u0288\2\0\1\u0282\3\0\23\u0281"+
    "\3\0\1\u0281\2\0\3\u0281\3\0\1\u0289\3\0\1\u0282"+
    "\2\0\2\u0282\7\0\1\33\1\0\1\33\1\0\4\33"+
    "\11\0\23\33\3\0\1\33\2\0\1\33\1\u028a\1\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\16\33"+
    "\1\u028b\4\33\3\0\1\33\2\0\3\33\33\0\3\u0288"+
    "\45\0\1\u0289\100\0\1\u028c\16\0\1\33\1\0\1\u028d"+
    "\1\0\4\33\11\0\23\33\3\0\1\33\2\0\3\33"+
    "\23\0\1\33\1\0\1\33\1\0\4\33\11\0\11\33"+
    "\1\u028e\11\33\3\0\1\33\2\0\3\33\22\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[30400];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


	/* error codes */
	private static final int ZZ_UNKNOWN_ERROR = 0;
	private static final int ZZ_NO_MATCH = 1;
	private static final int ZZ_PUSHBACK_2BIG = 2;

	/* error messages for the codes above */
	private static final String ZZ_ERROR_MSG[] = {
		"Unknown internal scanner error",		//$NON-NLS-1$
		"Error: could not match input",			//$NON-NLS-1$
		"Error: pushback value was too large"	//$NON-NLS-1$
	};

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\2\1\11\0\2\1\1\11\13\1\4\11\24\1"+
    "\1\11\12\1\4\11\1\1\2\11\1\1\1\11\2\1"+
    "\1\11\4\1\1\11\3\1\1\11\7\1\1\11\1\1"+
    "\1\11\2\1\1\11\2\1\1\11\2\1\2\11\1\1"+
    "\24\11\2\1\1\11\3\1\1\11\1\1\1\11\1\1"+
    "\1\0\3\1\1\0\1\11\6\1\2\11\1\0\2\1"+
    "\2\0\1\1\2\0\1\11\2\0\41\1\3\11\1\1"+
    "\2\11\1\1\12\0\1\1\1\11\2\1\2\11\1\1"+
    "\1\0\2\11\1\1\10\11\4\0\2\1\3\11\1\1"+
    "\1\0\1\11\3\0\2\1\3\0\4\1\1\0\1\11"+
    "\2\0\1\11\2\0\1\11\1\0\1\11\1\0\4\11"+
    "\1\0\1\1\1\0\12\1\1\0\44\1\1\11\1\1"+
    "\12\0\7\1\3\11\3\0\1\1\2\0\2\11\1\1"+
    "\1\11\2\1\1\0\55\1\12\0\10\1\4\0\1\11"+
    "\3\0\50\1\4\0\1\11\7\0\10\1\1\11\1\1"+
    "\4\0\2\11\33\1\3\0\1\11\5\0\1\11\1\0"+
    "\10\1\3\0\23\1\3\0\1\11\1\0\1\11\10\1"+
    "\2\0\16\1\2\11\7\1\4\0\17\1\2\0\12\1"+
    "\2\0\5\1\3\0\5\1\2\0\2\1\1\11\2\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[654];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

	/** the input device */
	private java.io.Reader zzReader;

	/** the current state of the DFA */
	private int zzState;

	/** the current lexical state */
	private int zzLexicalState = YYINITIAL;

	/** this buffer contains the current text to be matched and is
		the source of the yytext() string */
	private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

	/** the textposition at the last accepting state */
	private int zzMarkedPos;

	/** the current text position in the buffer */
	private int zzCurrentPos;

	/** startRead marks the beginning of the yytext() string in the buffer */
	private int zzStartRead;

	/** endRead marks the last character in the buffer, that has been read
		from input */
	private int zzEndRead;

	/** number of newlines encountered up to the start of the matched text */
	private int yyline;

	/** the number of characters up to the start of the matched text */
	private int yychar;

	/**
	 * the number of characters from the last newline up to the start of the
	 * matched text
	 */
	private int yycolumn;

	/**
	 * zzAtBOL == true <=> the scanner is currently at the beginning of a line
	 */
	private boolean zzAtBOL = true;

	/** zzAtEOF == true <=> the scanner is at the EOF */
	private boolean zzAtEOF;

	/** denotes if the user-EOF-code has already been executed */
	private boolean zzEOFDone;

	/**
	 * The number of occupied positions in zzBuffer beyond zzEndRead.
	 * When a lead/high surrogate has been read from the input stream
	 * into the final zzBuffer position, this will have a value of 1;
	 * otherwise, it will have a value of 0.
	 */
	private int zzFinalHighSurrogate = 0;

  /* user code: */
	private final LinkedList<Object> commentList = new LinkedList<>();
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=514632
	// stores nested HEREDOC and NOWDOC ids
	private final Stack<String> heredocIds = new Stack<>();
	private boolean asp_tags = false;
	private boolean short_tags_allowed = true;
	// XXX: "heredocIds" and "stack" are never reset
	private final StateStack stack = new StateStack();
	protected int commentStartPosition;

	private AST ast;

	public void setAST(AST ast) {
		this.ast = ast;
	}

	@Override
	public PHPVersion getPHPVersion() {
		return PHPVersion.PHP5_3;
	}

	@Override
	public void setInScriptingState() {
		yybegin(ST_IN_SCRIPTING);
	}

	@Override
	public void resetCommentList() {
		commentList.clear();
	}

	/**
	 * Will only be filled when ast != null
	 */
	@Override
	public LinkedList<Object> getCommentList() {
		return commentList;
	}

	/**
	 * Will only be added when ast != null
	 */
	protected void addComment(int type) {
		if (ast != null) {
			int leftPosition = getTokenStartPosition();
			Comment comment = new Comment(commentStartPosition, leftPosition + getTokenLength(), ast, type);
			commentList.add(comment);
		}
	}

	@Override
	public void setUseAspTagsAsPHP(boolean useAspTagsAsPhp) {
		asp_tags = useAspTagsAsPhp;
	}

	@Override
	public void setUseShortTags(boolean useShortTags) {
		short_tags_allowed = useShortTags;
	}

	private void pushState(int state) {
		stack.pushStack(zzLexicalState);
		yybegin(state);
	}

	private void popState() {
		yybegin(stack.popStack());
	}

	@Override
	public int getCurrentLine() {
		return yyline;
	}

	protected int getTokenStartPosition() {
		return zzStartRead - _zzPushbackPos;
	}

	protected int getTokenLength() {
		return zzMarkedPos - zzStartRead;
	}

	@Override
	public int getLength() {
		return zzEndRead - _zzPushbackPos;
	}

	private void handleCommentStart() {
		commentStartPosition = getTokenStartPosition();
	}

	private void handleLineCommentEnd() {
		addComment(Comment.TYPE_SINGLE_LINE);
	}

	private void handleMultilineCommentEnd() {
		addComment(Comment.TYPE_MULTILINE);
	}

	private void handlePHPDocEnd() {
		addComment(Comment.TYPE_PHPDOC);
	}

	protected void handleVarComment() {
		addComment(Comment.TYPE_MULTILINE);
	}

	private Symbol createFullSymbol(int symbolNumber) {
		Symbol symbol = createSymbol(symbolNumber);
		symbol.value = yytext();
		return symbol;
	}

	protected Symbol createSymbol(int symbolNumber) {
		int leftPosition = getTokenStartPosition();
		return new Symbol(symbolNumber, leftPosition, leftPosition + getTokenLength());
	}

	public int[] getParameters() {
		return new int[] { zzMarkedPos, _zzPushbackPos, zzCurrentPos,
				zzStartRead, zzEndRead, yyline, zzAtBOL ? 1 : 0,
				zzAtEOF ? 1 : 0, zzEOFDone ? 1 : 0, zzFinalHighSurrogate };
	}

	/**
	 * Parses a PHPDoc block comment. Underlying reader (zzReader) can be closed
	 * in the process (when EOF is reached).
	 *
	 * @return true when PHPDoc was parsed, false otherwise (false also implies
	 *         that underlying lexer was unavailable)
	 */
	protected boolean parsePHPDoc() {
		final IDocumentorLexer documentorLexer = getDocumentorLexer(zzReader);
		if (documentorLexer == null) {
			return false;
		}
		yypushback(zzMarkedPos - zzStartRead);
		int[] parameters = getParameters();
		documentorLexer.reset(zzReader, zzBuffer, parameters);
		Object phpDocBlock = documentorLexer.parse();
		commentList.add(phpDocBlock);
		reset(zzReader, documentorLexer.getBuffer(), documentorLexer.getParameters());
		return true;
	}

	protected IDocumentorLexer getDocumentorLexer(java.io.Reader reader) {
		return null;
	}

	/**
	 * Resets the {@code PhpAstLexer} properties to previous values, but leaves
	 * the lexical state unchanged. Be careful, method {@link #next_token()}
	 * also caches those properties using internal variables (zzCurrentPosL,
	 * zzMarkedPosL, zzBufferL, zzEndReadL) that should be accordingly resetted
	 * by the lexical rules calling
	 * {@link #reset(java.io.Reader, char[], int[])}. Also be careful that those
	 * internal variables could change from one version of JFlex to another.
	 *
	 * @param reader
	 * @param buffer
	 * @param parameters
	 */
	public void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		this.yychar = this.zzStartRead - this._zzPushbackPos;
		// XXX: never used
		this.yycolumn = 0;
		this.zzAtEOF = parameters[7] != 0;
		this.zzEOFDone = parameters[8] != 0;
		this.zzFinalHighSurrogate = parameters[9];
		// XXX: check if there's no side-effect to reset zzAtBOL
		// when zzAtEOF is false and zzMarkedPos is equal to zzStartRead.
		// One possible case would be that IDocumentorLexer#parse() matches
		// no text at all without being at EOF (i.e. the document lexer returns
		// a zero-length token), which of course would be totally broken...
		this.zzAtBOL = this.zzAtEOF ? false : (parameters[6] != 0);
	}


	/** the textposition at the last state to be included in yytext */
	private int _zzPushbackPos;

	/* The following fields are added in order to support the change in zzRefill */
	private String oldString = null;
	private boolean useOldString = false;
	private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PHPAstLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 236) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>false</code>, iff there was new input.
	 *
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
	private boolean zzRefill() throws java.io.IOException {

		if (useOldString) {
			String saveOldString = oldString;
			oldString = new String(zzBuffer, startPos, zzMarkedPos - startPos);
			if (saveOldString != null) {
				oldString = saveOldString + oldString;
			}
		}

		/* first: make room (if you can) */
		if (zzStartRead > 0) {
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
			System.arraycopy(zzBuffer, zzStartRead,
							zzBuffer, 0,
							zzEndRead-zzStartRead);

			/* translate stored positions */
			zzEndRead-= zzStartRead;
			zzCurrentPos-= zzStartRead;
			zzMarkedPos-= zzStartRead;
			_zzPushbackPos-= zzStartRead;
			startPos = 0;
			zzStartRead = 0;
		}

		/* is the buffer big enough? */
		if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
			/* if not: blow it up */
			char newBuffer[] = new char[zzBuffer.length*2];
			System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
			zzBuffer = newBuffer;
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
		}

		/* fill the buffer with new input */
		int requested = zzBuffer.length - zzEndRead;
		int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

		/* not supposed to occur according to specification of java.io.Reader */
		if (numRead == 0) {
			throw new java.io.IOException("Reader returned 0 characters.");
		}
		if (numRead > 0) {
			zzEndRead += numRead;
			/* If numRead == requested, we might have requested to few chars to
			   encode a full Unicode character. We assume that a Reader would
			   otherwise never return half characters. */
			if (numRead == requested) {
				if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
					--zzEndRead;
					zzFinalHighSurrogate = 1;
				}
			}
			/* potentially more input available */
			return false;
		}

		/* numRead < 0 ==> end of stream */
		return true;
	}


	/**
	 * Gets the next input character.
	 *
	 * @return      the next character of the input stream, EOF if the
	 *              end of the stream is reached.
	 * @exception   IOException  if any I/O-Error occurs
	 */
	private int yy_advance() throws java.io.IOException {

		/* standard case */
		if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

		/* if the eof is reached, we don't need to work hard */
		if (zzAtEOF) return YYEOF;

		/* otherwise: need to refill the buffer */

		String saveOldString = oldString;
		oldString = null;

		/* first: make room (if you can) */
		if (zzRefill()) {
			oldString = saveOldString;
			return YYEOF;
		}

		oldString = saveOldString;

		return zzBuffer[zzCurrentPos++];
	}


	/**
	 * Closes the input stream.
	 */
	public final void yyclose() throws java.io.IOException {
		zzAtEOF = true;            /* indicate end of file */
		zzEndRead = zzStartRead;  /* invalidate buffer    */

		if (zzReader != null)
			zzReader.close();
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>ZZ_INITIAL</tt>.
	 *
	 * Internal scan buffer is resized down to its initial length, if it has grown.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		zzReader = reader;
		zzAtBOL  = true;
		zzAtEOF  = false;
		zzEOFDone = false;
		zzEndRead = zzStartRead = 0;
		zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
		zzFinalHighSurrogate = 0;
		oldString = null;
		yyline = yychar = yycolumn = 0;
		zzLexicalState = YYINITIAL;
		if (zzBuffer.length > ZZ_BUFFERSIZE)
			zzBuffer = new char[ZZ_BUFFERSIZE];
	}


	/**
	 * Returns the current lexical state.
	 */
	public final int yystate() {
		return zzLexicalState;
	}


	/**
	 * Enters a new lexical state
	 *
	 * @param newState the new lexical state
	 */
	public final void yybegin(int newState) {
		zzLexicalState = newState;
	}


	/**
	 * Returns the text matched by the current regular expression.
	 */
	public final String yytext() {
		return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
	}


	/**
	 * Returns the character at position <tt>pos</tt> from the
	 * matched text.
	 *
	 * It is equivalent to yytext().charAt(pos), but faster
	 *
	 * @param pos the position of the character to fetch.
	 *            A value from 0 to yylength()-1.
	 *
	 * @return the character at position pos
	 */
	public final char yycharat(int pos) {
		return zzBuffer[zzStartRead+pos];
	}


	/**
	 * Returns the length of the matched text region.
	 */
	public final int yylength() {
		return zzMarkedPos-zzStartRead;
	}


	/**
	 * Reports an error that occured while scanning.
	 *
	 * In a wellformed scanner (no or only correct usage of
	 * yypushback(int) and a match-all fallback rule) this method
	 * will only be called with things that "Can't Possibly Happen".
	 * If this method is called, something is seriously wrong
	 * (e.g. a JFlex bug producing a faulty scanner etc.).
	 *
	 * Usual syntax/scanner level error handling should be done
	 * in error fallback rules.
	 *
	 * @param   errorCode  the code of the errormessage to display
	 */
  private void zzScanError(int errorCode) {
		String message;
		try {
			message = ZZ_ERROR_MSG[errorCode];
		}
		catch (ArrayIndexOutOfBoundsException e) {
			message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
		}

    throw new Error(message);
	}


	/**
	 * Pushes the specified amount of characters back into the input stream.
	 *
	 * They will be read again by then next call of the scanning method
	 *
	 * @param number  the number of characters to be read again.
	 *                This number must not be greater than yylength()!
	 */
  public void yypushback(int number)  {
		if ( number > yylength() )
			zzScanError(ZZ_PUSHBACK_2BIG);

		zzMarkedPos -= number;
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		updateStartPos(zzMarkedPos);
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos(int position) {
		startPos = position;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


	/**
	 * Resumes scanning until the next regular expression is matched,
	 * the end of input is encountered or an I/O-Error occurs.
	 *
	 * @return      the next token
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
	int zzInput;
	int zzAction;

	// cached fields:
	int zzCurrentPosL;
	int zzMarkedPosL;
	int zzEndReadL = zzEndRead;
	char [] zzBufferL = zzBuffer;
	char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

	while (true) {
		zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
		zzAction = -1;

		zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


		zzForAction: {
			while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
				zzAction = zzState;
				zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
				}

			}
		}

			// store back cached position
			zzMarkedPos = zzMarkedPosL;

			if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
				zzAtEOF = true;
            zzDoEOF();
          { 	return createSymbol(sym.EOF);
 }
			}
			else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 188: break;
          case 2: 
            { return createSymbol(ParserConstants.T_INLINE_HTML);
            }
          case 189: break;
          case 3: 
            { // do nothing
            }
          case 190: break;
          case 4: 
            { return createFullSymbol(ParserConstants.T_LNUMBER);
            }
          case 191: break;
          case 5: 
            { return createSymbol(ParserConstants.T_NEKUDA);
            }
          case 192: break;
          case 6: 
            { return createFullSymbol(ParserConstants.T_STRING);
            }
          case 193: break;
          case 7: 
            { return createSymbol(ParserConstants.T_PLUS);
            }
          case 194: break;
          case 8: 
            { 
            }
          case 195: break;
          case 9: 
            { return createSymbol(ParserConstants.T_DOLLAR);
            }
          case 196: break;
          case 10: 
            { yybegin(ST_DOUBLE_QUOTES);
	return createSymbol(ParserConstants.T_QUATE);
            }
          case 197: break;
          case 11: 
            { return createSymbol(ParserConstants.T_NS_SEPARATOR);
            }
          case 198: break;
          case 12: 
            { yybegin(ST_BACKQUOTE);
	return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 199: break;
          case 13: 
            { pushState(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          case 200: break;
          case 14: 
            { return createSymbol(ParserConstants.T_SEMICOLON);
            }
          case 201: break;
          case 15: 
            { return createSymbol(ParserConstants.T_MINUS);
            }
          case 202: break;
          case 16: 
            { return createSymbol(ParserConstants.T_LGREATER);
            }
          case 203: break;
          case 17: 
            { return createSymbol(ParserConstants.T_NEKUDOTAIM);
            }
          case 204: break;
          case 18: 
            { return createSymbol(ParserConstants.T_OPEN_PARENTHESE);
            }
          case 205: break;
          case 19: 
            { return createSymbol(ParserConstants.T_CLOSE_PARENTHESE);
            }
          case 206: break;
          case 20: 
            { return createSymbol(ParserConstants.T_EQUAL);
            }
          case 207: break;
          case 21: 
            { return createSymbol(ParserConstants.T_NOT);
            }
          case 208: break;
          case 22: 
            { return createSymbol(ParserConstants.T_RGREATER);
            }
          case 209: break;
          case 23: 
            { return createSymbol(ParserConstants.T_TIMES);
            }
          case 210: break;
          case 24: 
            { return createSymbol(ParserConstants.T_DIV);
            }
          case 211: break;
          case 25: 
            { return createSymbol(ParserConstants.T_PRECENT);
            }
          case 212: break;
          case 26: 
            { return createSymbol(ParserConstants.T_REFERENCE);
            }
          case 213: break;
          case 27: 
            { return createSymbol(ParserConstants.T_OR);
            }
          case 214: break;
          case 28: 
            { return createSymbol(ParserConstants.T_KOVA);
            }
          case 215: break;
          case 29: 
            { return createSymbol(ParserConstants.T_COMMA);
            }
          case 216: break;
          case 30: 
            { return createSymbol(ParserConstants.T_OPEN_RECT);
            }
          case 217: break;
          case 31: 
            { return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          case 218: break;
          case 32: 
            { return createSymbol(ParserConstants.T_TILDA);
            }
          case 219: break;
          case 33: 
            { return createSymbol(ParserConstants.T_QUESTION_MARK);
            }
          case 220: break;
          case 34: 
            { return createSymbol(ParserConstants.T_AT);
            }
          case 221: break;
          case 35: 
            { if (!stack.isEmpty()) {
		popState();
	}
	return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          case 222: break;
          case 36: 
            { yybegin(ST_SINGLE_QUOTE);
	return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          case 223: break;
          case 37: 
            { handleCommentStart();
	yybegin(ST_ONE_LINE_COMMENT);
	// yymore();
            }
          case 224: break;
          case 38: 
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_QUATE);
            }
          case 225: break;
          case 39: 
            { return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 226: break;
          case 40: 
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          case 227: break;
          case 41: 
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 228: break;
          case 42: 
            { yypushback(1);
	yybegin(ST_HEREDOC);
            }
          case 229: break;
          case 43: 
            { yypushback(1);
	yybegin(ST_NOWDOC);
            }
          case 230: break;
          case 44: 
            { yypushback(1);
	popState();
            }
          case 231: break;
          case 45: 
            { popState();
	return createFullSymbol(ParserConstants.T_STRING);
            }
          case 232: break;
          case 46: 
            { yypushback(1);
	yybegin(ST_IN_SCRIPTING);
            }
          case 233: break;
          case 47: 
            { yybegin(ST_IN_SCRIPTING);
	return createFullSymbol(ParserConstants.T_STRING_VARNAME);
            }
          case 234: break;
          case 48: 
            { /* treat numbers (almost) as strings inside encapsulated strings */
	return createFullSymbol(ParserConstants.T_NUM_STRING);
            }
          case 235: break;
          case 49: 
            { yypushback(1);
	popState();
	return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 236: break;
          case 50: 
            { return createSymbol(ParserConstants.T_QUATE);
            }
          case 237: break;
          case 51: 
            { return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 238: break;
          case 52: 
            { return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          case 239: break;
          case 53: 
            { popState();
	return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          case 240: break;
          case 54: 
            { return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          case 241: break;
          case 55: 
            { // yymore();
            }
          case 242: break;
          case 56: 
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			handleLineCommentEnd();
			yybegin(ST_IN_SCRIPTING);
	}
	// yymore();
            }
          case 243: break;
          case 57: 
            { if (asp_tags) {
		yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          case 244: break;
          case 58: 
            { if (short_tags_allowed) {
		yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          case 245: break;
          case 59: 
            { return createFullSymbol(ParserConstants.T_DNUMBER);
            }
          case 246: break;
          case 60: 
            { return createSymbol(ParserConstants.T_CONCAT_EQUAL);
            }
          case 247: break;
          case 61: 
            { return createSymbol(ParserConstants.T_INC);
            }
          case 248: break;
          case 62: 
            { return createSymbol(ParserConstants.T_PLUS_EQUAL);
            }
          case 249: break;
          case 63: 
            { return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 250: break;
          case 64: 
            { return createFullSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
            }
          case 251: break;
          case 65: 
            { return createSymbol(ParserConstants.T_IF);
            }
          case 252: break;
          case 66: 
            { return createSymbol(ParserConstants.T_DO);
            }
          case 253: break;
          case 67: 
            { return createSymbol(ParserConstants.T_LOGICAL_OR);
            }
          case 254: break;
          case 68: 
            { return createSymbol(ParserConstants.T_AS);
            }
          case 255: break;
          case 69: 
            { return createSymbol(ParserConstants.T_DEC);
            }
          case 256: break;
          case 70: 
            { pushState(ST_LOOKING_FOR_PROPERTY);
	return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          case 257: break;
          case 71: 
            { return createSymbol(ParserConstants.T_MINUS_EQUAL);
            }
          case 258: break;
          case 72: 
            { return createSymbol(ParserConstants.T_SR);
            }
          case 259: break;
          case 73: 
            { return createSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);
            }
          case 260: break;
          case 74: 
            { return createSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);
            }
          case 261: break;
          case 75: 
            { return createSymbol(ParserConstants.T_DOUBLE_ARROW);
            }
          case 262: break;
          case 76: 
            { return createSymbol(ParserConstants.T_IS_EQUAL);
            }
          case 263: break;
          case 77: 
            { return createSymbol(ParserConstants.T_IS_NOT_EQUAL);
            }
          case 264: break;
          case 78: 
            { return createSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);
            }
          case 265: break;
          case 79: 
            { return createSymbol(ParserConstants.T_SL);
            }
          case 266: break;
          case 80: 
            { return createSymbol(ParserConstants.T_MUL_EQUAL);
            }
          case 267: break;
          case 81: 
            { return createSymbol(ParserConstants.T_DIV_EQUAL);
            }
          case 268: break;
          case 82: 
            { handleCommentStart();
	yybegin(ST_COMMENT);
            }
          case 269: break;
          case 83: 
            { if (asp_tags) {
		yybegin(YYINITIAL);
		return createSymbol(ParserConstants.T_SEMICOLON); /* implicit ';' at php-end tag */
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          case 270: break;
          case 84: 
            { return createSymbol(ParserConstants.T_MOD_EQUAL);
            }
          case 271: break;
          case 85: 
            { return createSymbol(ParserConstants.T_AND_EQUAL);
            }
          case 272: break;
          case 86: 
            { return createSymbol(ParserConstants.T_BOOLEAN_AND);
            }
          case 273: break;
          case 87: 
            { return createSymbol(ParserConstants.T_OR_EQUAL);
            }
          case 274: break;
          case 88: 
            { return createSymbol(ParserConstants.T_BOOLEAN_OR);
            }
          case 275: break;
          case 89: 
            { return createSymbol(ParserConstants.T_XOR_EQUAL);
            }
          case 276: break;
          case 90: 
            { yybegin(YYINITIAL);
	return createSymbol(ParserConstants.T_SEMICOLON); /* implicit ';' at php-end tag */
            }
          case 277: break;
          case 91: 
            { yypushback(1);
	return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 278: break;
          case 92: 
            { pushState(ST_LOOKING_FOR_VARNAME);
	return createSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
            }
          case 279: break;
          case 93: 
            { pushState(ST_IN_SCRIPTING);
	yypushback(yylength() - 1);
	return createSymbol(ParserConstants.T_CURLY_OPEN_WITH_DOLAR);
            }
          case 280: break;
          case 94: 
            { return createSymbol(ParserConstants.T_CHARACTER);
            }
          case 281: break;
          case 95: 
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	String heredoc = heredocIds.peek();
	if (yytext.equals(heredoc)) {
		yypushback(nb_pushback);
		heredocIds.pop();
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_END_HEREDOC);
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
		yybegin(ST_HEREDOC);
	}
            }
          case 282: break;
          case 96: 
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	String nowdoc = heredocIds.peek();
	if (yytext.equals(nowdoc)) {
		yypushback(nb_pushback);
		heredocIds.pop();
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_END_HEREDOC);
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
		yybegin(ST_NOWDOC);
	}
            }
          case 283: break;
          case 97: 
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		nb_pushback = 2;
	} else {
		nb_pushback = 1;
	}
	yypushback(nb_pushback);
	heredocIds.pop();
	yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_END_HEREDOC);
            }
          case 284: break;
          case 98: 
            { return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          case 285: break;
          case 99: 
            { handleMultilineCommentEnd();
	yybegin(ST_IN_SCRIPTING);
            }
          case 286: break;
          case 100: 
            { handlePHPDocEnd();
	yybegin(ST_IN_SCRIPTING);
            }
          case 287: break;
          case 101: 
            { if (asp_tags || yytext().charAt(0) != '%') { /* asp comment? */
		handleLineCommentEnd();
		yypushback(yylength());
		yybegin(ST_IN_SCRIPTING);
	}
            }
          case 288: break;
          case 102: 
            { String yytext = yytext();
	if ((yytext.charAt(1) == '%' && asp_tags)
		|| (yytext.charAt(1) == '?' && short_tags_allowed)) {
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_OPEN_TAG_WITH_ECHO);
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          case 289: break;
          case 103: 
            { return createSymbol(ParserConstants.T_LOGICAL_XOR);
            }
          case 290: break;
          case 104: 
            { return createSymbol(ParserConstants.T_TRY);
            }
          case 291: break;
          case 105: 
            { return createFullSymbol(ParserConstants.T_EXIT);
            }
          case 292: break;
          case 106: 
            { return createSymbol(ParserConstants.T_FOR);
            }
          case 293: break;
          case 107: 
            { return createSymbol(ParserConstants.T_USE);
            }
          case 294: break;
          case 108: 
            { return createSymbol(ParserConstants.T_NEW);
            }
          case 295: break;
          case 109: 
            { return createSymbol(ParserConstants.T_LOGICAL_AND);
            }
          case 296: break;
          case 110: 
            { return createSymbol(ParserConstants.T_SR_EQUAL);
            }
          case 297: break;
          case 111: 
            { return createSymbol(ParserConstants.T_VAR);
            }
          case 298: break;
          case 112: 
            { return createSymbol(ParserConstants.T_IS_IDENTICAL);
            }
          case 299: break;
          case 113: 
            { return createSymbol(ParserConstants.T_IS_NOT_IDENTICAL);
            }
          case 300: break;
          case 114: 
            { return createSymbol(ParserConstants.T_SL_EQUAL);
            }
          case 301: break;
          case 115: 
            { if (parsePHPDoc()) {
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=316077
	// Reset the internal variables caching the values
	// previously resetted by parsePHPDoc().
	// Actually it would be enough to only reset zzEndReadL,
	// but do it cleanly...
	// Also be careful that those internal variables could
	// change from one version of JFlex to another.
	zzCurrentPosL = zzCurrentPos;
	zzMarkedPosL = zzMarkedPos;
	zzBufferL = zzBuffer;
	zzEndReadL = zzEndRead;
} else {
	handleCommentStart();
	yybegin(ST_DOCBLOCK);
}
            }
          case 302: break;
          case 116: 
            { yypushback(1);
	pushState(ST_VAR_OFFSET);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 303: break;
          case 117: 
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	int textLength = yytext.length();
	String heredoc = heredocIds.peek();
	int heredocLength = heredoc.length();
	if (textLength > heredocLength && yytext.substring(textLength - heredocLength, textLength).equals(heredoc)) {
		char c = yytext.charAt(textLength - heredocLength - 1);
		if (c == '\n' || c == '\r') {
			nb_pushback += heredocLength;
			// we need to remove the closing label from the symbol value
			yypushback(nb_pushback);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		}
	}
	// we must (at least) push the newline character back
	yypushback(1);
            }
          case 304: break;
          case 118: 
            { String yytext = yytext();
	int nb_pushback;
	if (yytext.charAt(yytext.length() - 2) == ';') {
		yytext = yytext.substring(0, yytext.length() - 2);
		nb_pushback = 2;
	} else {
		yytext = yytext.substring(0, yytext.length() - 1);
		nb_pushback = 1;
	}
	int textLength = yytext.length();
	String nowdoc = heredocIds.peek();
	int nowdocLength = nowdoc.length();
	if (textLength > nowdocLength && yytext.substring(textLength - nowdocLength, textLength).equals(nowdoc)) {
		char c = yytext.charAt(textLength - nowdocLength - 1);
		if (c == '\n' || c == '\r') {
			nb_pushback += nowdocLength;
			// we need to remove the closing label from the symbol value
			yypushback(nb_pushback);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		}
	}
	// we must (at least) push the newline character back
	yypushback(1);
            }
          case 305: break;
          case 119: 
            { return createSymbol(ParserConstants.T_ECHO);
            }
          case 306: break;
          case 120: 
            { return createSymbol(ParserConstants.T_ELSE);
            }
          case 307: break;
          case 121: 
            { return createSymbol(ParserConstants.T_EVAL);
            }
          case 308: break;
          case 122: 
            { return createSymbol(ParserConstants.T_CASE);
            }
          case 309: break;
          case 123: 
            { return createSymbol(ParserConstants.T_LIST);
            }
          case 310: break;
          case 124: 
            { return createSymbol(ParserConstants.T_GOTO);
            }
          case 311: break;
          case 125: 
            { handleCommentStart();
	handleMultilineCommentEnd();
            }
          case 312: break;
          case 126: 
            { return createSymbol(ParserConstants.T_ENDIF);
            }
          case 313: break;
          case 127: 
            { return createSymbol(ParserConstants.T_EMPTY);
            }
          case 314: break;
          case 128: 
            { return createSymbol(ParserConstants.T_BREAK);
            }
          case 315: break;
          case 129: 
            { return createSymbol(ParserConstants.T_ISSET);
            }
          case 316: break;
          case 130: 
            { return createSymbol(ParserConstants.T_THROW);
            }
          case 317: break;
          case 131: 
            { return createSymbol(ParserConstants.T_FINAL);
            }
          case 318: break;
          case 132: 
            { return createSymbol(ParserConstants.T_UNSET);
            }
          case 319: break;
          case 133: 
            { return createSymbol(ParserConstants.T_CONST);
            }
          case 320: break;
          case 134: 
            { return createSymbol(ParserConstants.T_CATCH);
            }
          case 321: break;
          case 135: 
            { return createSymbol(ParserConstants.T_CLONE);
            }
          case 322: break;
          case 136: 
            { return createSymbol(ParserConstants.T_CLASS);
            }
          case 323: break;
          case 137: 
            { return createSymbol(ParserConstants.T_ARRAY);
            }
          case 324: break;
          case 138: 
            { return createSymbol(ParserConstants.T_WHILE);
            }
          case 325: break;
          case 139: 
            { return createSymbol(ParserConstants.T_PRINT);
            }
          case 326: break;
          case 140: 
            { return createSymbol(ParserConstants.T_INT_CAST);
            }
          case 327: break;
          case 141: 
            { String yytext = yytext();
	int removeChars = (yytext.charAt(0) == 'b') ? 4 : 3;
	String hereOrNowDoc = yytext.substring(removeChars).trim();    // for 'b<<<' or '<<<'
	int heredoc_len = hereOrNowDoc.length();

	Symbol sym = createFullSymbol(ParserConstants.T_START_HEREDOC);
	sym.value = hereOrNowDoc;

	if (hereOrNowDoc.charAt(0) == '\'') {
		heredocIds.push(hereOrNowDoc.substring(1, heredoc_len - 1));
		yybegin(ST_START_NOWDOC);
	} else if (hereOrNowDoc.charAt(0) == '"') {
		heredocIds.push(hereOrNowDoc.substring(1, heredoc_len - 1));
		yybegin(ST_START_HEREDOC);
	} else {
		heredocIds.push(hereOrNowDoc);
		yybegin(ST_START_HEREDOC);
	}
	return sym;
            }
          case 328: break;
          case 142: 
            { yypushback(3);
	pushState(ST_LOOKING_FOR_PROPERTY);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 329: break;
          case 143: 
            { yybegin(ST_IN_SCRIPTING);
	//return T_OPEN_TAG;
            }
          case 330: break;
          case 144: 
            { return createSymbol(ParserConstants.T_ENDFOR);
            }
          case 331: break;
          case 145: 
            { return createSymbol(ParserConstants.T_ELSEIF);
            }
          case 332: break;
          case 146: 
            { /* not a keyword, used to recognize constants.*/
	return createFullSymbol(ParserConstants.T_DEFINE);
            }
          case 333: break;
          case 147: 
            { return createSymbol(ParserConstants.T_STATIC);
            }
          case 334: break;
          case 148: 
            { return createSymbol(ParserConstants.T_SWITCH);
            }
          case 335: break;
          case 149: 
            { return createSymbol(ParserConstants.T_RETURN);
            }
          case 336: break;
          case 150: 
            { return createSymbol(ParserConstants.T_GLOBAL);
            }
          case 337: break;
          case 151: 
            { return createSymbol(ParserConstants.T_PUBLIC);
            }
          case 338: break;
          case 152: 
            { return createSymbol(ParserConstants.T_BOOL_CAST);
            }
          case 339: break;
          case 153: 
            { return createSymbol(ParserConstants.T_DOUBLE_CAST);
            }
          case 340: break;
          case 154: 
            { return createSymbol(ParserConstants.T_EXTENDS);
            }
          case 341: break;
          case 155: 
            { return createSymbol(ParserConstants.T_INCLUDE);
            }
          case 342: break;
          case 156: 
            { return createSymbol(ParserConstants.T_DEFAULT);
            }
          case 343: break;
          case 157: 
            { return createSymbol(ParserConstants.T_DECLARE);
            }
          case 344: break;
          case 158: 
            { return createSymbol(ParserConstants.T_FOREACH);
            }
          case 345: break;
          case 159: 
            { return createSymbol(ParserConstants.T_REQUIRE);
            }
          case 346: break;
          case 160: 
            { return createSymbol(ParserConstants.T_PRIVATE);
            }
          case 347: break;
          case 161: 
            { return createSymbol(ParserConstants.T_UNSET_CAST);
            }
          case 348: break;
          case 162: 
            { return createSymbol(ParserConstants.T_ARRAY_CAST);
            }
          case 349: break;
          case 163: 
            { return createSymbol(ParserConstants.T_DIR);
            }
          case 350: break;
          case 164: 
            { return createSymbol(ParserConstants.T_ENDWHILE);
            }
          case 351: break;
          case 165: 
            { return createSymbol(ParserConstants.T_FUNCTION);
            }
          case 352: break;
          case 166: 
            { return createSymbol(ParserConstants.T_CONTINUE);
            }
          case 353: break;
          case 167: 
            { return createSymbol(ParserConstants.T_ABSTRACT);
            }
          case 354: break;
          case 168: 
            { return createSymbol(ParserConstants.T_STRING_CAST);
            }
          case 355: break;
          case 169: 
            { return createSymbol(ParserConstants.T_OBJECT_CAST);
            }
          case 356: break;
          case 170: 
            { return createSymbol(ParserConstants.T_FILE);
            }
          case 357: break;
          case 171: 
            { return createSymbol(ParserConstants.T_LINE);
            }
          case 358: break;
          case 172: 
            { return createSymbol(ParserConstants.T_ENDSWITCH);
            }
          case 359: break;
          case 173: 
            { return createSymbol(ParserConstants.T_INTERFACE);
            }
          case 360: break;
          case 174: 
            { return createSymbol(ParserConstants.T_NAMESPACE);
            }
          case 361: break;
          case 175: 
            { return createSymbol(ParserConstants.T_PROTECTED);
            }
          case 362: break;
          case 176: 
            { return createSymbol(ParserConstants.T_CLASS_C);
            }
          case 363: break;
          case 177: 
            { return createSymbol(ParserConstants.T_ENDDECLARE);
            }
          case 364: break;
          case 178: 
            { return createSymbol(ParserConstants.T_ENDFOREACH);
            }
          case 365: break;
          case 179: 
            { return createSymbol(ParserConstants.T_INSTANCEOF);
            }
          case 366: break;
          case 180: 
            { return createSymbol(ParserConstants.T_IMPLEMENTS);
            }
          case 367: break;
          case 181: 
            { return createSymbol(ParserConstants.T_METHOD_C);
            }
          case 368: break;
          case 182: 
            { return createSymbol(ParserConstants.T_INCLUDE_ONCE);
            }
          case 369: break;
          case 183: 
            { return createSymbol(ParserConstants.T_REQUIRE_ONCE);
            }
          case 370: break;
          case 184: 
            { return createSymbol(ParserConstants.T_FUNC_C);
            }
          case 371: break;
          case 185: 
            { return createSymbol(ParserConstants.T_NS_C);
            }
          case 372: break;
          case 186: 
            { handleCommentStart();
	handleVarComment();
	//return createFullSymbol(ParserConstants.T_VAR_COMMENT);
            }
          case 373: break;
          case 187: 
            { return createSymbol(ParserConstants.T_HALT_COMPILER);
            }
          case 374: break;
		default:
            zzScanError(ZZ_NO_MATCH);
				}
			}
		}
	}

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java PHPAstLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          java.nio.charset.Charset.forName(encodingName); // Side-effect: is encodingName valid? 
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        PHPAstLexer scanner = null;
        try {
          java.io.FileInputStream stream = new java.io.FileInputStream(argv[i]);
          java.io.Reader reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new PHPAstLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
