/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006, 2017 Zend Corporation and IBM Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.documentModel.parser.php7;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag.TagKind;

@SuppressWarnings({"unused", "nls"})


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>highlighting_scanner.jflex</tt>
 */
public class PHPLexer extends org.eclipse.php.internal.core.documentModel.parser.AbstractPHPLexer {

	/** This character denotes the end of file */
	public static final int YYEOF = -1;

	/** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

	/** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_PHP_IN_SCRIPTING = 2;
  public static final int ST_PHP_DOUBLE_QUOTES = 4;
  public static final int ST_PHP_SINGLE_QUOTE = 6;
  public static final int ST_PHP_BACKQUOTE = 8;
  public static final int ST_PHP_QUOTES_AFTER_VARIABLE = 10;
  public static final int ST_PHP_HEREDOC = 12;
  public static final int ST_PHP_NOWDOC = 14;
  public static final int ST_PHP_START_HEREDOC = 16;
  public static final int ST_PHP_START_NOWDOC = 18;
  public static final int ST_PHP_END_HEREDOC = 20;
  public static final int ST_PHP_LOOKING_FOR_PROPERTY = 22;
  public static final int ST_PHP_VAR_OFFSET = 24;
  public static final int ST_PHP_COMMENT = 26;
  public static final int ST_PHP_DOC_COMMENT = 28;
  public static final int ST_PHP_LINE_COMMENT = 30;
  public static final int ST_PHP_HIGHLIGHTING_ERROR = 32;
  public static final int ST_PHP_END_NOWDOC = 34;
  public static final int ST_PHP_IDENTIFIER = 36;
  public static final int ST_PHP_DOLLAR_CURLY_OPEN = 38;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16, 17, 17, 18, 18, 19, 19
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\14\1\13\2\0\1\17\22\0\1\14\1\30\1\21\1\76"+
    "\1\20\1\34\1\35\1\75\1\65\1\66\1\32\1\27\1\15\1\4"+
    "\1\2\1\33\1\5\1\11\10\1\1\63\1\16\1\31\1\25\1\26"+
    "\1\45\1\77\1\42\1\10\1\7\1\44\1\3\1\50\1\61\1\56"+
    "\1\101\1\67\1\103\1\54\1\55\1\43\1\40\1\62\1\71\1\41"+
    "\1\102\1\47\1\51\1\64\1\57\1\6\1\53\1\100\1\73\1\22"+
    "\1\74\1\37\1\70\1\23\1\42\1\10\1\7\1\44\1\3\1\50"+
    "\1\61\1\56\1\101\1\67\1\103\1\54\1\55\1\43\1\40\1\62"+
    "\1\71\1\41\1\102\1\47\1\51\1\64\1\57\1\6\1\53\1\100"+
    "\1\24\1\36\1\72\1\15\1\0\260\12\2\46\115\12\1\52\u1faa\12"+
    "\1\60\uded5\12\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\20\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\1\2\14\0\1\3\1\4\1\5\1\6"+
    "\1\5\1\4\4\6\1\7\1\5\1\10\1\5\1\11"+
    "\1\12\1\13\1\14\13\5\5\6\1\5\12\6\1\5"+
    "\1\6\1\5\1\6\1\15\1\16\1\17\1\1\1\2"+
    "\1\20\4\2\1\1\3\2\3\21\2\1\3\3\1\2"+
    "\2\22\2\23\1\0\1\3\1\24\1\25\1\24\1\4"+
    "\1\26\1\4\1\27\1\26\1\6\1\30\2\31\4\32"+
    "\3\33\3\34\1\35\1\36\1\0\1\3\2\25\1\24"+
    "\1\37\1\40\2\4\1\41\6\6\1\42\2\0\3\6"+
    "\1\0\2\6\2\43\2\0\1\2\2\0\3\41\1\44"+
    "\1\45\1\41\4\6\1\46\4\6\1\47\1\6\1\50"+
    "\1\6\1\51\27\6\1\52\1\6\12\0\1\6\5\0"+
    "\1\53\2\54\1\55\1\56\1\54\4\0\2\54\1\57"+
    "\3\0\1\1\2\54\1\2\1\0\1\60\2\0\1\61"+
    "\2\0\1\62\1\53\1\63\1\0\1\64\1\65\1\66"+
    "\1\67\1\0\2\25\1\70\1\71\1\40\7\6\2\4"+
    "\6\6\1\0\2\6\1\43\1\0\1\72\4\6\1\73"+
    "\4\6\1\74\1\6\1\75\5\6\1\76\1\6\1\77"+
    "\6\6\1\100\15\6\1\101\12\0\7\6\1\102\1\103"+
    "\1\1\1\104\1\2\1\105\2\0\2\106\1\107\1\0"+
    "\2\25\1\110\1\6\1\111\5\6\1\112\1\6\1\113"+
    "\3\6\1\114\3\6\1\115\1\6\1\43\3\0\1\116"+
    "\5\6\1\117\10\6\1\120\2\6\1\121\5\6\1\122"+
    "\4\6\1\123\1\6\1\124\6\6\12\0\10\6\1\125"+
    "\2\25\2\6\1\126\4\6\1\127\1\6\1\130\1\131"+
    "\1\6\1\132\1\133\1\134\1\135\2\136\2\0\3\6"+
    "\1\137\7\6\1\140\1\6\1\141\1\142\1\6\1\143"+
    "\1\144\1\6\1\145\1\146\3\6\1\147\1\150\2\6"+
    "\1\151\3\6\7\0\1\152\2\0\10\6\1\133\1\25"+
    "\2\6\1\153\2\6\1\154\2\6\1\0\1\155\15\6"+
    "\1\156\1\157\1\160\1\0\1\161\2\6\1\162\1\163"+
    "\4\0\10\6\1\25\1\164\6\6\1\165\2\6\1\166"+
    "\1\167\1\170\4\6\1\171\1\172\1\6\1\0\1\6"+
    "\1\173\2\0\2\6\1\174\5\6\1\25\3\6\1\175"+
    "\1\176\1\177\1\6\1\200\6\6\1\201\1\0\3\6"+
    "\1\202\1\6\1\203\2\6\1\204\2\6\1\205\1\6"+
    "\1\206\1\6\1\207\1\210\2\6\1\0\1\211\1\212"+
    "\4\6\1\213\1\214\2\6\1\215\1\216\1\147\2\6"+
    "\1\217\6\6\1\220\1\221\1\6\1\222\1\6\1\223"+
    "\2\6\1\224";

  private static int [] zzUnpackAction() {
    int [] result = new int[650];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\104\0\210\0\314\0\u0110\0\u0154\0\u0198\0\u01dc"+
    "\0\u0220\0\u0264\0\u02a8\0\u02ec\0\u0330\0\u0374\0\u03b8\0\u03fc"+
    "\0\u0440\0\u0484\0\u04c8\0\u050c\0\0\0\u0550\0\u0594\0\u05d8"+
    "\0\u061c\0\u0660\0\u06a4\0\u06e8\0\u072c\0\u0770\0\u07b4\0\0"+
    "\0\0\0\u07f8\0\u083c\0\0\0\0\0\u0880\0\u08c4\0\u0908"+
    "\0\u094c\0\u0990\0\u09d4\0\u0a18\0\u0a5c\0\u0aa0\0\u0ae4\0\u0b28"+
    "\0\u0b6c\0\u0bb0\0\u0bf4\0\u0c38\0\u0c7c\0\u0cc0\0\u0d04\0\u0d48"+
    "\0\u0d8c\0\u0dd0\0\u0e14\0\u0e58\0\u0e9c\0\u0ee0\0\u0f24\0\u0f68"+
    "\0\u0fac\0\u0ff0\0\u1034\0\u1078\0\u10bc\0\u1100\0\u1144\0\0"+
    "\0\u1188\0\u11cc\0\0\0\u1210\0\u1254\0\u1298\0\u12dc\0\u1320"+
    "\0\u1364\0\u13a8\0\u13ec\0\0\0\u1430\0\u1474\0\u14b8\0\u14fc"+
    "\0\u1540\0\u1584\0\u15c8\0\u160c\0\0\0\u1650\0\0\0\u1694"+
    "\0\u16d8\0\u171c\0\0\0\u1760\0\u17a4\0\u17e8\0\0\0\u182c"+
    "\0\0\0\u1870\0\u18b4\0\0\0\u18f8\0\u193c\0\0\0\u1980"+
    "\0\u19c4\0\u1a08\0\u1a4c\0\0\0\u1a90\0\0\0\u1ad4\0\u1b18"+
    "\0\0\0\u1b5c\0\u1ba0\0\u1be4\0\u1c28\0\u1c6c\0\u1cb0\0\u1cf4"+
    "\0\u1d38\0\u1d7c\0\u1dc0\0\0\0\u1e04\0\u1e48\0\u1e8c\0\u1ed0"+
    "\0\u1f14\0\u1f58\0\0\0\u1f9c\0\u1fe0\0\u2024\0\u2068\0\u20ac"+
    "\0\u20f0\0\u2134\0\u2178\0\u21bc\0\u2200\0\u083c\0\u2244\0\0"+
    "\0\u2288\0\u22cc\0\u0b6c\0\u2310\0\u2354\0\u2398\0\0\0\u0770"+
    "\0\u23dc\0\u2420\0\u2464\0\u24a8\0\u0770\0\u24ec\0\u2530\0\u2574"+
    "\0\u25b8\0\u0770\0\u25fc\0\0\0\u2640\0\u0770\0\u2684\0\u26c8"+
    "\0\u270c\0\u2750\0\u2794\0\u27d8\0\u281c\0\u2860\0\u28a4\0\u28e8"+
    "\0\u292c\0\u2970\0\u29b4\0\u29f8\0\u2a3c\0\u2a80\0\u2ac4\0\u2b08"+
    "\0\u2b4c\0\u2b90\0\u2bd4\0\u2c18\0\u2c5c\0\0\0\u2ca0\0\u2ce4"+
    "\0\u1078\0\u2d28\0\u2d6c\0\u2db0\0\u2df4\0\u2e38\0\u2e7c\0\u2ec0"+
    "\0\u2f04\0\u2f48\0\u1144\0\u2f8c\0\u2fd0\0\u1210\0\u3014\0\u3058"+
    "\0\u2fd0\0\0\0\0\0\0\0\u3014\0\u309c\0\u30e0\0\u13a8"+
    "\0\u3124\0\u30e0\0\u3124\0\0\0\u3168\0\u1584\0\u31ac\0\u31f0"+
    "\0\u3168\0\u31ac\0\u3234\0\u1650\0\0\0\u3278\0\u1694\0\0"+
    "\0\u32bc\0\u3300\0\0\0\u3344\0\0\0\u3388\0\0\0\u1a08"+
    "\0\0\0\u33cc\0\u3410\0\u3454\0\u3498\0\0\0\u34dc\0\u3520"+
    "\0\u3564\0\u35a8\0\u35ec\0\u3630\0\u3674\0\u36b8\0\u36fc\0\u1f9c"+
    "\0\u1fe0\0\u3740\0\u3784\0\u37c8\0\u380c\0\u3850\0\u3894\0\u38d8"+
    "\0\u391c\0\u3960\0\u39a4\0\u39e8\0\u3a2c\0\u3a70\0\u3ab4\0\u3af8"+
    "\0\u3b3c\0\u0770\0\u3b80\0\u3bc4\0\u3c08\0\u3c4c\0\u0770\0\u3c90"+
    "\0\u3cd4\0\u3d18\0\u3d5c\0\u3da0\0\u3de4\0\u3e28\0\u0770\0\u3e6c"+
    "\0\u3eb0\0\u3ef4\0\u3f38\0\u3f7c\0\u3fc0\0\u4004\0\u4048\0\u0770"+
    "\0\u408c\0\u40d0\0\u4114\0\u4158\0\u419c\0\u41e0\0\u4224\0\u4268"+
    "\0\u42ac\0\u42f0\0\u4334\0\u4378\0\u43bc\0\u0770\0\u4400\0\u4444"+
    "\0\u4488\0\u44cc\0\u4510\0\u4554\0\u4598\0\u45dc\0\u4620\0\u4664"+
    "\0\u46a8\0\u46ec\0\u4730\0\u4774\0\u47b8\0\u47fc\0\u4840\0\0"+
    "\0\0\0\u4884\0\0\0\u48c8\0\0\0\u490c\0\u4950\0\0"+
    "\0\u4994\0\0\0\u49d8\0\u4a1c\0\u4a60\0\u0770\0\u4aa4\0\u0770"+
    "\0\u4ae8\0\u4b2c\0\u4b70\0\u4bb4\0\u4bf8\0\u4c3c\0\u4c80\0\u0770"+
    "\0\u4cc4\0\u4d08\0\u4d4c\0\u0770\0\u4d90\0\u4dd4\0\u4e18\0\u0770"+
    "\0\u4e5c\0\u4ea0\0\u4ee4\0\u4f28\0\u4f6c\0\0\0\u4fb0\0\u4ff4"+
    "\0\u5038\0\u507c\0\u50c0\0\u0770\0\u5104\0\u5148\0\u518c\0\u51d0"+
    "\0\u5214\0\u5258\0\u529c\0\u52e0\0\u0770\0\u5324\0\u5368\0\u0770"+
    "\0\u53ac\0\u53f0\0\u5434\0\u5478\0\u54bc\0\u0770\0\u5500\0\u5544"+
    "\0\u5588\0\u55cc\0\u0770\0\u5610\0\u0770\0\u5654\0\u5698\0\u56dc"+
    "\0\u5720\0\u5764\0\u57a8\0\u57ec\0\u5830\0\u5874\0\u58b8\0\u58fc"+
    "\0\u5940\0\u5984\0\u59c8\0\u5a0c\0\u5a50\0\u5a94\0\u5ad8\0\u5b1c"+
    "\0\u5b60\0\u5ba4\0\u5be8\0\u5c2c\0\u5c70\0\0\0\u5cb4\0\u5cf8"+
    "\0\u5d3c\0\u5d80\0\u0770\0\u5dc4\0\u5e08\0\u5e4c\0\u5e90\0\u0770"+
    "\0\u5ed4\0\u0770\0\u0770\0\u5f18\0\u0770\0\u0770\0\u0770\0\u21bc"+
    "\0\0\0\u5f5c\0\u5fa0\0\u5fe4\0\u6028\0\u606c\0\u60b0\0\u0770"+
    "\0\u60f4\0\u6138\0\u617c\0\u61c0\0\u6204\0\u6248\0\u628c\0\u0770"+
    "\0\u62d0\0\u0770\0\u0770\0\u6314\0\u0770\0\u6358\0\u639c\0\u0770"+
    "\0\u0770\0\u63e0\0\u6424\0\u6468\0\u64ac\0\u0770\0\u64f0\0\u6534"+
    "\0\u0770\0\u6578\0\u65bc\0\u6600\0\u6644\0\u6688\0\u66cc\0\u6710"+
    "\0\u6754\0\u6798\0\u67dc\0\0\0\u6820\0\u6864\0\u68a8\0\u68ec"+
    "\0\u6930\0\u6974\0\u69b8\0\u69fc\0\u6a40\0\u6a84\0\u1760\0\u6ac8"+
    "\0\u6b0c\0\u6b50\0\u6b94\0\u6bd8\0\u6c1c\0\u0770\0\u6c60\0\u6ca4"+
    "\0\u6ce8\0\u0770\0\u6d2c\0\u6d70\0\u6db4\0\u6df8\0\u6e3c\0\u6e80"+
    "\0\u6ec4\0\u6f08\0\u6f4c\0\u6f90\0\u6fd4\0\u7018\0\u705c\0\u0770"+
    "\0\u0770\0\u0770\0\u70a0\0\u0770\0\u70e4\0\u7128\0\u0770\0\u0770"+
    "\0\u716c\0\u71b0\0\u71f4\0\u7238\0\u727c\0\u72c0\0\u7304\0\u7348"+
    "\0\u738c\0\u73d0\0\u7414\0\u7458\0\u749c\0\u0770\0\u74e0\0\u7524"+
    "\0\u7568\0\u75ac\0\u75f0\0\u7634\0\u7678\0\u76bc\0\u7700\0\u0770"+
    "\0\u0770\0\u7744\0\u7788\0\u77cc\0\u7810\0\u7854\0\u0770\0\u0770"+
    "\0\u7898\0\u78dc\0\u7920\0\u0770\0\u7964\0\u79a8\0\u79ec\0\u7a30"+
    "\0\u0770\0\u7a74\0\u7ab8\0\u7afc\0\u7b40\0\u7b84\0\u7bc8\0\u7c0c"+
    "\0\u7c50\0\u7c94\0\u0770\0\u0770\0\u0770\0\u7cd8\0\u0770\0\u7d1c"+
    "\0\u7d60\0\u7da4\0\u7de8\0\u7e2c\0\u7e70\0\u0770\0\u7eb4\0\u7ef8"+
    "\0\u7f3c\0\u7f80\0\u0770\0\u7fc4\0\u0770\0\u8008\0\u804c\0\u1760"+
    "\0\u8090\0\u80d4\0\u0770\0\u8118\0\u0770\0\u815c\0\u0770\0\u0770"+
    "\0\u81a0\0\u81e4\0\u8228\0\u0770\0\u0770\0\u826c\0\u82b0\0\u82f4"+
    "\0\u8338\0\u0770\0\u0770\0\u837c\0\u83c0\0\u0770\0\u0770\0\0"+
    "\0\u8404\0\u8448\0\u0770\0\u848c\0\u84d0\0\u8514\0\u8558\0\u859c"+
    "\0\u85e0\0\u0770\0\u0770\0\u8624\0\u0770\0\u8668\0\u0770\0\u86ac"+
    "\0\u86f0\0\u0770";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[650];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\104\0\1\25\1\26\1\27\1\30\1\31\1\32\1\33"+
    "\1\34\1\35\1\26\1\36\2\37\1\40\1\41\1\37"+
    "\1\42\1\43\1\44\1\45\1\46\1\47\1\50\1\51"+
    "\1\52\1\53\1\54\1\55\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\66\1\67\1\70\1\71"+
    "\1\72\1\73\1\74\1\75\1\76\2\36\1\77\1\36"+
    "\1\100\1\101\1\102\1\103\1\104\1\40\1\36\1\105"+
    "\1\36\1\106\2\40\1\107\1\110\1\40\1\36\1\70"+
    "\1\74\1\36\20\111\1\112\1\113\1\114\1\111\1\115"+
    "\57\111\22\116\1\117\52\116\1\113\6\116\20\120\1\121"+
    "\1\120\1\122\1\113\1\123\57\120\4\124\1\125\17\124"+
    "\1\126\57\124\13\127\1\130\3\127\1\130\1\131\1\127"+
    "\1\132\1\127\1\133\57\127\13\10\1\134\3\10\1\134"+
    "\64\10\3\135\1\136\2\135\3\136\1\135\1\136\25\135"+
    "\5\136\1\135\15\136\1\135\1\136\2\135\3\136\6\135"+
    "\4\136\3\137\1\140\2\137\3\140\1\137\1\140\25\137"+
    "\5\140\1\137\15\140\1\137\1\140\2\137\3\140\6\137"+
    "\4\140\13\25\1\141\3\25\1\142\64\25\3\143\1\144"+
    "\1\145\1\143\3\144\1\143\1\144\2\37\2\143\1\37"+
    "\20\143\5\144\1\143\15\144\1\143\1\144\2\143\3\144"+
    "\6\143\4\144\1\25\1\146\1\147\1\36\1\147\1\150"+
    "\3\36\1\146\1\36\2\151\2\147\1\151\1\152\1\147"+
    "\1\151\15\147\3\36\1\153\1\36\1\147\15\36\1\147"+
    "\1\36\2\147\3\36\1\147\1\40\1\154\2\151\1\147"+
    "\4\36\32\155\1\156\51\155\24\157\1\160\5\157\1\161"+
    "\44\157\1\162\4\157\13\163\1\164\3\163\1\165\6\163"+
    "\1\166\5\163\1\167\10\163\1\170\36\163\13\171\2\172"+
    "\2\171\1\172\64\171\13\25\1\173\3\25\1\174\64\25"+
    "\3\143\1\144\2\143\1\144\1\175\1\144\1\143\1\144"+
    "\2\37\2\143\1\37\20\143\5\144\1\143\2\144\1\176"+
    "\12\144\1\177\1\144\2\143\3\144\6\143\4\144\3\25"+
    "\1\200\2\25\3\200\1\25\1\200\1\0\10\25\1\201"+
    "\13\25\5\200\1\25\15\200\1\25\1\200\2\25\3\200"+
    "\6\25\4\200\1\0\1\26\1\202\1\203\1\0\1\26"+
    "\3\0\1\26\73\0\1\202\3\0\1\202\3\0\1\202"+
    "\13\0\1\204\57\0\1\36\1\0\1\36\1\0\1\36"+
    "\1\205\1\206\3\36\25\0\3\36\1\207\1\36\1\0"+
    "\6\36\1\210\1\211\5\36\1\0\1\212\2\0\3\36"+
    "\6\0\4\36\4\0\1\204\20\0\1\204\1\213\56\0"+
    "\1\26\1\202\1\203\1\0\1\26\1\214\1\0\1\215"+
    "\1\26\73\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\1\62\4\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\1\216\1\36\1\217\2\36\1\0\6\36\1\220"+
    "\6\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\6\0\1\43\7\0"+
    "\1\221\6\0\1\222\1\223\3\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\3\0\1\107\2\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\13\0"+
    "\2\37\2\0\1\37\67\0\1\224\2\0\3\224\1\0"+
    "\1\224\25\0\5\224\1\0\1\224\1\225\13\224\1\0"+
    "\1\224\2\0\3\224\6\0\4\224\20\226\1\227\1\230"+
    "\1\231\1\226\1\232\57\226\13\0\2\46\2\0\1\46"+
    "\111\0\1\233\1\204\102\0\1\204\1\233\102\0\1\204"+
    "\1\0\1\204\101\0\1\233\103\0\1\234\1\204\2\0"+
    "\1\235\77\0\1\204\4\0\1\233\76\0\1\204\4\0"+
    "\1\236\1\110\75\0\1\204\1\237\102\0\1\204\7\0"+
    "\1\204\73\0\1\204\10\0\1\204\72\0\1\204\57\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\1\36\1\240"+
    "\3\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\241\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\3\36\1\242"+
    "\2\36\25\0\1\36\1\243\1\36\1\244\1\36\1\0"+
    "\4\36\1\245\10\36\1\0\1\36\2\0\3\36\6\0"+
    "\2\36\1\245\1\36\1\0\1\36\1\0\1\246\1\0"+
    "\6\36\25\0\2\36\1\247\2\36\1\0\3\36\1\250"+
    "\11\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\251\1\0\6\36\25\0\1\252\4\36"+
    "\1\0\1\253\14\36\1\0\1\36\2\0\3\36\6\0"+
    "\1\36\1\253\2\36\26\0\1\254\16\0\1\204\37\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\3\36\1\255"+
    "\1\36\1\0\2\36\1\256\1\36\1\257\2\36\1\260"+
    "\5\36\1\0\1\36\2\0\3\36\6\0\2\36\1\257"+
    "\1\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\1\36\1\261\3\36\1\0\10\36\1\262\4\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\1\263\1\264\1\265\2\36"+
    "\1\0\1\266\2\36\1\267\2\36\1\270\6\36\1\0"+
    "\1\36\2\0\3\36\6\0\1\36\1\266\2\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\3\36\1\271"+
    "\1\36\1\0\4\36\1\272\10\36\1\0\1\36\2\0"+
    "\3\36\6\0\2\36\1\272\1\36\1\0\1\36\1\0"+
    "\1\273\1\0\6\36\25\0\5\36\1\0\1\36\1\274"+
    "\7\36\1\275\3\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\1\276\14\36\1\0\1\36\2\0\3\36"+
    "\6\0\1\36\1\276\2\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\1\277\14\36\1\0"+
    "\1\36\2\0\3\36\6\0\1\36\1\277\2\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\10\36\1\300\4\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\1\301\4\36\1\0\6\36\1\302\6\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\1\36\1\303\1\304\2\36\1\0"+
    "\3\36\1\305\11\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\63\0\1\306\21\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\2\36\1\307\2\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\10\0\1\310\3\0"+
    "\1\311\23\0\1\312\1\313\1\314\1\0\1\315\1\0"+
    "\1\316\1\0\1\317\1\320\1\321\26\0\1\316\1\321"+
    "\2\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\1\36\1\322\1\36"+
    "\6\0\4\36\13\0\2\106\2\0\1\106\64\0\22\323"+
    "\1\324\52\323\1\230\6\323\20\111\1\325\1\0\1\326"+
    "\1\111\1\327\62\111\1\330\2\111\3\330\1\111\1\330"+
    "\5\111\1\331\1\332\1\326\1\111\1\333\13\111\5\330"+
    "\1\111\15\330\1\111\1\330\2\111\3\330\6\111\4\330"+
    "\124\111\1\334\1\332\1\326\1\111\1\335\57\111\22\116"+
    "\1\336\52\116\1\0\30\116\1\230\52\116\1\230\6\116"+
    "\20\120\1\337\1\120\1\340\1\0\1\341\62\120\1\330"+
    "\2\120\3\330\1\120\1\330\5\120\1\342\1\120\1\340"+
    "\1\332\1\333\13\120\5\330\1\120\15\330\1\120\1\330"+
    "\2\120\3\330\6\120\4\330\124\120\1\334\1\120\1\340"+
    "\1\332\1\343\57\120\26\0\1\344\75\0\1\334\63\0"+
    "\13\127\1\130\3\127\1\130\1\345\1\127\1\346\1\127"+
    "\1\347\62\127\1\350\2\127\3\350\1\127\1\350\1\130"+
    "\3\127\1\130\1\345\1\127\1\346\1\127\1\347\13\127"+
    "\5\350\1\127\15\350\1\127\1\350\2\127\3\350\6\127"+
    "\4\350\3\127\1\330\2\127\3\330\1\127\1\330\1\130"+
    "\3\127\1\130\1\351\1\127\1\346\1\127\1\333\13\127"+
    "\5\330\1\127\15\330\1\127\1\330\2\127\3\330\6\127"+
    "\4\330\13\127\1\130\3\127\1\130\77\127\1\130\3\127"+
    "\1\130\1\334\1\127\1\346\1\127\1\352\57\127\3\10"+
    "\1\353\2\10\3\353\1\10\1\353\1\134\3\10\1\134"+
    "\20\10\5\353\1\10\15\353\1\10\1\353\2\10\3\353"+
    "\6\10\4\353\1\0\1\354\1\0\1\354\1\0\6\354"+
    "\1\355\2\0\1\356\1\355\20\0\5\354\1\0\15\354"+
    "\1\0\1\354\2\0\3\354\6\0\4\354\1\0\1\357"+
    "\1\0\1\357\1\0\6\357\1\360\2\0\1\361\1\360"+
    "\20\0\5\357\1\0\15\357\1\0\1\357\2\0\3\357"+
    "\6\0\4\357\3\0\1\362\2\0\3\362\1\0\1\362"+
    "\25\0\5\362\1\0\15\362\1\0\1\362\2\0\3\362"+
    "\6\0\4\362\3\0\1\362\2\0\3\362\1\0\1\362"+
    "\1\141\24\0\5\362\1\0\15\362\1\0\1\362\2\0"+
    "\3\362\6\0\4\362\1\0\1\144\1\0\1\144\1\0"+
    "\6\144\25\0\5\144\1\0\15\144\1\0\1\144\2\0"+
    "\3\144\6\0\4\144\26\0\1\363\56\0\1\146\3\0"+
    "\1\146\3\0\1\146\73\0\1\146\3\0\1\146\1\214"+
    "\1\0\1\215\1\146\75\0\1\364\2\0\3\364\1\0"+
    "\1\364\25\0\5\364\1\0\15\364\1\0\1\364\2\0"+
    "\3\364\6\0\4\364\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\3\36\1\250\11\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\32\155\1\0\51\155"+
    "\33\0\1\365\147\0\1\366\37\0\1\367\50\0\13\370"+
    "\2\0\2\370\1\0\12\370\1\0\51\370\13\163\1\164"+
    "\3\163\1\164\6\163\1\164\5\163\1\164\10\163\1\164"+
    "\36\163\13\0\1\371\116\0\1\372\103\0\1\254\70\0"+
    "\2\172\2\0\1\172\67\0\1\373\2\0\3\373\1\0"+
    "\1\373\25\0\5\373\1\0\15\373\1\0\1\373\2\0"+
    "\3\373\6\0\4\373\3\0\1\373\2\0\3\373\1\0"+
    "\1\373\1\173\24\0\5\373\1\0\15\373\1\0\1\373"+
    "\2\0\3\373\6\0\4\373\1\0\1\144\1\0\1\144"+
    "\1\0\6\144\25\0\5\144\1\0\6\144\1\374\6\144"+
    "\1\0\1\144\2\0\3\144\6\0\4\144\1\0\1\144"+
    "\1\0\1\144\1\0\6\144\25\0\5\144\1\0\3\144"+
    "\1\375\11\144\1\0\1\144\2\0\3\144\6\0\4\144"+
    "\63\0\1\376\21\0\1\200\1\0\1\200\1\0\6\200"+
    "\25\0\5\200\1\0\15\200\1\0\1\200\2\0\3\200"+
    "\6\0\4\200\3\0\1\377\2\0\3\377\1\0\1\377"+
    "\2\u0100\2\0\1\u0100\20\0\5\377\1\0\15\377\1\0"+
    "\1\377\2\0\3\377\6\0\4\377\1\0\1\202\1\0"+
    "\1\203\1\0\1\202\3\0\1\202\73\0\1\146\2\0"+
    "\2\146\3\0\1\146\15\0\1\146\55\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\1\u0101\1\u0102"+
    "\13\36\1\0\1\36\2\0\3\36\6\0\1\36\1\u0101"+
    "\2\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\10\36\1\u0103\4\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\4\36\1\u0104\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\4\36\1\u0105\10\36"+
    "\1\0\1\36\2\0\3\36\6\0\2\36\1\u0105\1\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\14\36\1\u0106\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\2\36\1\u0107\2\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\u0108\1\0\1\u0108\1\0"+
    "\1\u0108\1\0\3\u0108\30\0\1\u0108\1\0\1\u0108\3\0"+
    "\1\u0108\40\0\1\u0109\3\0\1\u0109\73\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\3\36\1\u010a\1\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\36\1\u010b\2\36\1\u010c\1\36\1\u010d\6\36\1\0"+
    "\1\36\2\0\3\36\6\0\2\36\1\u010c\1\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\1\u010e\1\36"+
    "\1\u010f\2\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\31\0\1\u0110\53\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\1\u0111\4\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\u0112\1\0\6\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\224\1\0"+
    "\1\224\1\0\6\224\25\0\5\224\1\0\15\224\1\0"+
    "\1\224\2\0\3\224\6\0\4\224\1\0\1\224\1\0"+
    "\1\224\1\0\6\224\25\0\5\224\1\0\10\224\1\u0113"+
    "\4\224\1\0\1\224\2\0\3\224\6\0\4\224\3\226"+
    "\1\0\2\226\3\0\1\226\1\0\5\226\1\227\1\230"+
    "\1\231\1\226\1\0\13\226\5\0\1\226\15\0\1\226"+
    "\1\0\2\226\3\0\6\226\4\0\124\226\1\0\1\230"+
    "\1\231\1\226\1\232\57\226\26\0\1\204\102\0\1\204"+
    "\3\0\1\u0114\104\0\1\u0115\52\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\1\36\1\u0116\13\36"+
    "\1\0\1\36\2\0\2\36\1\u0117\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\4\36\1\u0118\10\36\1\0\1\36\2\0\3\36\6\0"+
    "\2\36\1\u0118\1\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\1\36\1\u0119\3\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\4\36\1\240\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\11\36"+
    "\1\u011a\3\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\7\36\1\u011b\5\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\6\36\1\u011c\6\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\2\36\1\u011d\3\36\25\0\5\36\1\0\2\36"+
    "\1\u011e\12\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\u011f\1\0\6\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\2\36\1\u0120\3\36"+
    "\25\0\5\36\1\0\1\36\1\u0121\2\36\1\u0122\10\36"+
    "\1\0\1\36\2\0\3\36\6\0\2\36\1\u0122\1\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\4\36\1\u0123\10\36\1\0\1\36\2\0\3\36"+
    "\6\0\2\36\1\u0123\1\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\14\36\1\u0124\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\2\36\1\u0125\2\36\1\0"+
    "\3\36\1\u0126\1\36\1\u0127\7\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\1\36\1\u0128\3\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\1\36\1\u0129\3\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\1\u012a\4\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\6\36\1\u012b\6\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\3\36\1\u012c\1\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\3\36\1\u012d\1\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\1\u012e\4\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\4\36\1\u012f\10\36\1\0\1\36\2\0\3\36\6\0"+
    "\2\36\1\u012f\1\36\1\0\1\36\1\0\1\u0130\1\0"+
    "\6\36\25\0\5\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\6\36\1\u0131\6\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\1\36\1\u0132\1\u0133\2\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\1\u0134\14\36\1\0\1\36\2\0\3\36\6\0"+
    "\1\36\1\u0134\2\36\1\0\1\36\1\0\1\u0135\1\0"+
    "\6\36\25\0\5\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\4\36\1\u0136\10\36\1\0"+
    "\1\36\2\0\3\36\6\0\2\36\1\u0136\1\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\u0137\14\36\1\0\1\36\2\0\3\36\6\0\1\36"+
    "\1\u0137\2\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\1\36\1\u0138\13\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\1\u0139\4\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\1\u013a\4\36\1\0\1\u013b"+
    "\14\36\1\0\1\36\2\0\3\36\6\0\1\36\1\u013b"+
    "\2\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\1\36\1\u013c\3\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\3\36\1\u013d\2\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\1\36\1\u013e\3\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\40\0"+
    "\1\u013f\5\0\1\u0140\32\0\1\u0140\12\0\1\u0141\76\0"+
    "\1\u0142\141\0\1\u0143\102\0\1\u0144\106\0\1\u0145\114\0"+
    "\1\u0146\72\0\1\u0147\107\0\1\u0148\35\0\1\36\1\0"+
    "\1\36\1\0\2\36\1\u0149\3\36\25\0\3\36\1\u014a"+
    "\1\u014b\1\0\2\36\1\u014c\3\36\1\u014d\1\u014e\1\u014f"+
    "\4\36\1\0\1\36\2\0\3\36\6\0\4\36\104\323"+
    "\3\111\1\0\2\111\3\0\1\111\1\0\5\111\1\331"+
    "\1\332\1\326\1\111\1\0\13\111\5\0\1\111\15\0"+
    "\1\111\1\0\2\111\3\0\6\111\4\0\20\111\1\0"+
    "\1\332\1\326\1\111\1\335\57\111\1\0\1\330\1\0"+
    "\1\330\1\0\6\330\25\0\5\330\1\0\15\330\1\0"+
    "\1\330\2\0\3\330\1\0\1\u0150\4\0\4\330\22\116"+
    "\1\0\52\116\1\0\6\116\3\120\1\0\2\120\3\0"+
    "\1\120\1\0\5\120\1\342\1\120\1\340\1\332\1\0"+
    "\13\120\5\0\1\120\15\0\1\120\1\0\2\120\3\0"+
    "\6\120\4\0\20\120\1\0\1\120\1\340\1\332\1\343"+
    "\57\120\3\127\1\0\2\127\3\0\1\127\1\0\1\130"+
    "\3\127\1\130\1\351\1\127\1\346\1\127\1\0\13\127"+
    "\5\0\1\127\15\0\1\127\1\0\2\127\3\0\6\127"+
    "\4\0\13\127\1\130\3\127\1\130\1\0\1\127\1\346"+
    "\1\127\1\352\60\127\1\350\1\127\1\350\1\127\6\350"+
    "\1\u0151\2\127\1\u0152\1\u0151\1\345\1\127\1\346\1\127"+
    "\1\347\13\127\5\350\1\127\15\350\1\127\1\350\2\127"+
    "\3\350\6\127\4\350\1\10\1\353\1\10\1\353\1\10"+
    "\6\353\1\u0153\2\10\1\u0154\1\u0153\20\10\5\353\1\10"+
    "\15\353\1\10\1\353\2\10\3\353\6\10\4\353\13\0"+
    "\1\355\3\0\1\355\77\0\1\360\3\0\1\360\65\0"+
    "\1\362\1\0\1\362\1\0\6\362\1\u0155\2\0\1\u0156"+
    "\1\u0155\20\0\5\362\1\0\15\362\1\0\1\362\2\0"+
    "\3\362\6\0\4\362\1\0\1\364\1\0\1\364\1\0"+
    "\6\364\25\0\5\364\1\0\15\364\1\0\1\364\2\0"+
    "\3\364\6\0\4\364\3\0\2\u0157\1\0\3\u0157\27\0"+
    "\5\u0157\2\0\3\u0157\1\0\5\u0157\1\0\2\u0157\1\0"+
    "\1\u0157\2\0\1\u0157\1\0\1\u0157\6\0\4\u0157\13\0"+
    "\1\u0158\3\0\1\u0159\65\0\1\373\1\0\1\373\1\0"+
    "\6\373\1\u015a\2\0\1\u015b\1\u015a\20\0\5\373\1\0"+
    "\15\373\1\0\1\373\2\0\3\373\6\0\4\373\1\0"+
    "\1\144\1\0\1\144\1\0\6\144\25\0\2\144\1\u015c"+
    "\2\144\1\0\15\144\1\0\1\144\2\0\3\144\6\0"+
    "\4\144\1\0\1\144\1\0\1\144\1\0\6\144\25\0"+
    "\3\144\1\u015d\1\144\1\0\15\144\1\0\1\144\2\0"+
    "\3\144\6\0\4\144\1\0\1\377\1\0\1\377\1\0"+
    "\6\377\25\0\5\377\1\0\15\377\1\0\1\377\2\0"+
    "\3\377\6\0\4\377\13\0\2\u0100\2\0\1\u0100\65\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\36\1\u015e\13\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\u015f\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\1\u0160\4\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\4\36\1\u0161\1\0\1\u0162\1\36\1\u0163\1\36"+
    "\1\u0164\4\36\1\u0165\3\36\1\0\1\36\2\0\3\36"+
    "\6\0\1\36\1\u0162\1\u0164\1\36\1\0\1\36\1\0"+
    "\1\u0166\1\0\6\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\1\36\1\u0167"+
    "\13\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\6\36\1\u0168\6\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\1\36\1\u0169\2\36\1\u016a\10\36\1\0"+
    "\1\36\2\0\3\36\6\0\2\36\1\u016a\1\36\1\0"+
    "\1\36\1\0\1\36\1\0\2\36\1\u016b\3\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\u016c\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\6\36\1\u016d\6\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\3\36\1\u016e\1\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\4\36\1\u016f"+
    "\10\36\1\0\1\36\2\0\3\36\6\0\2\36\1\u016f"+
    "\1\36\31\0\1\u0114\53\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\6\36\1\u0170\6\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\2\36\1\u0171\2\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\224\1\0\1\224\1\0\6\224\25\0\5\224\1\0"+
    "\1\u0172\14\224\1\0\1\224\2\0\3\224\6\0\1\224"+
    "\1\u0172\2\224\3\0\1\u0173\2\0\3\u0173\1\0\1\u0173"+
    "\1\0\1\u0114\4\0\1\u0174\16\0\5\u0173\1\0\15\u0173"+
    "\1\0\1\u0173\2\0\3\u0173\3\0\1\u0175\2\0\4\u0173"+
    "\33\0\1\u0176\51\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\3\36\1\u0177\11\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\3\36\1\u0178\11\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\1\36"+
    "\1\u0179\13\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\2\36"+
    "\1\u017a\2\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\u017b\1\0\6\36"+
    "\25\0\5\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\6\36\1\u017c\6\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\6\36\1\u017d\6\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\2\36\1\u017e\2\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\6\36\1\u017f\6\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\u0180\1\0\6\36"+
    "\25\0\5\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\1\36\1\u0181\13\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\u0182"+
    "\1\0\6\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\6\36\1\u0183\6\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\1\u0184"+
    "\14\36\1\0\1\36\2\0\3\36\6\0\1\36\1\u0184"+
    "\2\36\1\0\1\36\1\0\1\u0185\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\1\u0186\4\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\u0187\1\0\6\36"+
    "\25\0\5\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\7\36\1\u0188\5\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\4\36\1\u0189\10\36"+
    "\1\0\1\36\2\0\3\36\6\0\2\36\1\u0189\1\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\2\36"+
    "\1\u018a\2\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\2\36"+
    "\1\u018b\3\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\2\36\1\u018c\2\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\u018d\1\0\6\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\2\36"+
    "\1\u018e\12\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\1\u018f\14\36\1\0\1\36\2\0\3\36\6\0"+
    "\1\36\1\u018f\2\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\1\36\1\u0190\13\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\1\36\1\u0191"+
    "\13\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\6\36\1\u0192\6\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\1\36\1\u0193\13\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\6\36\1\u0194\6\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\1\u0195\4\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\3\36\1\u0196\2\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\1\36\1\u0197\13\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\3\36\1\u0198\1\36\1\0\15\36\1\0\1\u0199"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\u019a"+
    "\1\0\6\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\6\36\1\u019b\6\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\40\0\1\u019c"+
    "\106\0\1\u019d\127\0\1\u019e\56\0\1\u019f\102\0\1\u01a0"+
    "\113\0\1\u01a1\101\0\1\u01a2\74\0\1\u01a3\115\0\1\u01a4"+
    "\27\0\1\u01a4\42\0\1\u01a5\43\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\6\36\1\u01a6\6\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\2\36\1\u01a7\2\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\1\u01a8\14\36\1\0\1\36\2\0\3\36\6\0"+
    "\1\36\1\u01a8\2\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\1\u01a9\2\36\1\u01aa\11\36"+
    "\1\0\1\36\2\0\3\36\6\0\1\36\1\u01a9\2\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\1\u01ab\14\36\1\0\1\36\2\0\3\36\6\0"+
    "\1\36\1\u01ab\2\36\1\0\1\36\1\0\1\u01ac\1\0"+
    "\6\36\25\0\5\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\2\36\1\u01ad\2\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\13\127\1\u0151\3\127"+
    "\1\u0151\1\345\1\127\1\346\1\127\1\347\57\127\13\10"+
    "\1\u0153\3\10\1\u0153\64\10\13\0\1\u0155\3\0\1\u0155"+
    "\67\0\2\u0157\1\0\3\u0157\27\0\5\u0157\2\0\3\u0157"+
    "\1\0\5\u0157\1\0\2\u0157\1\0\1\u0157\2\0\1\u0157"+
    "\1\0\1\u0157\1\u01ae\5\0\4\u0157\13\0\1\u0158\103\0"+
    "\1\u015a\3\0\1\u015a\65\0\1\144\1\0\1\144\1\0"+
    "\6\144\25\0\5\144\1\0\4\144\1\u01af\10\144\1\0"+
    "\1\144\2\0\3\144\6\0\2\144\1\u01af\1\144\1\0"+
    "\1\144\1\0\1\144\1\0\2\144\1\u01b0\3\144\25\0"+
    "\5\144\1\0\15\144\1\0\1\144\2\0\3\144\6\0"+
    "\4\144\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\3\36\1\u01b1\1\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\u01b2\1\0"+
    "\6\36\25\0\5\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\2\36\1\u01b3\12\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\1\u01b4\4\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\11\36"+
    "\1\u01b5\3\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\10\36\1\u01b6\4\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\1\u01b7\14\36\1\0\1\36\2\0"+
    "\3\36\6\0\1\36\1\u01b7\2\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\5\36\1\u01b8"+
    "\7\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\u01b9\14\36\1\0\1\36\2\0\3\36\6\0\1\36"+
    "\1\u01b9\2\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\1\36\1\u01ba\13\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\10\36\1\u01bb\4\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\2\36\1\u01bc\2\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\u01bd\1\0\6\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\4\36\1\u01be\10\36\1\0\1\36\2\0\3\36"+
    "\6\0\2\36\1\u01be\1\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\12\36\1\u01bf\2\36"+
    "\1\0\1\36\2\0\3\36\6\0\3\36\1\u01bf\1\0"+
    "\1\224\1\0\1\224\1\0\6\224\25\0\5\224\1\0"+
    "\4\224\1\u01c0\10\224\1\0\1\224\2\0\3\224\6\0"+
    "\2\224\1\u01c0\1\224\1\0\1\u0173\1\0\1\u0173\1\0"+
    "\6\u0173\1\u01c1\3\0\1\u01c2\20\0\5\u0173\1\0\15\u0173"+
    "\1\0\1\u0173\2\0\3\u0173\6\0\4\u0173\3\0\1\u01c3"+
    "\2\0\3\u01c3\1\0\1\u01c3\25\0\5\u01c3\1\0\15\u01c3"+
    "\1\0\1\u01c3\2\0\3\u01c3\6\0\4\u01c3\3\0\1\u01c4"+
    "\2\0\3\u01c4\1\0\1\u01c4\25\0\5\u01c4\1\0\15\u01c4"+
    "\1\0\1\u01c4\2\0\3\u01c4\6\0\4\u01c4\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\1\36\1\u01c5\3\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\1\u01c6\14\36\1\0\1\36\2\0\3\36\6\0"+
    "\1\36\1\u01c6\2\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\1\36\1\u01c7\3\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\5\36\1\u01c8"+
    "\7\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\4\36\1\u01c9\10\36\1\0\1\36\2\0\3\36\6\0"+
    "\2\36\1\u01c9\1\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\2\36\1\u01ca\2\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\3\36\1\u01cb"+
    "\11\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\3\36\1\u01cc\11\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\1\36\1\u01cd\3\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\u01ce\1\0"+
    "\6\36\25\0\2\36\1\u01cf\2\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\1\36\1\u01d0"+
    "\13\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\u01d1\1\0\6\36\25\0\5\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\36\1\u01d2\13\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\11\36\1\u01d3\3\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\2\36\1\u01d4\2\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\u01d5\1\0\6\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\6\36\1\u01d6"+
    "\6\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\36\1\u01d7\13\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\1\36\1\u01d8\13\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\1\36\1\u01d9\13\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\3\36\1\u01da\1\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\u01db\14\36\1\0\1\36\2\0\3\36\6\0\1\36"+
    "\1\u01db\2\36\1\0\1\36\1\0\1\36\1\0\2\36"+
    "\1\u01dc\3\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\4\36\1\u01dd\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\u01de\1\0\6\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\2\36\1\u01df\2\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\u01e0\1\0\6\36\25\0\5\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\36\1\u01e1\13\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\2\36\1\u01e2\2\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\3\36\1\u01e3\1\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\1\u01e4\14\36"+
    "\1\0\1\36\2\0\3\36\6\0\1\36\1\u01e4\2\36"+
    "\54\0\1\u01e5\71\0\1\u01e6\44\0\1\u01e7\154\0\1\u01e8"+
    "\71\0\1\u01e9\51\0\1\u01ea\76\0\1\u01eb\10\0\1\u01e8"+
    "\51\0\1\u01ec\57\0\1\u01ed\44\0\1\u01ed\146\0\1\u01ee"+
    "\32\0\1\u01ee\3\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\2\36\1\u01ef\2\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\7\36\1\u01f0\5\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\1\36\1\u01f1\3\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\6\36\1\u01f2\6\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\3\36\1\u01f3\1\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\3\36\1\u01f4\1\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\1\36"+
    "\1\u01f5\13\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\6\36\1\u01f6\6\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\144\1\0\1\144\1\0\6\144"+
    "\25\0\5\144\1\0\4\144\1\u01f7\10\144\1\0\1\144"+
    "\2\0\3\144\6\0\2\144\1\u01f7\1\144\1\0\1\144"+
    "\1\0\1\144\1\0\6\144\25\0\5\144\1\0\1\144"+
    "\1\u01f8\13\144\1\0\1\144\2\0\3\144\6\0\4\144"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\4\36"+
    "\1\u01f9\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\2\36\1\u01fa"+
    "\3\36\25\0\5\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\1\36\1\u01fb\3\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\1\u01fc\14\36"+
    "\1\0\1\36\2\0\3\36\6\0\1\36\1\u01fc\2\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\1\u01fd\14\36\1\0\1\36\2\0\3\36\6\0"+
    "\1\36\1\u01fd\2\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\2\36\1\u01fe\12\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\3\36\1\u01ff\1\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\3\36\1\u0200\2\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\13\0\1\u01c1\71\0\1\u01c3\1\0\1\u01c3\1\0"+
    "\6\u01c3\6\0\1\u0201\16\0\5\u01c3\1\0\15\u01c3\1\0"+
    "\1\u01c3\2\0\3\u01c3\6\0\4\u01c3\1\0\1\u01c4\1\0"+
    "\1\u01c4\1\0\6\u01c4\25\0\5\u01c4\1\0\15\u01c4\1\0"+
    "\1\u01c4\2\0\3\u01c4\3\0\1\u0201\2\0\4\u01c4\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\3\36\1\u0202"+
    "\1\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\1\36\1\u0203\3\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\2\36\1\u0204\2\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\14\36\1\u0205"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\1\36\1\u0206\3\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\6\36\1\u0207\6\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\4\36\1\u0208\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\2\36\1\u0209\12\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\2\36\1\u020a\2\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\3\36\1\u020b"+
    "\1\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\7\36\1\u020c\5\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\2\36\1\u020d\3\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\6\36\1\u020e"+
    "\6\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\u020f\14\36\1\0\1\36\2\0\3\36\6\0\1\36"+
    "\1\u020f\2\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\13\36\1\u0210\1\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\2\36\1\u0211\3\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\10\36"+
    "\1\u0212\4\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\2\u0213\2\0"+
    "\1\u0213\20\0\5\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\6\36\1\u0214\6\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\2\36\1\u0215\3\36\25\0\5\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\36\1\u0216\13\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\1\36\1\u0217\13\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\2\36\1\u0218\3\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\3\0\1\u0219\10\0"+
    "\1\u01e8\51\0\1\u01ec\56\0\1\u01e9\51\0\1\u01ed\110\0"+
    "\1\u01e8\51\0\1\u01ec\70\0\1\u01e8\104\0\1\u021a\110\0"+
    "\1\u021b\71\0\1\u01e8\77\0\1\u021c\41\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\4\36\1\u021d"+
    "\10\36\1\0\1\36\2\0\3\36\6\0\2\36\1\u021d"+
    "\1\36\1\0\1\36\1\0\1\u021e\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\1\36\1\u021f"+
    "\1\36\6\0\4\36\1\0\1\36\1\0\1\u0220\1\0"+
    "\6\36\25\0\5\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\2\36\1\u0221\3\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\u0222\1\0\6\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\10\36\1\u0223"+
    "\4\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\36\1\u0224\13\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\144\1\0\1\144\1\0\6\144\25\0"+
    "\5\144\1\0\1\u0225\14\144\1\0\1\144\2\0\3\144"+
    "\6\0\1\144\1\u0225\2\144\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\4\36\1\u0226\10\36"+
    "\1\0\1\36\2\0\3\36\6\0\2\36\1\u0226\1\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\6\36\1\u0227\6\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\u0228\1\0\6\36"+
    "\25\0\5\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\1\36\1\u0229\13\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\6\36\1\u022a\6\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\3\36"+
    "\1\u022b\11\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\6\36\1\u022c\6\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\13\0\1\u01c1\3\0\1\u01c2\65\0\1\36"+
    "\1\0\1\u022d\1\0\6\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\2\36\1\u022e\3\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\2\36"+
    "\1\u022f\2\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\u0230\1\0\6\36"+
    "\25\0\5\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\1\36\1\u0231\13\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\u0232"+
    "\1\0\6\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\2\36\1\u0233\2\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\4\36\1\u0234\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\2\36\1\u0235\3\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\u0236\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\10\36\1\u0237\4\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\5\36\1\u0238\7\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\1\u0239\4\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\13\0\2\u0213"+
    "\2\0\1\u0213\30\0\1\u023a\34\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\1\36\1\u023b\13\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\u023c\1\0\6\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\42\0\1\u023d"+
    "\44\0\1\u01e8\103\0\1\u023e\161\0\1\u01e8\23\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\4\36"+
    "\1\u023f\10\36\1\0\1\36\2\0\3\36\6\0\2\36"+
    "\1\u023f\1\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\4\36\1\u0240\10\36\1\0\1\36"+
    "\2\0\3\36\6\0\2\36\1\u0240\1\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\1\36\1\u0241\1\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\1\36\1\u0242\1\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\1\36\1\u0243\13\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\1\36\1\u0244\1\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\1\u0245\4\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\15\36\1\0\1\36\2\0\1\36\1\u0246\1\36\6\0"+
    "\4\36\1\0\1\144\1\0\1\144\1\0\6\144\25\0"+
    "\1\u0247\4\144\1\0\15\144\1\0\1\144\2\0\3\144"+
    "\6\0\4\144\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\2\36\1\u0248\2\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\2\36\1\u0249\2\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\2\36\1\u024a\3\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\u024b\1\0\6\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\u024c\1\0\6\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\u024d\1\0\6\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\1\36\1\u024e\1\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\1\36\1\u024f\13\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\2\36\1\u0250\3\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\1\36\1\u0251\1\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\2\36\1\u0252\3\36"+
    "\25\0\5\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\1\u0253\4\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\u0254\1\0"+
    "\6\36\25\0\5\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\3\36\1\u0255\1\36\1\0\15\36\1\0"+
    "\1\36\2\0\3\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\3\36\1\u0256\1\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\41\0"+
    "\1\u0257\43\0\1\36\1\0\1\u0258\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\43\0\1\u01e8\101\0\1\u01e8\43\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\1\36\1\u0259\1\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\14\36\1\u025a\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\1\36\1\u025b\1\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\1\u025c\14\36\1\0\1\36\2\0"+
    "\3\36\6\0\1\36\1\u025c\2\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\15\36\1\0"+
    "\1\36\2\0\1\36\1\u025d\1\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\4\36\1\u025e"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\2\36\1\u025f\3\36"+
    "\25\0\5\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\144\1\0\1\144\1\0\6\144"+
    "\25\0\3\144\1\u0260\1\144\1\0\15\144\1\0\1\144"+
    "\2\0\3\144\6\0\4\144\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\1\36\1\u0261\3\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\2\36\1\u0262\3\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\10\36\1\u0263\4\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\1\u0264\4\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\u0265\1\0"+
    "\6\36\25\0\5\36\1\0\15\36\1\0\1\36\2\0"+
    "\3\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\1\u0266\4\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\u0267"+
    "\1\0\6\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\2\36\1\u0268\12\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\1\u0269\4\36\1\0"+
    "\15\36\1\0\1\36\2\0\3\36\6\0\4\36\1\0"+
    "\1\36\1\0\1\36\1\0\6\36\25\0\5\36\1\0"+
    "\1\36\1\u026a\13\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\40\0\1\u026b\44\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\4\36\1\u026c\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\1\36\1\u026d\1\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\2\36\1\u026e\2\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\1\u026f"+
    "\4\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\1\36\1\u0270"+
    "\1\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\1\u0271\4\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\u0272"+
    "\1\0\6\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\10\36\1\u0273\4\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\3\36\1\u0274\1\36"+
    "\1\0\15\36\1\0\1\36\2\0\3\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\3\36"+
    "\1\u0275\1\36\1\0\15\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\2\36\1\u0276\12\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\5\36\1\0\4\36\1\u0277\10\36"+
    "\1\0\1\36\2\0\3\36\6\0\2\36\1\u0277\1\36"+
    "\55\0\1\u0278\27\0\1\36\1\0\1\36\1\0\2\36"+
    "\1\u0279\3\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\3\36\1\u027a\1\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\1\36\1\u027b\1\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\7\36\1\u027c\5\36\1\0\1\36\2\0\3\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\2\36"+
    "\1\u027d\3\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\2\36\1\u027e\3\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\u027f\1\0\6\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36\1\0\1\36"+
    "\1\0\1\36\1\0\6\36\25\0\5\36\1\0\15\36"+
    "\1\0\1\36\2\0\1\36\1\u0280\1\36\6\0\4\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\14\36\1\u0281\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\u0282\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\u0283\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\3\36\6\0"+
    "\4\36\1\0\1\36\1\0\1\36\1\0\6\36\25\0"+
    "\5\36\1\0\15\36\1\0\1\36\2\0\1\36\1\u0284"+
    "\1\36\6\0\4\36\1\0\1\36\1\0\1\36\1\0"+
    "\6\36\25\0\5\36\1\0\15\36\1\0\1\36\2\0"+
    "\1\36\1\u0285\1\36\6\0\4\36\1\0\1\36\1\0"+
    "\1\36\1\0\6\36\25\0\5\36\1\0\1\u0286\14\36"+
    "\1\0\1\36\2\0\3\36\6\0\1\36\1\u0286\2\36"+
    "\1\0\1\36\1\0\1\36\1\0\6\36\25\0\5\36"+
    "\1\0\15\36\1\0\1\36\2\0\1\36\1\u0287\1\36"+
    "\6\0\4\36\1\0\1\36\1\0\1\36\1\0\6\36"+
    "\25\0\5\36\1\0\6\36\1\u0288\6\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\u0289"+
    "\1\0\6\36\25\0\5\36\1\0\15\36\1\0\1\36"+
    "\2\0\3\36\6\0\4\36\1\0\1\36\1\0\1\36"+
    "\1\0\6\36\25\0\1\36\1\u028a\3\36\1\0\15\36"+
    "\1\0\1\36\2\0\3\36\6\0\4\36";

  private static int [] zzUnpackTrans() {
    int [] result = new int[34612];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


	/* error codes */
	private static final int ZZ_UNKNOWN_ERROR = 0;
	private static final int ZZ_NO_MATCH = 1;
	private static final int ZZ_PUSHBACK_2BIG = 2;

	/* error messages for the codes above */
	private static final String ZZ_ERROR_MSG[] = {
		"Unknown internal scanner error",		//$NON-NLS-1$
		"Error: could not match input",			//$NON-NLS-1$
		"Error: pushback value was too large"	//$NON-NLS-1$
	};

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\10\5\0\2\1\14\0\1\11\12\1\2\11\2\1"+
    "\2\11\42\1\1\11\2\1\1\11\10\1\1\11\10\1"+
    "\1\11\1\1\1\11\1\1\1\0\1\1\1\11\3\1"+
    "\1\11\1\1\1\11\2\1\1\11\2\1\1\11\4\1"+
    "\1\11\1\1\1\11\2\1\1\11\1\1\1\0\10\1"+
    "\1\11\6\1\1\11\2\0\3\1\1\0\4\1\2\0"+
    "\1\11\2\0\4\1\1\11\14\1\1\11\31\1\1\11"+
    "\1\1\12\0\1\1\5\0\2\1\3\11\1\1\4\0"+
    "\2\1\1\11\3\0\4\1\1\0\1\11\2\0\1\11"+
    "\2\0\1\11\1\1\1\11\1\0\1\11\1\1\1\11"+
    "\1\1\1\0\2\1\1\11\21\1\1\0\3\1\1\0"+
    "\52\1\12\0\7\1\2\11\1\1\1\11\1\1\1\11"+
    "\2\0\1\11\1\1\1\11\1\0\27\1\3\0\1\11"+
    "\45\1\12\0\10\1\1\11\22\1\1\11\1\1\2\0"+
    "\40\1\7\0\1\11\2\0\22\1\1\0\21\1\1\0"+
    "\5\1\4\0\35\1\1\0\2\1\2\0\30\1\1\0"+
    "\23\1\1\0\14\1\1\11\22\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[650];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

	/** the input device */
	private java.io.Reader zzReader;

	/** the current state of the DFA */
	private int zzState;

	/** the current lexical state */
	private int zzLexicalState = YYINITIAL;

	/** this buffer contains the current text to be matched and is
		the source of the yytext() string */
	private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

	/** the textposition at the last accepting state */
	private int zzMarkedPos;

	/** the current text position in the buffer */
	private int zzCurrentPos;

	/** startRead marks the beginning of the yytext() string in the buffer */
	private int zzStartRead;

	/** endRead marks the last character in the buffer, that has been read
		from input */
	private int zzEndRead;

	/** number of newlines encountered up to the start of the matched text */
	private int yyline;

	/** the number of characters up to the start of the matched text */
	private int yychar;

	/**
	 * the number of characters from the last newline up to the start of the
	 * matched text
	 */
	private int yycolumn;

	/**
	 * zzAtBOL == true <=> the scanner is currently at the beginning of a line
	 */
	private boolean zzAtBOL = true;

	/** zzAtEOF == true <=> the scanner is at the EOF */
	private boolean zzAtEOF;

	/** denotes if the user-EOF-code has already been executed */
	private boolean zzEOFDone;

	/**
	 * The number of occupied positions in zzBuffer beyond zzEndRead.
	 * When a lead/high surrogate has been read from the input stream
	 * into the final zzBuffer position, this will have a value of 1;
	 * otherwise, it will have a value of 0.
	 */
	private int zzFinalHighSurrogate = 0;

  /* user code: */
	public PHPLexer(int state) {
		initialize(state);
	}

	// NB: this method resets the lexer only partially
	@Override
	protected void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzFinalHighSurrogate = 0;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		initialize(parameters[6]);
	}

	@Override
	public int getInScriptingState() {
		return ST_PHP_IN_SCRIPTING;
	}

	private static final int[] heredocStates = new int[] { ST_PHP_HEREDOC, ST_PHP_NOWDOC, ST_PHP_START_HEREDOC, ST_PHP_START_NOWDOC, ST_PHP_END_HEREDOC, ST_PHP_END_NOWDOC };

	@Override
	public int[] getHeredocStates() {
		return heredocStates;
	}

	private static final int[] phpQuotesStates = new int[] { ST_PHP_DOUBLE_QUOTES, ST_PHP_SINGLE_QUOTE, ST_PHP_BACKQUOTE, ST_PHP_HEREDOC, ST_PHP_NOWDOC, ST_PHP_START_HEREDOC, ST_PHP_START_NOWDOC, ST_PHP_END_HEREDOC, ST_PHP_END_NOWDOC };

	@Override
	public int[] getPHPQuotesStates() {
		return phpQuotesStates;
	}

	@Override
	public int[] getParameters() {
		return new int[]{zzMarkedPos, _zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
	}

	@Override
	protected int getZZLexicalState() {
		return zzLexicalState;
	}

	@Override
	protected int getZZMarkedPos() {
		return zzMarkedPos;
	}

	@Override
	protected int getZZEndRead() {
		return zzEndRead;
	}

	@Override
	public char[] getZZBuffer() {
		return zzBuffer;
	}

	@Override
	protected int getZZStartRead() {
		return this.zzStartRead;
	}

	@Override
	protected int getZZPushBackPosition() {
		return this._zzPushbackPos;
	}

	@Override
	protected void pushBack(int i) {
		yypushback(i);
	}

	@Override
	public int getScriptingState() {
		return ST_PHP_IN_SCRIPTING;
	}

	// A pool of states. To avoid creation of a new state on each createMemento.
	private static final Map<LexerState, LexerState> lexerStates = new HashMap<>();

	@Override
	protected Map<LexerState, LexerState> getLexerStates() {
		return lexerStates;
	}

	// End user code


	/** the textposition at the last state to be included in yytext */
	private int _zzPushbackPos;

	/* The following fields are added in order to support the change in zzRefill */
	private String oldString = null;
	private boolean useOldString = false;
	private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PHPLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 238) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>false</code>, iff there was new input.
	 *
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
	private boolean zzRefill() throws java.io.IOException {

		if (useOldString) {
			String saveOldString = oldString;
			oldString = new String(zzBuffer, startPos, zzMarkedPos - startPos);
			if (saveOldString != null) {
				oldString = saveOldString + oldString;
			}
		}

		/* first: make room (if you can) */
		if (zzStartRead > 0) {
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
			System.arraycopy(zzBuffer, zzStartRead,
							zzBuffer, 0,
							zzEndRead-zzStartRead);

			/* translate stored positions */
			zzEndRead-= zzStartRead;
			zzCurrentPos-= zzStartRead;
			zzMarkedPos-= zzStartRead;
			_zzPushbackPos-= zzStartRead;
			startPos = 0;
			zzStartRead = 0;
		}

		/* is the buffer big enough? */
		if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
			/* if not: blow it up */
			char newBuffer[] = new char[zzBuffer.length*2];
			System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
			zzBuffer = newBuffer;
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
		}

		/* fill the buffer with new input */
		int requested = zzBuffer.length - zzEndRead;
		int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

		/* not supposed to occur according to specification of java.io.Reader */
		if (numRead == 0) {
			throw new java.io.IOException("Reader returned 0 characters.");
		}
		if (numRead > 0) {
			zzEndRead += numRead;
			/* If numRead == requested, we might have requested to few chars to
			   encode a full Unicode character. We assume that a Reader would
			   otherwise never return half characters. */
			if (numRead == requested) {
				if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
					--zzEndRead;
					zzFinalHighSurrogate = 1;
				}
			}
			/* potentially more input available */
			return false;
		}

		/* numRead < 0 ==> end of stream */
		return true;
	}


	/**
	 * Gets the next input character.
	 *
	 * @return      the next character of the input stream, EOF if the
	 *              end of the stream is reached.
	 * @exception   IOException  if any I/O-Error occurs
	 */
	private int yy_advance() throws java.io.IOException {

		/* standard case */
		if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

		/* if the eof is reached, we don't need to work hard */
		if (zzAtEOF) return YYEOF;

		/* otherwise: need to refill the buffer */

		String saveOldString = oldString;
		oldString = null;

		/* first: make room (if you can) */
		if (zzRefill()) {
			oldString = saveOldString;
			return YYEOF;
		}

		oldString = saveOldString;

		return zzBuffer[zzCurrentPos++];
	}


	/**
	 * Closes the input stream.
	 */
	public final void yyclose() throws java.io.IOException {
		zzAtEOF = true;            /* indicate end of file */
		zzEndRead = zzStartRead;  /* invalidate buffer    */

		if (zzReader != null)
			zzReader.close();
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>ZZ_INITIAL</tt>.
	 *
	 * Internal scan buffer is resized down to its initial length, if it has grown.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		zzReader = reader;
		zzAtBOL  = true;
		zzAtEOF  = false;
		zzEOFDone = false;
		zzEndRead = zzStartRead = 0;
		zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
		zzFinalHighSurrogate = 0;
		oldString = null;
		yyline = yychar = yycolumn = 0;
		zzLexicalState = YYINITIAL;
		if (zzBuffer.length > ZZ_BUFFERSIZE)
			zzBuffer = new char[ZZ_BUFFERSIZE];
	}


	/**
	 * Returns the current lexical state.
	 */
	public final int yystate() {
		return zzLexicalState;
	}


	/**
	 * Enters a new lexical state
	 *
	 * @param newState the new lexical state
	 */
	public final void yybegin(int newState) {
		zzLexicalState = newState;
	}


	/**
	 * Returns the text matched by the current regular expression.
	 */
	public final String yytext() {
		return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
	}


	/**
	 * Returns the character at position <tt>pos</tt> from the
	 * matched text.
	 *
	 * It is equivalent to yytext().charAt(pos), but faster
	 *
	 * @param pos the position of the character to fetch.
	 *            A value from 0 to yylength()-1.
	 *
	 * @return the character at position pos
	 */
	public final char yycharat(int pos) {
		return zzBuffer[zzStartRead+pos];
	}


	/**
	 * Returns the length of the matched text region.
	 */
	public final int yylength() {
		return zzMarkedPos-zzStartRead;
	}


	/**
	 * Reports an error that occured while scanning.
	 *
	 * In a wellformed scanner (no or only correct usage of
	 * yypushback(int) and a match-all fallback rule) this method
	 * will only be called with things that "Can't Possibly Happen".
	 * If this method is called, something is seriously wrong
	 * (e.g. a JFlex bug producing a faulty scanner etc.).
	 *
	 * Usual syntax/scanner level error handling should be done
	 * in error fallback rules.
	 *
	 * @param   errorCode  the code of the errormessage to display
	 */
  private void zzScanError(int errorCode) {
		String message;
		try {
			message = ZZ_ERROR_MSG[errorCode];
		}
		catch (ArrayIndexOutOfBoundsException e) {
			message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
		}

    throw new Error(message);
	}


	/**
	 * Pushes the specified amount of characters back into the input stream.
	 *
	 * They will be read again by then next call of the scanning method
	 *
	 * @param number  the number of characters to be read again.
	 *                This number must not be greater than yylength()!
	 */
  public void yypushback(int number)  {
		if ( number > yylength() )
			zzScanError(ZZ_PUSHBACK_2BIG);

		zzMarkedPos -= number;
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		updateStartPos(zzMarkedPos);
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos(int position) {
		startPos = position;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


	/**
	 * Resumes scanning until the next regular expression is matched,
	 * the end of input is encountered or an I/O-Error occurs.
	 *
	 * @return      the next token
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
  public String yylex() throws java.io.IOException {
	int zzInput;
	int zzAction;

	// cached fields:
	int zzCurrentPosL;
	int zzMarkedPosL;
	int zzEndReadL = zzEndRead;
	char [] zzBufferL = zzBuffer;
	char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

	while (true) {
		zzMarkedPosL = zzMarkedPos;

		zzAction = -1;

		zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


		zzForAction: {
			while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
				zzAction = zzState;
				zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
				}

			}
		}

			// store back cached position
			zzMarkedPos = zzMarkedPosL;

			if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
				zzAtEOF = true;
        return null;
			}
			else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 149: break;
          case 2: 
            { return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 150: break;
          case 3: 
            { yypushback(1);
	pushState(ST_PHP_HIGHLIGHTING_ERROR);
            }
          case 151: break;
          case 4: 
            { return PHP_NUMBER;
            }
          case 152: break;
          case 5: 
            { return PHP_TOKEN;
            }
          case 153: break;
          case 6: 
            { return PHP_LABEL;
            }
          case 154: break;
          case 7: 
            { return WHITESPACE;
            }
          case 155: break;
          case 8: 
            { return PHP_SEMICOLON;
            }
          case 156: break;
          case 9: 
            { pushState(ST_PHP_DOUBLE_QUOTES);
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 157: break;
          case 10: 
            { return PHP_NS_SEPARATOR;
            }
          case 158: break;
          case 11: 
            { pushState(ST_PHP_BACKQUOTE);
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 159: break;
          case 12: 
            { // Whitespaces are directly appended to the curly before pushState()
	// is effective or whitespaces would be stored in a separate ContextRegion.
	// Method PhpTokenContainer#addLast() will correct the curlies length...
	if (!phpStack.isEmpty()) {
		// Only push the state when stack is not empty, it's useless otherwise
		// (and it pollutes the stack).
		pushState(ST_PHP_IN_SCRIPTING);
	}
	return PHP_CURLY_OPEN;
            }
          case 160: break;
          case 13: 
            { // Whitespaces are directly appended to the curly before pushState()
	// is effective or whitespaces would be stored in a separate ContextRegion.
	// Method PhpTokenContainer#addLast() will correct the curlies length...
	if (!phpStack.isEmpty()) {
		popState();
		// If new state is not ST_PHP_IN_SCRIPTING then some blanks are signifiant (like newlines
		// after the closing curly and before an ending heredoc tag), so don't append them...
		// See rule <ST_PHP_HEREDOC>{HEREDOC_CHARS}*({HEREDOC_NEWLINE}+({LABEL}";"?)?)?
		if (getZZLexicalState() != ST_PHP_IN_SCRIPTING) {
			yypushback(yylength() - 1);
		}
	}
	return PHP_CURLY_CLOSE;
            }
          case 161: break;
          case 14: 
            { pushState(ST_PHP_SINGLE_QUOTE);
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 162: break;
          case 15: 
            { pushState(ST_PHP_LINE_COMMENT);
	return PHP_LINE_COMMENT;
            }
          case 163: break;
          case 16: 
            { popState();
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 164: break;
          case 17: 
            { yypushback(1);
		popState();
            }
          case 165: break;
          case 18: 
            { yypushback(1);
	yybegin(ST_PHP_HEREDOC);
            }
          case 166: break;
          case 19: 
            { yypushback(1);
	yybegin(ST_PHP_NOWDOC);
            }
          case 167: break;
          case 20: 
            { yypushback(1);
	popState();
            }
          case 168: break;
          case 21: 
            { popState();
	return PHP_LABEL;
            }
          case 169: break;
          case 22: 
            { //the difference from the original rules comes from the fact that we took ';' out of tokens
	return UNKNOWN_TOKEN;
            }
          case 170: break;
          case 23: 
            { yypushback(1);
	popState();
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 171: break;
          case 24: 
            { popState();
	return PHP_TOKEN;
            }
          case 172: break;
          case 25: 
            { return PHP_COMMENT;
            }
          case 173: break;
          case 26: 
            { return PHPDOC_COMMENT;
            }
          case 174: break;
          case 27: 
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			if (yylength() > 0) {
				return PHP_LINE_COMMENT;
			}
			break;
		default:
			popState();
			return PHP_LINE_COMMENT;
	}
            }
          case 175: break;
          case 28: 
            { return PHP_LINE_COMMENT;
            }
          case 176: break;
          case 29: 
            { return UNKNOWN_TOKEN;
            }
          case 177: break;
          case 30: 
            { popState();return WHITESPACE;
            }
          case 178: break;
          case 31: 
            { yybegin(ST_PHP_IN_SCRIPTING);
	return PHP_ENCAPSED_VARIABLE;
            }
          case 179: break;
          case 32: 
            { yybegin(ST_PHP_IN_SCRIPTING);
	return PHP_CURLY_OPEN;
            }
          case 180: break;
          case 33: 
            { return PHP_OPERATOR;
            }
          case 181: break;
          case 34: 
            { pushState(ST_PHP_LOOKING_FOR_PROPERTY);
	return PHP_OBJECT_OPERATOR;
            }
          case 182: break;
          case 35: 
            { return PHP_VARIABLE;
            }
          case 183: break;
          case 36: 
            { pushState(ST_PHP_COMMENT);
	return PHP_COMMENT_START;
            }
          case 184: break;
          case 37: 
            { if (asp_tags) {
		return PHP_CLOSETAG;
	}
	return UNKNOWN_TOKEN;
            }
          case 185: break;
          case 38: 
            { return PHP_AS;
            }
          case 186: break;
          case 39: 
            { return PHP_DO;
            }
          case 187: break;
          case 40: 
            { return PHP_CLOSETAG;
            }
          case 188: break;
          case 41: 
            { return PHP_IF;
            }
          case 189: break;
          case 42: 
            { pushState(ST_PHP_IDENTIFIER);
	return PHP_PAAMAYIM_NEKUDOTAYIM;
            }
          case 190: break;
          case 43: 
            { pushState(ST_PHP_QUOTES_AFTER_VARIABLE);
	return PHP_VARIABLE;
            }
          case 191: break;
          case 44: 
            { yypushback(1);
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 192: break;
          case 45: 
            { // We can have nested curlies after applying this rule,
	// so we have to count all curlies...
	yypushback(1);
	pushState(ST_PHP_DOLLAR_CURLY_OPEN);
	return PHP_TOKEN;
            }
          case 193: break;
          case 46: 
            { // We can have nested curlies after applying rule below for "${",
	// so we have to count all curlies...
	yypushback(1);
	pushState(ST_PHP_IN_SCRIPTING);
	return PHP_CURLY_OPEN;
            }
          case 194: break;
          case 47: 
            { popState();
	pushState(ST_PHP_LOOKING_FOR_PROPERTY);
	return PHP_OBJECT_OPERATOR;
            }
          case 195: break;
          case 48: 
            { String yytext = yytext();
	int label_len = yylength() - 1;

	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}

	String heredoc = getHeredocId();
	int heredoc_len = heredoc.length();
	if (label_len == heredoc_len && yytext.substring(0, label_len).equals(heredoc)) {
		// we must (at least) push the newline character back
		yypushback(1);
		popHeredocId();
		popState();
		return PHP_HEREDOC_CLOSE_TAG;
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
		return PHP_ENCAPSED_AND_WHITESPACE;
	}
            }
          case 196: break;
          case 49: 
            { String yytext = yytext();
	int label_len = yylength() - 1;

	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}

	String nowdoc = getHeredocId();
	int nowdoc_len = nowdoc.length();
	if (label_len == nowdoc_len && yytext.substring(0, label_len).equals(nowdoc)) {
		// we must (at least) push the newline character back
		yypushback(1);
		popHeredocId();
		popState();
		return PHP_NOWDOC_CLOSE_TAG;
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
		return PHP_CONSTANT_ENCAPSED_STRING;
	}
            }
          case 197: break;
          case 50: 
            { return PHP_OBJECT_OPERATOR;
            }
          case 198: break;
          case 51: 
            { popState();
	return PHP_COMMENT_END;
            }
          case 199: break;
          case 52: 
            { popState();
	return PHPDOC_COMMENT_END;
            }
          case 200: break;
          case 53: 
            { TagKind tagkind = TagKind.getTagKindFromValue(yytext());
		if (tagkind != null && tagkind != TagKind.UNKNOWN
			&& /* ignore @todo tag */ tagkind != TagKind.TODO) {
				return PHPDOC_GENERIC_TAG;
		}
		return PHPDOC_COMMENT;
            }
          case 201: break;
          case 54: 
            { popState();
	return PHP_LINE_COMMENT;
            }
          case 202: break;
          case 55: 
            { if (asp_tags) {
		return PHP_CLOSETAG;
	}
	return PHP_LINE_COMMENT;
            }
          case 203: break;
          case 56: 
            { return PHP_PAAMAYIM_NEKUDOTAYIM;
            }
          case 204: break;
          case 57: 
            { yypushback(yylength() - 1);
	return PHP_CURLY_OPEN;
            }
          case 205: break;
          case 58: 
            { pushState(ST_PHP_DOC_COMMENT);
	return PHPDOC_COMMENT_START;
            }
          case 206: break;
          case 59: 
            { return PHP_NEW;
            }
          case 207: break;
          case 60: 
            { return PHP_DIE;
            }
          case 208: break;
          case 61: 
            { return PHP_INT;
            }
          case 209: break;
          case 62: 
            { return PHP_TRY;
            }
          case 210: break;
          case 63: 
            { return PHP_FOR;
            }
          case 211: break;
          case 64: 
            { return PHP_USE;
            }
          case 212: break;
          case 65: 
            { return PHP_VAR;
            }
          case 213: break;
          case 66: 
            { yypushback(1);
	pushState(ST_PHP_VAR_OFFSET);
	return PHP_VARIABLE;
            }
          case 214: break;
          case 67: 
            { String yytext = yytext();
	int label_len = yylength() - 1;

	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}
	String heredoc = getHeredocId();
	int heredoc_len = heredoc.length();
	int startIndex = label_len - heredoc_len;
	if (startIndex > 0 && yytext.substring(startIndex, label_len).equals(heredoc)
		&& (yytext.charAt(startIndex - 1) == '\n' || yytext.charAt(startIndex - 1) == '\r')) {

		if (startIndex - 2 >= 0
			&& yytext.charAt(startIndex - 2) == '\r'
			&& yytext.charAt(startIndex - 1) == '\n') {
			startIndex-= 2;
		} else {
			startIndex--;
		}
		yypushback(yylength() - startIndex);

		yybegin(ST_PHP_END_HEREDOC);
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
	}
	// In some cases, all text is pushed back (using yypushback()),
	// especially when the parsed document has Windows newlines.
	// In those cases, ignore this rule and try next one...
	if (yylength() > 0) {
		return PHP_ENCAPSED_AND_WHITESPACE;
	}
            }
          case 215: break;
          case 68: 
            { String yytext = yytext();
	int label_len = yylength() - 1;

	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}
	String nowdoc = getHeredocId();
	int nowdoc_len = nowdoc.length();
	int startIndex = label_len - nowdoc_len;
	if (startIndex > 0 && yytext.substring(startIndex, label_len).equals(nowdoc)
		&& (yytext.charAt(startIndex - 1) == '\n' || yytext.charAt(startIndex - 1) == '\r')) {

		if (startIndex - 2 >= 0
			&& yytext.charAt(startIndex - 2) == '\r'
			&& yytext.charAt(startIndex - 1) == '\n') {
			startIndex-= 2;
		} else {
			startIndex--;
		}
		yypushback(yylength() - startIndex);

		yybegin(ST_PHP_END_NOWDOC);
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
	}
	// In some cases, all text is pushed back (using yypushback()),
	// especially when the parsed document has Windows newlines.
	// In those cases, ignore this rule and try next one...
	if (yylength() > 0) {
		return PHP_CONSTANT_ENCAPSED_STRING;
	}
            }
          case 216: break;
          case 69: 
            { // we must (at least) push the newline character back
	yypushback(1);
	popHeredocId();
	popState();
	return PHP_HEREDOC_CLOSE_TAG;
            }
          case 217: break;
          case 70: 
            { yypushback(yylength() - 2);
	if (asp_tags) {
		return PHP_CLOSETAG;
	}
	popState();
	return PHP_LINE_COMMENT;
            }
          case 218: break;
          case 71: 
            { // we must (at least) push the newline character back
	yypushback(1);
	popHeredocId();
	popState();
	return PHP_NOWDOC_CLOSE_TAG;
            }
          case 219: break;
          case 72: 
            { return PHP_EXIT;
            }
          case 220: break;
          case 73: 
            { return PHP_ECHO;
            }
          case 221: break;
          case 74: 
            { return PHP_ELSE;
            }
          case 222: break;
          case 75: 
            { return PHP_EVAL;
            }
          case 223: break;
          case 76: 
            { return PHP_CASE;
            }
          case 224: break;
          case 77: 
            { return PHP_BOOL;
            }
          case 225: break;
          case 78: 
            { yypushback(2);
	pushState(ST_PHP_COMMENT);
	return PHP_COMMENT_START;
            }
          case 226: break;
          case 79: 
            { return PHP_KEYWORD;
            }
          case 227: break;
          case 80: 
            { return PHP_TRUE;
            }
          case 228: break;
          case 81: 
            { return PHP_FROM;
            }
          case 229: break;
          case 82: 
            { return PHP_SELF;
            }
          case 230: break;
          case 83: 
            { return PHP_LIST;
            }
          case 231: break;
          case 84: 
            { return PHP_GOTO;
            }
          case 232: break;
          case 85: 
            { TagKind tagkind = TagKind.getTagKindFromValue(yytext());
		if (tagkind != null && tagkind != TagKind.UNKNOWN) {
			return PHPDOC_GENERIC_TAG;
		}
		return PHPDOC_COMMENT;
            }
          case 233: break;
          case 86: 
            { return PHP_ENDIF;
            }
          case 234: break;
          case 87: 
            { return PHP_EMPTY;
            }
          case 235: break;
          case 88: 
            { pushState(ST_PHP_IDENTIFIER);
	return PHP_CONST;
            }
          case 236: break;
          case 89: 
            { return PHP_CATCH;
            }
          case 237: break;
          case 90: 
            { return PHP_CLONE;
            }
          case 238: break;
          case 91: 
            { return PHP_CLASS;
            }
          case 239: break;
          case 92: 
            { return PHP_BREAK;
            }
          case 240: break;
          case 93: 
            { return PHP_THIS;
            }
          case 241: break;
          case 94: 
            { String yytext = yytext();
	int bprefix = (yytext.charAt(0) != '<') ? 1 : 0;
	int startString = 3 + bprefix;

	int hereOrNowDoc_len = yylength() - bprefix - 3 - 1 - (yytext.charAt(yylength() - 2) == '\r' ? 1 : 0);
	while ((yytext.charAt(startString) == ' ') || (yytext.charAt(startString) == '\t')) {
		startString++;
		hereOrNowDoc_len--;
	}
	String hereOrNowDoc = yytext.substring(startString, hereOrNowDoc_len + startString);
	if (hereOrNowDoc.charAt(0) == '\'') {
		pushHeredocId(hereOrNowDoc.substring(1, hereOrNowDoc_len - 1));
		pushState(ST_PHP_START_NOWDOC);
		return PHP_NOWDOC_START_TAG;
	} else if (hereOrNowDoc.charAt(0) == '"') {
		pushHeredocId(hereOrNowDoc.substring(1, hereOrNowDoc_len - 1));
		pushState(ST_PHP_START_HEREDOC);
		return PHP_HEREDOC_START_TAG;
	} else {
		pushHeredocId(hereOrNowDoc);
		pushState(ST_PHP_START_HEREDOC);
		return PHP_HEREDOC_START_TAG;
	}
            }
          case 242: break;
          case 95: 
            { return PHP_ARRAY;
            }
          case 243: break;
          case 96: 
            { return PHP_ISSET;
            }
          case 244: break;
          case 97: 
            { return PHP_TRAIT;
            }
          case 245: break;
          case 98: 
            { return PHP_THROW;
            }
          case 246: break;
          case 99: 
            { return PHP_FALSE;
            }
          case 247: break;
          case 100: 
            { return PHP_FINAL;
            }
          case 248: break;
          case 101: 
            { return PHP_FLOAT;
            }
          case 249: break;
          case 102: 
            { return PHP_UNSET;
            }
          case 250: break;
          case 103: 
            { return PHP_YIELD;
            }
          case 251: break;
          case 104: 
            { return PHP_WHILE;
            }
          case 252: break;
          case 105: 
            { return PHP_PRINT;
            }
          case 253: break;
          case 106: 
            { return PHP_CASTING;
            }
          case 254: break;
          case 107: 
            { return PHP_ENDFOR;
            }
          case 255: break;
          case 108: 
            { return PHP_ELSEIF;
            }
          case 256: break;
          case 109: 
            { return PHP_RETURN;
            }
          case 257: break;
          case 110: 
            { return PHP_STRING;
            }
          case 258: break;
          case 111: 
            { return PHP_STATIC;
            }
          case 259: break;
          case 112: 
            { return PHP_SWITCH;
            }
          case 260: break;
          case 113: 
            { return PHP_GLOBAL;
            }
          case 261: break;
          case 114: 
            { return PHP_PARENT;
            }
          case 262: break;
          case 115: 
            { return PHP_PUBLIC;
            }
          case 263: break;
          case 116: 
            { return PHP_EXTENDS;
            }
          case 264: break;
          case 117: 
            { return PHP_REQUIRE;
            }
          case 265: break;
          case 118: 
            { return PHP_DECLARE;
            }
          case 266: break;
          case 119: 
            { return PHP_DEFAULT;
            }
          case 267: break;
          case 120: 
            { return PHP_INCLUDE;
            }
          case 268: break;
          case 121: 
            { return PHP_FOREACH;
            }
          case 269: break;
          case 122: 
            { return PHP_FINALLY;
            }
          case 270: break;
          case 123: 
            { return PHP_PRIVATE;
            }
          case 271: break;
          case 124: 
            { return PHP__DIR__;
            }
          case 272: break;
          case 125: 
            { return PHP_ENDWHILE;
            }
          case 273: break;
          case 126: 
            { return PHP_CONTINUE;
            }
          case 274: break;
          case 127: 
            { return PHP_CALLABLE;
            }
          case 275: break;
          case 128: 
            { return PHP_ABSTRACT;
            }
          case 276: break;
          case 129: 
            { pushState(ST_PHP_IDENTIFIER);
	return PHP_FUNCTION;
            }
          case 277: break;
          case 130: 
            { return PHP__FILE__;
            }
          case 278: break;
          case 131: 
            { return PHP__LINE__;
            }
          case 279: break;
          case 132: 
            { return PHP_FUNCTION;
            }
          case 280: break;
          case 133: 
            { return PHP_ENDSWITCH;
            }
          case 281: break;
          case 134: 
            { return PHP_NAMESPACE;
            }
          case 282: break;
          case 135: 
            { return PHP_INTERFACE;
            }
          case 283: break;
          case 136: 
            { return PHP_INSTEADOF;
            }
          case 284: break;
          case 137: 
            { return PHP_PROTECTED;
            }
          case 285: break;
          case 138: 
            { return PHP__CLASS__;
            }
          case 286: break;
          case 139: 
            { return PHP_ENDDECLARE;
            }
          case 287: break;
          case 140: 
            { return PHP_ENDFOREACH;
            }
          case 288: break;
          case 141: 
            { return PHP_INSTANCEOF;
            }
          case 289: break;
          case 142: 
            { return PHP_IMPLEMENTS;
            }
          case 290: break;
          case 143: 
            { return PHP__METHOD__;
            }
          case 291: break;
          case 144: 
            { return PHP_REQUIRE_ONCE;
            }
          case 292: break;
          case 145: 
            { return PHP_INCLUDE_ONCE;
            }
          case 293: break;
          case 146: 
            { return PHP__FUNCTION__;
            }
          case 294: break;
          case 147: 
            { return PHP__NAMESPACE__;
            }
          case 295: break;
          case 148: 
            { return PHP_HALT_COMPILER;
            }
          case 296: break;
		default:
            zzScanError(ZZ_NO_MATCH);
				}
			}
		}
	}


}
