/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ArrayCreation;
import org.eclipse.php.core.ast.nodes.ArraySpreadElement;
import org.eclipse.php.core.ast.nodes.ArrowFunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP71;
import org.eclipse.php.core.tests.dom_ast.rewrite.NodeDeletionTestsPHP74;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

public class ASTRewriteTestsPHP74
extends ASTRewriteTestsPHP71 {
    @Override
    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP7_4;
    }

    @Override
    @Test
    public void staticLambdaFunction() throws Exception {
        String str = "<?php $lambda = static function ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(false);
        this.rewrite();
        this.checkResult("<?php $lambda = function ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticLambdaFunction2() throws Exception {
        String str = "<?php $lambda = function ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(true);
        this.rewrite();
        this.checkResult("<?php $lambda = static function ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticLambdaFunction3() throws Exception {
        String str = "<?php $lambda = static function ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(true);
        this.rewrite();
        this.checkResult("<?php $lambda = static function ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticLambdaFunction4() throws Exception {
        String str = "<?php $lambda = function ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(false);
        this.rewrite();
        this.checkResult("<?php $lambda = function ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticLambdaFunction5() throws Exception {
        String str = "<?php $lambda = static function ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(true);
        lambdaFunctions.get(0).setIsReference(true);
        this.rewrite();
        this.checkResult("<?php $lambda = static function & ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticLambdaFunction5b() throws Exception {
        String str = "<?php $lambda = static function & ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(true);
        lambdaFunctions.get(0).setIsReference(true);
        this.rewrite();
        this.checkResult("<?php $lambda = static function & ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticLambdaFunction6() throws Exception {
        String str = "<?php $lambda = static function & ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(true);
        lambdaFunctions.get(0).setIsReference(false);
        this.rewrite();
        this.checkResult("<?php $lambda = static function ($param) { $k = 'value'; }; ?>");
    }

    public void staticLambdaFunction6b() throws Exception {
        String str = "<?php $lambda = static function ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(true);
        lambdaFunctions.get(0).setIsReference(false);
        this.rewrite();
        this.checkResult("<?php $lambda = static function ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticLambdaFunction7() throws Exception {
        String str = "<?php $lambda = function & ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(false);
        lambdaFunctions.get(0).setIsReference(false);
        this.rewrite();
        this.checkResult("<?php $lambda = function ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticLambdaFunction7b() throws Exception {
        String str = "<?php $lambda = function ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(false);
        lambdaFunctions.get(0).setIsReference(false);
        this.rewrite();
        this.checkResult("<?php $lambda = function ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticLambdaFunction8() throws Exception {
        String str = "<?php $lambda = function ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(false);
        lambdaFunctions.get(0).setIsReference(true);
        this.rewrite();
        this.checkResult("<?php $lambda = function & ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticLambdaFunction8b() throws Exception {
        String str = "<?php $lambda = function & ($param) { $k = 'value'; }; ?>";
        this.initialize(str);
        List<LambdaFunctionDeclaration> lambdaFunctions = this.getAllOfType(this.program, LambdaFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (lambdaFunctions.size() == 1 ? 1 : 0) != 0);
        lambdaFunctions.get(0).setStatic(false);
        lambdaFunctions.get(0).setIsReference(true);
        this.rewrite();
        this.checkResult("<?php $lambda = function & ($param) { $k = 'value'; }; ?>");
    }

    @Test
    public void staticArrowFunction() throws Exception {
        String str = "<?php $arrow = static fn ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(false);
        this.rewrite();
        this.checkResult("<?php $arrow = fn ($param) => $k = 'value'; ?>");
    }

    @Test
    public void staticArrowFunction2() throws Exception {
        String str = "<?php $arrow = fn ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(true);
        this.rewrite();
        this.checkResult("<?php $arrow = static fn ($param) => $k = 'value'; ?>");
    }

    @Test
    public void staticArrowFunction3() throws Exception {
        String str = "<?php $arrow = static fn ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(true);
        this.rewrite();
        this.checkResult("<?php $arrow = static fn ($param) => $k = 'value'; ?>");
    }

    @Test
    public void staticArrowFunction4() throws Exception {
        String str = "<?php $arrow = fn ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(false);
        this.rewrite();
        this.checkResult("<?php $arrow = fn ($param) => $k = 'value'; ?>");
    }

    @Test
    public void staticArrowFunction5() throws Exception {
        String str = "<?php $arrow = static fn ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(true);
        arrowFunctions.get(0).setIsReference(true);
        this.rewrite();
        this.checkResult("<?php $arrow = static fn & ($param) => $k = 'value'; ?>");
    }

    @Test
    public void staticArrowFunction5b() throws Exception {
        String str = "<?php $arrow = static fn & ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(true);
        arrowFunctions.get(0).setIsReference(true);
        this.rewrite();
        this.checkResult("<?php $arrow = static fn & ($param) => $k = 'value'; ?>");
    }

    @Test
    public void staticArrowFunction6() throws Exception {
        String str = "<?php $arrow = static fn & ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(true);
        arrowFunctions.get(0).setIsReference(false);
        this.rewrite();
        this.checkResult("<?php $arrow = static fn ($param) => $k = 'value'; ?>");
    }

    public void staticArrowFunction6b() throws Exception {
        String str = "<?php $arrow = static fn ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(true);
        arrowFunctions.get(0).setIsReference(false);
        this.rewrite();
        this.checkResult("<?php $arrow = static fn ($param) => $k = 'value'; ?>");
    }

    @Test
    public void staticArrowFunction7() throws Exception {
        String str = "<?php $arrow = fn & ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(false);
        arrowFunctions.get(0).setIsReference(false);
        this.rewrite();
        this.checkResult("<?php $arrow = fn ($param) => $k = 'value'; ?>");
    }

    @Test
    public void staticArrowFunction7b() throws Exception {
        String str = "<?php $arrow = fn ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(false);
        arrowFunctions.get(0).setIsReference(false);
        this.rewrite();
        this.checkResult("<?php $arrow = fn ($param) => $k = 'value'; ?>");
    }

    @Test
    public void staticArrowFunction8() throws Exception {
        String str = "<?php $arrow = fn ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(false);
        arrowFunctions.get(0).setIsReference(true);
        this.rewrite();
        this.checkResult("<?php $arrow = fn & ($param) => $k = 'value'; ?>");
    }

    @Test
    public void staticArrowFunction8b() throws Exception {
        String str = "<?php $arrow = fn & ($param) => $k = 'value'; ?>";
        this.initialize(str);
        List<ArrowFunctionDeclaration> arrowFunctions = this.getAllOfType(this.program, ArrowFunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrowFunctions.size() == 1 ? 1 : 0) != 0);
        arrowFunctions.get(0).setStatic(false);
        arrowFunctions.get(0).setIsReference(true);
        this.rewrite();
        this.checkResult("<?php $arrow = fn & ($param) => $k = 'value'; ?>");
    }

    @Test
    public void arraySpreadElement() throws Exception {
        String str = "<?php [...$arr1]; ?>";
        this.initialize(str);
        List<ArraySpreadElement> arraySpreadElements = this.getAllOfType(this.program, ArraySpreadElement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arraySpreadElements.size() == 1 ? 1 : 0) != 0);
        ((Variable)arraySpreadElements.get(0).getValue()).setName((Expression)this.ast.newIdentifier("b2"));
        this.rewrite();
        this.checkResult("<?php [...$b2]; ?>");
    }

    @Test
    public void arraySpreadElement2() throws Exception {
        String str = "<?php [...$arr1]; ?>";
        this.initialize(str);
        List<ArraySpreadElement> arraySpreadElements = this.getAllOfType(this.program, ArraySpreadElement.class);
        Assert.assertTrue((String)"Unexpected list size.", (arraySpreadElements.size() == 1 ? 1 : 0) != 0);
        ((Variable)arraySpreadElements.get(0).getValue()).setName((Expression)this.ast.newIdentifier("b2"));
        List<ArrayCreation> arrayCreations = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayCreations.size() == 1 ? 1 : 0) != 0);
        arrayCreations.get(0).elements().add(this.ast.newArrayElement(null, (Expression)this.ast.newVariable("c2")));
        arrayCreations.get(0).elements().add(this.ast.newArrayElement(null, (Expression)this.ast.newArraySpreadElement((Expression)this.ast.newVariable("d2"))));
        arrayCreations.get(0).elements().add(this.ast.newArrayElement(null, (Expression)this.ast.newVariable("e2")));
        this.rewrite();
        this.checkResult("<?php [...$b2, $c2, ...$d2, $e2]; ?>");
    }

    @Test
    public void arraySpreadElement3() throws Exception {
        String str = "<?php [...$b2, $c2, ...$d2, $e2]; ?>";
        this.initialize(str);
        List<ArrayCreation> arrayCreations = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayCreations.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected list size.", (arrayCreations.get(0).elements().size() == 4 ? 1 : 0) != 0);
        arrayCreations.get(0).elements().remove(2);
        arrayCreations.get(0).elements().remove(0);
        this.rewrite();
        this.checkResult("<?php [$c2, $e2]; ?>");
    }

    @Test
    public void fieldsDeclarations() throws Exception {
        String str = "<?php class A { private   ?int $prop1   =   5, $prop2   =   null, $prop3, $prop4   =   0; } ?>";
        this.initialize(str);
        List<FieldsDeclaration> fieldsDeclarations = this.getAllOfType(this.program, FieldsDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (fieldsDeclarations.size() == 1 ? 1 : 0) != 0);
        fieldsDeclarations.get(0).setFieldsType(null);
        Assert.assertTrue((String)"Unexpected list size.", (fieldsDeclarations.get(0).fields().size() == 4 ? 1 : 0) != 0);
        fieldsDeclarations.get(0).fields().remove(0);
        this.rewrite();
        this.checkResult("<?php class A { private $prop2   =   null, $prop3, $prop4   =   0; } ?>");
    }

    @Test
    public void fieldsDeclarations2() throws Exception {
        String str = "<?php class A { private   $prop1   =   5, $prop2   =   null, $prop3, $prop4   =   0; } ?>";
        this.initialize(str);
        List<FieldsDeclaration> fieldsDeclarations = this.getAllOfType(this.program, FieldsDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (fieldsDeclarations.size() == 1 ? 1 : 0) != 0);
        fieldsDeclarations.get(0).setFieldsType((Expression)this.ast.newIdentifier("float"));
        Assert.assertTrue((String)"Unexpected list size.", (fieldsDeclarations.get(0).fields().size() == 4 ? 1 : 0) != 0);
        fieldsDeclarations.get(0).fields().add(0, this.ast.newSingleFieldDeclaration(this.ast.newVariable("prop0"), (Expression)this.ast.newScalar("10", 0)));
        this.rewrite();
        this.checkResult("<?php class A { private float   $prop0 = 10, $prop1   =   5, $prop2   =   null, $prop3, $prop4   =   0; } ?>");
    }

    @Test
    public void fieldsDeclarations3() throws Exception {
        String str = "<?php class A { private   $prop1   =   5, $prop2   =   null, $prop3, $prop4   =   0; } ?>";
        this.initialize(str);
        List<FieldsDeclaration> fieldsDeclarations = this.getAllOfType(this.program, FieldsDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (fieldsDeclarations.size() == 1 ? 1 : 0) != 0);
        fieldsDeclarations.get(0).setFieldsType((Expression)this.ast.newIdentifier("float"));
        Assert.assertTrue((String)"Unexpected list size.", (fieldsDeclarations.get(0).fields().size() == 4 ? 1 : 0) != 0);
        fieldsDeclarations.get(0).fields().clear();
        fieldsDeclarations.get(0).fields().add(this.ast.newSingleFieldDeclaration(this.ast.newVariable("prop0"), (Expression)this.ast.newScalar("10", 0)));
        this.rewrite();
        this.checkResult("<?php class A { private float   $prop0 = 10; } ?>");
    }

    @RunWith(value=org.junit.runners.Suite.class)
    @Suite.SuiteClasses(value={ASTRewriteTestsPHP74.class, NodeDeletionTestsPHP74.class})
    public static class Suite {
    }
}

