/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.formatter.autoedit;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.ui.autoEdit.MainAutoEditStrategy;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class FormatterAutoEditTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    protected static final String DEFAULT_CURSOR = "|";
    protected IProject project;
    protected IFile testFile;
    protected int count;
    protected PHPVersion phpVersion;
    protected String[] fileNames;
    protected PHPStructuredEditor editor;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/formatter-autoedit", "/workspace/phpdoc-generation/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/formatter-autoedit", "/workspace/phpdoc-generation/php5", "/workspace/phpdoc-generation/php53"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/formatter-autoedit", "/workspace/phpdoc-generation/php5", "/workspace/phpdoc-generation/php53", "/workspace/phpdoc-generation/php7"});
        TESTS.put(PHPVersion.PHP7_1, new String[]{"/workspace/formatter-autoedit", "/workspace/phpdoc-generation/php5", "/workspace/phpdoc-generation/php53", "/workspace/phpdoc-generation/php7", "/workspace/phpdoc-generation/php71"});
        TESTS.put(PHPVersion.PHP7_2, new String[]{"/workspace/formatter-autoedit", "/workspace/phpdoc-generation/php5", "/workspace/phpdoc-generation/php53", "/workspace/phpdoc-generation/php7", "/workspace/phpdoc-generation/php71", "/workspace/phpdoc-generation/php72"});
        TESTS.put(PHPVersion.PHP7_3, new String[]{"/workspace/formatter-autoedit", "/workspace/phpdoc-generation/php5", "/workspace/phpdoc-generation/php53", "/workspace/phpdoc-generation/php7", "/workspace/phpdoc-generation/php71", "/workspace/phpdoc-generation/php72"});
        TESTS.put(PHPVersion.PHP7_4, new String[]{"/workspace/formatter-autoedit", "/workspace/phpdoc-generation/php5", "/workspace/phpdoc-generation/php53", "/workspace/phpdoc-generation/php7", "/workspace/phpdoc-generation/php71", "/workspace/phpdoc-generation/php72"});
    }

    public FormatterAutoEditTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
        this.fileNames = fileNames;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = TestUtils.createProject((String)("FormatterTests" + this.phpVersion.name()));
        TestUtils.setProjectPHPVersion((IProject)this.project, (PHPVersion)this.phpVersion);
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.php.formatter.core");
        node.put("formatterProfile", "org.eclipse.php.formatter.ui.default");
    }

    @After
    public void after() throws Exception {
        if (this.testFile != null) {
            TestUtils.deleteFile((IFile)this.testFile);
        }
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject((IProject)this.project);
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    private static String getCursor(PdttFile pdttFile) {
        Map config = pdttFile.getConfig();
        return (String)config.get("cursor");
    }

    @Test
    public void formatter(String fileName) throws Exception {
        final PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        pdttFile.applyPreferences();
        String cursor = FormatterAutoEditTests.getCursor(pdttFile) != null ? FormatterAutoEditTests.getCursor(pdttFile) : DEFAULT_CURSOR;
        final DocumentCommand cmd = this.createFile(pdttFile.getFile().trim(), cursor);
        Exception[] err = new Exception[1];
        IStructuredDocument document = StructuredModelManager.getModelManager().getModelForRead(this.testFile).getStructuredDocument();
        Display.getDefault().syncExec(new Runnable((IDocument)document, err){
            private final /* synthetic */ IDocument val$document;
            private final /* synthetic */ Exception[] val$err;
            {
                this.val$document = iDocument;
                this.val$err = exceptionArray;
            }

            @Override
            public void run() {
                try {
                    FormatterAutoEditTests.this.openEditor();
                    FormatterAutoEditTests.this.format(pdttFile, cmd, this.val$document);
                    FormatterAutoEditTests.this.closeEditor();
                }
                catch (Exception e) {
                    this.val$err[0] = e;
                }
            }
        });
        if (err[0] != null) {
            throw err[0];
        }
        try {
            PDTTUtils.assertContents((String)pdttFile.getExpected(), (String)document.get());
        }
        finally {
            pdttFile.restorePreferences();
        }
    }

    protected DocumentCommand createFile(String data, String cursor) throws Exception {
        int firstOffset = data.indexOf(cursor);
        int lastOffset = data.lastIndexOf(cursor);
        if (lastOffset == -1) {
            throw new IllegalArgumentException("Offset character is not set");
        }
        DocumentCommand cmd = new DocumentCommand(){};
        if (firstOffset == lastOffset) {
            data = String.valueOf(data.substring(0, lastOffset)) + data.substring(lastOffset + cursor.length());
            cmd.offset = lastOffset;
            cmd.length = 0;
        } else {
            data = String.valueOf(data.substring(0, firstOffset)) + data.substring(firstOffset + cursor.length(), lastOffset) + data.substring(lastOffset + cursor.length());
            cmd.offset = firstOffset;
            cmd.length = lastOffset - (firstOffset + cursor.length());
        }
        this.testFile = TestUtils.createFile((IProject)this.project, (String)("test" + ++this.count + ".php"), (String)data);
        this.project.getFile("test" + ++this.count + ".php");
        TestUtils.waitForIndexer();
        return cmd;
    }

    protected void openEditor() throws Exception {
        FileEditorInput input;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)(input = new FileEditorInput(this.testFile)), "org.eclipse.php.test.editor", false);
        if (part instanceof PHPStructuredEditor) {
            this.editor = (PHPStructuredEditor)part;
        } else {
            Assert.assertTrue((String)"Unable to open php editor", (boolean)false);
        }
    }

    protected void closeEditor() {
        this.editor.doSave(null);
        this.editor.getSite().getPage().closeEditor((IEditorPart)this.editor, false);
        this.editor = null;
    }

    protected void format(PdttFile pdttFile, DocumentCommand cmd, IDocument document) throws BadLocationException {
        MainAutoEditStrategy indentLineAutoEditStrategy = new MainAutoEditStrategy();
        if (pdttFile.getOther() != null && !pdttFile.getOther().isEmpty()) {
            cmd.text = pdttFile.getOther().substring(0, pdttFile.getOther().length() - 1);
            if (cmd.text != null && cmd.text.trim().length() == 1 && cmd.text.indexOf(13) == -1 && cmd.text.indexOf(10) == -1) {
                cmd.text = cmd.text.trim();
            }
        } else {
            cmd.text = "\n";
        }
        cmd.doit = true;
        cmd.shiftsCaret = true;
        cmd.caretOffset = -1;
        indentLineAutoEditStrategy.customizeDocumentCommand(document, cmd);
        document.replace(cmd.offset, cmd.length, cmd.text);
    }
}

