/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core.tests;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.format.IProfile;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.formatter.core.tests.Activator;
import org.eclipse.php.formatter.ui.preferences.ProfileManager;
import org.eclipse.php.formatter.ui.preferences.ProfileStore;
import org.eclipse.php.internal.formatter.core.Logger;
import org.eclipse.php.ui.format.PHPFormatProcessorProxy;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class FormatterTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    @PDTTList.Parameters(recursive=true)
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static int suiteCounter;
    protected Map<String, IFile> files = new LinkedHashMap<String, IFile>();
    protected Map<String, PdttFile> pdttFiles = new LinkedHashMap<String, PdttFile>();
    protected final String[] fileNames;
    protected IProject project;
    protected int count;
    protected final PHPVersion phpVersion;
    protected final IScopeContext scopeContext;
    protected final ProfileManager profileManager;
    protected final String xmlFile;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/formatter/php5", "/workspace/formatter_indent_empty_lines/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/formatter/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/formatter/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/formatter/php55", "/workspace/formatter_indent_empty_lines/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/formatter/php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/formatter/php7", "/workspace/formatter_indent_empty_lines/php7"});
        TESTS.put(PHPVersion.PHP7_1, new String[]{"/workspace/formatter/php71"});
        TESTS.put(PHPVersion.PHP7_2, new String[]{"/workspace/formatter/php72"});
        TESTS.put(PHPVersion.PHP7_3, new String[]{"/workspace/formatter/php73"});
        TESTS.put(PHPVersion.PHP7_4, new String[]{"/workspace/formatter/php74"});
        suiteCounter = 0;
    }

    @AbstractPDTTRunner.Context
    public static Bundle getContext() {
        return Activator.getDefault().getBundle();
    }

    public FormatterTests(PHPVersion version, String[] fileNames) throws Exception {
        this.phpVersion = version;
        this.fileNames = fileNames;
        Bundle bundle = FormatterTests.getContext();
        if (fileNames.length > 0) {
            Path path = new Path(fileNames[0]);
            String[] formatterConfigurationFile = PDTTUtils.getFiles((String)(path = path.removeLastSegments(1)).toString(), (Bundle)bundle, (String)".xml");
            this.xmlFile = formatterConfigurationFile.length > 0 ? formatterConfigurationFile[0] : null;
        } else {
            this.xmlFile = null;
        }
        this.scopeContext = InstanceScope.INSTANCE;
        this.profileManager = new ProfileManager(new ArrayList(), this.scopeContext);
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = TestUtils.createProject((String)("FormatterTests_" + suiteCounter++));
        TestUtils.setProjectPHPVersion((IProject)this.project, (PHPVersion)this.phpVersion, (boolean)true, (boolean)true);
        String[] stringArray = this.fileNames;
        int n = this.fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            PdttFile pdttFile = new PdttFile(FormatterTests.getContext(), fileName);
            IFile file = this.createFile(pdttFile.getFile().trim());
            this.files.put(fileName, file);
            this.pdttFiles.put(fileName, pdttFile);
            ++n2;
        }
        TestUtils.waitForIndexer();
        this.profileManager.clearAllSettings(this.scopeContext);
        this.profileManager.commitChanges(this.scopeContext);
        if (this.xmlFile != null) {
            String abcolutXmlFilePath = null;
            URL url = FileLocator.find((Bundle)FormatterTests.getContext(), (IPath)new Path(this.xmlFile), null);
            URL resolved = FileLocator.resolve((URL)url);
            IPath path = Path.fromOSString((String)resolved.getFile());
            abcolutXmlFilePath = path.toString();
            File file = new File(abcolutXmlFilePath);
            Assert.assertTrue((String)("Formatter Configuration Not Found " + file.toString()), (boolean)file.exists());
            List profiles = null;
            try {
                profiles = ProfileStore.readProfilesFromFile((File)file);
            }
            catch (CoreException e) {
                Logger.logException((String)"Error while reading profile configuration xml file", (Throwable)e);
            }
            if (profiles != null && profiles.size() > 0) {
                ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)profiles.iterator().next();
                this.profileManager.addProfile(profile);
                this.profileManager.setSelected((IProfile)profile);
                this.profileManager.commitChanges(this.scopeContext);
            }
        }
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        FormatterTests.setDefaultFormatter(this.scopeContext, this.profileManager);
        TestUtils.deleteProject((IProject)this.project);
    }

    @Test
    public void formatter(String fileName) throws Exception {
        IFile file = this.files.get(fileName);
        IStructuredDocument document = StructuredModelManager.getModelManager().getModelForRead(file).getStructuredDocument();
        PHPFormatProcessorProxy formatter = new PHPFormatProcessorProxy();
        formatter.formatDocument((IDocument)document, 0, document.getLength());
        PDTTUtils.assertContents((String)this.pdttFiles.get(fileName).getExpected(), (String)document.get());
    }

    private static void setDefaultFormatter(IScopeContext scopeContext, ProfileManager profileManager) {
        profileManager.clearAllSettings(scopeContext);
        if (profileManager.getSelected().getID() != "org.eclipse.php.formatter.ui.default") {
            profileManager.setSelected((IProfile)profileManager.getProfile("org.eclipse.php.formatter.ui.default"));
        }
        profileManager.commitChanges(scopeContext);
    }

    protected IFile createFile(String data) throws Exception {
        return TestUtils.createFile((IProject)this.project, (String)("test" + ++this.count + ".php"), (String)data);
    }
}

