/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.test;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.eclipse.php.composer.api.MinimalPackage;
import org.eclipse.php.composer.api.RepositoryPackage;
import org.eclipse.php.composer.api.packages.AsyncDownloader;
import org.eclipse.php.composer.api.packages.AsyncPackagistDownloader;
import org.eclipse.php.composer.api.packages.AsyncPackagistSearch;
import org.eclipse.php.composer.api.packages.AsyncPharDownloader;
import org.eclipse.php.composer.api.packages.DownloadListenerAdapter;
import org.eclipse.php.composer.api.packages.DownloadListenerInterface;
import org.eclipse.php.composer.api.packages.PackageListenerInterface;
import org.eclipse.php.composer.api.packages.PackageSearchListenerInterface;
import org.eclipse.php.composer.api.packages.PackagistDownloader;
import org.eclipse.php.composer.api.packages.PackagistSearch;
import org.eclipse.php.composer.api.packages.PharDownloader;
import org.eclipse.php.composer.api.packages.SearchResult;
import org.eclipse.php.composer.api.test.RetryRule;
import org.junit.Rule;
import org.junit.Test;

public class PackagesTest
extends TestCase {
    private static final int TIMEOUT = 60;
    private CountDownLatch counter;
    private Object asyncResult;
    private String asyncQuery;
    private int asyncCounter;
    private int asyncAborts;
    @Rule
    public final RetryRule retry = new RetryRule(2, 3);

    public void setUp() {
        this.counter = new CountDownLatch(1);
        this.asyncResult = null;
        this.asyncQuery = "";
        this.asyncCounter = 0;
        this.asyncAborts = 0;
    }

    @Test
    public void testAsyncDownloader() {
        try {
            AsyncDownloader downloader = new AsyncDownloader("https://getcomposer.org/composer.phar");
            downloader.addDownloadListener((DownloadListenerInterface)new DownloadListenerAdapter(){

                public void dataReceived(InputStream content, String url) {
                    PackagesTest.this.asyncResult = content;
                    PackagesTest.this.counter.countDown();
                }

                public void errorOccured(Exception e) {
                    e.printStackTrace();
                }
            });
            downloader.download();
            this.counter.await(60L, TimeUnit.SECONDS);
            PackagesTest.assertNotNull((Object)this.asyncResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }

    public void testComposerDownload() {
        try {
            PharDownloader downloader = new PharDownloader();
            InputStream content = downloader.download();
            PackagesTest.assertNotNull((Object)content);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }

    @Test
    public void testAsyncComposerDownload() {
        try {
            AsyncPharDownloader downloader = new AsyncPharDownloader();
            downloader.addDownloadListener((DownloadListenerInterface)new DownloadListenerAdapter(){

                public void dataReceived(InputStream content, String url) {
                    PackagesTest.this.asyncResult = content;
                    PackagesTest.this.counter.countDown();
                }

                public void errorOccured(Exception e) {
                    e.printStackTrace();
                }
            });
            downloader.download();
            this.counter.await(60L, TimeUnit.SECONDS);
            PackagesTest.assertNotNull((Object)this.asyncResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }

    @Test
    public void testPackageDownloader() {
        try {
            PackagistDownloader downloader = new PackagistDownloader();
            RepositoryPackage pkg = downloader.loadPackage("gossi/ldap");
            PackagesTest.assertNotNull((Object)pkg);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }

    @Test
    public void testAsyncPackageDownloader() {
        try {
            AsyncPackagistDownloader downloader = new AsyncPackagistDownloader();
            downloader.addPackageListener(new PackageListenerInterface(){

                public void packageLoaded(RepositoryPackage repositoryPackage) {
                    PackagesTest.this.asyncResult = repositoryPackage;
                    PackagesTest.this.counter.countDown();
                }

                public void aborted(String url) {
                }

                public void errorOccured(Exception e) {
                    e.printStackTrace();
                    PackagesTest.fail();
                }
            });
            String pkg = "symfony/symfony";
            downloader.loadPackage(pkg);
            this.counter.await(60L, TimeUnit.SECONDS);
            PackagesTest.assertNotNull((Object)this.asyncResult);
            PackagesTest.assertEquals((String)pkg, (String)((RepositoryPackage)this.asyncResult).getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }

    @Test
    public void testPackage() {
        try {
            RepositoryPackage resource = RepositoryPackage.fromPackagist((String)"react/react");
            PackagesTest.assertNotNull((Object)resource);
            PackagesTest.assertEquals((String)"react/react", (String)resource.getName());
            PackagesTest.assertEquals((String)"ReactPHP: Event-driven, non-blocking I/O with PHP.", (String)resource.getDescription());
            PackagesTest.assertNotNull((Object)resource.getVersions());
            PackagesTest.assertTrue((resource.getVersions().size() > 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }

    @Test
    public void testSearch() {
        try {
            this.assertSearchResult("html");
            this.assertSearchResult("react");
            this.assertSearchResult("foo bar");
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }

    protected void assertSearchResult(String query) throws Exception {
        PackagistSearch downloader = new PackagistSearch();
        downloader.setPageLimit(1);
        List packages = downloader.search(query);
        PackagesTest.assertNotNull((Object)packages);
        PackagesTest.assertTrue((packages.size() > 0 ? 1 : 0) != 0);
        for (MinimalPackage phpPackage : packages) {
            PackagesTest.assertNotNull((Object)phpPackage);
            PackagesTest.assertNotNull((Object)phpPackage.getName());
            PackagesTest.assertNotNull((Object)phpPackage.getDescription());
        }
    }

    @Test
    public void testAsyncSearch() {
        try {
            AsyncPackagistSearch downloader = new AsyncPackagistSearch();
            downloader.addPackageSearchListener(new PackageSearchListenerInterface(){

                public void packagesFound(List<MinimalPackage> packages, String query, SearchResult result) {
                    PackagesTest.this.asyncResult = packages;
                    PackagesTest.this.asyncQuery = query;
                    PackagesTest packagesTest = PackagesTest.this;
                    packagesTest.asyncCounter = packagesTest.asyncCounter + 1;
                    PackagesTest.this.counter.countDown();
                }

                public void aborted(String url) {
                }

                public void errorOccured(Exception e) {
                }
            });
            String query = "gossi/ldap";
            downloader.search(query);
            this.counter.await(60L, TimeUnit.SECONDS);
            PackagesTest.assertNotNull((Object)this.asyncResult);
            PackagesTest.assertEquals((String)query, (String)this.asyncQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }

    @Test
    public void testAsyncSearchWithPages() {
        try {
            AsyncPackagistSearch downloader = new AsyncPackagistSearch();
            downloader.addPackageSearchListener(new PackageSearchListenerInterface(){

                public void packagesFound(List<MinimalPackage> packages, String query, SearchResult result) {
                    PackagesTest.this.asyncResult = packages;
                    PackagesTest.this.asyncQuery = query;
                    PackagesTest packagesTest = PackagesTest.this;
                    packagesTest.asyncCounter = packagesTest.asyncCounter + 1;
                }

                public void aborted(String url) {
                }

                public void errorOccured(Exception e) {
                }
            });
            String query = "symfony";
            downloader.setPageLimit(3);
            downloader.search(query);
            this.counter.await(60L, TimeUnit.SECONDS);
            PackagesTest.assertNotNull((Object)this.asyncResult);
            PackagesTest.assertEquals((String)query, (String)this.asyncQuery);
            PackagesTest.assertEquals((int)3, (int)this.asyncCounter);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }

    @Test
    public void testAsyncSearchAbortNDownload() {
        try {
            AsyncPackagistSearch downloader = new AsyncPackagistSearch();
            downloader.addPackageSearchListener(new PackageSearchListenerInterface(){

                public void packagesFound(List<MinimalPackage> packages, String query, SearchResult result) {
                    PackagesTest.this.asyncResult = packages;
                    PackagesTest.this.asyncQuery = query;
                    PackagesTest packagesTest = PackagesTest.this;
                    packagesTest.asyncCounter = packagesTest.asyncCounter + 1;
                    if (PackagesTest.this.asyncCounter == 1) {
                        PackagesTest.this.counter.countDown();
                    }
                }

                public void aborted(String url) {
                }

                public void errorOccured(Exception e) {
                    e.printStackTrace();
                }
            });
            String query = "symfony";
            downloader.setPageLimit(1);
            downloader.search(query);
            downloader.abort();
            query = "zend";
            downloader.search(query);
            this.counter.await(60L, TimeUnit.SECONDS);
            PackagesTest.assertNotNull((Object)this.asyncResult);
            PackagesTest.assertEquals((String)query, (String)this.asyncQuery);
            PackagesTest.assertEquals((int)1, (int)this.asyncCounter);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncAbort() {
        try {
            AsyncPackagistSearch downloader = new AsyncPackagistSearch();
            downloader.addPackageSearchListener(new PackageSearchListenerInterface(){

                public void packagesFound(List<MinimalPackage> packages, String query, SearchResult result) {
                    PackagesTest.this.asyncResult = packages;
                    PackagesTest.this.asyncQuery = query;
                    PackagesTest packagesTest = PackagesTest.this;
                    packagesTest.asyncCounter = packagesTest.asyncCounter + 1;
                    if (PackagesTest.this.asyncAborts == 1 && PackagesTest.this.asyncCounter == 1) {
                        PackagesTest.this.counter.countDown();
                    }
                }

                public void aborted(String url) {
                    PackagesTest packagesTest = PackagesTest.this;
                    packagesTest.asyncAborts = packagesTest.asyncAborts + 1;
                    if (PackagesTest.this.asyncAborts == 1 && PackagesTest.this.asyncCounter == 1) {
                        PackagesTest.this.counter.countDown();
                    }
                }

                public void errorOccured(Exception e) {
                }
            });
            downloader.setPageLimit(1);
            AsyncPackagistSearch asyncPackagistSearch = downloader;
            synchronized (asyncPackagistSearch) {
                downloader.search("test");
                downloader.abort();
            }
            downloader.search("symfony");
            this.counter.await(60L, TimeUnit.SECONDS);
            PackagesTest.assertEquals((String)"Aborts: ", (int)1, (int)this.asyncAborts);
            PackagesTest.assertEquals((String)"Searches:", (int)1, (int)this.asyncCounter);
            PackagesTest.assertEquals((String)"symfony", (String)this.asyncQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackagesTest.fail();
        }
    }
}

