/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.codeassist.scope;

import java.io.InputStream;
import java.util.LinkedList;
import org.eclipse.php.core.codeassist.ICompletionScope;
import org.eclipse.php.core.tests.PdttFile;

public class CodeAssistScopePdttFile
extends PdttFile {
    private ExpectedScope[] expectedScopes;

    public CodeAssistScopePdttFile(String fileName) throws Exception {
        super(fileName);
    }

    public ExpectedScope[] getExpectedScopes() {
        return this.expectedScopes;
    }

    @Override
    protected void parse(InputStream stream, String charsetName) throws Exception {
        String[] lines;
        super.parse(stream, null);
        LinkedList<ExpectedScope> expectedScopes = new LinkedList<ExpectedScope>();
        String[] stringArray = lines = this.getExpected().split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int i = line.indexOf(40);
            int j = line.indexOf(41);
            if (i != -1 && j != -1) {
                ExpectedScope proposal = new ExpectedScope();
                proposal.type = ICompletionScope.Type.valueOf((String)line.substring(0, i));
                String[] nums = line.substring(i + 1, j).split(",", 3);
                if (nums.length != 2 && nums.length != 3) {
                    throw new Exception("Invalid sope arguments!");
                }
                proposal.offset = Integer.valueOf(nums[0]);
                proposal.length = Integer.valueOf(nums[1]);
                if (nums.length == 3) {
                    proposal.name = nums[2];
                }
                expectedScopes.add(proposal);
            }
            ++n2;
        }
        this.expectedScopes = expectedScopes.toArray(new ExpectedScope[expectedScopes.size()]);
    }

    public static class ExpectedScope {
        public ICompletionScope.Type type;
        public int offset;
        public int length;
        public String name = null;

        public boolean equals(Object obj) {
            if (obj instanceof ICompletionScope) {
                ICompletionScope scope = (ICompletionScope)obj;
                if (scope.getType() != this.type || scope.getLength() != this.length || scope.getOffset() != this.offset) {
                    return false;
                }
                String objName = scope.getName();
                if (this.name == null && objName != null) {
                    return false;
                }
                return this.name == null || this.name.equals(objName);
            }
            return super.equals(obj);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.type.name()).append('(').append(this.offset).append(',').append(this.length);
            if (this.name != null) {
                sb.append(',').append(this.name);
            }
            return sb.append(')').toString();
        }
    }
}

