/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.document.lexer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.documentModel.parser.AbstractPHPLexer;
import org.eclipse.php.internal.core.documentModel.parser.PHPLexerFactory;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class DocumentLexerTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private final PHPVersion version;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/document_lexer/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/document_lexer/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/document_lexer/php53", "/workspace/document_lexer/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/document_lexer/php53", "/workspace/document_lexer/php54", "/workspace/document_lexer/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/document_lexer/php53", "/workspace/document_lexer/php54", "/workspace/document_lexer/php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/document_lexer/php7"});
        TESTS.put(PHPVersion.PHP7_3, new String[]{"/workspace/document_lexer/php73"});
        TESTS.put(PHPVersion.PHP7_4, new String[]{"/workspace/document_lexer/php74"});
    }

    public DocumentLexerTests(PHPVersion version, String[] fileNames) {
        this.version = version;
    }

    @Test
    public void test(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(PHPCoreTests.getDefault().getBundle(), fileName, "UTF-8");
        AbstractPHPLexer lexer = PHPLexerFactory.createLexer((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(pdttFile.getFile().trim().getBytes("UTF-8")), "UTF-8"), (PHPVersion)this.version);
        int inScriptingState = lexer.getScriptingState();
        lexer.initialize(inScriptingState);
        StringBuilder actualBuf = new StringBuilder();
        String tokenType = lexer.yylex();
        while (tokenType != null) {
            actualBuf.append(tokenType).append('|').append(lexer.yytext()).append('|').append(lexer.yystate()).append('\n');
            tokenType = lexer.yylex();
        }
        PDTTUtils.assertContents(pdttFile.getExpected(), actualBuf.toString());
    }
}

