/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views.coverage;

import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.preferences.coverage.CodeCoveragePreferenceKeys;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class CodeCoverageViewer
extends TreeViewer {
    private TreeColumn[] treeColumns = new TreeColumn[2];

    public CodeCoverageViewer(Composite parent) {
        super(parent, 772);
        this.createColumns();
        this.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CodeCoverageViewer.this.dispose();
            }
        });
    }

    protected void createColumns() {
        Tree tree = this.getTree();
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        int[] columnWidths = CodeCoveragePreferenceKeys.getCodeCoverageColumnWidths();
        int i = 0;
        this.treeColumns[i] = new TreeColumn(tree, 16384, i);
        this.treeColumns[i].setText(PHPDebugUIMessages.CodeCoverageViewer_0);
        this.treeColumns[i].setMoveable(false);
        this.treeColumns[i].setWidth(columnWidths[i]);
        this.treeColumns[++i] = new TreeColumn(tree, 16384, i);
        this.treeColumns[i].setText(PHPDebugUIMessages.CodeCoverageViewer_1);
        this.treeColumns[i].setMoveable(false);
        this.treeColumns[i].setWidth(columnWidths[i]);
    }

    public void dispose() {
        CodeCoveragePreferenceKeys.setCodeCoverageColumnWidths(this.getColumnWidths());
        this.getTree().dispose();
    }

    int[] getColumnWidths() {
        int[] widths = new int[this.treeColumns.length];
        int i = 0;
        while (i < this.treeColumns.length) {
            widths[i] = this.treeColumns[i].getWidth();
            ++i;
        }
        return widths;
    }

    void setColumnWidths(int[] widths) {
        boolean isParamLimiter = widths.length < this.treeColumns.length;
        int limit = isParamLimiter ? widths.length : this.treeColumns.length;
        int i = 0;
        while (i < limit) {
            this.treeColumns[i].setWidth(widths[i]);
            ++i;
        }
        if (!isParamLimiter) {
            i = widths.length;
            while (i < this.treeColumns.length) {
                this.treeColumns[i].setWidth(widths[widths.length - 1]);
                ++i;
            }
        }
    }
}

