/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.compiler_ast.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractPHPSourceParser;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPSourceParserFactory;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class CompilerParserTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private AbstractPHPSourceParser parser;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/compiler_parser/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php53/php5only", "/workspace/compiler_parser/php53/phplowerthan73", "/workspace/compiler_parser/php53/phplowerthan74", "/workspace/compiler_parser/php53/phplowerthan80"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php53/php5only", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php53/phplowerthan73", "/workspace/compiler_parser/php53/phplowerthan74", "/workspace/compiler_parser/php53/phplowerthan80"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php53/php5only", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php53/phplowerthan73", "/workspace/compiler_parser/php53/phplowerthan74", "/workspace/compiler_parser/php53/phplowerthan80"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php53/php5only", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56", "/workspace/compiler_parser/php53/phplowerthan73", "/workspace/compiler_parser/php53/phplowerthan74", "/workspace/compiler_parser/php53/phplowerthan80"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56", "/workspace/compiler_parser/php7", "/workspace/compiler_parser/php53/phplowerthan73", "/workspace/compiler_parser/php53/phplowerthan74", "/workspace/compiler_parser/php53/phplowerthan80"});
        TESTS.put(PHPVersion.PHP7_1, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56", "/workspace/compiler_parser/php7", "/workspace/compiler_parser/php71", "/workspace/compiler_parser/php53/phplowerthan73", "/workspace/compiler_parser/php53/phplowerthan74", "/workspace/compiler_parser/php53/phplowerthan80"});
        TESTS.put(PHPVersion.PHP7_2, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56", "/workspace/compiler_parser/php7", "/workspace/compiler_parser/php71", "/workspace/compiler_parser/php72", "/workspace/compiler_parser/php53/phplowerthan73", "/workspace/compiler_parser/php53/phplowerthan74", "/workspace/compiler_parser/php53/phplowerthan80"});
        TESTS.put(PHPVersion.PHP7_3, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56", "/workspace/compiler_parser/php7", "/workspace/compiler_parser/php71", "/workspace/compiler_parser/php72", "/workspace/compiler_parser/php73", "/workspace/compiler_parser/php53/phplowerthan74", "/workspace/compiler_parser/php53/phplowerthan80"});
        TESTS.put(PHPVersion.PHP7_4, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56", "/workspace/compiler_parser/php7", "/workspace/compiler_parser/php71", "/workspace/compiler_parser/php72", "/workspace/compiler_parser/php73", "/workspace/compiler_parser/php74"});
        TESTS.put(PHPVersion.PHP8_0, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56", "/workspace/compiler_parser/php7", "/workspace/compiler_parser/php71", "/workspace/compiler_parser/php72", "/workspace/compiler_parser/php73", "/workspace/compiler_parser/php74", "/workspace/compiler_parser/php80"});
        TESTS.put(PHPVersion.PHP8_1, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56", "/workspace/compiler_parser/php7", "/workspace/compiler_parser/php71", "/workspace/compiler_parser/php72", "/workspace/compiler_parser/php73", "/workspace/compiler_parser/php74", "/workspace/compiler_parser/php80", "/workspace/compiler_parser/php81"});
        TESTS.put(PHPVersion.PHP8_2, new String[]{"/workspace/compiler_parser/php53", "/workspace/compiler_parser/php54", "/workspace/compiler_parser/php55", "/workspace/compiler_parser/php56", "/workspace/compiler_parser/php7", "/workspace/compiler_parser/php71", "/workspace/compiler_parser/php72", "/workspace/compiler_parser/php73", "/workspace/compiler_parser/php74", "/workspace/compiler_parser/php80", "/workspace/compiler_parser/php81", "/workspace/compiler_parser/php82"});
    }

    public CompilerParserTests(PHPVersion version, String[] fileNames) {
        this.parser = PHPSourceParserFactory.createParser((PHPVersion)version);
    }

    @Test
    public void parserTest(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(PHPCoreTests.getDefault().getBundle(), fileName, "UTF-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdttFile.getFile().trim().getBytes("UTF-8"));
        IModuleDeclaration moduleDeclaration = this.parser.parse((Reader)new InputStreamReader((InputStream)inputStream, "UTF-8"), null, ProjectOptions.isSupportingASPTags(null), ProjectOptions.useShortTags(null));
        String actual = ASTPrintVisitor.toXMLString((ASTNode)((ASTNode)moduleDeclaration));
        PDTTUtils.assertContents(pdttFile.getExpected(), actual);
    }
}

