/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PHPMoveProcessorTestCase {
    private IProject project1;
    private IProject project2;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"TestProject1");
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        TestUtils.createFile((IFolder)folder, (String)"test1.php", (String)"<?php class TestRenameClass{}?>");
        this.project2 = TestUtils.createProject((String)"TestProject2");
        TestUtils.createFile((IProject)this.project2, (String)"test2.php", (String)"<?php include('src/test1.php'); ?>");
        IAccessRule[] accesRules = new IAccessRule[]{};
        boolean combineAccessRules = false;
        IBuildpathEntry buildPath = DLTKCore.newProjectEntry((IPath)this.project1.getProject().getFullPath(), (IAccessRule[])accesRules, (boolean)combineAccessRules, (IBuildpathAttribute[])new IBuildpathAttribute[0], (boolean)false);
        IScriptProject scriptProject = DLTKCore.create((IProject)this.project2.getProject());
        ArrayList<IBuildpathEntry> entriesList = new ArrayList<IBuildpathEntry>();
        try {
            IBuildpathEntry[] entries = scriptProject.getRawBuildpath();
            entriesList.addAll(Arrays.asList(entries));
            entriesList.add(buildPath);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        IBuildpathEntry[] newEntries = new IBuildpathEntry[entriesList.size()];
        scriptProject.setRawBuildpath(null, (IProgressMonitor)new NullProgressMonitor());
        scriptProject.setRawBuildpath(entriesList.toArray(newEntries), (IProgressMonitor)new NullProgressMonitor());
        TestUtils.waitForIndexer();
    }

    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
        this.project2.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testMove() {
        PHPMoveProcessor processor = new PHPMoveProcessor((IResource)this.project1.getProject().getFile("src/test1.php"));
        RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        processor.setDestination((IContainer)this.project1);
        processor.setUpdateReferences(true);
        try {
            Change change = processor.createChange((IProgressMonitor)new NullProgressMonitor());
            change.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        TestUtils.waitForIndexer();
        IFile file = this.project2.getFile("test2.php");
        try {
            String content = FileUtils.getContents(file);
            Assert.assertEquals((Object)"<?php include('test1.php'); ?>", (Object)content);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

