/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.codeassist.scope;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.CompletionCompanion;
import org.eclipse.php.core.codeassist.ICompletionScope;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.codeassist.scope.CodeAssistScopePdttFile;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.documentModel.loader.PHPDocumentLoader;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class CodeAssistScopeTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    public static final String DEFAULT_CURSOR = "|";
    private IProject project;
    private IFile testFile;
    private List<IFile> otherFiles = null;
    private PHPVersion version;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/codeassist_scope/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53", "/workspace/codeassist_scope/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53", "/workspace/codeassist_scope/php54", "/workspace/codeassist_scope/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53", "/workspace/codeassist_scope/php54", "/workspace/codeassist_scope/php55", "/workspace/codeassist_scope/php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53", "/workspace/codeassist_scope/php54", "/workspace/codeassist_scope/php55", "/workspace/codeassist_scope/php56", "/workspace/codeassist_scope/php7"});
        TESTS.put(PHPVersion.PHP7_1, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53", "/workspace/codeassist_scope/php54", "/workspace/codeassist_scope/php55", "/workspace/codeassist_scope/php56", "/workspace/codeassist_scope/php7", "/workspace/codeassist_scope/php71"});
        TESTS.put(PHPVersion.PHP7_2, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53", "/workspace/codeassist_scope/php54", "/workspace/codeassist_scope/php55", "/workspace/codeassist_scope/php56", "/workspace/codeassist_scope/php7", "/workspace/codeassist_scope/php71", "/workspace/codeassist_scope/php72"});
        TESTS.put(PHPVersion.PHP7_3, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53", "/workspace/codeassist_scope/php54", "/workspace/codeassist_scope/php55", "/workspace/codeassist_scope/php56", "/workspace/codeassist_scope/php7", "/workspace/codeassist_scope/php71", "/workspace/codeassist_scope/php72"});
        TESTS.put(PHPVersion.PHP7_4, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53", "/workspace/codeassist_scope/php54", "/workspace/codeassist_scope/php55", "/workspace/codeassist_scope/php56", "/workspace/codeassist_scope/php7", "/workspace/codeassist_scope/php71", "/workspace/codeassist_scope/php72", "/workspace/codeassist_scope/php74"});
        TESTS.put(PHPVersion.PHP8_0, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53", "/workspace/codeassist_scope/php54", "/workspace/codeassist_scope/php55", "/workspace/codeassist_scope/php56", "/workspace/codeassist_scope/php7", "/workspace/codeassist_scope/php71", "/workspace/codeassist_scope/php72", "/workspace/codeassist_scope/php74", "/workspace/codeassist_scope/php80"});
        TESTS.put(PHPVersion.PHP8_1, new String[]{"/workspace/codeassist_scope/php5", "/workspace/codeassist_scope/php53", "/workspace/codeassist_scope/php54", "/workspace/codeassist_scope/php55", "/workspace/codeassist_scope/php56", "/workspace/codeassist_scope/php7", "/workspace/codeassist_scope/php71", "/workspace/codeassist_scope/php72", "/workspace/codeassist_scope/php74", "/workspace/codeassist_scope/php80", "/workspace/codeassist_scope/php81"});
    }

    public CodeAssistScopeTests(PHPVersion version, String[] fileNames) {
        this.version = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        TestUtils.disableColliders(TestUtils.ColliderType.ALL);
        ModelManager.getModelManager().getIndexManager().disable();
        this.project = TestUtils.createProject("CodeAssistScopeTests_" + this.version.toString());
        ProjectOptions.setPHPVersion((PHPVersion)this.version, (IProject)this.project);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject(this.project);
        TestUtils.enableColliders(TestUtils.ColliderType.ALL);
        ModelManager.getModelManager().getIndexManager().enable();
    }

    @Test
    public void assist(String fileName) throws Exception {
        CodeAssistScopePdttFile pdttFile = new CodeAssistScopePdttFile(fileName);
        pdttFile.applyPreferences();
        int offset = this.createFiles(pdttFile);
        ICompletionScope[] scopes = this.getScopes(DLTKCore.createSourceModuleFrom((IFile)this.testFile), offset);
        this.compareScopes(scopes, pdttFile);
    }

    private ICompletionScope[] getScopes(ISourceModule sourceModule, int offset) throws ModelException {
        IStructuredDocument document = (IStructuredDocument)new PHPDocumentLoader().createNewStructuredDocument();
        String content = new String(sourceModule.getSourceAsCharArray());
        document.set(content);
        LinkedList<ICompletionScope> scopes = new LinkedList<ICompletionScope>();
        CompletionCompanion companion = new CompletionCompanion((CompletionRequestor)new TestCompletionRequestor(document, offset), (IModuleSource)sourceModule, offset);
        ICompletionScope scope = companion.getScope();
        do {
            scopes.add(scope);
        } while ((scope = scope.getParent()) != null);
        return scopes.toArray(new ICompletionScope[scopes.size()]);
    }

    private void compareScopes(ICompletionScope[] proposals, CodeAssistScopePdttFile pdttFile) throws Exception {
        int n;
        int n2;
        ICompletionScope[] iCompletionScopeArray;
        CodeAssistScopePdttFile.ExpectedScope[] expectedProposals = pdttFile.getExpectedScopes();
        boolean proposalsEqual = true;
        if (proposals.length == expectedProposals.length) {
            int pos = 0;
            iCompletionScopeArray = proposals;
            n2 = proposals.length;
            n = 0;
            while (n < n2) {
                CodeAssistScopePdttFile.ExpectedScope compare;
                ICompletionScope proposal = iCompletionScopeArray[n];
                if (!(compare = expectedProposals[pos++]).equals(proposal)) {
                    proposalsEqual = false;
                    break;
                }
                ++n;
            }
        } else {
            proposalsEqual = false;
        }
        if (!proposalsEqual) {
            StringBuilder errorBuf = new StringBuilder();
            errorBuf.append("\nEXPECTED COMPLETIONS LIST:\n-----------------------------\n");
            errorBuf.append(pdttFile.getExpected());
            errorBuf.append("\nACTUAL COMPLETIONS LIST:\n-----------------------------\n");
            iCompletionScopeArray = proposals;
            n2 = proposals.length;
            n = 0;
            while (n < n2) {
                ICompletionScope p = iCompletionScopeArray[n];
                errorBuf.append(p.toString()).append('\n');
                ++n;
            }
            Assert.fail((String)errorBuf.toString());
        }
    }

    @After
    public void deleteFiles() {
        if (this.testFile != null) {
            TestUtils.deleteFile(this.testFile);
        }
        if (this.otherFiles != null) {
            for (IFile file : this.otherFiles) {
                if (file == null) continue;
                TestUtils.deleteFile(file);
            }
        }
    }

    private int createFiles(PdttFile pdttFile) throws Exception {
        String cursor = this.getCursor(pdttFile) != null ? this.getCursor(pdttFile) : DEFAULT_CURSOR;
        String data = pdttFile.getFile();
        String[] otherFiles = pdttFile.getOtherFiles();
        int offset = data.lastIndexOf(cursor);
        if (offset == -1) {
            throw new IllegalArgumentException("Offset character is not set");
        }
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        String fileName = Paths.get(pdttFile.getFileName(), new String[0]).getFileName().toString();
        fileName = fileName.substring(0, fileName.indexOf(46));
        this.testFile = TestUtils.createFile(this.project, String.valueOf(fileName) + ".php", data);
        this.otherFiles = new ArrayList<IFile>(otherFiles.length);
        int i = 0;
        String[] stringArray = otherFiles;
        int n = otherFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String otherFileContent = stringArray[n2];
            IFile tmp = TestUtils.createFile(this.project, String.format("test%s.php", i), otherFileContent);
            this.otherFiles.add(i, tmp);
            ++i;
            ++n2;
        }
        return offset;
    }

    private String getCursor(PdttFile pdttFile) {
        Map<String, String> config = pdttFile.getConfig();
        return config.get("cursor");
    }

    private static class TestCompletionRequestor
    extends CompletionRequestor
    implements IPHPCompletionRequestor {
        private IStructuredDocument document;
        private int offset;

        public TestCompletionRequestor(IStructuredDocument document, int offset) {
            this.document = document;
            this.offset = offset;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public boolean isExplicit() {
            return true;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public boolean filter(int flag) {
            return false;
        }

        public void addFlag(int flag) {
        }

        public void accept(CompletionProposal proposal) {
        }
    }
}

