/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.actions.ActionMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.OpenActionUtil;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.explorer.PHPTreeViewer;
import org.eclipse.php.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OpenAction
extends SelectionDispatchAction {
    private PHPStructuredEditor fEditor;
    static /* synthetic */ Class class$0;

    public OpenAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.open_action");
    }

    public OpenAction(PHPStructuredEditor pHPStructuredEditor) {
        this((IWorkbenchSite)pHPStructuredEditor.getEditorSite());
        this.fEditor = pHPStructuredEditor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.checkEnabled(iStructuredSelection));
    }

    private boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof PHPCodeData || e instanceof IFile || e instanceof IStorage) continue;
            return false;
        }
        return true;
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtils.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        PHPCodeData pHPCodeData = SelectionConverter.codeResolve(this.fEditor, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_select_element);
        if (pHPCodeData == null) {
            IEditorStatusLine iEditorStatusLine;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iEditorStatusLine = (IEditorStatusLine)this.fEditor.getAdapter(clazz)) != null) {
                iEditorStatusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null);
            }
            this.getShell().getDisplay().beep();
            return;
        }
        this.run(new Object[]{pHPCodeData}, null);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (!this.checkEnabled(iStructuredSelection)) {
            return;
        }
        this.run(iStructuredSelection.toArray(), ((PHPTreeViewer)this.getSelectionProvider()).getTree().getSelection());
    }

    public void run(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            try {
                boolean bl;
                object = this.getElementToOpen(object);
                boolean bl2 = bl = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                if (object instanceof PHPCodeData && objectArray2 != null) {
                    OpenActionUtil.open(objectArray2[n], bl);
                } else {
                    OpenActionUtil.open(object, bl);
                }
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.OpenAction_error_messageProblems, (String)"");
            }
            ++n;
        }
    }

    public Object getElementToOpen(Object object) {
        return object;
    }

    private String getDialogTitle() {
        return ActionMessages.OpenAction_error_title;
    }

    private void showError(CoreException coreException) {
        ExceptionHandler.handle(coreException, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_error_message);
    }
}

