/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.php.Logger;
import org.eclipse.php.core.format.DefualtIndentationStrategy;
import org.eclipse.php.core.format.FormatterUtils;
import org.eclipse.php.core.format.IIndentationStrategy;
import org.eclipse.php.internal.ui.autoEdit.CurlyCloseAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.IAfterNewLineAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.PairCurlyBracketAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class IndentLineAutoEditStrategy
extends DefualtIndentationStrategy
implements IAutoEditStrategy {
    private StringBuffer helpBuffer = new StringBuffer();
    private CurlyCloseAutoEditStrategy curlyCloseAutoEditStrategy = new CurlyCloseAutoEditStrategy();
    IAfterNewLineAutoEditStrategy pairCurlyBracketAutoEditStrategy = new PairCurlyBracketAutoEditStrategy();

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.text != null && TextUtilities.endsWith((String[])iDocument.getLegalLineDelimiters(), (String)documentCommand.text) != -1) {
            this.autoIndentAfterNewLine((IStructuredDocument)iDocument, documentCommand);
        }
    }

    private void autoIndentAfterNewLine(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand) {
        try {
            Object object;
            this.helpBuffer.setLength(0);
            this.helpBuffer.append(documentCommand.text);
            int n = documentCommand.offset;
            int n2 = iStructuredDocument.getLineOfOffset(n);
            this.placeMatchingBlanks(iStructuredDocument, this.helpBuffer, n2, documentCommand);
            int n3 = -1;
            if (n > 0 && (object = this.getAfterNewLineAutoEditStrategy(iStructuredDocument, documentCommand)) != null) {
                n3 = object.autoEditAfterNewLine(iStructuredDocument, documentCommand, this.helpBuffer);
            }
            object = iStructuredDocument.getLineInformation(n2);
            int n4 = object.getOffset();
            int n5 = object.getLength();
            String string = iStructuredDocument.get(n4, n5);
            int n6 = 0;
            while (n6 < n5 && (string.charAt(n6) == ' ' || string.charAt(n6) == '\t')) {
                ++n6;
            }
            if (n < n4 + n6) {
                documentCommand.offset = Math.min(documentCommand.offset, n4);
                documentCommand.length = Math.max(n6, documentCommand.length);
            }
            documentCommand.text = this.helpBuffer.toString();
            if (n3 != -1) {
                iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                documentCommand.length = 0;
                documentCommand.text = "";
                documentCommand.offset = n3;
                iStructuredDocument.getUndoManager().disableUndoManagement();
                iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                iStructuredDocument.getUndoManager().enableUndoManagement();
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
    }

    public void placeMatchingBlanks(IStructuredDocument iStructuredDocument, StringBuffer stringBuffer, int n, DocumentCommand documentCommand) throws BadLocationException {
        int n2 = documentCommand.offset;
        IRegion iRegion = iStructuredDocument.getLineInformation(n);
        String string = iStructuredDocument.get(n2 + documentCommand.length, iRegion.getOffset() + iRegion.getLength() - (n2 + documentCommand.length));
        String string2 = string.trim();
        char c = string2.length() == 0 ? (char)'{' : (char)string2.charAt(0);
        IIndentationStrategy iIndentationStrategy = this.getAutoEditStrategy(c);
        iIndentationStrategy.placeMatchingBlanks(iStructuredDocument, stringBuffer, n, n2);
    }

    private IIndentationStrategy getAutoEditStrategy(char c) {
        switch (c) {
            case '}': {
                return this.curlyCloseAutoEditStrategy;
            }
        }
        return this;
    }

    private IAfterNewLineAutoEditStrategy getAfterNewLineAutoEditStrategy(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand) throws BadLocationException {
        if (documentCommand.length > 0) {
            return null;
        }
        int n = documentCommand.offset;
        String string = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)n);
        char c = iStructuredDocument.getChar(n - 1);
        if (TypingPreferences.closeCurlyBracket && c == '{' && string == "org.eclipse.php.PHP_DEFAULT") {
            return this.pairCurlyBracketAutoEditStrategy;
        }
        return null;
    }
}

