/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.Logger;
import org.eclipse.php.core.format.CurlyCloseIndentationStrategy;
import org.eclipse.php.core.format.FormatPreferencesSupport;
import org.eclipse.php.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.autoEdit.IAfterNewLineAutoEditStrategy;
import org.eclipse.wst.html.ui.internal.text.HTMLDocumentRegionEdgeMatcher;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class PairCurlyBracketAutoEditStrategy
implements IAfterNewLineAutoEditStrategy {
    private static final char CURLY_OPEN = '{';
    private static final char CURLY_CLOSE = '}';
    private static HTMLDocumentRegionEdgeMatcher matcher = new HTMLDocumentRegionEdgeMatcher();
    private CurlyCloseIndentationStrategy curlyCloseIndentationStrategy = new CurlyCloseIndentationStrategy();

    public int autoEditAfterNewLine(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand, StringBuffer stringBuffer) {
        try {
            int n = documentCommand.offset;
            int n2 = n + stringBuffer.length();
            n2 += this.copyRestOfLine(iStructuredDocument, documentCommand, stringBuffer);
            boolean bl = false;
            int n3 = 0;
            int n4 = n;
            IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n4);
            while (n4 >= 0 && iStructuredDocumentRegion != null) {
                if (iStructuredDocumentRegion.getType() != "PHP_CONTENT") {
                    n4 = iStructuredDocumentRegion.getStartOffset() - 1;
                    iStructuredDocumentRegion = iStructuredDocumentRegion.getPrevious();
                    continue;
                }
                int n5 = iStructuredDocumentRegion.getStart();
                String string = iStructuredDocumentRegion.getFullText();
                ITextRegion iTextRegion = null;
                int n6 = string.length() - 1;
                while (n6 >= 0) {
                    char c = string.charAt(n6);
                    if (c == '}') {
                        iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n5 + n6);
                        if (iTextRegion.getType() == "PHP_CURLY_CLOSE") {
                            ++n3;
                        }
                    } else if (c == '{') {
                        iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n5 + n6);
                        String string2 = iTextRegion.getType();
                        if (string2 != "PHP_CURLY_OPEN") {
                            --n6;
                            continue;
                        }
                        if (--n3 < 0) {
                            if (matcher.match((IDocument)iStructuredDocument, n5 + n6 + 1) == null) {
                                bl = true;
                                break;
                            }
                            ++n3;
                        }
                    }
                    --n6;
                }
                if (bl) break;
                n4 = iStructuredDocumentRegion.getStartOffset() - 1;
                iStructuredDocumentRegion = iStructuredDocumentRegion.getPrevious();
            }
            if (bl) {
                this.addCurlyCloseBracket(iStructuredDocument, documentCommand, stringBuffer);
            }
            return n2;
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return -1;
        }
    }

    private int copyRestOfLine(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand, StringBuffer stringBuffer) throws BadLocationException {
        int n;
        int n2 = documentCommand.offset;
        IRegion iRegion = iStructuredDocument.getLineInformationOfOffset(n2);
        int n3 = iRegion.getOffset() + iRegion.getLength();
        int n4 = 0;
        String string = iStructuredDocument.get(n2, n3 - n2);
        int n5 = 0;
        while (n5 < string.length()) {
            n = string.charAt(n5);
            if (n == 10 || n == 13 || !Character.isWhitespace((char)n)) {
                documentCommand.length += n5;
                break;
            }
            ++n5;
        }
        String string2 = string.trim();
        if (string2.length() > 0 && string2.charAt(0) == '}') {
            n = FormatPreferencesSupport.getInstance().getIndentationSize((IDocument)iStructuredDocument);
            char c = FormatPreferencesSupport.getInstance().getIndentationChar((IDocument)iStructuredDocument);
            int n6 = 0;
            while (n6 < n) {
                stringBuffer.append(c);
                ++n4;
                ++n6;
            }
            stringBuffer.append(iStructuredDocument.getLineDelimiter());
            String string3 = FormatterUtils.getLineBlanks((IStructuredDocument)iStructuredDocument, (IRegion)iRegion);
            stringBuffer.append(string3);
        }
        n = iStructuredDocument.getChar(n2 += documentCommand.length);
        while (n != 10 && n != 13) {
            stringBuffer.append((char)n);
            ++documentCommand.length;
            n = iStructuredDocument.getChar(++n2);
        }
        return n4;
    }

    private void addCurlyCloseBracket(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand, StringBuffer stringBuffer) {
        stringBuffer.append(iStructuredDocument.getLineDelimiter());
        int n = iStructuredDocument.getLineOfOffset(documentCommand.offset);
        try {
            IRegion iRegion = iStructuredDocument.getLineInformation(n);
            this.curlyCloseIndentationStrategy.placeMatchingBlanks(iStructuredDocument, stringBuffer, n, iRegion.getOffset() + iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
        stringBuffer.append('}');
    }
}

