/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor;

import java.util.Arrays;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.internal.text.link.contentassist.HTMLTextPresenter;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.core.containers.LocalFileStorage;
import org.eclipse.php.core.containers.ZipEntryStorage;
import org.eclipse.php.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.actions.ActionMessages;
import org.eclipse.php.internal.ui.actions.AddBlockCommentAction;
import org.eclipse.php.internal.ui.actions.BlockCommentAction;
import org.eclipse.php.internal.ui.actions.FoldingActionGroup;
import org.eclipse.php.internal.ui.actions.OpenDeclarationAction;
import org.eclipse.php.internal.ui.actions.OpenFunctionsManualAction;
import org.eclipse.php.internal.ui.actions.RemoveBlockCommentAction;
import org.eclipse.php.internal.ui.actions.ToggleCommentAction;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.containers.StorageEditorInput;
import org.eclipse.php.ui.editor.PHPEditorMessages;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorators;
import org.eclipse.php.ui.editor.hover.SourceViewerInformationControl;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;

public class PHPStructuredEditor
extends StructuredTextEditor {
    protected InformationPresenter fInformationPresenter;
    private FoldingActionGroup foldingGroup;
    IHoverMessageDecorators messageDecorator;
    static /* synthetic */ Class class$0;

    static {
        System.setProperty("org.eclipse.wst.sse.ui.foldingenabled", "foldingenabled");
    }

    public PHPStructuredEditor() {
        this.initFolding();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.ui.hoverMessageDecorators");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            try {
                this.messageDecorator = (IHoverMessageDecorators)iConfigurationElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            ++n;
        }
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        IInformationControlCreator iInformationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                boolean bl = false;
                int n = bl ? 0 : 768;
                return new DefaultInformationControl(shell, 20, n, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(bl));
            }
        };
        this.fInformationPresenter = new InformationPresenter(iInformationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
    }

    private void initFolding() {
        boolean bl = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("foldingEnabled");
        if (bl) {
            SSEUIPlugin.getDefault().getPreferenceStore().setValue("foldingEnabled", true);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        try {
            if ("hoverModifiers".equals(string)) {
                this.updateHoverBehavior();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            super.handlePreferenceStoreChanged(propertyChangeEvent);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        super.handlePreferenceStoreChanged(propertyChangeEvent);
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        IFile iFile = null;
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            iFile = iFileEditorInput.getFile();
        } else if (iEditorInput instanceof StorageEditorInput) {
            StorageEditorInput storageEditorInput = (StorageEditorInput)iEditorInput;
            IStorage iStorage = storageEditorInput.getStorage();
            if (iStorage instanceof ZipEntryStorage) {
                iFile = ((ZipEntryStorage)iStorage).getProject();
            } else if (iStorage instanceof LocalFileStorage) {
                iFile = ((LocalFileStorage)iStorage).getProject();
            }
        }
        PhpSourceParser.editFile.set(iFile);
        super.doSetInput(iEditorInput);
    }

    public PHPFileData getPHPFileData() {
        String string = this.getModel().getBaseLocation();
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
        return PHPWorkspaceModelManager.getInstance().getModelForProject(iFile.getProject()).getFileData(string);
    }

    public void setSelection(PHPCodeData pHPCodeData, boolean bl) {
        if (pHPCodeData != null) {
            IStructuredDocument iStructuredDocument;
            IStructuredDocumentRegion iStructuredDocumentRegion;
            UserData userData = pHPCodeData.getUserData();
            int n = userData.getStartPosition();
            int n2 = userData.getEndPosition() - userData.getStartPosition() + 1;
            IDocument iDocument = this.getSourceViewer().getDocument();
            if (iDocument instanceof IStructuredDocument && (iStructuredDocumentRegion = (iStructuredDocument = (IStructuredDocument)iDocument).getRegionAtCharacterOffset(n)) != null) {
                int n3 = iStructuredDocumentRegion.getStartOffset();
                ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
                String string = pHPCodeData.getName();
                if (pHPCodeData instanceof PHPVariableData) {
                    string = "$" + string;
                }
                while (iTextRegion != null && iTextRegion.getEnd() + n3 < n + n2) {
                    String string2 = iStructuredDocumentRegion.getText(iTextRegion).trim();
                    if (string.equals(string2)) {
                        n = iTextRegion.getStart() + n3;
                        n2 = iTextRegion.getTextLength();
                        break;
                    }
                    iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iTextRegion.getEnd() + n3);
                }
            }
            if (!bl) {
                this.getSourceViewer().setSelectedRange(n, n2);
            } else {
                this.selectAndReveal(n, n2);
            }
        }
    }

    public IFile getFile() {
        String string = this.getModel().getBaseLocation();
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
    }

    public SourceViewerConfiguration getSourceViwerConfiguration() {
        return super.getSourceViewerConfiguration();
    }

    public Object getAdapter(Class clazz) {
        Object object = super.getAdapter(clazz);
        if (object instanceof ConfigurableContentOutlinePage) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(clazz)) {
                ConfigurableContentOutlinePage configurableContentOutlinePage = (ConfigurableContentOutlinePage)object;
                configurableContentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){
                    boolean selecting = false;

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        ISelection iSelection;
                        if (selectionChangedEvent.getSelection().isEmpty() || this.selecting) {
                            return;
                        }
                        if (PHPStructuredEditor.this.getSourceViewer() != null && PHPStructuredEditor.this.getSourceViewer().getTextWidget() != null && !PHPStructuredEditor.this.getSourceViewer().getTextWidget().isDisposed() && !PHPStructuredEditor.this.getSourceViewer().getTextWidget().isFocusControl() && selectionChangedEvent.getSelection() instanceof IStructuredSelection && (iSelection = PHPStructuredEditor.this.getSelectionProvider().getSelection()) instanceof IStructuredSelection && !Arrays.equals(objectArray2 = ((IStructuredSelection)iSelection).toArray(), objectArray = ((IStructuredSelection)selectionChangedEvent.getSelection()).toArray()) && objectArray.length > 0) {
                            Object object = objectArray[0];
                            this.selecting = true;
                            if (object instanceof PHPCodeData) {
                                PHPStructuredEditor.this.setSelection((PHPCodeData)object, true);
                            }
                            this.selecting = false;
                        }
                    }
                });
            }
        }
        return object;
    }

    public void dispose() {
        super.dispose();
        if (this.foldingGroup != null) {
            this.foldingGroup.dispose();
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.rulerContextMenuAboutToShow(iMenuManager);
        MenuManager menuManager = new MenuManager(PHPEditorMessages.PHP_Editor_FoldingMenu_name, "projection");
        iMenuManager.appendToGroup("rulers", (IContributionItem)menuManager);
        IAction iAction = this.getAction("FoldingToggle");
        menuManager.add(iAction);
        iAction = this.getAction("FoldingExpandAll");
        menuManager.add(iAction);
    }

    protected void createActions() {
        super.createActions();
        this.foldingGroup = new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getTextViewer());
        ResourceBundle resourceBundle = ActionMessages.getResourceBundle();
        ISourceViewer iSourceViewer = this.getSourceViewer();
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        TextEditorAction textEditorAction = new ToggleCommentAction(resourceBundle, "ToggleCommentAction_", (ITextEditor)this);
        textEditorAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.toggle.comment");
        this.setAction("org.eclipse.php.ui.actions.ToggleCommentAction", (IAction)textEditorAction);
        this.markAsStateDependentAction("org.eclipse.php.ui.actions.ToggleCommentAction", true);
        textEditorAction.configure(iSourceViewer, sourceViewerConfiguration);
        textEditorAction = new AddBlockCommentAction(resourceBundle, "AddBlockCommentAction_", (ITextEditor)this);
        textEditorAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.add.block.comment");
        this.setAction("org.eclipse.php.ui.actions.AddBlockComment", (IAction)textEditorAction);
        this.markAsStateDependentAction("org.eclipse.php.ui.actions.AddBlockComment", true);
        this.markAsSelectionDependentAction("org.eclipse.php.ui.actions.AddBlockComment", true);
        ((BlockCommentAction)textEditorAction).configure(iSourceViewer, sourceViewerConfiguration);
        textEditorAction = new RemoveBlockCommentAction(resourceBundle, "RemoveBlockCommentAction_", (ITextEditor)this);
        textEditorAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.remove.block.comment");
        this.setAction("org.eclipse.php.ui.actions.RemoveBlockComment", (IAction)textEditorAction);
        this.markAsStateDependentAction("org.eclipse.php.ui.actions.RemoveBlockComment", true);
        ((BlockCommentAction)textEditorAction).configure(iSourceViewer, sourceViewerConfiguration);
        textEditorAction = new TextOperationAction(resourceBundle, "CommentAction_", (ITextEditor)this, 11);
        textEditorAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.comment");
        this.setAction("org.eclipse.php.ui.actions.Comment", (IAction)textEditorAction);
        this.markAsStateDependentAction("org.eclipse.php.ui.actions.Comment", true);
        textEditorAction = new TextOperationAction(resourceBundle, "UncommentAction_", (ITextEditor)this, 11);
        textEditorAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.uncomment");
        this.setAction("org.eclipse.php.ui.actions.Uncomment", (IAction)textEditorAction);
        this.markAsStateDependentAction("org.eclipse.php.ui.actions.Uncomment", true);
        textEditorAction = new OpenFunctionsManualAction(resourceBundle, this);
        textEditorAction.setActionDefinitionId("org.eclipse.php.ui.edit.OpenFunctionsManualAction");
        this.setAction("org.eclipse.php.ui.actions.OpenFunctionsManualAction", (IAction)textEditorAction);
        this.markAsStateDependentAction("org.eclipse.php.ui.actions.OpenFunctionsManualAction", true);
        textEditorAction = new OpenDeclarationAction(resourceBundle, this);
        textEditorAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.open.editor");
        this.setAction("org.eclipse.php.ui.actions.Open", (IAction)textEditorAction);
        this.markAsStateDependentAction("org.eclipse.php.ui.actions.Open", true);
        Object object = new TextOperationAction(ActionMessages.getBundleForConstructedKeys(), "ShowPHPDoc.", (ITextEditor)this, 16, true);
        object = new InformationDispatchAction(ActionMessages.getBundleForConstructedKeys(), "ShowPHPDoc.", (TextOperationAction)object);
        object.setActionDefinitionId("org.eclipse.php.ui.edit.text.show.phpdoc");
        this.setAction("ShowPHPDoc", (IAction)object);
    }

    protected void addContextMenuActions(IMenuManager iMenuManager) {
        super.addContextMenuActions(iMenuManager);
        if (this.getSourceViewer().isEditable()) {
            String string = PHPEditorMessages.PHPStructuredEditor_Source;
            MenuManager menuManager = new MenuManager(string, "org.eclipse.php.ui.source.menu");
            menuManager.add((IContributionItem)new GroupMarker("editGroup"));
            this.addAction((IMenuManager)menuManager, "org.eclipse.php.ui.actions.ToggleCommentAction");
            this.addAction((IMenuManager)menuManager, "org.eclipse.php.ui.actions.AddBlockComment");
            this.addAction((IMenuManager)menuManager, "org.eclipse.php.ui.actions.RemoveBlockComment");
            iMenuManager.appendToGroup("group.edit", (IContributionItem)menuManager);
            String string2 = "group.open";
            iMenuManager.appendToGroup("group.edit", (IContributionItem)new Separator(string2));
            IAction iAction = this.getAction("org.eclipse.php.ui.actions.Open");
            if (iAction != null) {
                iMenuManager.appendToGroup(string2, iAction);
            }
            if ((iAction = this.getAction("org.eclipse.php.ui.actions.OpenFunctionsManualAction")) != null) {
                iMenuManager.appendToGroup(string2, iAction);
            }
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.php.ui.phpEditorScope"});
    }

    private void updateHoverBehavior() {
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        String[] stringArray = sourceViewerConfiguration.getConfiguredContentTypes(this.getSourceViewer());
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iSourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)iSourceViewer).removeTextHovers(string);
                int[] nArray = sourceViewerConfiguration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), string);
                if (nArray != null) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        int n3 = nArray[n2];
                        ITextHover iTextHover = sourceViewerConfiguration.getTextHover(iSourceViewer, string, n3);
                        ((ITextViewerExtension2)iSourceViewer).setTextHover(iTextHover, string, n3);
                        ++n2;
                    }
                } else {
                    ITextHover iTextHover = sourceViewerConfiguration.getTextHover(iSourceViewer, string);
                    ((ITextViewerExtension2)iSourceViewer).setTextHover(iTextHover, string, 255);
                }
            } else {
                iSourceViewer.setTextHover(sourceViewerConfiguration.getTextHover(iSourceViewer, string), string);
            }
            ++n;
        }
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private IRegion fHoverRegion;
        private Object fHoverInfo;
        private IInformationControlCreator fControlCreator;

        InformationProvider(IRegion iRegion, Object object, IInformationControlCreator iInformationControlCreator) {
            this.fHoverRegion = iRegion;
            this.fHoverInfo = object;
            this.fControlCreator = iInformationControlCreator;
        }

        public IRegion getSubject(ITextViewer iTextViewer, int n) {
            return this.fHoverRegion;
        }

        public String getInformation(ITextViewer iTextViewer, IRegion iRegion) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer iTextViewer, IRegion iRegion) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }
    }

    class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String string, TextOperationAction textOperationAction) {
            super(resourceBundle, string, (ITextEditor)PHPStructuredEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        public void run() {
            ITextViewerExtension4 iTextViewerExtension4;
            ISourceViewer iSourceViewer = PHPStructuredEditor.this.getSourceViewer();
            if (iSourceViewer == null) {
                this.fTextOperationAction.run();
                return;
            }
            if (iSourceViewer instanceof ITextViewerExtension4 && (iTextViewerExtension4 = (ITextViewerExtension4)iSourceViewer).moveFocusToWidgetToken()) {
                return;
            }
            if (iSourceViewer instanceof ITextViewerExtension2 && (iTextViewerExtension4 = ((ITextViewerExtension2)iSourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(iSourceViewer, (ITextHover)iTextViewerExtension4)) {
                return;
            }
            if (iSourceViewer instanceof ISourceViewerExtension3 && (iTextViewerExtension4 = ((ISourceViewerExtension3)iSourceViewer).getCurrentAnnotationHover()) != null && this.makeAnnotationHoverFocusable(iSourceViewer, (IAnnotationHover)iTextViewerExtension4)) {
                return;
            }
            this.fTextOperationAction.run();
        }

        private boolean makeTextHoverFocusable(ISourceViewer iSourceViewer, ITextHover iTextHover) {
            String string;
            IRegion iRegion;
            int n;
            block6: {
                Point point = ((ITextViewerExtension2)iSourceViewer).getHoverEventLocation();
                n = this.computeOffsetAtLocation((ITextViewer)iSourceViewer, point.x, point.y);
                if (n == -1) {
                    return false;
                }
                try {
                    iRegion = iTextHover.getHoverRegion((ITextViewer)iSourceViewer, n);
                    if (iRegion != null) break block6;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            String string2 = iTextHover.getHoverInfo((ITextViewer)iSourceViewer, iRegion);
            if (PHPStructuredEditor.this.messageDecorator != null && (string = PHPStructuredEditor.this.messageDecorator.getDecoratedMessage(string2)) != null && string.length() > 0) {
                string2 = string;
            }
            string = null;
            if (iTextHover instanceof IInformationProviderExtension2) {
                string = ((IInformationProviderExtension2)iTextHover).getInformationPresenterControlCreator();
            }
            InformationProvider informationProvider = new InformationProvider(iRegion, string2, (IInformationControlCreator)string);
            PHPStructuredEditor.this.fInformationPresenter.setOffset(n);
            PHPStructuredEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            PHPStructuredEditor.this.fInformationPresenter.setMargins(6, 6);
            String string3 = TextUtilities.getContentType((IDocument)iSourceViewer.getDocument(), (String)"org.eclipse.php.PHP_DOC", (int)n, (boolean)true);
            PHPStructuredEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, string3);
            PHPStructuredEditor.this.fInformationPresenter.showInformation();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean makeAnnotationHoverFocusable(ISourceViewer iSourceViewer, IAnnotationHover iAnnotationHover) {
            IVerticalRuler iVerticalRuler = PHPStructuredEditor.this.getVerticalRuler();
            int n = iVerticalRuler.getLineOfLastMouseButtonActivity();
            if (n == -1) {
                return false;
            }
            try {
                Object object;
                IAnnotationHoverExtension iAnnotationHoverExtension;
                if (iAnnotationHover instanceof IAnnotationHoverExtension) {
                    iAnnotationHoverExtension = (IAnnotationHoverExtension)iAnnotationHover;
                    ILineRange iLineRange = iAnnotationHoverExtension.getHoverLineRange(iSourceViewer, n);
                    if (iLineRange == null) {
                        return false;
                    }
                    object = iAnnotationHoverExtension.getHoverInfo(iSourceViewer, iLineRange, Integer.MAX_VALUE);
                } else {
                    object = iAnnotationHover.getHoverInfo(iSourceViewer, n);
                }
                iAnnotationHoverExtension = iSourceViewer.getDocument();
                int n2 = iAnnotationHoverExtension.getLineOffset(n);
                String string = TextUtilities.getContentType((IDocument)iAnnotationHoverExtension, (String)"org.eclipse.php.PHP_DOC", (int)n2, (boolean)true);
                IInformationControlCreator iInformationControlCreator = null;
                if ("org.eclipse.jface.text.source.projection.ProjectionAnnotationHover".equals(iAnnotationHover.getClass().getName())) {
                    iInformationControlCreator = new IInformationControlCreator(this){
                        final /* synthetic */ InformationDispatchAction this$1;
                        {
                            this.this$1 = informationDispatchAction;
                        }

                        public IInformationControl createInformationControl(Shell shell) {
                            int n = 0x14 | InformationDispatchAction.access$0(this.this$1).getOrientation();
                            int n2 = 768;
                            return new SourceViewerInformationControl(shell, n, n2);
                        }
                    };
                } else if (iAnnotationHover instanceof IInformationProviderExtension2) {
                    iInformationControlCreator = ((IInformationProviderExtension2)iAnnotationHover).getInformationPresenterControlCreator();
                } else if (iAnnotationHover instanceof IAnnotationHoverExtension) {
                    iInformationControlCreator = ((IAnnotationHoverExtension)iAnnotationHover).getHoverControlCreator();
                }
                InformationProvider informationProvider = new InformationProvider((IRegion)new Region(n2, 0), object, iInformationControlCreator);
                PHPStructuredEditor.this.fInformationPresenter.setOffset(n2);
                PHPStructuredEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
                PHPStructuredEditor.this.fInformationPresenter.setMargins(4, 0);
                PHPStructuredEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, string);
                PHPStructuredEditor.this.fInformationPresenter.showInformation();
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        private int computeOffsetAtLocation(ITextViewer iTextViewer, int n, int n2) {
            StyledText styledText = iTextViewer.getTextWidget();
            IDocument iDocument = iTextViewer.getDocument();
            if (iDocument == null) {
                return -1;
            }
            try {
                int n3 = styledText.getOffsetAtLocation(new Point(n, n2));
                Point point = styledText.getLocationAtOffset(n3);
                if (point.x > n) {
                    --n3;
                }
                if (iTextViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iTextViewer;
                    return iTextViewerExtension5.widgetOffset2ModelOffset(n3);
                }
                IRegion iRegion = iTextViewer.getVisibleRegion();
                return n3 + iRegion.getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }

        static /* synthetic */ PHPStructuredEditor access$0(InformationDispatchAction informationDispatchAction) {
            return informationDispatchAction.PHPStructuredEditor.this;
        }
    }
}

