/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.configuration;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.core.format.HTMLFormatProcessorForPhp;
import org.eclipse.php.core.format.PhpFormatProcessorImpl;
import org.eclipse.php.core.util.WeakPropertyChangeListener;
import org.eclipse.php.internal.ui.autoEdit.CaseDefualtAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.CurlyCloseAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.CurlyOpenAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.DocBlockAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.IndentLineAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.MatchingBracketAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.QuotesAutoEditStrategy;
import org.eclipse.php.internal.ui.editor.PHPCodeHyperlinkDetector;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.editor.contentassist.IContentAssistProccesorForPHP;
import org.eclipse.php.ui.editor.contentassist.PHPContentAssistProcessor;
import org.eclipse.php.ui.editor.contentassist.PHPDocContentAssistProcessor;
import org.eclipse.php.ui.editor.highlighter.PHPLineStyleProvider;
import org.eclipse.php.ui.editor.hover.IHyperlinkDetectorForPHP;
import org.eclipse.php.ui.editor.hover.PHPTextHoverProxy;
import org.eclipse.php.ui.preferences.PreferenceConstants;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.contentassist.StructuredContentAssistant;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;

public class PHPStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationHTML {
    private String[] configuredContentTypes;
    private LineStyleProvider fLineStyleProvider;
    private IPropertyChangeListener propertyChangeListener;
    private ArrayList processors = new ArrayList();
    private ArrayList detectors = new ArrayList();
    private static IAutoEditStrategy indentLineAutoEditStrategy = new IndentLineAutoEditStrategy();
    private static IAutoEditStrategy curlyOpenAutoEditStrategy = new CurlyOpenAutoEditStrategy();
    private static IAutoEditStrategy curlyCloseAutoEditStrategy = new CurlyCloseAutoEditStrategy();
    private static IAutoEditStrategy matchingBAutoEditStrategy = new MatchingBracketAutoEditStrategy();
    private static IAutoEditStrategy quotesAutoEditStrategy = new QuotesAutoEditStrategy();
    private static IAutoEditStrategy caseDefualtAutoEditStrategy = new CaseDefualtAutoEditStrategy();
    private static IAutoEditStrategy docBlockAutoEditStrategy = new DocBlockAutoEditStrategy();
    private static IAutoEditStrategy[] defaultStrategies = new IAutoEditStrategy[]{indentLineAutoEditStrategy, curlyOpenAutoEditStrategy, curlyCloseAutoEditStrategy, matchingBAutoEditStrategy, quotesAutoEditStrategy, caseDefualtAutoEditStrategy};
    private static IAutoEditStrategy[] quotesStrategies = new IAutoEditStrategy[]{quotesAutoEditStrategy};
    private static IAutoEditStrategy[] docBlockStrategies = new IAutoEditStrategy[]{docBlockAutoEditStrategy};

    public PHPStructuredTextViewerConfiguration() {
        Object object;
        Object object2;
        IConfigurationElement iConfigurationElement;
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.ui.contentAssistProccesorForPHP");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("ContentAssistProccesorForPHP") && (object2 = ((ContentAssistProccesorProxy)(object = new ContentAssistProccesorProxy(iConfigurationElement))).getProcessor()) != null) {
                this.processors.add(object2);
            }
            ++n;
        }
        this.detectors.add(new PHPCodeHyperlinkDetector());
        iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.ui.hyperlinkDetectorForPHP");
        n = 0;
        while (n < iConfigurationElementArray.length) {
            iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("HyperlinkDetectorForPHP") && (object2 = ((HyperlinkDetectorProxy)(object = new HyperlinkDetectorProxy(iConfigurationElement))).getDetector()) != null) {
                this.detectors.add(object2);
            }
            ++n;
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        if (this.configuredContentTypes == null) {
            String[] stringArray = PHPStructuredTextPartitioner.getConfiguredContentTypes();
            String[] stringArray2 = StructuredTextPartitionerForXML.getConfiguredContentTypes();
            String[] stringArray3 = StructuredTextPartitionerForHTML.getConfiguredContentTypes();
            this.configuredContentTypes = new String[2 + stringArray.length + stringArray2.length + stringArray3.length];
            this.configuredContentTypes[0] = "org.eclipse.wst.sse.ST_DEFAULT";
            this.configuredContentTypes[1] = "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
            int n = 0;
            System.arraycopy(stringArray, 0, this.configuredContentTypes, n += 2, stringArray.length);
            System.arraycopy(stringArray2, 0, this.configuredContentTypes, n += stringArray.length, stringArray2.length);
            System.arraycopy(stringArray3, 0, this.configuredContentTypes, n += stringArray2.length, stringArray3.length);
        }
        return this.configuredContentTypes;
    }

    public LineStyleProvider getLineStyleProvider() {
        if (this.fLineStyleProvider == null) {
            this.fLineStyleProvider = new PHPLineStyleProvider();
        }
        return this.fLineStyleProvider;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer iSourceViewer, String string) {
        if (string == "org.eclipse.php.PHP_DEFAULT" || string == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || string == "org.eclipse.php.PHP_QUOTED_STRING" || string == "org.eclipse.php.PHP_SINGLE_LINE_COMMENT" || string == "org.eclipse.php.PHP_DOC") {
            LineStyleProvider[] lineStyleProviderArray = new LineStyleProvider[]{this.getLineStyleProvider()};
            return lineStyleProviderArray;
        }
        return super.getLineStyleProviders(iSourceViewer, string);
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer iSourceViewer, String string) {
        IContentAssistProcessor[] iContentAssistProcessorArray = null;
        ArrayList arrayList = this.getProcessorsForPartition(string);
        if (string == "org.eclipse.php.PHP_DEFAULT" || string == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || string == "org.eclipse.php.PHP_QUOTED_STRING" || string == "org.eclipse.php.PHP_SINGLE_LINE_COMMENT") {
            arrayList.add(0, new PHPContentAssistProcessor());
        } else if (string == "org.eclipse.php.PHP_DOC") {
            arrayList.add(0, new PHPDocContentAssistProcessor());
        } else {
            iContentAssistProcessorArray = super.getContentAssistProcessors(iSourceViewer, string);
        }
        if (iContentAssistProcessorArray == null) {
            iContentAssistProcessorArray = new IContentAssistProcessor[arrayList.size()];
            arrayList.toArray(iContentAssistProcessorArray);
        }
        this.configureContentAssistant(iSourceViewer);
        return iContentAssistProcessorArray;
    }

    private ArrayList getProcessorsForPartition(String string) {
        ArrayList<IContentAssistProccesorForPHP> arrayList = new ArrayList<IContentAssistProccesorForPHP>();
        int n = this.processors.size();
        int n2 = 0;
        while (n2 < n) {
            IContentAssistProccesorForPHP iContentAssistProccesorForPHP = (IContentAssistProccesorForPHP)this.processors.get(n2);
            String[] stringArray = iContentAssistProccesorForPHP.getSupportedPartitionsTypes();
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string2 = stringArray[n3];
                if (string2 == string) {
                    arrayList.add(iContentAssistProccesorForPHP);
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        return arrayList;
    }

    protected void setupPropertyChangeListener(final ISourceViewer iSourceViewer) {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getProperty();
                    if ("contentAssistAutoinsert".equals(string) || "contentAssistAutoactivation".equals(string) || "contentAssistAutoactivationDelay".equals(string)) {
                        PHPStructuredTextViewerConfiguration.this.configureContentAssistant(iSourceViewer);
                    }
                }
            };
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)WeakPropertyChangeListener.create((IPropertyChangeListener)this.propertyChangeListener, (Object)PreferenceConstants.getPreferenceStore()));
        }
    }

    protected void configureContentAssistant(ISourceViewer iSourceViewer) {
        this.setupPropertyChangeListener(iSourceViewer);
        IContentAssistant iContentAssistant = this.getContentAssistant(iSourceViewer);
        if (iContentAssistant instanceof StructuredContentAssistant) {
            StructuredContentAssistant structuredContentAssistant = (StructuredContentAssistant)iContentAssistant;
            structuredContentAssistant.enableAutoInsert(PreferenceConstants.getPreferenceStore().getBoolean("contentAssistAutoinsert"));
            structuredContentAssistant.enableAutoActivation(PreferenceConstants.getPreferenceStore().getBoolean("contentAssistAutoactivation"));
            structuredContentAssistant.setAutoActivationDelay(PreferenceConstants.getPreferenceStore().getInt("contentAssistAutoactivationDelay"));
        }
    }

    public String[] getDefaultPrefixes(ISourceViewer iSourceViewer, String string) {
        return new String[]{"//", "#", ""};
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer iSourceViewer, String string) {
        PHPEditorTextHoverDescriptor[] pHPEditorTextHoverDescriptorArray = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int[] nArray = new int[pHPEditorTextHoverDescriptorArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < pHPEditorTextHoverDescriptorArray.length) {
            if (pHPEditorTextHoverDescriptorArray[n2].isEnabled()) {
                int n3 = 0;
                int n4 = pHPEditorTextHoverDescriptorArray[n2].getStateMask();
                while (n3 < n) {
                    if (nArray[n3] == n4) break;
                    ++n3;
                }
                if (n3 == n) {
                    nArray[n++] = n4;
                }
            }
            ++n2;
        }
        if (n == pHPEditorTextHoverDescriptorArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string, int n) {
        if (!PHPStructuredTextPartitioner.isPHPPartitionType((String)string)) {
            return super.getTextHover(iSourceViewer, string, n);
        }
        PHPEditorTextHoverDescriptor[] pHPEditorTextHoverDescriptorArray = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int n2 = 0;
        while (n2 < pHPEditorTextHoverDescriptorArray.length) {
            if (pHPEditorTextHoverDescriptorArray[n2].isEnabled() && pHPEditorTextHoverDescriptorArray[n2].getStateMask() == n) {
                return new PHPTextHoverProxy(pHPEditorTextHoverDescriptorArray[n2], null);
            }
            ++n2;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        return this.getTextHover(iSourceViewer, string, 255);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer iSourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray = super.getHyperlinkDetectors(iSourceViewer);
        int n = iHyperlinkDetectorArray != null ? iHyperlinkDetectorArray.length : 0;
        IHyperlinkDetector[] iHyperlinkDetectorArray2 = new IHyperlinkDetector[n + this.detectors.size()];
        this.detectors.toArray(iHyperlinkDetectorArray2);
        System.arraycopy(iHyperlinkDetectorArray, 0, iHyperlinkDetectorArray2, this.detectors.size(), n);
        return iHyperlinkDetectorArray2;
    }

    public IContentFormatter getContentFormatter(ISourceViewer iSourceViewer) {
        MultiPassContentFormatter multiPassContentFormatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(iSourceViewer), "org.eclipse.php.PHP_DEFAULT");
        multiPassContentFormatter.setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new PhpFormatProcessorImpl()));
        multiPassContentFormatter.setSlaveStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new HTMLFormatProcessorForPhp()), "org.eclipse.wst.html.HTML_DEFAULT");
        return multiPassContentFormatter;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
        if (string.equals("org.eclipse.php.PHP_DEFAULT")) {
            return defaultStrategies;
        }
        if (string.equals("org.eclipse.php.PHP_QUOTED_STRING")) {
            return quotesStrategies;
        }
        if (string.equals("org.eclipse.php.PHP_DOC") || string.equals("org.eclipse.php.PHP_MULTI_LINE_COMMENT")) {
            return docBlockStrategies;
        }
        return super.getAutoEditStrategies(iSourceViewer, string);
    }

    private class ContentAssistProccesorProxy {
        IConfigurationElement element;
        IContentAssistProccesorForPHP processor;

        public ContentAssistProccesorProxy(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IContentAssistProccesorForPHP getProcessor() {
            if (this.processor == null) {
                Platform.run((ISafeRunnable)new SafeRunnable(this, "Error creation contentAssistProccesorForPHP for extension-point org.eclipse.php.ui.contentAssistProccesorForPHP"){
                    final /* synthetic */ ContentAssistProccesorProxy this$1;
                    {
                        this.this$1 = contentAssistProccesorProxy;
                        super(string);
                    }

                    public void run() throws Exception {
                        this.this$1.processor = (IContentAssistProccesorForPHP)this.this$1.element.createExecutableExtension("class");
                    }
                });
            }
            return this.processor;
        }
    }

    private class HyperlinkDetectorProxy {
        IConfigurationElement element;
        IHyperlinkDetectorForPHP detector;

        public HyperlinkDetectorProxy(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IHyperlinkDetectorForPHP getDetector() {
            if (this.detector == null) {
                Platform.run((ISafeRunnable)new SafeRunnable(this, "Error creation hyperlinkDetectorForPHP for extension-point org.eclipse.php.ui.hyperlinkDetectorForPHP"){
                    final /* synthetic */ HyperlinkDetectorProxy this$1;
                    {
                        this.this$1 = hyperlinkDetectorProxy;
                        super(string);
                    }

                    public void run() throws Exception {
                        this.this$1.detector = (IHyperlinkDetectorForPHP)this.this$1.element.createExecutableExtension("class");
                    }
                });
            }
            return this.detector;
        }
    }
}

