/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.contentassist;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.php.core.Logger;
import org.eclipse.php.core.documentModel.parser.PhpLexer;
import org.eclipse.php.ui.editor.util.TextSequence;
import org.eclipse.php.ui.editor.util.TextSequenceUtilities;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class PHPTextSequenceUtilities {
    private static final Pattern COMMENT_START_PATTERN = Pattern.compile("(/[*])|(//)");
    private static final Pattern COMMENT_END_PATTERN = Pattern.compile("[*]/");
    private static final String START_COMMENT = "/*";
    private static final String END_COMMENT = "*/";
    private static final char END_LINE = '\n';
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("function\\s", 2);
    private static final Pattern CLASS_PATTERN = Pattern.compile("(class|interface)\\s", 2);

    private PHPTextSequenceUtilities() {
    }

    public static TextSequence getStatment(int n, IStructuredDocumentRegion iStructuredDocumentRegion, boolean bl) {
        CharSequence charSequence;
        int n2 = iStructuredDocumentRegion.getStartOffset();
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion.getType() != "PHP_OPENTAG" && iStructuredDocumentRegion.getStartOffset(iTextRegion) == n) {
            iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n - 1);
        }
        iStructuredDocumentRegion.getParentDocument();
        while (iTextRegion != null && iTextRegion.getType() != "PHP_OPENTAG") {
            charSequence = iTextRegion.getType();
            int n3 = iStructuredDocumentRegion.getStartOffset(iTextRegion);
            if (charSequence == "PHP_SEMICOLON" || charSequence == "PHP_CURLY_OPEN" || charSequence == "PHP_CURLY_CLOSE") {
                n2 = n3 + 1;
                break;
            }
            iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n3 - 1);
        }
        charSequence = TextSequenceUtilities.createTextSequence(iStructuredDocumentRegion, n2, n - n2);
        if (bl) {
            charSequence = PHPTextSequenceUtilities.removeComments((TextSequence)charSequence);
        }
        charSequence = charSequence.subTextSequence(PHPTextSequenceUtilities.readForwardSpaces((TextSequence)charSequence, 0), charSequence.length());
        return charSequence;
    }

    private static TextSequence removeComments(TextSequence textSequence) {
        int n;
        while ((n = PHPTextSequenceUtilities.getCommentStartIndex(textSequence)) > -1) {
            String string = textSequence.subSequence(n, n + 2).toString();
            if (string.equals(START_COMMENT)) {
                Matcher matcher = COMMENT_END_PATTERN.matcher(textSequence);
                boolean bl = matcher.find(n);
                if (!bl) break;
                int n2 = matcher.end();
                textSequence = textSequence.cutTextSequence(n, n2);
                continue;
            }
            int n3 = n + 2;
            while (n3 < textSequence.length()) {
                if (textSequence.charAt(n3) == '\n') {
                    textSequence = textSequence.cutTextSequence(n, n3);
                }
                ++n3;
            }
            break block0;
        }
        return textSequence;
    }

    private static int getCommentStartIndex(TextSequence textSequence) {
        Matcher matcher = COMMENT_START_PATTERN.matcher(textSequence);
        int n = 0;
        while (matcher.find(n)) {
            String string = TextSequenceUtilities.getType(textSequence, matcher.start());
            if (string != null) {
                string.equals("");
            }
            if (!PhpLexer.isPHPCommentState((String)string) && !PhpLexer.isPHPQuotesState((String)string)) {
                return matcher.start();
            }
            n = matcher.start() + 2;
        }
        return -1;
    }

    public static ITextRegion getMultilineCommentStartRegion(IStructuredDocumentRegion iStructuredDocumentRegion, int n) {
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        ITextRegion iTextRegion2 = null;
        try {
            while (PhpLexer.isPHPMultiLineCommentState((String)iTextRegion.getType())) {
                if (iTextRegion.getType().equals("PHP_COMMENT_START")) {
                    iTextRegion2 = iTextRegion;
                    break;
                }
                iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iStructuredDocumentRegion.getStartOffset(iTextRegion) - 1);
            }
        }
        catch (Exception exception) {
            Logger.logException((Throwable)exception);
        }
        return iTextRegion2;
    }

    public static ITextRegion getMultilineCommentEndRegion(IStructuredDocumentRegion iStructuredDocumentRegion, int n) {
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        ITextRegion iTextRegion2 = null;
        try {
            while (PhpLexer.isPHPMultiLineCommentState((String)iTextRegion.getType())) {
                if (iTextRegion.getType().equals("PHP_COMMENT_END")) {
                    iTextRegion2 = iTextRegion;
                    break;
                }
                iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iStructuredDocumentRegion.getEndOffset(iTextRegion) + 1);
            }
        }
        catch (Exception exception) {
            Logger.logException((Throwable)exception);
        }
        return iTextRegion2;
    }

    public static int isInFunctionDeclaretion(TextSequence textSequence) {
        Matcher matcher = FUNCTION_PATTERN.matcher(textSequence);
        while (matcher.find()) {
            String string;
            int n = matcher.start();
            if (n != 0 && Character.isJavaIdentifierStart(textSequence.charAt(n - 1)) || !PhpLexer.isPHPRegularState((String)(string = TextSequenceUtilities.getType(textSequence, n + 1)))) continue;
            int n2 = matcher.end();
            while (n2 < textSequence.length()) {
                if (textSequence.charAt(n2) == ')' && PhpLexer.isPHPRegularState((String)(string = TextSequenceUtilities.getType(textSequence, n2)))) break;
                ++n2;
            }
            if (n2 != textSequence.length()) continue;
            return n;
        }
        return -1;
    }

    public static int isInClassDeclaretion(TextSequence textSequence) {
        Matcher matcher = CLASS_PATTERN.matcher(textSequence);
        while (matcher.find()) {
            int n;
            String string;
            int n2 = matcher.start();
            if (n2 != 0 && Character.isJavaIdentifierStart(textSequence.charAt(n2 - 1)) || !PhpLexer.isPHPRegularState((String)(string = TextSequenceUtilities.getType(textSequence, n2 + 1)))) continue;
            int n3 = n = matcher.end();
            while (n3 < textSequence.length()) {
                if (textSequence.charAt(n3) == '}' && PhpLexer.isPHPRegularState((String)(string = TextSequenceUtilities.getType(textSequence, n3)))) break;
                ++n3;
            }
            if (n3 != textSequence.length()) continue;
            return n;
        }
        return -1;
    }

    public static int readIdentifiarStartIndex(TextSequence textSequence, int n, boolean bl) {
        while (n > 0) {
            char c = textSequence.charAt(n - 1);
            if (!Character.isLetterOrDigit(c) && c != '_') break;
            --n;
        }
        if (bl && n > 0 && textSequence.charAt(n - 1) == '$') {
            --n;
        }
        return n;
    }

    public static int readIdentifiarEndIndex(TextSequence textSequence, int n, boolean bl) {
        int n2 = textSequence.length();
        if (bl && n < n2 && textSequence.charAt(n) == '$') {
            ++n;
        }
        while (n < n2) {
            char c = textSequence.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '_') break;
            ++n;
        }
        return n;
    }

    public static int readBackwardSpaces(TextSequence textSequence, int n) {
        int n2 = n;
        while (n2 > 0) {
            if (!Character.isWhitespace(textSequence.charAt(n2 - 1))) break;
            --n2;
        }
        return n2;
    }

    public static int readForwardSpaces(TextSequence textSequence, int n) {
        int n2 = n;
        while (n2 < textSequence.length()) {
            if (!Character.isWhitespace(textSequence.charAt(n2))) break;
            ++n2;
        }
        return n2;
    }

    public static int getPrivousTriggerIndex(TextSequence textSequence, int n) {
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            char c = textSequence.charAt(n2 - 1);
            if (!(Character.isLetterOrDigit(c) || c == '_' || Character.isWhitespace(c) && c != '\n')) {
                switch (c) {
                    case '(': 
                    case '[': 
                    case '{': {
                        if (--n3 >= 0) break;
                        return -1;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        ++n3;
                        break;
                    }
                    case ':': {
                        if (n3 != 0 || n2 < 2 || textSequence.charAt(n2 - 2) != ':') break;
                        return n2 - 2;
                    }
                    case '>': {
                        if (n3 != 0 || n2 < 2 || textSequence.charAt(n2 - 2) != '-') break;
                        return n2 - 2;
                    }
                    case '\n': {
                        return -1;
                    }
                    default: {
                        if (n3 != 0) break;
                        return -1;
                    }
                }
            }
            --n2;
        }
        return -1;
    }
}

