/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor.hover;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.editor.hover.AbstractPHPTextHover;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.ui.IEditorPart;

public class BestMatchHover
extends AbstractPHPTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private List fTextHoverSpecifications;
    private List fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        if (PHPUiPlugin.getActivePage() != null) {
            this.setEditorPart(PHPUiPlugin.getActivePage().getActiveEditor());
        }
        this.installTextHovers();
    }

    public BestMatchHover(IEditorPart iEditorPart) {
        this();
        this.setEditorPart(iEditorPart);
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList(2);
        this.fInstantiatedTextHovers = new ArrayList(2);
        PHPEditorTextHoverDescriptor[] pHPEditorTextHoverDescriptorArray = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int n = 0;
        while (n < pHPEditorTextHoverDescriptorArray.length) {
            if (!"org.eclipse.php.ui.editor.hover.BestMatchHover".equals(pHPEditorTextHoverDescriptorArray[n].getId())) {
                this.fTextHoverSpecifications.add(pHPEditorTextHoverDescriptorArray[n]);
            }
            ++n;
        }
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications.size() == 0) {
            return;
        }
        Iterator iterator = new ArrayList(this.fTextHoverSpecifications).iterator();
        while (iterator.hasNext()) {
            PHPEditorTextHoverDescriptor pHPEditorTextHoverDescriptor = (PHPEditorTextHoverDescriptor)iterator.next();
            IPHPTextHover iPHPTextHover = pHPEditorTextHoverDescriptor.createTextHover();
            if (iPHPTextHover == null) continue;
            iPHPTextHover.setEditorPart(this.getEditorPart());
            this.addTextHover(iPHPTextHover);
            this.fTextHoverSpecifications.remove(pHPEditorTextHoverDescriptor);
        }
    }

    protected void addTextHover(ITextHover iTextHover) {
        if (!this.fInstantiatedTextHovers.contains(iTextHover)) {
            this.fInstantiatedTextHovers.add(iTextHover);
        }
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        Iterator iterator = this.fInstantiatedTextHovers.iterator();
        while (iterator.hasNext()) {
            ITextHover iTextHover = (ITextHover)iterator.next();
            String string = iTextHover.getHoverInfo(iTextViewer, iRegion);
            if (string == null || string.trim().length() <= 0) continue;
            this.fBestHover = iTextHover;
            return string;
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

