/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.functions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.Logger;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.util.MultiElementSelection;
import org.eclipse.php.internal.ui.util.TreePath;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.explorer.ExplorerMessages;
import org.eclipse.php.ui.explorer.IMultiElementTreeContentProvider;
import org.eclipse.php.ui.explorer.PHPTreeViewer;
import org.eclipse.php.ui.functions.PHPFunctionsContentProvider;
import org.eclipse.php.ui.functions.PHPFunctionsLabelProvider;
import org.eclipse.php.ui.util.DecoratingPHPLabelProvider;
import org.eclipse.php.ui.util.EditorUtility;
import org.eclipse.php.ui.util.PHPElementLabels;
import org.eclipse.php.ui.util.PHPManualFactory;
import org.eclipse.php.ui.util.StatusBarUpdater;
import org.eclipse.php.ui.workingset.FunctionsViewGroup;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPFunctionsPart
extends ViewPart
implements IMenuListener,
IPartListener {
    private PHPTreeViewer fViewer;
    private PHPFunctionsContentProvider fContentProvider;
    private PHPFunctionsLabelProvider fLabelProvider;
    private Menu fContextMenu;
    private String fWorkingSetName;
    private Action showFunctionHelpAction;
    private FunctionsViewGroup actionGroup;

    public void createPartControl(Composite composite) {
        this.fViewer = this.createViewer(composite);
        this.fViewer.setUseHashlookup(true);
        this.setProviders();
        this.setUpPopupMenu();
        this.actionGroup = new FunctionsViewGroup(this);
        this.addDoubleClickListener();
        this.addMouseTrackListener();
        this.getSite().getPage().addPartListener((IPartListener)this);
        IStatusLineManager iStatusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(iStatusLineManager));
        this.updateTitle();
        IEditorPart iEditorPart = this.getViewSite().getPage().getActiveEditor();
        this.updateInputForCurrentEditor(iEditorPart);
        this.fViewer.refresh();
    }

    private void setUpPopupMenu() {
        this.showFunctionHelpAction = new ShowFunctionHelpAction();
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fViewer.getTree());
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                IStructuredSelection iStructuredSelection;
                ISelection iSelection = PHPFunctionsPart.this.fViewer.getSelection();
                if (!iSelection.isEmpty() && (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement() instanceof PHPFunctionData) {
                    iMenuManager.add((IAction)PHPFunctionsPart.this.showFunctionHelpAction);
                }
            }
        });
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        iWorkbenchPartSite.registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void updateInputForCurrentEditor(IEditorPart iEditorPart) {
        this.actionGroup.handleUpdateInput(iEditorPart);
    }

    private PHPTreeViewer createViewer(Composite composite) {
        return new FunctionsTreeViewer(composite, 772);
    }

    private void addMouseTrackListener() {
        final Tree tree = this.fViewer.getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent mouseEvent) {
                Object object;
                TreeItem treeItem = tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (treeItem != null && (object = treeItem.getData()) instanceof PHPCodeData) {
                    tree.setToolTipText(PHPFunctionsPart.this.fLabelProvider.getTooltipText(object));
                }
            }
        });
    }

    private void addDoubleClickListener() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IEditorPart iEditorPart = PHPFunctionsPart.this.getViewSite().getPage().getActiveEditor();
                StructuredSelection structuredSelection = (StructuredSelection)PHPFunctionsPart.this.fViewer.getSelection();
                if (iEditorPart != null && iEditorPart instanceof ITextEditor && structuredSelection != null && !structuredSelection.isEmpty() && structuredSelection.getFirstElement() instanceof PHPCodeData) {
                    PHPCodeData pHPCodeData = (PHPCodeData)structuredSelection.getFirstElement();
                    ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                    int n = ((ITextSelection)iTextEditor.getSelectionProvider().getSelection()).getOffset();
                    IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput());
                    try {
                        iDocument.replace(n, 0, pHPCodeData.getName());
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.logException(badLocationException);
                    }
                    iTextEditor.setFocus();
                    iTextEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(iDocument, n + pHPCodeData.getName().length(), 0));
                }
            }
        });
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    private void linkToEditor(IStructuredSelection iStructuredSelection) {
        IEditorPart iEditorPart;
        if (this != this.getSite().getPage().getActivePart()) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (iStructuredSelection.size() == 1 && (iEditorPart = EditorUtility.isOpenInEditor(object)) != null) {
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            if (object instanceof PHPCodeData) {
                EditorUtility.revealInEditor(iEditorPart, (PHPCodeData)object);
            }
        }
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingPHPLabelProvider(this.fLabelProvider, false));
    }

    void projectStateChanged(Object object) {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            this.fViewer.refresh(object, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }

    public PHPFunctionsContentProvider createContentProvider() {
        return new PHPFunctionsContentProvider();
    }

    private PHPFunctionsLabelProvider createLabelProvider() {
        return new PHPFunctionsLabelProvider(1090519051, 3, this.fContentProvider);
    }

    private Object findInputElement() {
        IAdaptable iAdaptable = this.getSite().getPage().getInput();
        if (iAdaptable instanceof IWorkspace || iAdaptable instanceof IWorkspaceRoot) {
            return PHPWorkspaceModelManager.getInstance();
        }
        if (iAdaptable instanceof IProject) {
            return PHPWorkspaceModelManager.getInstance().getModelForProject((IProject)iAdaptable);
        }
        if (iAdaptable instanceof IContainer) {
            return iAdaptable;
        }
        return PHPWorkspaceModelManager.getInstance();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        super.dispose();
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (this.getViewer().getTree().getVisible() && iWorkbenchPart instanceof PHPStructuredEditor) {
            this.updateInputForCurrentEditor((IEditorPart)iWorkbenchPart);
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        PHPUiPlugin.createStandardGroups(iMenuManager);
    }

    void editorActivated(IEditorPart iEditorPart) {
    }

    public TreeViewer getViewer() {
        return this.fViewer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.fViewer.getControl().setRedraw(true);
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    String getFrameName(Object object) {
        if (object instanceof PHPCodeData) {
            return ((PHPCodeData)object).getName();
        }
        return this.fLabelProvider.getText(object);
    }

    String getToolTipText(Object object) {
        Object object2;
        String string = !(object instanceof IResource) ? (object instanceof PHPWorkspaceModelManager ? ExplorerMessages.PHPExplorerPart_workspace : (object instanceof PHPCodeData ? PHPElementLabels.getTextLabel(object, 1090519051L) : this.fLabelProvider.getText(object))) : ((object2 = ((IResource)object).getFullPath()).isRoot() ? ExplorerMessages.PHPExplorer_title : object2.makeRelative().toString());
        if (this.fWorkingSetName == null) {
            return string;
        }
        object2 = MessageFormat.format(ExplorerMessages.PHPExplorer_toolTip, this.fWorkingSetName);
        if (string.length() == 0) {
            return object2;
        }
        return MessageFormat.format(ExplorerMessages.PHPExplorer_toolTip2, string, this.fWorkingSetName);
    }

    void updateTitle() {
        Object object = this.fViewer.getInput();
        if (object == null || object instanceof PHPWorkspaceModelManager) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String string = PHPElementLabels.getTextLabel(object, 1090519051L);
            this.setContentDescription(string);
            this.setTitleToolTip(this.getToolTipText(object));
        }
    }

    private class FunctionsTreeViewer
    extends PHPTreeViewer {
        List fPendingGetChildren;

        public FunctionsTreeViewer(Composite composite, int n) {
            super(composite, n);
            this.fPendingGetChildren = Collections.synchronizedList(new ArrayList());
        }

        public void add(Object object, Object[] objectArray) {
            if (this.fPendingGetChildren.contains(object)) {
                return;
            }
            super.add(object, objectArray);
        }

        protected Object[] getRawChildren(Object object) {
            Object[] objectArray;
            try {
                this.fPendingGetChildren.add(object);
                objectArray = super.getRawChildren(object);
                Object var2_3 = null;
                this.fPendingGetChildren.remove(object);
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.fPendingGetChildren.remove(object);
                throw throwable;
            }
            return objectArray;
        }

        private Object getElement(TreeItem treeItem) {
            Object object = treeItem.getData();
            if (object == null) {
                return null;
            }
            return object;
        }

        private TreePath createTreePath(TreeItem treeItem) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(treeItem.getData());
            TreeItem treeItem2 = treeItem.getParentItem();
            while (treeItem2 != null) {
                arrayList.add(treeItem2.getData());
                treeItem2 = treeItem2.getParentItem();
            }
            Collections.reverse(arrayList);
            return new TreePath(arrayList.toArray());
        }

        public ISelection getSelection() {
            IContentProvider iContentProvider = this.getContentProvider();
            if (!(iContentProvider instanceof IMultiElementTreeContentProvider)) {
                return super.getSelection();
            }
            Control control = this.getControl();
            if (control == null || control.isDisposed()) {
                return StructuredSelection.EMPTY;
            }
            Tree tree = this.getTree();
            TreeItem[] treeItemArray = tree.getSelection();
            ArrayList<Object> arrayList = new ArrayList<Object>(treeItemArray.length);
            ArrayList<TreePath> arrayList2 = new ArrayList<TreePath>();
            int n = 0;
            while (n < treeItemArray.length) {
                TreeItem treeItem = treeItemArray[n];
                Object object = this.getElement(treeItem);
                if (object != null) {
                    if (!arrayList.contains(object)) {
                        arrayList.add(object);
                    }
                    arrayList2.add(this.createTreePath(treeItem));
                }
                ++n;
            }
            return new MultiElementSelection((StructuredViewer)this, arrayList, arrayList2.toArray(new TreePath[arrayList2.size()]));
        }

        protected Object[] getFilteredChildren(Object object) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ViewerFilter[] viewerFilterArray = PHPFunctionsPart.this.fViewer.getFilters();
            if (PHPFunctionsPart.this.fViewer.getContentProvider() == null) {
                return new Object[0];
            }
            Object[] objectArray = ((ITreeContentProvider)PHPFunctionsPart.this.fViewer.getContentProvider()).getChildren(object);
            int n = 0;
            while (objectArray != null && n < objectArray.length) {
                Object object2 = objectArray[n];
                if (!this.isEssential(object2)) {
                    if ((object2 = this.filter(object2, object, viewerFilterArray)) != null) {
                        arrayList.add(object2);
                    }
                } else {
                    arrayList.add(object2);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        public boolean isExpandable(Object object) {
            ViewerFilter[] viewerFilterArray = PHPFunctionsPart.this.fViewer.getFilters();
            Object[] objectArray = ((ITreeContentProvider)PHPFunctionsPart.this.fViewer.getContentProvider()).getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                Object object2 = objectArray[n];
                if (this.isEssential(object2)) {
                    return true;
                }
                if ((object2 = this.filter(object2, object, viewerFilterArray)) != null) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private Object filter(Object object, Object object2, ViewerFilter[] viewerFilterArray) {
            int n = 0;
            while (n < viewerFilterArray.length) {
                ViewerFilter viewerFilter = viewerFilterArray[n];
                if (!viewerFilter.select((Viewer)PHPFunctionsPart.this.fViewer, object2, object)) {
                    return null;
                }
                ++n;
            }
            return object;
        }

        protected Object[] filter(Object[] objectArray) {
            ViewerFilter[] viewerFilterArray = this.getFilters();
            if (viewerFilterArray == null || viewerFilterArray.length == 0) {
                return objectArray;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            Object object = this.getRoot();
            int n = 0;
            while (n < objectArray.length) {
                boolean bl = true;
                if (!this.isEssential(objectArray[n])) {
                    int n2 = 0;
                    while (n2 < viewerFilterArray.length) {
                        bl = viewerFilterArray[n2].select((Viewer)this, object, objectArray[n]);
                        if (!bl) break;
                        ++n2;
                    }
                }
                if (bl) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        private boolean isEssential(Object object) {
            if (object instanceof IContainer) {
                IContainer iContainer = (IContainer)object;
                try {
                    return iContainer.members().length > 0;
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            return false;
        }

        protected void handleInvalidSelection(ISelection iSelection, ISelection iSelection2) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            ArrayList<Object> arrayList = null;
            arrayList = iSelection2 instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)iSelection2).toList()) : new ArrayList<IProject>();
            boolean bl = false;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                IProject iProject;
                Object e = iterator.next();
                if (e instanceof PHPProjectModel) {
                    iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)e);
                    if (iProject.isOpen()) continue;
                    arrayList.add(iProject);
                    bl = true;
                    continue;
                }
                if (!(e instanceof IProject) || !(iProject = (IProject)e).isOpen()) continue;
                bl = true;
            }
            if (bl) {
                iSelection2 = new StructuredSelection(arrayList);
                this.setSelection(iSelection2);
            }
            super.handleInvalidSelection(iSelection, iSelection2);
        }
    }

    class ShowFunctionHelpAction
    extends Action {
        private final Pattern METHOD_PATTERN;

        public ShowFunctionHelpAction() {
            super("Open Manual");
            this.METHOD_PATTERN = Pattern.compile("([A-Z])");
        }

        public void run() {
            IStructuredSelection iStructuredSelection;
            ISelection iSelection = PHPFunctionsPart.this.fViewer.getSelection();
            if (!iSelection.isEmpty() && (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement() instanceof PHPFunctionData) {
                PHPFunctionData pHPFunctionData = (PHPFunctionData)iStructuredSelection.getFirstElement();
                PHPCodeData pHPCodeData = pHPFunctionData.getContainer();
                String string = "";
                if (pHPCodeData instanceof PHPClassData) {
                    Matcher matcher = this.METHOD_PATTERN.matcher(pHPFunctionData.getName());
                    string = String.valueOf(pHPCodeData.getName()) + "-" + matcher.replaceAll("-$1");
                } else {
                    string = pHPFunctionData.getName();
                }
                PHPManualFactory.getManual().showFunctionHelp(string);
            }
        }
    }
}

