/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.outline;

import java.util.ArrayList;
import org.eclipse.php.core.documentModel.PHPEditorModel;
import org.eclipse.php.core.documentModel.dom.PHPElementImpl;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.StandardPHPElementContentProvider;
import org.eclipse.php.ui.treecontent.PHPTreeNode;
import org.eclipse.php.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;

public class PHPOutlineContentProvider
extends JFaceNodeContentProvider {
    public static final int MODE_PHP = 1;
    public static final int MODE_HTML = 2;
    public static final int MODE_MIXED = 3;
    public static final int GROUP_CLASSES = 1;
    public static final int GROUP_CONSTANTS = 2;
    public static final int GROUP_FUNCTIONS = 3;
    public static final int GROUP_INCLUDES = 4;
    private static final Image CLASSES_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_CLASSES_GROUP.createImage();
    private static final Image CONSTANTS_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP.createImage();
    private static final Image FUNCTIONS_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_FUNCTIONS_GROUP.createImage();
    private static final Image INCLUDES_GROUP_IMAGE = PHPPluginImages.DESC_OBJS_INCLUDE.createImage();
    StandardPHPElementContentProvider phpContentProvider = new StandardPHPElementContentProvider(true);
    int mode = PHPUiPlugin.getDefault().getPreferenceStore().getInt("ChangeOutlineModeAction.selectedMode");
    boolean showGroups = false;

    public PHPOutlineContentProvider() {
        if (this.mode == 0) {
            this.mode = 1;
            PHPUiPlugin.getDefault().getPreferenceStore().setValue("ChangeOutlineModeAction.selectedMode", this.mode);
        }
    }

    public Object[] getChildren(Object object) {
        if (object instanceof PHPElementImpl && this.mode == 3) {
            ArrayList arrayList = this.getPHPChildren((PHPElementImpl)object);
            return arrayList.toArray();
        }
        if (object instanceof PHPCodeData) {
            return this.phpContentProvider.getChildren(object);
        }
        if (object instanceof PHPEditorModel && this.mode == 1) {
            PHPEditorModel pHPEditorModel = (PHPEditorModel)object;
            PHPFileData pHPFileData = pHPEditorModel.getFileData();
            if (this.showGroups) {
                Object[] objectArray = new Object[]{new GroupNode(1, "classes", pHPFileData), new GroupNode(3, "functions", pHPFileData), new GroupNode(2, "constants", pHPFileData), new GroupNode(4, "include files", pHPFileData)};
                return objectArray;
            }
            Object[] objectArray = this.phpContentProvider.getChildren(pHPFileData);
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
            objectArray2[0] = new GroupNode(4, "include files", pHPFileData);
            return objectArray2;
        }
        if (object instanceof GroupNode) {
            return ((GroupNode)object).getChildren();
        }
        if (object instanceof PHPTreeNode) {
            return ((PHPTreeNode)object).getChildren();
        }
        return super.getChildren(object);
    }

    public Object getParent(Object object) {
        if (object instanceof PHPCodeData) {
            PHPCodeData pHPCodeData = (PHPCodeData)object;
            return pHPCodeData.getContainer();
        }
        return super.getParent(object);
    }

    public Object[] getElements(Object object) {
        if (object instanceof PHPElementImpl && this.mode == 3) {
            ArrayList arrayList = this.getPHPChildren((PHPElementImpl)object);
            return arrayList.toArray();
        }
        if (object instanceof PHPCodeData) {
            return this.phpContentProvider.getElements(object);
        }
        if (object instanceof PHPEditorModel && this.mode == 1) {
            PHPEditorModel pHPEditorModel = (PHPEditorModel)object;
            PHPFileData pHPFileData = pHPEditorModel.getFileData();
            if (this.showGroups) {
                Object[] objectArray = new Object[]{new GroupNode(1, "classes", pHPFileData), new GroupNode(3, "functions", pHPFileData), new GroupNode(2, "constants", pHPFileData), new GroupNode(4, "include files", pHPFileData)};
                return objectArray;
            }
            Object[] objectArray = this.phpContentProvider.getElements(pHPFileData);
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
            objectArray2[0] = new GroupNode(4, "include files", pHPFileData);
            return objectArray2;
        }
        if (object instanceof GroupNode) {
            return ((GroupNode)object).getChildren();
        }
        return super.getElements(object);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof PHPElementImpl) {
            ArrayList arrayList = this.getPHPChildren((PHPElementImpl)object);
            return arrayList.size() > 0;
        }
        if (object instanceof PHPCodeData) {
            return this.phpContentProvider.hasChildren(object);
        }
        if (object instanceof GroupNode) {
            return ((GroupNode)object).hasChildren();
        }
        if (object instanceof PHPTreeNode) {
            return ((PHPTreeNode)object).hasChildren();
        }
        return super.hasChildren(object);
    }

    boolean isInside(int n, int n2, PHPCodeData pHPCodeData) {
        UserData userData = pHPCodeData.getUserData();
        if (userData == null) {
            return false;
        }
        return n <= userData.getStartPosition() && n2 >= userData.getEndPosition();
    }

    private ArrayList getPHPChildren(PHPElementImpl pHPElementImpl) {
        String string = pHPElementImpl.getModel().getBaseLocation();
        int n = pHPElementImpl.getStartOffset();
        int n2 = pHPElementImpl.getEndOffset();
        PHPFileData pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(string);
        ArrayList arrayList = this.getPHPChildren(pHPFileData, n, n2);
        return arrayList;
    }

    private ArrayList getPHPChildren(PHPFileData pHPFileData, int n, int n2) {
        PHPFunctionData[] pHPFunctionDataArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (pHPFileData == null) {
            return arrayList;
        }
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        if (pHPClassDataArray != null) {
            int n3 = 0;
            while (n3 < pHPClassDataArray.length) {
                if (this.isInside(n, n2, (PHPCodeData)pHPClassDataArray[n3])) {
                    arrayList.add(pHPClassDataArray[n3]);
                }
                ++n3;
            }
        }
        if ((pHPFunctionDataArray = pHPFileData.getFunctions()) != null) {
            int n4 = 0;
            while (n4 < pHPFunctionDataArray.length) {
                if (this.isInside(n, n2, (PHPCodeData)pHPFunctionDataArray[n4])) {
                    arrayList.add(pHPFunctionDataArray[n4]);
                }
                ++n4;
            }
        }
        return arrayList;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public boolean getShowGroups() {
        return this.showGroups;
    }

    public void setShowGroups(boolean bl) {
        this.showGroups = bl;
    }

    static class GroupNode {
        String text;
        Object[] children;
        PHPFileData fileData;
        int type;

        GroupNode(int n, String string, PHPFileData pHPFileData) {
            this.type = n;
            this.text = string;
            this.fileData = pHPFileData;
        }

        void loadChildren() {
            switch (this.type) {
                case 1: {
                    this.children = this.fileData.getClasses();
                    break;
                }
                case 3: {
                    this.children = this.fileData.getFunctions();
                    break;
                }
                case 2: {
                    this.children = this.fileData.getConstants();
                    break;
                }
                case 4: {
                    if (this.fileData != null) {
                        this.children = this.fileData.getIncludeFiles();
                        break;
                    }
                    this.children = new Object[0];
                    break;
                }
            }
        }

        public boolean hasChildren() {
            if (this.children == null) {
                this.loadChildren();
            }
            return this.children.length > 0;
        }

        public Object[] getChildren() {
            if (this.children == null) {
                this.loadChildren();
            }
            return this.children;
        }

        public String getText() {
            return this.text;
        }

        public Image getImage() {
            switch (this.type) {
                case 1: {
                    return CLASSES_GROUP_IMAGE;
                }
                case 3: {
                    return FUNCTIONS_GROUP_IMAGE;
                }
                case 2: {
                    return CONSTANTS_GROUP_IMAGE;
                }
                case 4: {
                    return INCLUDES_GROUP_IMAGE;
                }
            }
            return null;
        }
    }
}

