/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.core;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.php.server.apache.core.ApacheRuntime;
import org.eclipse.php.server.apache.core.ApacheServerConfiguration;
import org.eclipse.php.server.apache.core.Messages;
import org.eclipse.php.server.apache.core.Trace;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class ApacheServer
extends ServerDelegate
implements IURLProvider {
    public static final String PROPERTY_SECURE = "secure";
    public static final String PROPERTY_DEBUG = "debug";
    public static final String PROPERTY_TEST_ENVIRONMENT = "testEnvironment";
    public static final String BASE_URL = "base_url";
    public static final String DOCUMENT_ROOT = "document_root";
    public static final String PUBLISH = "publish";
    public static final String PORT = "port";
    protected transient ApacheServerConfiguration serverConfiguration;
    public static int count = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void initialize() {
        super.initialize();
    }

    public String getContextRoot(IProject iProject) {
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
        String string = (String)pHPProjectOptions.getOption("org.eclipse.php.core.contextRoot");
        if (string == null || string.equals("")) {
            string = iProject.getFullPath().toString();
        }
        return string;
    }

    public ApacheRuntime getApacheRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        IRuntime iRuntime = this.getServer().getRuntime();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ApacheRuntime)((Object)iRuntime.loadAdapter((Class)clazz, null));
    }

    public ApacheServerConfiguration getApacheServerConfiguration() {
        if (this.serverConfiguration == null) {
            this.serverConfiguration = new ApacheServerConfiguration(this);
        }
        return this.serverConfiguration;
    }

    public void importConfiguration(IRuntime iRuntime, IProgressMonitor iProgressMonitor) {
        this.serverConfiguration = new ApacheServerConfiguration(this);
    }

    public void saveConfiguration(IProgressMonitor iProgressMonitor) throws CoreException {
        ApacheServerConfiguration apacheServerConfiguration = this.getApacheServerConfiguration();
        if (apacheServerConfiguration == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.apache.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object)"null"), null));
        }
        apacheServerConfiguration.save(this.getServer().getServerConfiguration(), iProgressMonitor);
    }

    public void configurationChanged() {
        this.serverConfiguration = null;
    }

    public String getBaseURL() {
        return this.getAttribute(BASE_URL, "");
    }

    public void setBaseURL(String string) {
        this.setAttribute(BASE_URL, string);
    }

    public void setDocumentRoot(String string) {
        this.setAttribute(DOCUMENT_ROOT, string);
    }

    public String getDocumentRoot() {
        return this.getAttribute(DOCUMENT_ROOT, "");
    }

    public boolean canPublish() {
        return this.getAttribute(PUBLISH, false);
    }

    public void setPublish(boolean bl) {
        this.setAttribute(PUBLISH, bl);
    }

    public URL getModuleRootURL(IModule iModule) {
        try {
            String string = this.getPortString();
            IServer iServer = this.getServer();
            String string2 = this.getBaseURL();
            if (string2.equals("")) {
                string2 = "http://" + iServer.getHost();
            }
            URL uRL = null;
            uRL = string.equals("80") ? new URL(String.valueOf(string2) + "/") : new URL(String.valueOf(string2) + ":" + string + "/");
            return uRL;
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Could not get root URL", exception);
            return null;
        }
    }

    public boolean isDebug() {
        return this.getAttribute(PROPERTY_DEBUG, false);
    }

    public boolean isTestEnvironment() {
        return false;
    }

    public boolean isSecure() {
        return this.getAttribute(PROPERTY_SECURE, false);
    }

    protected static String renderCommandLine(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(string);
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "ApacheServer";
    }

    public IModule[] getChildModules(IModule[] iModuleArray) {
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule iModule) throws CoreException {
        return new IModule[]{iModule};
    }

    public IStatus canModifyModules(IModule[] iModuleArray, IModule[] iModuleArray2) {
        return new Status(0, "org.eclipse.php.server.apache.core", 0, "%canModifyModules", null);
    }

    public ServerPort[] getServerPorts() {
        int n = this.getPort();
        ServerPort[] serverPortArray = new ServerPort[]{new ServerPort(null, null, n, "http")};
        return serverPortArray;
    }

    public int getPort() {
        String string = this.getAttribute(PORT, "80");
        return Integer.parseInt(string);
    }

    public String getPortString() {
        return this.getAttribute(PORT, "80");
    }

    public void setPort(String string) {
        try {
            if (string.equals("")) {
                this.setAttribute(PORT, "80");
            } else {
                this.setAttribute(PORT, string);
            }
        }
        catch (Throwable throwable) {}
    }

    public void setDefaults(IProgressMonitor iProgressMonitor) {
        this.setTestEnvironment(true);
    }

    public void setDebug(boolean bl) {
        this.setAttribute(PROPERTY_DEBUG, bl);
    }

    public void setSecure(boolean bl) {
        this.setAttribute(PROPERTY_SECURE, bl);
    }

    public void setTestEnvironment(boolean bl) {
        this.setAttribute(PROPERTY_TEST_ENVIRONMENT, bl);
    }

    public void modifyModules(IModule[] iModuleArray, IModule[] iModuleArray2, IProgressMonitor iProgressMonitor) throws CoreException {
    }

    public static IServer createApacheServer(String string, String string2, String string3) {
        int n;
        String string4 = string2;
        if (string2.startsWith("http://")) {
            string4 = string4.substring(7);
        }
        if ((n = string4.indexOf("/")) != -1) {
            string4 = string4.substring(0, n - 1);
        }
        if ((n = string4.indexOf(":")) != -1) {
            string4 = string4.substring(0, n - 1);
        }
        IServer iServer = null;
        try {
            ApacheServer apacheServer;
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            IRuntimeType iRuntimeType = ServerCore.findRuntimeType((String)"org.eclipse.php.server.apache.runtime.13");
            IRuntimeWorkingCopy iRuntimeWorkingCopy = iRuntimeType.createRuntime("org.eclipse.php.server.apache.runtime.13", (IProgressMonitor)nullProgressMonitor);
            iRuntimeWorkingCopy.save(true, (IProgressMonitor)nullProgressMonitor);
            IRuntime iRuntime = iRuntimeWorkingCopy.getOriginal();
            IServerType iServerType = ServerCore.findServerType((String)"org.eclipse.php.server.apache.13");
            IServerWorkingCopy iServerWorkingCopy = iServerType.createServer(string3, null, iRuntime, (IProgressMonitor)nullProgressMonitor);
            iServerWorkingCopy.setName(string);
            iServerWorkingCopy.setHost(string4);
            iServerWorkingCopy.save(true, (IProgressMonitor)nullProgressMonitor);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((apacheServer = (ApacheServer)((Object)iServerWorkingCopy.getAdapter((Class)clazz))) == null) {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                apacheServer = (ApacheServer)((Object)iServerWorkingCopy.loadAdapter((Class)clazz2, null));
            }
            apacheServer.setBaseURL(string2);
            apacheServer.saveConfiguration(null);
            iServerWorkingCopy.save(true, (IProgressMonitor)nullProgressMonitor);
            iServer = iServerWorkingCopy.getOriginal();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return iServer;
    }

    public static IServer checkForApacheServer(String string) {
        IServer[] iServerArray = ServerCore.getServers();
        int n = 0;
        while (n < iServerArray.length) {
            if (iServerArray[n].getId().equals(string)) {
                return iServerArray[n];
            }
            ++n;
        }
        return null;
    }

    public static void updateBaseURL(String string, String string2) {
        ApacheServer.updateBaseURL(ApacheServer.checkForApacheServer(string), string2);
    }

    public static void updateBaseURL(IServer iServer, String string) {
        String string2;
        ApacheServer apacheServer;
        if (iServer == null) {
            return;
        }
        IServerWorkingCopy iServerWorkingCopy = iServer.createWorkingCopy();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((apacheServer = (ApacheServer)((Object)iServerWorkingCopy.getAdapter((Class)clazz))) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            apacheServer = (ApacheServer)((Object)iServerWorkingCopy.loadAdapter((Class)clazz2, null));
        }
        if ((string2 = apacheServer.getBaseURL()).equals(string)) {
            return;
        }
        apacheServer.setBaseURL(string);
        try {
            apacheServer.saveConfiguration(null);
            iServerWorkingCopy.save(true, null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }
}

