/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.php.server.apache.core.ApacheRuntime;
import org.eclipse.php.server.apache.core.ApacheServer;
import org.eclipse.php.server.apache.core.FileUtil;
import org.eclipse.php.server.apache.core.PingThread;
import org.eclipse.php.server.apache.core.ProgressUtil;
import org.eclipse.php.server.apache.core.Trace;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.ProjectModule;

public class ApacheServerBehaviour
extends ServerBehaviourDelegate {
    protected transient PingThread ping = null;
    protected transient IProcess process;
    protected transient IDebugEventSetListener processListener;
    protected ILaunch currentLaunch = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void initialize(IProgressMonitor iProgressMonitor) {
    }

    public ApacheRuntime getApacheRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        IRuntime iRuntime = this.getServer().getRuntime();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ApacheRuntime)((Object)iRuntime.loadAdapter((Class)clazz, null));
    }

    public ApacheServer getApacheServer() {
        IServer iServer = this.getServer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ApacheServer)((Object)iServer.getAdapter((Class)clazz));
    }

    public IPath getRuntimeBaseDirectory() {
        return this.getServer().getRuntime().getLocation();
    }

    protected String[] getRuntimeProgramArguments(boolean bl) {
        return null;
    }

    public void setProcess(IProcess iProcess) {
        if (this.process != null) {
            return;
        }
        this.process = iProcess;
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
        }
        if (iProcess == null) {
            return;
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] debugEventArray) {
                if (debugEventArray != null) {
                    int n = debugEventArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = debugEventArray[n2].getSource();
                        if (object instanceof IDebugTarget) {
                            IDebugTarget iDebugTarget = (IDebugTarget)object;
                            IProcess iProcess = iDebugTarget.getProcess();
                            if (ApacheServerBehaviour.this.process != null && ApacheServerBehaviour.this.process.equals(iProcess) && debugEventArray[n2].getKind() == 8) {
                                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                            }
                        }
                        ++n2;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    protected void setServerStarted() {
        this.setServerState(2);
    }

    protected void stopImpl() {
        if (this.process != null) {
            this.process = null;
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
            this.processListener = null;
        }
        this.setServerState(4);
    }

    protected void publishServer(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = ProgressUtil.getMonitorFor(iProgressMonitor);
        iProgressMonitor.done();
        this.setServerPublishState(1);
    }

    public boolean publish(IModule iModule, IProgressMonitor iProgressMonitor) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule projectModule = (ProjectModule)iModule.loadAdapter((Class)clazz, null);
        IPath iPath = projectModule.getProject().getLocation();
        ApacheServer apacheServer = this.getApacheServer();
        String string = null;
        if (this.currentLaunch != null) {
            iLaunchConfiguration = this.currentLaunch.getLaunchConfiguration();
            string = iLaunchConfiguration.getAttribute("context_root", string);
        } else {
            string = projectModule.getProject().getName();
        }
        iLaunchConfiguration = new Path(apacheServer.getDocumentRoot());
        if (string != null && !string.equals("")) {
            iLaunchConfiguration = iLaunchConfiguration.append(string);
        }
        String string2 = iPath.toOSString();
        String string3 = iLaunchConfiguration.toOSString();
        return FileUtil.smartCopyDirectory(string2, string3, iProgressMonitor);
    }

    protected void publishModule(int n, int n2, IModule[] iModuleArray, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iModuleArray != null) {
            this.publish(iModuleArray[0], iProgressMonitor);
        }
        this.setModulePublishState(iModuleArray, 1);
    }

    public void setupLaunch(ILaunch iLaunch, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        if ("true".equals(iLaunch.getLaunchConfiguration().getAttribute("stop-server", "false"))) {
            return;
        }
        this.setMode("run");
        this.currentLaunch = iLaunch;
    }

    public void restart(String string) throws CoreException {
        this.setServerState(4);
        this.setServerState(2);
    }

    public void stop(boolean bl) {
        this.setServerState(4);
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            this.setServerState(3);
            Trace.trace(Trace.FINER, "Killing the Apache process");
            if (this.process != null && !this.process.isTerminated()) {
                this.process.terminate();
                this.stopImpl();
            }
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Error killing the process", exception);
        }
    }

    public IPath getTempDirectory() {
        return super.getTempDirectory();
    }

    public String toString() {
        return "ApacheServer";
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, IProgressMonitor iProgressMonitor) throws CoreException {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.server.apache.corestart-server", true);
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(IModule[] iModuleArray) {
        return super.getPublishedResourceDelta(iModuleArray);
    }

    public void handleResourceChange() {
    }
}

