/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.server.apache.core.Messages;
import org.eclipse.php.server.apache.core.ProgressUtil;
import org.eclipse.php.server.apache.core.Trace;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileUtil {
    private static final int BUFFER = 10240;
    private static byte[] buf = new byte[10240];

    private FileUtil() {
    }

    public static void copyDirectory(String string, String string2, IProgressMonitor iProgressMonitor) {
        try {
            File file = new File(string);
            File file2 = new File(string2);
            File[] fileArray = file.listFiles();
            file2.mkdir();
            int n = fileArray.length;
            iProgressMonitor = ProgressUtil.getMonitorFor(iProgressMonitor);
            iProgressMonitor.beginTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{string, string2}), n * 50);
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray[n2];
                String string3 = file3.getAbsolutePath();
                String string4 = string2;
                if (!string4.endsWith(File.separator)) {
                    string4 = String.valueOf(string4) + File.separator;
                }
                string4 = String.valueOf(string4) + file3.getName();
                if (file3.isFile()) {
                    FileUtil.copyFile(string3, string4);
                    iProgressMonitor.worked(50);
                } else if (file3.isDirectory()) {
                    iProgressMonitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{string3, string4}));
                    FileUtil.copyDirectory(string3, string4, ProgressUtil.getSubMonitorFor(iProgressMonitor, 50));
                }
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                ++n2;
            }
            iProgressMonitor.done();
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Error copying directory", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus copyFile(InputStream inputStream, String string) {
        Status status;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(string);
                int n = inputStream.read(buf);
                while (true) {
                    if (n <= 0) {
                        status = new Status(0, "org.eclipse.php.server.apache.core", 0, NLS.bind((String)Messages.copyingTask, (Object[])new String[]{string}), null);
                        Object var4_7 = null;
                        break;
                    }
                    ((OutputStream)fileOutputStream).write(buf, 0, n);
                    n = inputStream.read(buf);
                }
            }
            catch (Exception exception) {
                Trace.trace(Trace.SEVERE, "Error copying file", exception);
                Status status2 = new Status(4, "org.eclipse.php.server.apache.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{string, exception.getLocalizedMessage()}), (Throwable)exception);
                Object var4_8 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception2) {}
                try {
                    if (fileOutputStream == null) return status2;
                    ((OutputStream)fileOutputStream).close();
                    return status2;
                }
                catch (Exception exception3) {}
                return status2;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {}
            catch (Exception exception) {}
            if (inputStream != null) {
                inputStream.close();
            }
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            if (fileOutputStream == null) throw throwable;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (inputStream != null) {
            inputStream.close();
        }
        try {}
        catch (Exception exception) {}
        if (fileOutputStream == null) return status;
        ((OutputStream)fileOutputStream).close();
        return status;
    }

    public static IStatus copyFile(String string, String string2) {
        try {
            return FileUtil.copyFile(new FileInputStream(string), string2);
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Error copying file", exception);
            return new Status(4, "org.eclipse.php.server.apache.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{string2, exception.getLocalizedMessage()}), (Throwable)exception);
        }
    }

    public static IStatus copyFile(URL uRL, String string) {
        try {
            return FileUtil.copyFile(uRL.openStream(), string);
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Error copying file", exception);
            return new Status(4, "org.eclipse.php.server.apache.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{string, exception.getLocalizedMessage()}), (Throwable)exception);
        }
    }

    public static void deleteDirectory(File file, IProgressMonitor iProgressMonitor) {
        try {
            if (!file.exists() || !file.isDirectory()) {
                return;
            }
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            iProgressMonitor = ProgressUtil.getMonitorFor(iProgressMonitor);
            iProgressMonitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{file.getAbsolutePath()}), n * 10);
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2.isFile()) {
                    file2.delete();
                    iProgressMonitor.worked(10);
                } else if (file2.isDirectory()) {
                    iProgressMonitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{file2.getAbsolutePath()}));
                    FileUtil.deleteDirectory(file2, ProgressUtil.getSubMonitorFor(iProgressMonitor, 10));
                }
                ++n2;
            }
            file.delete();
            iProgressMonitor.done();
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Error deleting directory " + file.getAbsolutePath(), exception);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean smartCopyDirectory(String string, String string2, IProgressMonitor iProgressMonitor) {
        try {
            int n;
            int n2;
            int n3;
            File file = new File(string);
            File file2 = new File(string2);
            File[] fileArray = file.listFiles();
            int n4 = fileArray.length;
            iProgressMonitor = ProgressUtil.getMonitorFor(iProgressMonitor);
            iProgressMonitor.beginTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{string, string2}), 550);
            File[] fileArray2 = null;
            if (file2.exists() && file2.isDirectory()) {
                fileArray2 = file2.listFiles();
                n3 = fileArray2.length;
                n2 = 0;
                while (n2 < n3) {
                    String string3 = fileArray2[n2].getName();
                    boolean bl = fileArray2[n2].isDirectory();
                    n = 0;
                    while (n < n4) {
                        if (!string3.equals(fileArray[n].getName()) || bl == fileArray[n].isDirectory()) {
                            // empty if block
                        }
                        ++n;
                    }
                    if (iProgressMonitor.isCanceled()) {
                        return false;
                    }
                    ++n2;
                }
            } else {
                if (file2.isFile()) {
                    file2.delete();
                }
                if (!file2.mkdir()) {
                    iProgressMonitor.done();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Publish Error", (String)"Error while publishing files to the server.", (IStatus)new Status(4, "org.eclipse.php.server.apache.core", 0, "Make sure you have write permissions on the server's publish directory.", null));
                        }
                    });
                    return false;
                }
            }
            iProgressMonitor.worked(50);
            fileArray2 = file2.listFiles();
            n3 = 0;
            if (fileArray2 != null) {
                n3 = fileArray2.length;
            }
            n2 = 0;
            if (n3 > 0) {
                n2 = 500 / n3;
            }
            int n5 = 0;
            while (n5 < n4) {
                String string4;
                File file3 = fileArray[n5];
                n = 1;
                if (!file3.isDirectory()) {
                    string4 = file3.getName();
                    long l = file3.lastModified();
                    int n6 = 0;
                    while (n6 < n3) {
                        if (string4.equals(fileArray2[n6].getName()) && l <= fileArray2[n6].lastModified()) {
                            n = 0;
                        }
                        ++n6;
                    }
                }
                if (n != 0) {
                    string4 = file3.getAbsolutePath();
                    String string5 = string2;
                    if (!string5.endsWith(File.separator)) {
                        string5 = String.valueOf(string5) + File.separator;
                    }
                    string5 = String.valueOf(string5) + file3.getName();
                    if (file3.isFile()) {
                        FileUtil.copyFile(string4, string5);
                        iProgressMonitor.worked(n2);
                    } else if (file3.isDirectory()) {
                        iProgressMonitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{string4, string5}));
                        if (!FileUtil.smartCopyDirectory(string4, string5, ProgressUtil.getSubMonitorFor(iProgressMonitor, n2))) {
                            iProgressMonitor.done();
                            return false;
                        }
                    }
                }
                if (iProgressMonitor.isCanceled()) {
                    return false;
                }
                ++n5;
            }
            iProgressMonitor.worked(500 - n2 * n3);
            iProgressMonitor.done();
            return true;
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Error smart copying directory " + string + " - " + string2, exception);
            return false;
        }
    }
}

