/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.php.server.apache.core.ApachePlugin;

public class Trace {
    public static byte CONFIG = 0;
    public static byte WARNING = 1;
    public static byte SEVERE = (byte)2;
    public static byte FINEST = (byte)3;
    public static byte FINER = (byte)4;
    private static final String[] levelNames = new String[]{"CONFIG   ", "WARNING  ", "SEVERE   ", "FINER    ", "FINEST   "};
    private static final String spacer = "                                   ";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");
    protected static int pluginLength = -1;

    private Trace() {
    }

    public static void trace(byte by, String string) {
        Trace.trace(by, string, null);
    }

    public static void trace(byte by, String string, Throwable throwable) {
        if (!ApachePlugin.getInstance().isDebugging()) {
            return;
        }
        Trace.trace("org.eclipse.php.server.apache.core", by, string, throwable);
    }

    private static void trace(String string, int n, String string2, Throwable throwable) {
        if (string == null || string2 == null) {
            return;
        }
        if (!ApachePlugin.getInstance().isDebugging()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() > pluginLength) {
            pluginLength = string.length();
        } else if (string.length() < pluginLength) {
            stringBuffer.append(spacer.substring(0, pluginLength - string.length()));
        }
        stringBuffer.append(" ");
        stringBuffer.append(levelNames[n]);
        stringBuffer.append(" ");
        stringBuffer.append(sdf.format(new Date()));
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        System.out.println(stringBuffer.toString());
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }
}

