/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.php.server.apache.core.ApacheServer;
import org.eclipse.php.server.apache.internal.ui.PixelConverter;
import org.eclipse.php.server.apache.ui.Messages;
import org.eclipse.php.server.apache.ui.NewHttpServerWizard;
import org.eclipse.php.server.apache.ui.ServerEditDialog;
import org.eclipse.php.server.apache.ui.Trace;
import org.eclipse.php.ui.preferences.ui.IPreferenceConfigurationBlock;
import org.eclipse.php.ui.preferences.ui.ScrolledCompositeImpl;
import org.eclipse.php.ui.util.StatusInfo;
import org.eclipse.php.ui.util.StatusUtil;
import org.eclipse.php.ui.wizards.fields.DialogField;
import org.eclipse.php.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.ui.wizards.fields.IListAdapter;
import org.eclipse.php.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.wizard.ClosableWizardDialog;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

public class PHPServersConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private IStatus fServersStatus;
    private ListDialogField fServersList;
    private PreferencePage fMainPreferencePage;
    private String[] serverTypeIds;

    public PHPServersConfigurationBlock(PreferencePage preferencePage, OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)preferencePage);
        Assert.isNotNull((Object)overlayPreferenceStore);
        this.fMainPreferencePage = preferencePage;
        this.serverTypeIds = new String[]{"*"};
    }

    public Control createControl(Composite composite) {
        ServerAdapter serverAdapter = new ServerAdapter();
        String[] stringArray = new String[]{Messages.PHPServersBlock_new, Messages.PHPServersBlock_edit, Messages.PHPServersBlock_remove};
        this.fServersList = new ListDialogField(serverAdapter, stringArray, (ILabelProvider)new PHPServersLabelProvider()){

            protected boolean managedButtonPressed(int n) {
                if (n == this.getRemoveButtonIndex()) {
                    PHPServersConfigurationBlock.this.handleRemoveServer();
                }
                return super.managedButtonPressed(n);
            }
        };
        this.fServersList.setDialogFieldListener((IDialogFieldListener)serverAdapter);
        this.fServersList.setRemoveButtonIndex(2);
        String[] stringArray2 = new String[]{Messages.PHPServersBlock_serverName, Messages.PHPServersBlock_url, Messages.PHPServersBlock_publishing};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnWeightData(40), new ColumnWeightData(40), new ColumnWeightData(20)};
        this.fServersList.setTableColumns(new ListDialogField.ColumnsDescription(columnLayoutDataArray, stringArray2, true));
        if (this.fServersList.getSize() > 0) {
            this.fServersList.selectFirstElement();
        } else {
            this.fServersList.enableButton(1, false);
        }
        this.fServersStatus = new StatusInfo();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 768);
        Composite composite2 = new Composite((Composite)scrolledCompositeImpl, 0);
        composite2.setLayout((Layout)gridLayout);
        scrolledCompositeImpl.setContent((Control)composite2);
        scrolledCompositeImpl.setLayout((Layout)gridLayout);
        scrolledCompositeImpl.setFont(composite.getFont());
        GridData gridData = new GridData(1808);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        Control control = this.fServersList.getListControl(composite2);
        control.setLayoutData((Object)gridData);
        Composite composite3 = this.fServersList.getButtonBox(composite2);
        composite3.setLayoutData((Object)new GridData(258));
        this.addFiller(composite2);
        Point point = composite2.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(point.x, point.y);
        return scrolledCompositeImpl;
    }

    public void setServersTypes(String[] stringArray) {
        this.serverTypeIds = stringArray;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    protected void sideButtonPressed(int n) {
        if (n == 0) {
            IServer iServer = this.getServerFromWizard();
            if (iServer != null) {
                this.fServersList.addElement((Object)iServer);
                this.fServersList.refresh();
            }
        } else if (n == 1) {
            this.handleEditServerButtonSelected();
            this.fServersList.refresh();
        }
    }

    protected IServer getServerFromWizard() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        IServer iServer = null;
        (new String[1])[0] = "org.eclipse.php.server.apache.runtime.13";
        NewHttpServerWizard newHttpServerWizard = new NewHttpServerWizard(null, null);
        ClosableWizardDialog closableWizardDialog = new ClosableWizardDialog(shell, (IWizard)newHttpServerWizard);
        if (closableWizardDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return null;
        }
        try {
            Platform.getJobManager().join((Object)"org.eclipse.wst.server.ui.family", null);
        }
        catch (Exception exception) {
            Trace.trace(Trace.WARNING, "Error waiting for job", exception);
        }
        iServer = (IServer)newHttpServerWizard.getRootFragment().getTaskModel().getObject("server");
        try {
            Platform.getJobManager().join((Object)"org.eclipse.wst.server.ui.family", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            Trace.trace(Trace.WARNING, "Error waiting for job", exception);
        }
        return iServer;
    }

    protected void handleEditServerButtonSelected() {
        IServer iServer = (IServer)this.fServersList.getSelectedElements().get(0);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        ServerEditDialog serverEditDialog = new ServerEditDialog(shell, iServer);
        if (serverEditDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return;
        }
    }

    protected void handleRemoveServer() {
        IServer iServer = (IServer)this.fServersList.getSelectedElements().get(0);
        try {
            iServer.delete();
        }
        catch (CoreException coreException) {
            Trace.trace(Trace.SEVERE, "Error removing the server", coreException);
        }
    }

    protected void updateStatus() {
        this.fMainPreferencePage.setValid(this.fServersStatus.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, (IStatus)this.fServersStatus);
    }

    public void initialize() {
        ArrayList arrayList = new ArrayList();
        this.populateServerList(arrayList);
        this.fServersList.setElements(arrayList);
    }

    public void dispose() {
    }

    public void performDefaults() {
    }

    public void performOk() {
    }

    protected void populateServerList(List arrayList) {
        IServer[] iServerArray = ServerCore.getServers();
        if (arrayList == null) {
            arrayList = new ArrayList<IServer>();
        }
        if (iServerArray != null) {
            int n = iServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServer iServer = iServerArray[n2];
                if (this.isSupportedServer(iServer.getServerType().getId())) {
                    arrayList.add(iServer);
                }
                ++n2;
            }
        }
    }

    private boolean isSupportedServer(String string) {
        if (this.serverTypeIds == null) {
            return true;
        }
        int n = this.serverTypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            if (PHPServersConfigurationBlock.matches(string, this.serverTypeIds[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean matches(String string, String string2) {
        return string == null || string2 == null || "*".equals(string) || "*".equals(string2) || string.startsWith(string2) || string2.startsWith(string);
    }

    private class ServerAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ServerAdapter() {
        }

        private boolean hasActiveSelection(List list) {
            return list.size() == 1;
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            PHPServersConfigurationBlock.this.sideButtonPressed(n);
        }

        public void doubleClicked(ListDialogField listDialogField) {
            PHPServersConfigurationBlock.this.sideButtonPressed(1);
        }

        public void selectionChanged(ListDialogField listDialogField) {
            List list = listDialogField.getSelectedElements();
            listDialogField.enableButton(1, this.hasActiveSelection(list));
            listDialogField.enableButton(2, this.hasActiveSelection(list));
        }
    }

    private class PHPServersLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        static /* synthetic */ Class class$0;

        private PHPServersLabelProvider() {
        }

        public Font getFont(Object object) {
            return null;
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            IServer iServer = null;
            if (!(object instanceof IServer)) {
                return super.getText(object);
            }
            iServer = (IServer)object;
            if (n == 0) {
                return iServer.getName();
            }
            if (n == 1) {
                ApacheServer apacheServer;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((apacheServer = (ApacheServer)iServer.getAdapter((Class)clazz)) == null) {
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    apacheServer = (ApacheServer)iServer.loadAdapter((Class)clazz2, null);
                }
                if (apacheServer != null) {
                    return apacheServer.getBaseURL();
                }
                return iServer.getHost();
            }
            if (n == 2) {
                ApacheServer apacheServer;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((apacheServer = (ApacheServer)iServer.getAdapter((Class)clazz)) == null) {
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    apacheServer = (ApacheServer)iServer.loadAdapter((Class)clazz3, null);
                }
                return apacheServer != null && apacheServer.canPublish() ? Messages.PHPServersBlock_yes : Messages.PHPServersBlock_no;
            }
            return object.toString();
        }
    }
}

