/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.php.server.apache.core.ApacheServer;
import org.eclipse.php.server.apache.ui.ApacheUIPlugin;
import org.eclipse.php.server.apache.ui.HTTPServerUtil;
import org.eclipse.php.server.apache.ui.Messages;
import org.eclipse.php.server.apache.ui.NewHttpServerWizard;
import org.eclipse.php.server.apache.ui.Trace;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.util.WebResource;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.wizard.ClosableWizardDialog;

public class ApacheServerTab
extends AbstractLaunchConfigurationTab {
    private static final String SERVERS_PREFERENCES_PAGE_ID = "org.eclipse.php.server.apache.internal.ui.PHPServersPreferencePage";
    protected IFile selectedFile = null;
    protected Text fFile = null;
    protected Text fContextRoot = null;
    protected Text fURL = null;
    protected Button projectButton;
    protected Button fileButton;
    protected Button publish;
    protected Button createNewServer;
    protected Button configureServers;
    protected String[] serverTypeIds;
    protected Combo serverCombo;
    protected IServer server;
    protected boolean serverCanPublish = false;
    protected List servers;
    protected boolean init = true;
    private static final String READ_ONLY = "read-only";
    protected WidgetListener fListener = new WidgetListener();
    static /* synthetic */ Class class$0;

    public ApacheServerTab() {
        this(new String[]{"*"});
    }

    public ApacheServerTab(String[] stringArray) {
        this.serverTypeIds = stringArray;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.createServerControl(composite2);
        this.createFileComponent(composite2);
        this.createContextRootControl(composite2);
        this.createURLControl(composite2);
        this.createExtensionControls(composite2);
        Dialog.applyDialogFont((Control)composite2);
        this.setControl((Control)composite2);
    }

    public void createExtensionControls(Composite composite) {
    }

    public void createURLControl(Composite composite) {
        Group group = new Group(composite, 0);
        String string = "URL";
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.fURL = new Text((Composite)group, 2052);
        GridData gridData2 = new GridData(768);
        this.fURL.setLayoutData((Object)gridData2);
        this.fURL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ApacheServerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void createContextRootControl(Composite composite) {
        Group group = new Group(composite, 0);
        String string = "Context Root";
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.fContextRoot = new Text((Composite)group, 2052);
        GridData gridData2 = new GridData(768);
        this.fContextRoot.setLayoutData((Object)gridData2);
        this.fContextRoot.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ApacheServerTab.this.updateLaunchConfigurationDialog();
                ApacheServerTab.this.initializeURLControl();
            }
        });
    }

    protected void createServerSelectionControl(Composite composite) {
        GridData gridData = new GridData(256);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        group.setText("Server");
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        GridData gridData2 = new GridData(768);
        group.setLayout((Layout)gridLayout2);
        group.setLayoutData((Object)gridData2);
        this.serverCombo = new Combo((Composite)group, 2060);
        this.serverCombo.setLayoutData((Object)new GridData(768));
        this.serverCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ApacheServerTab.this.handleServerSelection();
            }
        });
        this.createNewServer = this.createPushButton((Composite)group, Messages.PHPServersLaunch_new, null);
        this.createNewServer.addSelectionListener((SelectionListener)this.fListener);
        this.configureServers = this.createPushButton((Composite)group, Messages.PHPServersLaunch_configure, null);
        this.configureServers.addSelectionListener((SelectionListener)this.fListener);
        this.servers = new ArrayList();
        this.populateServerList((ArrayList)this.servers);
        if (!this.servers.isEmpty()) {
            int n = 0;
            while (n < this.servers.size()) {
                IServer iServer = (IServer)this.servers.get(n);
                this.serverCombo.add(iServer.getName());
                ++n;
            }
        }
        if (this.serverCombo.getItemCount() > 0) {
            this.serverCombo.select(0);
        }
        this.serverCombo.forceFocus();
    }

    protected void populateServerList(ArrayList arrayList) {
        IServer[] iServerArray = ServerCore.getServers();
        if (arrayList == null) {
            arrayList = new ArrayList<IServer>();
        }
        if (iServerArray != null) {
            int n = iServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServer iServer = iServerArray[n2];
                if (this.isSupportedServer(iServer.getServerType().getId())) {
                    arrayList.add(iServer);
                }
                ++n2;
            }
        }
    }

    public void createServerControl(Composite composite) {
        this.createServerSelectionControl(composite);
        GridData gridData = new GridData(256);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.publish = new Button(composite2, 32);
        this.publish.setText("Publish to Server");
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.publish.setLayoutData((Object)gridData2);
        this.publish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ApacheServerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.handleServerSelection();
    }

    protected void createFileComponent(Composite composite) {
        Group group = new Group(composite, 0);
        String string = "File";
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.fFile = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        this.fFile.setLayoutData((Object)gridData);
        this.fFile.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fFile, group.getText());
        this.fileButton = this.createPushButton((Composite)group, "Files...", null);
        this.fileButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fileButton, String.valueOf(group.getText()) + " " + this.fileButton.getText());
    }

    public String[] getRequiredNatures() {
        return null;
    }

    protected void handleServerButtonSelected() {
        IServer iServer = this.getServerFromWizard();
        if (iServer != null) {
            this.servers.add(iServer);
            this.serverCombo.add(iServer.getName());
            this.serverCombo.select(this.serverCombo.indexOf(iServer.getName()));
            this.handleServerSelection();
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void handleConfigureButtonSelected() {
        PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)SERVERS_PREFERENCES_PAGE_ID, null, null);
        preferenceDialog.open();
        int n = this.serverCombo.getSelectionIndex();
        Object e = this.servers.get(n);
        if (e instanceof IServer) {
            IServer iServer = (IServer)e;
            this.serverCombo.remove(n);
            this.serverCombo.add(iServer.getName(), n);
            this.serverCombo.select(n);
            this.handleServerSelection();
            this.updateLaunchConfigurationDialog();
        }
    }

    public String[] getFileExtensions() {
        return null;
    }

    private IResource getFileFromDialog(IProject iProject) {
        return HTTPServerUtil.getFileFromDialog(iProject, this.getShell(), this.getFileExtensions(), this.getRequiredNatures());
    }

    protected void handleFileButtonSelected() {
        IResource iResource = null;
        iResource = this.getFileFromDialog(null);
        if (iResource == null) {
            return;
        }
        String string = iResource.getFullPath().toString();
        this.fFile.setText(string);
        this.initializeURLControl(this.fContextRoot.getText(), string);
    }

    protected IProject getProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        if (iProjectArray == null || iProjectArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            if (iProject.getName().equals(string)) {
                return iProject;
            }
            ++n;
        }
        return null;
    }

    private boolean isSupportedServer(String string) {
        if (this.serverTypeIds == null) {
            return true;
        }
        int n = this.serverTypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            if (ApacheServerTab.matches(string, this.serverTypeIds[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean matches(String string, String string2) {
        return string == null || string2 == null || "*".equals(string) || "*".equals(string2) || string.startsWith(string2) || string2.startsWith(string);
    }

    protected void handleServerSelection() {
        Object e;
        int n = this.serverCombo.getItemCount();
        int n2 = this.serverCombo.getSelectionIndex();
        if (!this.servers.isEmpty() && (e = this.servers.get(this.serverCombo.getSelectionIndex())) != null && e instanceof IServer) {
            ApacheServer apacheServer;
            this.server = (IServer)this.servers.get(this.serverCombo.getSelectionIndex());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((apacheServer = (ApacheServer)this.server.getAdapter((Class)clazz)) == null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                apacheServer = (ApacheServer)this.server.loadAdapter((Class)clazz2, null);
            }
            boolean bl = false;
            if (apacheServer != null) {
                bl = apacheServer.canPublish();
            }
            this.serverCanPublish = bl;
            this.publish.setSelection(bl);
            this.publish.setEnabled(bl);
            this.initializeURLControl();
        }
        if (this.server == null && n2 + 1 != n) {
            this.setErrorMessage(Messages.errorNoServerSelected);
        } else {
            this.setErrorMessage(null);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.setErrorMessage(null);
        if (this.serverCombo != null) {
            this.serverCombo.setEnabled(true);
            if (this.serverCombo.getItemCount() > 0) {
                this.serverCombo.select(0);
            }
        }
        if (this.servers != null) {
            this.server = (IServer)this.servers.get(this.serverCombo.getSelectionIndex());
            if (this.server != null) {
                ((Server)this.server).setupLaunchConfiguration(iLaunchConfigurationWorkingCopy, null);
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.serverCombo.setEnabled(true);
        this.setErrorMessage(null);
        try {
            IProject iProject;
            WebResource webResource;
            IModule iModule;
            IStructuredSelection iStructuredSelection;
            IModuleArtifact iModuleArtifact;
            String string = iLaunchConfiguration.getAttribute("file_name", "");
            String string2 = iLaunchConfiguration.getAttribute("context_root", "");
            boolean bl = iLaunchConfiguration.getAttribute("deployable", false);
            String string3 = iLaunchConfiguration.getAttribute("url", "");
            if (bl) {
                this.publish.setSelection(true);
            }
            if (string.equals("") && ApacheUIPlugin.currentSelection != null && !ApacheUIPlugin.currentSelection.isEmpty() && (iModuleArtifact = ServerPlugin.getModuleArtifact((Object)(iStructuredSelection = (IStructuredSelection)ApacheUIPlugin.currentSelection).getFirstElement())) instanceof WebResource && (iModule = (webResource = (WebResource)iModuleArtifact).getModule()) != null && (iProject = iModule.getProject()) != null) {
                IPath iPath = webResource.getPath();
                if (iPath.isEmpty()) {
                    string = iProject.getFullPath().toString();
                } else {
                    IFile iFile = iProject.getFile(iPath);
                    string = iFile.getFullPath().toString();
                }
                string2 = iProject.getName();
            }
            this.initializeServerControl(iLaunchConfiguration);
            this.fFile.setText(string);
            this.fContextRoot.setText(string2);
            if (string3.equals("")) {
                this.initializeURLControl(string2, string);
            } else {
                this.fURL.setText(string3);
            }
        }
        catch (CoreException coreException) {}
        this.initializeExtensionControls(iLaunchConfiguration);
    }

    protected void initializeExtensionControls(ILaunchConfiguration iLaunchConfiguration) {
    }

    protected IModuleArtifact getModuleArtifact(String string, String string2) {
        IModuleArtifact iModuleArtifact = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string2);
        if (iProject == null) {
            return null;
        }
        if (string != null && !string.equals("")) {
            IFile iFile = iProject.getFile(string);
            iModuleArtifact = ServerPlugin.getModuleArtifact((Object)iFile);
        } else {
            iModuleArtifact = ServerPlugin.getModuleArtifact((Object)iProject);
        }
        return iModuleArtifact;
    }

    protected void initializeURLControl(String string, String string2) {
        String string3;
        ApacheServer apacheServer;
        if (this.server == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((apacheServer = (ApacheServer)this.server.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.php.server.apache.core.ApacheServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            apacheServer = (ApacheServer)this.server.loadAdapter((Class)clazz2, null);
        }
        if ((string3 = apacheServer.getBaseURL()).equals("")) {
            string3 = "http://localhost";
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (!string.equals("")) {
            stringBuffer.append("/");
            stringBuffer.append(string);
        }
        if (!string2.equals("")) {
            stringBuffer.append(this.formatFileName(string2));
        }
        this.fURL.setText(stringBuffer.toString());
    }

    private String formatFileName(String string) {
        String string2 = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(string);
        if (iResource == null) {
            return "";
        }
        int n = iResource.getType();
        if (n == 1 || n == 2) {
            string2 = iResource.getProjectRelativePath().toString();
        } else if (iResource.getType() == 4) {
            string2 = "/";
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    protected void initializeURLControl() {
        if (this.fContextRoot == null || this.fFile == null) {
            return;
        }
        this.initializeURLControl(this.fContextRoot.getText(), this.fFile.getText());
    }

    protected void initializeServerControl(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute("server-id", "");
            if (string != null && !string.equals("")) {
                this.server = ServerCore.findServer((String)string);
                if (this.server == null) {
                    this.setErrorMessage(Messages.errorInvalidServer);
                    this.serverCombo.setEnabled(false);
                    return;
                }
                this.serverCombo.setText(this.server.getName());
                this.handleServerSelection();
            } else if (this.serverCombo.getItemCount() > 0) {
                this.serverCombo.select(0);
            }
            if (iLaunchConfiguration.getAttribute(READ_ONLY, false)) {
                this.serverCombo.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (this.server != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("server-id", this.server.getId());
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("server-id", null);
        }
        String string = this.fFile.getText();
        String string2 = this.fContextRoot.getText();
        String string3 = this.fURL.getText();
        boolean bl = this.publish.getSelection();
        iLaunchConfigurationWorkingCopy.setAttribute("file_name", string);
        iLaunchConfigurationWorkingCopy.setAttribute("context_root", string2);
        iLaunchConfigurationWorkingCopy.setAttribute("deployable", bl);
        iLaunchConfigurationWorkingCopy.setAttribute("url", string3);
        this.applyExtension(iLaunchConfigurationWorkingCopy);
    }

    protected void applyExtension(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        String string;
        block5: {
            this.setMessage(null);
            this.setErrorMessage(null);
            try {
                String string2 = iLaunchConfiguration.getAttribute("server-id", "");
                if (string2 == null || string2.equals("") || (string = ServerCore.findServer((String)string2)) != null) break block5;
                this.setErrorMessage("A Configuration for that server does not exist");
                return false;
            }
            catch (CoreException coreException) {}
        }
        string = iLaunchConfiguration.getAttribute("file_name", "");
        if (string != null && !string.equals("") && !this.fileExists(string)) {
            this.setErrorMessage("File Does Not Exist");
            return false;
        }
        return this.isValidExtension(iLaunchConfiguration);
    }

    protected boolean isValidExtension(ILaunchConfiguration iLaunchConfiguration) {
        return true;
    }

    private boolean fileExists(String string) {
        boolean bl = false;
        try {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path path = new Path(string);
            bl = iWorkspaceRoot.exists((IPath)path);
        }
        catch (Exception exception) {}
        return bl;
    }

    public Image getImage() {
        return ImageResource.getImage((String)"server");
    }

    public String getName() {
        return Messages.serverLaunchConfigurationTab;
    }

    public void addControlAccessibleListener(Control control, String string) {
        String[] stringArray = string.split("&");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stringBuffer.toString()));
    }

    protected IServer getServerFromWizard() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        IServer iServer = null;
        (new String[1])[0] = "org.eclipse.php.server.apache.runtime.13";
        NewHttpServerWizard newHttpServerWizard = new NewHttpServerWizard(null, null);
        ClosableWizardDialog closableWizardDialog = new ClosableWizardDialog(shell, (IWizard)newHttpServerWizard);
        if (closableWizardDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return null;
        }
        try {
            Platform.getJobManager().join((Object)"org.eclipse.wst.server.ui.family", null);
        }
        catch (Exception exception) {
            Trace.trace(Trace.WARNING, "Error waiting for job", exception);
        }
        iServer = (IServer)newHttpServerWizard.getRootFragment().getTaskModel().getObject("server");
        try {
            Platform.getJobManager().join((Object)"org.eclipse.wst.server.ui.family", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            Trace.trace(Trace.WARNING, "Error waiting for job", exception);
        }
        return iServer;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            ApacheServerTab.this.updateLaunchConfigurationDialog();
            ApacheServerTab.this.initializeURLControl();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            ApacheServerTab.this.setDirty(true);
            Object object = selectionEvent.getSource();
            if (object == ApacheServerTab.this.fileButton) {
                ApacheServerTab.this.handleFileButtonSelected();
            } else if (object == ApacheServerTab.this.createNewServer) {
                ApacheServerTab.this.handleServerButtonSelected();
            } else if (object == ApacheServerTab.this.configureServers) {
                ApacheServerTab.this.handleConfigureButtonSelected();
            }
        }
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String string) {
            this.controlName = string;
        }

        public void getName(AccessibleEvent accessibleEvent) {
            accessibleEvent.result = this.controlName;
        }
    }
}

