/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.server.apache.ui.Trace;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ApacheUIPlugin
extends AbstractUIPlugin
implements ISelectionListener {
    protected static ApacheUIPlugin singleton;
    protected Map imageDescriptors = new HashMap();
    private static URL ICON_BASE_URL;
    private static final String URL_OBJ = "obj16/";
    private static final String URL_WIZBAN = "wizban/";
    public static final String PLUGIN_ID = "org.eclipse.php.server.apache.ui";
    public static final String IMG_WIZ_SERVER = "wizServer";
    public static final String IMG_WEB_MODULE = "webModule";
    public static final String IMG_MIME_MAPPING = "mimeMapping";
    public static final String IMG_MIME_EXTENSION = "mimeExtension";
    public static final String IMG_PORT = "port";
    public static final String IMG_PROJECT_MISSING = "projectMissing";
    public static final String PREF_APACHE13_INSTALL_DIR = "apache13install";
    public static final String PREF_APACHE20_INSTALL_DIR = "apache20install";
    public static final String PHP_Port = "org.eclipse.php.debug.PHP_Port";
    public static final String PHP_URL = "org.eclipse.php.debug.PHP_URL";
    public static final String PHP_Project = "org.eclipse.php.debug.PHP_Project";
    public static ISelection currentSelection;

    static {
        currentSelection = null;
    }

    public ApacheUIPlugin() {
        singleton = this;
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry imageRegistry = new ImageRegistry();
        this.registerImage(imageRegistry, IMG_WIZ_SERVER, "wizban/server_wiz.gif");
        this.registerImage(imageRegistry, IMG_WEB_MODULE, "obj16/web_module.gif");
        this.registerImage(imageRegistry, IMG_MIME_MAPPING, "obj16/mime_mapping.gif");
        this.registerImage(imageRegistry, IMG_MIME_EXTENSION, "obj16/mime_extension.gif");
        this.registerImage(imageRegistry, IMG_PORT, "obj16/port.gif");
        this.registerImage(imageRegistry, IMG_PROJECT_MISSING, "obj16/project_missing.gif");
        return imageRegistry;
    }

    public static Image getImage(String string) {
        return ApacheUIPlugin.getInstance().getImageRegistry().get(string);
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        try {
            ApacheUIPlugin.getInstance().getImageRegistry();
            return (ImageDescriptor)ApacheUIPlugin.getInstance().imageDescriptors.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        IWorkbench iWorkbench = this.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        ISelectionService iSelectionService = iWorkbenchWindow.getSelectionService();
        ISelection iSelection = iSelectionService.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            currentSelection = (IStructuredSelection)iSelection;
        }
        iSelectionService.addSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            currentSelection = (IStructuredSelection)iSelection;
        }
    }

    public static ApacheUIPlugin getInstance() {
        return singleton;
    }

    public static void log(IStatus iStatus) {
        ApacheUIPlugin.getInstance().getLog().log(iStatus);
    }

    private void registerImage(ImageRegistry imageRegistry, String string, String string2) {
        String string3;
        if (ICON_BASE_URL == null) {
            string3 = "icons/";
            ICON_BASE_URL = singleton.getBundle().getEntry(string3);
        }
        try {
            string3 = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, string2));
            imageRegistry.put(string, (ImageDescriptor)string3);
            this.imageDescriptors.put(string, string3);
        }
        catch (Exception exception) {
            Trace.trace(Trace.WARNING, "Error registering image", exception);
        }
    }
}

