/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.apache.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.server.apache.ui.CompositeFragment;
import org.eclipse.php.server.apache.ui.IControlHandler;
import org.eclipse.php.server.apache.ui.Messages;
import org.eclipse.php.server.apache.ui.ServerFragmentsFactoryRegistry;
import org.eclipse.php.server.apache.ui.wizard.ICompositeFragmentFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wst.server.core.IServer;

public class ServerEditDialog
extends TitleAreaDialog
implements IControlHandler {
    private IServer server;
    private ArrayList runtimeComposites;

    public ServerEditDialog(Shell shell, IServer iServer) {
        super(shell);
        this.server = iServer;
        this.runtimeComposites = new ArrayList(3);
    }

    protected Control createDialogArea(Composite composite) {
        TabFolder tabFolder = new TabFolder(composite, 0x800080);
        ICompositeFragmentFactory[] iCompositeFragmentFactoryArray = ServerFragmentsFactoryRegistry.getFragmentsFactories("org.eclipse.php.server.apache.13");
        int n = 0;
        while (n < iCompositeFragmentFactoryArray.length) {
            TabItem tabItem = new TabItem(tabFolder, 0);
            CompositeFragment compositeFragment = iCompositeFragmentFactoryArray[n].createComposite((Composite)tabFolder, this);
            compositeFragment.setServerWorkingCopy(this.server.createWorkingCopy());
            tabItem.setText(compositeFragment.getDisplayName());
            tabItem.setControl((Control)compositeFragment);
            this.runtimeComposites.add(compositeFragment);
            ++n;
        }
        this.getShell().setText(Messages.serverEditDialogTitle);
        return tabFolder;
    }

    protected void cancelPressed() {
        Iterator iterator = this.runtimeComposites.iterator();
        while (iterator.hasNext()) {
            ((CompositeFragment)((Object)iterator.next())).performCancel();
        }
        super.cancelPressed();
    }

    protected void okPressed() {
        Iterator iterator = this.runtimeComposites.iterator();
        while (iterator.hasNext()) {
            ((CompositeFragment)((Object)iterator.next())).performOk();
        }
        super.okPressed();
    }

    public void setDescription(String string) {
        super.setMessage(string);
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        super.setTitleImage(imageDescriptor.createImage());
    }

    public void update() {
        Button button = this.getButton(0);
        if (button != null) {
            Iterator iterator = this.runtimeComposites.iterator();
            while (iterator.hasNext()) {
                if (((CompositeFragment)((Object)iterator.next())).isComplete()) continue;
                button.setEnabled(false);
                return;
            }
            button.setEnabled(true);
        }
    }

    public IServer getServer() {
        return this.server;
    }

    public void setServer(IServer iServer) {
        this.server = iServer;
    }
}

