/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.format;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPCorePlugin;
import org.eclipse.php.core.documentModel.PHPEditorModel;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.core.preferences.PreferencesPropagator;
import org.eclipse.php.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.core.preferences.PreferencesSupport;
import org.eclipse.wst.sse.core.StructuredModelManager;

public class FormatPreferencesSupport {
    private IDocument fLastDocument = null;
    private IProject fLastProject = null;
    private char indentationChar;
    private int indentationSize;
    private PreferencesSupport preferencesSupport = null;
    private PreferencesPropagatorListener listener = null;
    private boolean preferencesChanged = false;
    private static FormatPreferencesSupport instance = null;

    private FormatPreferencesSupport() {
        IPreferenceStore iPreferenceStore = PHPCorePlugin.getDefault().getPreferenceStore();
        this.preferencesSupport = new PreferencesSupport("org.eclipse.php.core", iPreferenceStore);
    }

    public static FormatPreferencesSupport getInstance() {
        if (instance == null) {
            instance = new FormatPreferencesSupport();
        }
        return instance;
    }

    public int getIndentationSize(IDocument iDocument) {
        this.verifyValidity(iDocument);
        return this.indentationSize;
    }

    public char getIndentationChar(IDocument iDocument) {
        this.verifyValidity(iDocument);
        return this.indentationChar;
    }

    private void verifyValidity(IDocument iDocument) {
        Object object;
        Object object2;
        if (this.fLastDocument != iDocument) {
            object2 = (PHPEditorModel)StructuredModelManager.getModelManager().getExistingModelForEdit(iDocument);
            object = object2.getProjectModel();
            IProject iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)object);
            if (this.fLastProject != iProject) {
                this.fLastProject = iProject;
                this.verifyListening();
            }
        }
        if (this.fLastDocument != iDocument || this.preferencesChanged) {
            object2 = this.preferencesSupport.getPreferencesValue("org.eclipse.php.core.phpForamtterUseTabs", null, this.fLastProject);
            object = this.preferencesSupport.getPreferencesValue("org.eclipse.php.core.phpForamtterIndentationSize", null, this.fLastProject);
            this.indentationChar = (char)(Boolean.valueOf((String)object2) != false ? 9 : 32);
            this.indentationSize = Integer.valueOf((String)object);
            this.preferencesChanged = false;
            this.fLastDocument = iDocument;
        }
    }

    private void verifyListening() {
        if (this.listener != null) {
            PreferencesPropagator.getInstance().removePropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterUseTabs");
            PreferencesPropagator.getInstance().removePropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterIndentationSize");
        }
        this.listener = new PreferencesPropagatorListener(this.fLastProject);
        PreferencesPropagator.getInstance().addPropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterUseTabs");
        PreferencesPropagator.getInstance().addPropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterIndentationSize");
    }

    private class PreferencesPropagatorListener
    implements IPreferencesPropagatorListener {
        private IProject project;

        public PreferencesPropagatorListener(IProject iProject) {
            this.project = iProject;
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            FormatPreferencesSupport.this.preferencesChanged = true;
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

