/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel.parser;

import java.io.Reader;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.eclipse.php.core.Logger;
import org.eclipse.php.core.phpModel.parser.CompletionLexer;
import org.eclipse.php.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.core.phpModel.parser.ParserClient;
import org.eclipse.php.core.phpModel.parser.PhpParser;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PhpParserSchedulerTask
implements Runnable {
    private volatile boolean threadAlive = true;
    private static final int BUFFER_MAX_SIZE = 100;
    private final LinkedList buffer = new LinkedList();
    protected static final PhpParserSchedulerTask instance;
    protected final Display display;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.core.phpModel.parser.PhpParserSchedulerTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = new PhpParserSchedulerTask();
    }

    private PhpParserSchedulerTask() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        this.display = iWorkbench == null ? null : PlatformUI.getWorkbench().getDisplay();
    }

    public static PhpParserSchedulerTask getInstance() {
        return instance;
    }

    public void run() {
        while (this.threadAlive) {
            try {
                ParserExecuter parserExecuter = this.release();
                if (!$assertionsDisabled && parserExecuter == null) {
                    throw new AssertionError();
                }
                this.display.asyncExec((Runnable)parserExecuter);
                parserExecuter.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ParserExecuter release() throws InterruptedException {
        LinkedList linkedList = this.buffer;
        synchronized (linkedList) {
            while (true) {
                if (this.buffer.size() != 0) {
                    ParserExecuter parserExecuter = (ParserExecuter)this.buffer.removeFirst();
                    this.buffer.notifyAll();
                    return parserExecuter;
                }
                try {
                    this.buffer.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(PHPParserManager pHPParserManager, PhpParser phpParser, ParserClient parserClient, String string, Reader reader, Pattern[] patternArray, long l, boolean bl) {
        LinkedList linkedList = this.buffer;
        synchronized (linkedList) {
            while (this.buffer.size() >= 100) {
                try {
                    this.buffer.wait();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            ParserExecuter parserExecuter = new ParserExecuter(pHPParserManager, phpParser, parserClient, string, reader, patternArray, l, bl);
            this.buffer.addFirst(parserExecuter);
            this.buffer.notifyAll();
        }
    }

    private static class ParserExecuter
    extends Thread {
        private final PHPParserManager parserManager;
        private PhpParser phpParser;
        private final ParserClient client;
        private final String filename;
        private final Reader reader;
        private final long lastModified;
        private final Pattern[] tasksPatterns;
        private final boolean useAspTagsAsPhp;

        public ParserExecuter(PHPParserManager pHPParserManager, PhpParser phpParser, ParserClient parserClient, String string, Reader reader, Pattern[] patternArray, long l, boolean bl) {
            this.parserManager = pHPParserManager;
            this.phpParser = phpParser;
            this.client = parserClient;
            this.filename = string;
            this.reader = reader;
            this.tasksPatterns = patternArray;
            this.lastModified = l;
            this.useAspTagsAsPhp = bl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block10: {
                try {
                    try {
                        CompletionLexer completionLexer = this.parserManager.createCompletionLexer(this.reader);
                        completionLexer.setUseAspTagsAsPhp(this.useAspTagsAsPhp);
                        completionLexer.setParserClient(this.client);
                        completionLexer.setTasksPatterns(this.tasksPatterns);
                        if (this.phpParser == null) {
                            this.phpParser = this.parserManager.createPhpParser();
                        }
                        this.phpParser.setScanner(completionLexer);
                        this.phpParser.setParserClient(this.client);
                        this.client.startParsing(this.filename);
                        this.phpParser.parse();
                    }
                    catch (Exception exception) {
                        Logger.logException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    if (this.client != null && this.phpParser != null) {
                        this.client.finishParsing(this.phpParser.getLength(), this.phpParser.getCurrentLine(), this.lastModified);
                    }
                    try {
                        this.reader.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        Logger.logException(exception);
                    }
                    throw throwable;
                }
                {
                    Object var2_5 = null;
                    if (this.client == null || this.phpParser == null) break block10;
                    this.client.finishParsing(this.phpParser.getLength(), this.phpParser.getCurrentLine(), this.lastModified);
                }
            }
            try {}
            catch (Exception exception) {
                Logger.logException(exception);
                return;
            }
            this.reader.close();
        }
    }
}

