/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.debug.core.Logger;
import org.eclipse.php.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.debug.core.communication.DebugConnectionThread;
import org.eclipse.php.debug.core.debugger.DebugError;
import org.eclipse.php.debug.core.debugger.DefaultExpressionsManager;
import org.eclipse.php.debug.core.debugger.IRemoteDebugger;
import org.eclipse.php.debug.core.debugger.RemoteDebugger;
import org.eclipse.php.debug.core.model.PHPDebugTarget;
import org.eclipse.php.debug.core.model.SimpleDebugHandler;
import org.eclipse.php.debug.core.model.StartLock;

public class ServerDebugHandler
extends SimpleDebugHandler {
    private IRemoteDebugger fRemoteDebugger;
    private PHPDebugTarget fDebugTarget;
    private boolean fStatus;
    protected DebugConnectionThread fConnectionThread;

    protected IRemoteDebugger createRemoteDebugger() {
        return new RemoteDebugger(this, this.fConnectionThread);
    }

    public IRemoteDebugger getRemoteDebugger() {
        return this.fRemoteDebugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStarted(String string, String string2, String string3, String string4) {
        StartLock startLock;
        super.sessionStarted(string, string2, string3, string4);
        String string5 = RemoteDebugger.convertToSystemIndependentFileName(string);
        this.fDebugTarget.setLastFileName(string5);
        if (!this.fDebugTarget.isPHPCGI()) {
            int n;
            this.fDebugTarget.setServerWindows(false);
            if (string.startsWith(":\\", 1)) {
                n = string5.toLowerCase().lastIndexOf(string2.toLowerCase());
                this.fDebugTarget.setServerWindows(true);
            } else {
                if (string2.startsWith("/~")) {
                    int n2 = string2.indexOf("/", 1);
                    string2 = string2.substring(n2);
                }
                n = string5.lastIndexOf(string2);
            }
            this.fDebugTarget.setHTDocs(string5.substring(0, n));
        }
        StartLock startLock2 = startLock = this.fDebugTarget.getStartLock();
        synchronized (startLock2) {
            if (startLock.isRunStart()) {
                startLock.setStarted(true);
                this.fDebugTarget.started();
                this.fStatus = this.getRemoteDebugger().start(this.fDebugTarget.getStartResponseHandler());
                if (!this.fStatus) {
                    Logger.log(4, "PHPDebugTarget: debugger.start return false");
                }
                this.fDebugTarget.setLastCommand("start");
            } else {
                startLock.setRunStart(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionEstablished() {
        StartLock startLock;
        super.connectionEstablished();
        StartLock startLock2 = startLock = this.fDebugTarget.getStartLock();
        synchronized (startLock2) {
            if (startLock.isRunStart()) {
                startLock.setStarted(true);
                this.fDebugTarget.started();
                this.fStatus = this.getRemoteDebugger().start(this.fDebugTarget.getStartResponseHandler());
                if (!this.fStatus) {
                    Logger.log(4, "PHPDebugTarget: debugger.start return false");
                }
                this.fDebugTarget.setLastCommand("start");
            } else {
                startLock.setRunStart(true);
            }
        }
    }

    public void ready(String string, int n) {
        super.ready(string, n);
        this.fDebugTarget.setLastStop(n);
        this.fDebugTarget.setLastFileName(RemoteDebugger.convertToSystemIndependentFileName(string));
        String string2 = this.fDebugTarget.getLastCommand();
        Logger.debugMSG("[" + this + "] PHPDebugTarget: lastCMD " + string2);
        this.fDebugTarget.setBreakpoints(new IBreakpoint[0]);
        this.fDebugTarget.setExpressionManager(new DefaultExpressionsManager(this.fRemoteDebugger));
        if (string2.equals("start")) {
            this.fDebugTarget.breakpointHit(this.fDebugTarget.getLastFileName(), n);
        } else if (string2.equals("resume")) {
            this.fDebugTarget.breakpointHit(this.fDebugTarget.getLastFileName(), n);
        } else if (string2.equals("suspend")) {
            this.fDebugTarget.suspended(32);
        } else if (string2.equals("stepReturn")) {
            this.fDebugTarget.suspended(4);
        } else if (string2.equals("stepOver")) {
            this.fDebugTarget.suspended(2);
        } else if (string2.equals("stepInto")) {
            this.fDebugTarget.suspended(1);
        } else if (string2.equals("terminate")) {
            this.fRemoteDebugger.finish();
            this.fDebugTarget.terminated();
        } else if (!string2.equals("breakpointAdded")) {
            string2.equals("breakpointRemoved");
        }
    }

    public void sessionEnded() {
        Logger.debugMSG("[" + this + "] PHPDebugTarget: Starting sessionEnded()");
        super.sessionEnded();
    }

    public void connectionClosed() {
        Logger.debugMSG("[" + this + "] PHPDebugTarget:Starting connectionClosed()");
        super.connectionClosed();
        this.fRemoteDebugger.finish();
        Logger.debugMSG("[" + this + "] PHPDebugTarget: Calling Terminated()");
        this.fDebugTarget.terminated();
    }

    public void handleScriptEnded() {
        Logger.debugMSG("[" + this + "] PHPDebugTarget: handleScriptEnded");
        try {
            Logger.debugMSG("[" + this + "] PHPDebugTarget: Calling Terminate()");
            this.fDebugTarget.terminate();
        }
        catch (DebugException debugException) {
            Logger.logException("PHPDebugTarget: terminate failed", debugException);
        }
    }

    public void multipleBindOccured() {
        super.multipleBindOccured();
        Logger.log(2, "PHPDebugTarget: Multiple Bind Occured");
        String string = PHPDebugCoreMessages.DebuggerDebugPortInUse_1;
        this.fRemoteDebugger.closeConnection();
        this.fDebugTarget.fireError(string, null);
        this.fDebugTarget.terminated();
    }

    public void parsingErrorOccured(DebugError debugError) {
        super.parsingErrorOccured(debugError);
        int n = !this.fDebugTarget.isPHPCGI() ? this.fDebugTarget.getHTDocs().length() + this.fDebugTarget.getContextRoot().length() : this.fDebugTarget.getWorkspacePath().length() + this.fDebugTarget.getProjectName().length();
        String string = debugError.getFileName();
        String string2 = string.substring(n);
        String string3 = RemoteDebugger.convertToSystemIndependentFileName(string2);
        debugError.setFileName(string3);
        this.fDebugTarget.getDebugErrors().add(debugError);
        Object[] objectArray = this.fDebugTarget.getConsoleEventListeners().toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            ((IPHPConsoleEventListener)objectArray[n2]).handleEvent(debugError);
            ++n2;
        }
    }

    public void newOutput(String string) {
        super.newOutput(string);
        this.fDebugTarget.getOutputBufffer().append(string);
        this.fDebugTarget.getOutputBufffer().incrementUpdateCount();
    }

    public void newHeaderOutput(String string) {
        super.newHeaderOutput(string);
        this.fDebugTarget.getOutputBufffer().append(string);
        this.fDebugTarget.getOutputBufffer().incrementUpdateCount();
    }

    public void setDebugTarget(PHPDebugTarget pHPDebugTarget) {
        this.fDebugTarget = pHPDebugTarget;
        this.fConnectionThread = this.fDebugTarget.getConnectionThread();
        this.fRemoteDebugger = this.createRemoteDebugger();
        this.fConnectionThread.getCommunicationAdministrator().connectionEstablished();
    }

    public PHPDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }
}

