/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.preferences.PHPexes;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.PHPDebugUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class PHPExeLaunchShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            PHPExeLaunchShortcut.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string, this.getPHPExeLaunchConfigType());
        }
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IFile iFile;
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iFile = (IFile)iEditorInput.getAdapter((Class)clazz)) != null) {
            PHPExeLaunchShortcut.searchAndLaunch(new Object[]{iFile}, string, this.getPHPExeLaunchConfigType());
        }
    }

    protected ILaunchConfigurationType getPHPExeLaunchConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        return iLaunchManager.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType");
    }

    public static void searchAndLaunch(Object[] objectArray, String string, ILaunchConfigurationType iLaunchConfigurationType) {
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IStatus iStatus;
                try {
                    String string2;
                    IContentType iContentType;
                    IFile iFile;
                    String string3 = null;
                    iStatus = null;
                    Object object = objectArray[n2];
                    if (object instanceof PHPCodeData) {
                        object = PHPModelUtil.getResource((Object)object);
                    }
                    if (object instanceof IFile) {
                        iFile = (IFile)object;
                        iStatus = iFile.getProject();
                        iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                        if (iContentType.isAssociatedWith(iFile.getName())) {
                            string3 = iFile.getFullPath().toString();
                        }
                    }
                    if (string3 == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_target, null));
                    }
                    iFile = new PHPexes();
                    iFile.load(PHPDebugUIPlugin.getDefault().getPluginPreferences());
                    iContentType = iFile.getDefaultItem();
                    String string4 = string2 = iContentType != null ? iFile.getDefaultItem().getPhpEXE().getAbsolutePath().toString() : null;
                    if (string2 == null) {
                        ErrorDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_noexe_msg_title, (String)PHPDebugUIMessages.launch_noexe_msg_text, (IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, "", null));
                        return;
                    }
                    ILaunchConfiguration iLaunchConfiguration = PHPExeLaunchShortcut.findLaunchConfiguration(iStatus.getName(), string3, string2, string, iLaunchConfigurationType);
                    if (iLaunchConfiguration != null) {
                        DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
                        break block9;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_config, null));
                }
                catch (CoreException coreException) {
                    iStatus = coreException.getStatus();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ErrorDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_failure_msg_title, (String)PHPDebugUIMessages.launch_failure_msg_text, (IStatus)iStatus);
                        }
                    });
                }
            }
            ++n2;
        }
    }

    protected static ILaunchConfiguration findLaunchConfiguration(String string, String string2, String string3, String string4, ILaunchConfigurationType iLaunchConfigurationType) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            int n = iLaunchConfigurationArray == null ? 0 : iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string5 = iLaunchConfigurationArray[n2].getAttribute("ATTR_WORKING_DIRECTORY", null);
                String string6 = iLaunchConfigurationArray[n2].getAttribute("ATTR_FILE", null);
                String string7 = iLaunchConfigurationArray[n2].getAttribute("ATTR_LOCATION", null);
                if (string2.equals(string6) && string.equals(string5) && string7.equals(string3)) {
                    iLaunchConfiguration = iLaunchConfigurationArray[n2].getWorkingCopy();
                    break;
                }
                ++n2;
            }
            if (iLaunchConfiguration == null) {
                iLaunchConfiguration = PHPExeLaunchShortcut.createConfiguration(string, string2, string3, iLaunchConfigurationType);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iLaunchConfiguration;
    }

    protected static ILaunchConfiguration createConfiguration(String string, String string2, String string3, ILaunchConfigurationType iLaunchConfigurationType) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration = null;
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom("New_configuration"));
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", string2);
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", string3);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
        iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        return iLaunchConfiguration;
    }
}

